/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.stream.output.spi;

import it.geosolutions.imageio.stream.output.FileImageOutputStreamExtImpl;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Iterator;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.spi.ImageOutputStreamSpi;
import javax.imageio.spi.ServiceRegistry;
import javax.imageio.stream.ImageOutputStream;

public class FileImageOutputStreamExtImplSpi
extends ImageOutputStreamSpi {
    private static final Logger LOGGER = Logger.getLogger("it.geosolutions.imageio.stream.output.spi");
    private static final String vendorName = "GeoSolutions";
    private static final String version = "1.0";
    private static final Class<?> outputClass = File.class;

    public FileImageOutputStreamExtImplSpi() {
        super(vendorName, version, outputClass);
    }

    @Override
    public String getDescription(Locale locale) {
        return "Service provider that wraps a FileImageOutputStream";
    }

    public void onRegistration(ServiceRegistry registry, Class category) {
        super.onRegistration(registry, category);
        Class<ImageOutputStreamSpi> targetClass = ImageOutputStreamSpi.class;
        Iterator<ImageOutputStreamSpi> i = registry.getServiceProviders(targetClass, true);
        while (i.hasNext()) {
            ImageOutputStreamSpi other = i.next();
            if (other != null && other.getClass().getName().equals("com.sun.imageio.spi.FileImageOutputStreamSpi")) {
                registry.deregisterServiceProvider(other);
            }
            if (this == other) continue;
            registry.setOrdering(targetClass, this, other);
        }
    }

    @Override
    public ImageOutputStream createOutputStreamInstance(Object output, boolean useCache, File cacheDir) {
        try {
            return new FileImageOutputStreamExtImpl((File)output);
        }
        catch (FileNotFoundException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.log(Level.FINE, e.getLocalizedMessage(), e);
            }
            return null;
        }
    }
}

