/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.html.wikipedia;

import info.bliki.html.wikipedia.AbstractHTMLTag;
import info.bliki.html.wikipedia.AbstractHTMLToWiki;
import info.bliki.htmlcleaner.TagNode;
import java.util.List;

public class OpenCloseTag
extends AbstractHTMLTag {
    protected String openStr;
    protected String closeStr;
    protected final boolean formatContent;

    public OpenCloseTag(String opener, String closer, boolean convertPlainText, boolean formatContent) {
        super(convertPlainText);
        this.openStr = opener;
        this.closeStr = closer;
        this.formatContent = formatContent;
    }

    public OpenCloseTag(String opener, String closer, boolean convertPlainText) {
        this(opener, closer, convertPlainText, false);
    }

    public OpenCloseTag(String opener, String closer) {
        this(opener, closer, false, false);
    }

    @Override
    public void open(TagNode node, StringBuilder resultBuffer) {
        resultBuffer.append(this.openStr);
    }

    @Override
    public void content(AbstractHTMLToWiki w, TagNode node, StringBuilder resultBuffer, boolean showWithoutTag) {
        List<Object> children = node.getChildren();
        if (children.size() != 0) {
            StringBuilder buf = new StringBuilder();
            if (this.fconvertPlainText) {
                w.nodesToPlainText(children, buf);
                for (int i = 0; i < buf.length(); ++i) {
                    char ch = buf.charAt(i);
                    if (ch != '\n' && ch != '\r' && ch != '\t') continue;
                    buf.setCharAt(i, ' ');
                }
            } else {
                w.nodesToText(children, buf);
            }
            String str = buf.toString();
            String trimmedStr = str.trim();
            boolean showWithout = showWithoutTag;
            if (trimmedStr.length() == 0) {
                showWithout = true;
            }
            if (!showWithout) {
                this.open(node, resultBuffer);
            }
            if (this.fconvertPlainText) {
                resultBuffer.append(trimmedStr);
            } else if (this.formatContent) {
                this.formatContent(trimmedStr, resultBuffer);
            } else {
                resultBuffer.append(str);
            }
            if (!showWithout) {
                this.close(node, resultBuffer);
            }
        }
    }

    public void formatContent(String str, StringBuilder resultBuffer) {
        char lastCh = 'X';
        char currentCh = 'X';
        boolean appendCh = true;
        for (int i = 0; i < str.length(); ++i) {
            currentCh = str.charAt(i);
            if (currentCh != ' ') {
                if (lastCh == ' ' && appendCh) {
                    resultBuffer.append(' ');
                }
                resultBuffer.append(currentCh);
                appendCh = currentCh != '\n';
            }
            lastCh = currentCh;
        }
    }

    @Override
    public void close(TagNode node, StringBuilder resultBuffer) {
        resultBuffer.append(this.closeStr);
    }

    public String getOpenStr() {
        return this.openStr;
    }

    public void setOpenStr(String openStr) {
        this.openStr = openStr;
    }

    public String getCloseStr() {
        return this.closeStr;
    }

    public void setCloseStr(String closeStr) {
        this.closeStr = closeStr;
    }
}

