/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.tags;

import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import java.io.IOException;

public class HTMLBlockTag
extends HTMLTag {
    private final String fAllowedParents;
    private final HTMLTag fDefaultParentTag;

    public HTMLBlockTag(String name, String allowedParents, HTMLTag defaultParentTag) {
        super(name);
        this.fAllowedParents = allowedParents;
        this.fDefaultParentTag = defaultParentTag;
    }

    public HTMLBlockTag(String name, String allowedParents) {
        this(name, allowedParents, null);
    }

    @Override
    public void renderPlainText(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        buf.append("\n");
        super.renderPlainText(converter, buf, wikiModel);
    }

    @Override
    public Object clone() {
        HTMLBlockTag bt = new HTMLBlockTag(this.name, this.fAllowedParents, this.fDefaultParentTag);
        return bt;
    }

    @Override
    public String getParents() {
        return this.fAllowedParents;
    }

    @Override
    public boolean isReduceTokenStack() {
        return true;
    }

    @Override
    public HTMLTag getDefaultParentTag() {
        return this.fDefaultParentTag;
    }
}

