/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JScrollBar;
import javax.swing.MenuElement;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;

public class JScrollPopupMenu
extends JPopupMenu {
    protected int maximumVisibleRows = 10;
    private JScrollBar popupScrollBar;

    public JScrollPopupMenu() {
        this(null);
    }

    @Override
    public void removeAll() {
        while (this.getComponentCount() > 1) {
            this.remove(0);
        }
    }

    public JScrollPopupMenu(String label) {
        super(label);
        this.setLayout(new ScrollPopupMenuLayout());
        super.add(this.getScrollBar());
        this.addMouseWheelListener(new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent event) {
                JScrollBar scrollBar = JScrollPopupMenu.this.getScrollBar();
                int amount = event.getScrollType() == 0 ? event.getUnitsToScroll() * scrollBar.getUnitIncrement() : (event.getWheelRotation() < 0 ? -1 : 1) * scrollBar.getBlockIncrement();
                scrollBar.setValue(scrollBar.getValue() + amount);
                event.consume();
            }
        });
        this.addMenuKeyListener(new MenuKeyListener(){

            @Override
            public void menuKeyTyped(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyReleased(MenuKeyEvent e) {
            }

            @Override
            public void menuKeyPressed(MenuKeyEvent e) {
                if (e.getKeyCode() == 10) {
                    for (MenuElement me : e.getMenuSelectionManager().getSelectedPath()) {
                        ActionListener[] as;
                        if (!(me instanceof JMenuItem)) continue;
                        for (ActionListener a : as = ((JMenuItem)me).getActionListeners()) {
                            a.actionPerformed(new ActionEvent(JScrollPopupMenu.this.getComponent(), 0, ""));
                        }
                    }
                }
            }
        });
    }

    protected JScrollBar getScrollBar() {
        if (this.popupScrollBar == null) {
            this.popupScrollBar = new JScrollBar(1);
            this.popupScrollBar.addAdjustmentListener(new AdjustmentListener(){

                @Override
                public void adjustmentValueChanged(AdjustmentEvent e) {
                    JScrollPopupMenu.this.doLayout();
                    JScrollPopupMenu.this.repaint();
                }
            });
            this.popupScrollBar.setVisible(true);
        }
        return this.popupScrollBar;
    }

    public int getMaximumVisibleRows() {
        return this.maximumVisibleRows;
    }

    public void setMaximumVisibleRows(int maximumVisibleRows) {
        this.maximumVisibleRows = maximumVisibleRows;
    }

    @Override
    public void paintChildren(Graphics g) {
        Insets insets = this.getInsets();
        g.clipRect(insets.left, insets.top, this.getWidth(), this.getHeight() - insets.top - insets.bottom);
        super.paintChildren(g);
    }

    @Override
    protected void addImpl(Component comp, Object constraints, int index) {
        super.addImpl(comp, constraints, index);
        if (this.maximumVisibleRows < this.getComponentCount() - 1) {
            this.getScrollBar().setVisible(true);
        }
    }

    @Override
    public void remove(int index) {
        super.remove(++index);
        if (this.maximumVisibleRows >= this.getComponentCount() - 1) {
            this.getScrollBar().setVisible(false);
        }
    }

    @Override
    public void show(Component invoker, int x, int y) {
        JScrollBar scrollBar = this.getScrollBar();
        if (scrollBar.isVisible()) {
            int extent = 0;
            int max = 0;
            int i = 0;
            int unit = -1;
            int width = 0;
            for (Component comp : this.getComponents()) {
                if (comp instanceof JScrollBar) continue;
                Dimension preferredSize = comp.getPreferredSize();
                width = Math.max(width, preferredSize.width);
                if (unit < 0) {
                    unit = preferredSize.height;
                }
                if (i++ < this.maximumVisibleRows) {
                    extent += preferredSize.height;
                }
                max += preferredSize.height;
            }
            Insets insets = this.getInsets();
            int widthMargin = insets.left + insets.right;
            int heightMargin = insets.top + insets.bottom;
            scrollBar.setUnitIncrement(unit);
            scrollBar.setBlockIncrement(extent);
            scrollBar.setValues(0, heightMargin + extent, 0, heightMargin + max);
            int height = heightMargin + extent;
            scrollBar.setSize(new Dimension(width += scrollBar.getPreferredSize().width + widthMargin, height));
            this.setPopupSize(new Dimension(width, height));
        }
        super.show(invoker, x, y);
    }

    protected static class ScrollPopupMenuLayout
    implements LayoutManager {
        protected ScrollPopupMenuLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int visibleAmount = Integer.MAX_VALUE;
            Dimension dim = new Dimension();
            for (Component comp : parent.getComponents()) {
                if (!comp.isVisible()) continue;
                if (comp instanceof JScrollBar) {
                    JScrollBar scrollBar = (JScrollBar)comp;
                    visibleAmount = scrollBar.getVisibleAmount();
                    continue;
                }
                Dimension pref = comp.getPreferredSize();
                dim.width = Math.max(dim.width, pref.width);
                dim.height += pref.height;
            }
            Insets insets = parent.getInsets();
            dim.height = Math.min(dim.height + insets.top + insets.bottom, visibleAmount);
            return dim;
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int visibleAmount = Integer.MAX_VALUE;
            Dimension dim = new Dimension();
            for (Component comp : parent.getComponents()) {
                if (!comp.isVisible()) continue;
                if (comp instanceof JScrollBar) {
                    JScrollBar scrollBar = (JScrollBar)comp;
                    visibleAmount = scrollBar.getVisibleAmount();
                    continue;
                }
                Dimension min = comp.getMinimumSize();
                dim.width = Math.max(dim.width, min.width);
                dim.height += min.height;
            }
            Insets insets = parent.getInsets();
            dim.height = Math.min(dim.height + insets.top + insets.bottom, visibleAmount);
            return dim;
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = parent.getInsets();
            int width = parent.getWidth() - insets.left - insets.right;
            int height = parent.getHeight() - insets.top - insets.bottom;
            int x = insets.left;
            int y = insets.top;
            int position = 0;
            for (Component comp : parent.getComponents()) {
                if (!(comp instanceof JScrollBar) || !comp.isVisible()) continue;
                JScrollBar scrollBar = (JScrollBar)comp;
                Dimension dim = scrollBar.getPreferredSize();
                scrollBar.setBounds(x + width - dim.width, y, dim.width, height);
                width -= dim.width;
                position = scrollBar.getValue();
            }
            y -= position;
            for (Component comp : parent.getComponents()) {
                if (comp instanceof JScrollBar || !comp.isVisible()) continue;
                Dimension pref = comp.getPreferredSize();
                comp.setBounds(x, y, width, pref.height);
                y += pref.height;
            }
        }
    }
}

