/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search.core;

import java.util.Objects;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;

public class TopIndexFilter
implements BinaryMapIndexReader.SearchPoiAdditionalFilter {
    private BinaryMapPoiReaderAdapter.PoiSubType poiSubType;
    private MapPoiTypes types;
    private String valueKey;
    private String tag;
    private String value;

    public TopIndexFilter(BinaryMapPoiReaderAdapter.PoiSubType poiSubType, MapPoiTypes types, String value) {
        this.valueKey = TopIndexFilter.getValueKey(value);
        this.poiSubType = poiSubType;
        this.types = types;
        this.value = value;
        this.tag = poiSubType.name.replace("top_index_", "");
    }

    @Override
    public boolean accept(BinaryMapPoiReaderAdapter.PoiSubType poiSubType, String value) {
        return this.poiSubType.name.equals(poiSubType.name) && this.value.equalsIgnoreCase(value);
    }

    public String getTag() {
        return this.tag;
    }

    public String getFilterId() {
        return "top_index_" + this.tag + "_" + TopIndexFilter.getValueKey(this.value);
    }

    @Override
    public String getName() {
        AbstractPoiType pt = this.types.getAnyPoiAdditionalTypeByKey(this.tag);
        if (pt != null) {
            return pt.getTranslation();
        }
        return this.types.getPoiTranslation(this.tag);
    }

    @Override
    public String getIconResource() {
        return this.valueKey;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TopIndexFilter)) {
            return false;
        }
        TopIndexFilter that = (TopIndexFilter)other;
        return this.tag.equals(that.tag) && this.value.equalsIgnoreCase(that.value);
    }

    public int hashCode() {
        return Objects.hash(this.tag, this.value);
    }

    public static String getValueKey(String value) {
        return value.toLowerCase().replace(':', '_').replaceAll("'", "").replace(' ', '_').replaceAll("\"", "");
    }

    public String getValue() {
        return this.value;
    }
}

