/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.wiki.filter;

import info.bliki.htmlcleaner.BaseToken;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.Utils;
import info.bliki.wiki.filter.AbstractWikipediaParser;
import info.bliki.wiki.filter.ITextConverter;
import info.bliki.wiki.filter.Util;
import info.bliki.wiki.filter.WPTable;
import info.bliki.wiki.model.IWikiModel;
import info.bliki.wiki.tags.HTMLTag;
import info.bliki.wiki.tags.util.TagStack;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class WPCell {
    public static final int ALIGN_NOT_SET = 0;
    public static final int ALIGN_LEFT = 1;
    public static final int ALIGN_RIGHT = 2;
    public static final int ALIGN_CENTER = 3;
    public static final int ALIGN_JUSTIFY = 4;
    int fStartPos;
    int fAttributesStartPos = -1;
    int fEndPos;
    public static final int DEFAULT = 1;
    public static final int TH = 2;
    public static final int CAPTION = 4;
    public static final int UNDEFINED = 8;
    private int fType;
    private int fAlign;
    private TagStack fStack;
    private Map<String, String> fAttributes;

    public WPCell(int start) {
        this.fStartPos = start;
        this.fType = 1;
        this.fAlign = 0;
        this.fStack = null;
        this.fAttributes = null;
    }

    public int getEndPos() {
        return this.fEndPos;
    }

    public void createTagStack(WPTable parent, char[] src, IWikiModel wikiModel, int endPos) {
        this.fEndPos = endPos;
        if (this.fEndPos > this.fStartPos) {
            String content;
            if (this.fAttributesStartPos == -1 || this.fAttributesStartPos >= this.fEndPos) {
                content = new String(src, this.fStartPos, this.fEndPos - this.fStartPos);
            } else {
                content = new String(src, this.fAttributesStartPos + 1, this.fEndPos - this.fAttributesStartPos - 1);
                String params = new String(src, this.fStartPos, this.fAttributesStartPos - this.fStartPos);
                this.fAttributes = Util.getAttributes(params);
            }
            String rawWikiText = Utils.ltrimNewline(content);
            AbstractWikipediaParser parser = wikiModel.createNewInstance(rawWikiText);
            this.fStack = parser.parseRecursiveInternal(wikiModel, true, false);
            List<BaseToken> list = this.fStack.getNodeList();
            for (int i = 0; i < list.size(); ++i) {
                if (!(list.get(i) instanceof TagNode)) continue;
                ((TagNode)list.get(i)).setParent(parent);
            }
        }
    }

    public int getStartPos() {
        return this.fStartPos;
    }

    public void setStartPos(int startPos) {
        this.fStartPos = startPos;
    }

    public void setAttributesStartPos(int attributesStartPos) {
        if (this.fAttributesStartPos == -1) {
            this.fAttributesStartPos = attributesStartPos;
        }
    }

    public void renderHTML(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        if (this.fType != 8) {
            if (this.fType == 4) {
                buf.append("\n<caption");
            } else if (this.fType == 2) {
                buf.append("\n<th");
            } else {
                buf.append("\n<td");
            }
            HTMLTag.appendEscapedAttributes(buf, this.fAttributes);
        }
        if (this.fStack != null) {
            List<BaseToken> list = this.fStack.getNodeList();
            if (list.isEmpty()) {
                if (this.fType != 8) {
                    buf.append(" />");
                }
            } else {
                if (this.fType != 8) {
                    buf.append(">");
                }
                converter.nodesToText(this.fStack.getNodeList(), buf, wikiModel);
                if (this.fType != 8) {
                    if (this.fType == 4) {
                        buf.append("</caption>");
                    } else if (this.fType == 2) {
                        buf.append("</th>");
                    } else {
                        buf.append("</td>");
                    }
                }
            }
        } else if (this.fType != 8) {
            buf.append(">");
            if (this.fType == 4) {
                buf.append("</caption>");
            } else if (this.fType == 2) {
                buf.append("</th>");
            } else {
                buf.append("</td>");
            }
        }
    }

    public void renderPlainText(ITextConverter converter, Appendable buf, IWikiModel wikiModel) throws IOException {
        List<BaseToken> list;
        if (this.fStack != null && !(list = this.fStack.getNodeList()).isEmpty()) {
            converter.nodesToText(this.fStack.getNodeList(), buf, wikiModel);
        }
    }

    public int getType() {
        return this.fType;
    }

    public int getAlign() {
        return this.fAlign;
    }

    public void setType(int type) {
        this.fType = type;
    }

    public TagStack getTagStack() {
        return this.fStack;
    }

    public Map<String, String> getNodeAttributes() {
        return this.fAttributes;
    }
}

