/*
 * Decompiled with CFR 0.152.
 */
package info.bliki.htmlcleaner;

import info.bliki.htmlcleaner.DoctypeToken;
import info.bliki.htmlcleaner.HtmlCleaner;
import info.bliki.htmlcleaner.TagNode;
import info.bliki.htmlcleaner.Utils;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Map;

public abstract class XmlSerializer {
    protected final String XML_DECLARATION = "<?xml version=\"1.0\"?>";
    protected HtmlCleaner htmlCleaner;
    protected BufferedWriter writer;

    protected XmlSerializer() {
    }

    protected XmlSerializer(Writer writer, HtmlCleaner htmlCleaner) {
        this.writer = new BufferedWriter(writer);
        this.htmlCleaner = htmlCleaner;
    }

    protected void createXml(TagNode tagNode) throws IOException {
        DoctypeToken doctypeToken;
        if (!this.htmlCleaner.isOmitXmlDeclaration()) {
            this.writer.write("<?xml version=\"1.0\"?>\n");
        }
        if (!this.htmlCleaner.isOmitDoctypeDeclaration() && (doctypeToken = this.htmlCleaner.getDoctype()) != null) {
            doctypeToken.serialize(this);
        }
        this.serialize(tagNode);
        this.writer.flush();
        this.writer.close();
    }

    protected String escapeXml(String xmlContent) {
        return Utils.escapeXml(xmlContent, this.htmlCleaner.isAdvancedXmlEscape(), this.htmlCleaner.isRecognizeUnicodeChars(), this.htmlCleaner.isTranslateSpecialEntities());
    }

    protected boolean dontEscape(TagNode tagNode) {
        String tagName = tagNode.getName();
        return this.htmlCleaner.isUseCdataForScriptAndStyle() && ("script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName));
    }

    protected boolean isScriptOrStyle(TagNode tagNode) {
        String tagName = tagNode.getName();
        return "script".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName);
    }

    protected void serializeOpenTag(TagNode tagNode, boolean newLine) throws IOException {
        String tagName = tagNode.getName();
        Map<String, String> tagAtttributes = tagNode.getAttributes();
        List<Object> tagChildren = tagNode.getChildren();
        this.writer.write("<" + tagName);
        for (Map.Entry<String, String> currEntry : tagAtttributes.entrySet()) {
            String attName = currEntry.getKey();
            String attValue = currEntry.getValue();
            if (this.htmlCleaner.isOmitXmlnsAttributes() && "xmlns".equals(attName)) continue;
            this.writer.write(" " + attName + "=\"" + this.escapeXml(attValue) + "\"");
        }
        if (tagChildren.size() == 0) {
            this.writer.write("/>");
            if (newLine) {
                this.writer.write("\n");
            }
        } else if (this.dontEscape(tagNode)) {
            this.writer.write("><![CDATA[");
        } else {
            this.writer.write(">");
        }
    }

    protected void serializeOpenTag(TagNode tagNode) throws IOException {
        this.serializeOpenTag(tagNode, true);
    }

    protected void serializeEndTag(TagNode tagNode, boolean newLine) throws IOException {
        String tagName = tagNode.getName();
        if (this.dontEscape(tagNode)) {
            this.writer.write("]]>");
        }
        this.writer.write("</" + tagName + ">");
        if (newLine) {
            this.writer.write("\n");
        }
    }

    Writer getWriter() {
        return this.writer;
    }

    protected void serializeEndTag(TagNode tagNode) throws IOException {
        this.serializeEndTag(tagNode, true);
    }

    protected abstract void serialize(TagNode var1) throws IOException;
}

