/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_int;

public class IntPtr {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected IntPtr(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(IntPtr intPtr) {
        return intPtr == null ? 0L : intPtr.swigCPtr;
    }

    protected static long swigRelease(IntPtr intPtr) {
        long l = 0L;
        if (intPtr != null) {
            if (!intPtr.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = intPtr.swigCPtr;
            intPtr.swigCMemOwn = false;
            intPtr.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_IntPtr(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public IntPtr() {
        this(OsmAndCoreJNI.new_IntPtr(), true);
    }

    public void assign(int n) {
        OsmAndCoreJNI.IntPtr_assign(this.swigCPtr, this, n);
    }

    public int value() {
        return OsmAndCoreJNI.IntPtr_value(this.swigCPtr, this);
    }

    public SWIGTYPE_p_int cast() {
        long l = OsmAndCoreJNI.IntPtr_cast(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_int(l, false);
    }

    public static IntPtr frompointer(SWIGTYPE_p_int sWIGTYPE_p_int) {
        long l = OsmAndCoreJNI.IntPtr_frompointer(SWIGTYPE_p_int.getCPtr(sWIGTYPE_p_int));
        return l == 0L ? null : new IntPtr(l, false);
    }
}

