/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.net.URLEncoder;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.osmand.util.GeoPointParserUtil;

public class GeoParsedPoint {
    public static final int NO_ZOOM = -1;
    private double lat = 0.0;
    private double lon = 0.0;
    private int zoom = -1;
    private String label;
    private String query;
    private boolean geoPoint;
    private boolean geoAddress;

    public GeoParsedPoint(double lat, double lon) {
        this.lat = lat;
        this.lon = lon;
        this.geoPoint = true;
    }

    public GeoParsedPoint(double lat, double lon, String label) {
        this(lat, lon);
        if (label != null) {
            this.label = label.replaceAll("\\+", " ");
        }
    }

    public GeoParsedPoint(double lat, double lon, int zoom) {
        this(lat, lon);
        this.zoom = zoom;
    }

    public GeoParsedPoint(double lat, double lon, int zoom, String label) {
        this(lat, lon, label);
        this.zoom = zoom;
    }

    public GeoParsedPoint(String latString, String lonString, String zoomString, String label) throws NumberFormatException {
        this(latString, lonString, zoomString);
        this.label = label;
    }

    public GeoParsedPoint(String latString, String lonString, String zoomString) throws NumberFormatException {
        this(GeoParsedPoint.parseLat(latString), GeoParsedPoint.parseLon(lonString));
        this.zoom = GeoPointParserUtil.parseZoom(zoomString);
    }

    private static double parseLon(String lonString) {
        if (lonString.startsWith("E")) {
            return Double.valueOf(lonString.substring(1));
        }
        if (lonString.startsWith("W")) {
            return -Double.valueOf(lonString.substring(1)).doubleValue();
        }
        return Double.valueOf(lonString);
    }

    private static double parseLat(String latString) {
        if (latString.startsWith("S")) {
            return -Double.valueOf(latString.substring(1)).doubleValue();
        }
        if (latString.startsWith("N")) {
            return Double.valueOf(latString.substring(1));
        }
        return Double.valueOf(latString);
    }

    public GeoParsedPoint(String latString, String lonString) throws NumberFormatException {
        this(GeoParsedPoint.parseLat(latString), GeoParsedPoint.parseLon(lonString));
        this.zoom = -1;
    }

    public GeoParsedPoint(String query) {
        this.query = query;
        this.geoAddress = true;
    }

    public double getLatitude() {
        return this.lat;
    }

    public double getLongitude() {
        return this.lon;
    }

    public int getZoom() {
        return this.zoom;
    }

    public String getLabel() {
        return this.label;
    }

    public String getQuery() {
        return this.query;
    }

    public boolean isGeoPoint() {
        return this.geoPoint;
    }

    public boolean isGeoAddress() {
        return this.geoAddress;
    }

    private String formatDouble(double d) {
        return this.formatDouble(d, -1);
    }

    private String formatDouble(double d, int precision) {
        if (d == (double)((long)d)) {
            return String.format(Locale.US, "%d", (long)d);
        }
        if (precision < 0) {
            return String.format(Locale.US, "%s", d);
        }
        return String.format(Locale.US, "%." + precision + "f", d);
    }

    public String getGeoUriString() {
        return this.buildGeoUri(this.formatDouble(this.lat), this.formatDouble(this.lon));
    }

    public String getGeoUriString(int precision) {
        return this.buildGeoUri(this.formatDouble(this.lat, precision), this.formatDouble(this.lon, precision));
    }

    private String buildGeoUri(String latStr, String lonStr) {
        if (this.isGeoPoint()) {
            String latlon = latStr + "," + lonStr;
            String uriString = "geo:" + latlon;
            LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
            if (this.zoom != -1) {
                map.put("z", String.valueOf(this.zoom));
            }
            if (this.query != null) {
                map.put("q", URLEncoder.encode(this.query));
            }
            if (this.label != null && this.query == null) {
                map.put("q", latlon + "(" + URLEncoder.encode(this.label) + ")");
            }
            if (map.size() > 0) {
                uriString = uriString + "?";
            }
            int i = 0;
            for (Map.Entry entry : map.entrySet()) {
                if (i > 0) {
                    uriString = uriString + "&";
                }
                uriString = uriString + (String)entry.getKey() + "=" + (String)entry.getValue();
                ++i;
            }
            return uriString;
        }
        if (this.isGeoAddress()) {
            Object uriString = "geo:0,0";
            if (this.query != null) {
                uriString = (String)uriString + "?";
                if (this.zoom != -1) {
                    uriString = (String)uriString + "z=" + this.zoom + "&";
                }
                uriString = (String)uriString + "q=" + URLEncoder.encode(this.query);
            }
            return uriString;
        }
        return null;
    }

    public String toString() {
        return this.isGeoPoint() ? String.format("GeoParsedPoint [lat=%.5f, lon=%.5f, zoom=%d, label=%s]", this.lat, this.lon, this.zoom, this.label) : String.format("GeoParsedPoint [query=%s]", this.query);
    }
}

