/*
 * Decompiled with CFR 0.152.
 */
package com.jwetherell.openmap.common;

import com.jwetherell.openmap.common.Ellipsoid;
import com.jwetherell.openmap.common.LatLonPoint;
import com.jwetherell.openmap.common.MGRSPoint;
import com.jwetherell.openmap.common.UTMPoint;

public class ZonedUTMPoint
extends UTMPoint {
    public ZonedUTMPoint() {
    }

    public ZonedUTMPoint(LatLonPoint llpoint) {
        super(llpoint);
        this.zone_letter = this.getLetterDesignator(llpoint.getLatitude());
    }

    public ZonedUTMPoint(LatLonPoint llpoint, Ellipsoid ellip) {
        super(llpoint, ellip);
        this.zone_letter = this.getLetterDesignator(llpoint.getLatitude());
    }

    public ZonedUTMPoint(double northing, double easting, int zone_number, char zone_letter) {
        super(northing, easting, zone_number, MGRSPoint.MGRSZoneToUTMZone(zone_letter));
        this.zone_letter = zone_letter;
    }

    public LatLonPoint ZonedUTMtoLL() {
        return ZonedUTMPoint.ZonedUTMtoLL(Ellipsoid.WGS_84, this.northing, this.easting, this.zone_number, this.zone_letter, new LatLonPoint());
    }

    public static LatLonPoint ZonedUTMtoLL(Ellipsoid ellip, double UTMNorthing, double UTMEasting, int ZoneNumber, char ZoneLetter, LatLonPoint llpoint) {
        return UTMPoint.UTMtoLL(ellip, UTMNorthing, UTMEasting, ZoneNumber, MGRSPoint.MGRSZoneToUTMZone(ZoneLetter), llpoint);
    }

    @Override
    protected char getLetterDesignator(double lat) {
        int LetterDesignator = 90;
        if (84.0 >= lat && lat >= 72.0) {
            LetterDesignator = 88;
        } else if (72.0 > lat && lat >= 64.0) {
            LetterDesignator = 87;
        } else if (64.0 > lat && lat >= 56.0) {
            LetterDesignator = 86;
        } else if (56.0 > lat && lat >= 48.0) {
            LetterDesignator = 85;
        } else if (48.0 > lat && lat >= 40.0) {
            LetterDesignator = 84;
        } else if (40.0 > lat && lat >= 32.0) {
            LetterDesignator = 83;
        } else if (32.0 > lat && lat >= 24.0) {
            LetterDesignator = 82;
        } else if (24.0 > lat && lat >= 16.0) {
            LetterDesignator = 81;
        } else if (16.0 > lat && lat >= 8.0) {
            LetterDesignator = 80;
        } else if (8.0 > lat && lat >= 0.0) {
            LetterDesignator = 78;
        } else if (0.0 > lat && lat >= -8.0) {
            LetterDesignator = 77;
        } else if (-8.0 > lat && lat >= -16.0) {
            LetterDesignator = 76;
        } else if (-16.0 > lat && lat >= -24.0) {
            LetterDesignator = 75;
        } else if (-24.0 > lat && lat >= -32.0) {
            LetterDesignator = 74;
        } else if (-32.0 > lat && lat >= -40.0) {
            LetterDesignator = 72;
        } else if (-40.0 > lat && lat >= -48.0) {
            LetterDesignator = 71;
        } else if (-48.0 > lat && lat >= -56.0) {
            LetterDesignator = 70;
        } else if (-56.0 > lat && lat >= -64.0) {
            LetterDesignator = 69;
        } else if (-64.0 > lat && lat >= -72.0) {
            LetterDesignator = 68;
        } else if (-72.0 > lat && lat >= -80.0) {
            LetterDesignator = 67;
        }
        return (char)LetterDesignator;
    }

    @Override
    public String toString() {
        return "Zone_number=" + this.zone_number + ", Hemisphere=" + this.zone_letter + ", Northing=" + this.northing + ", Easting=" + this.easting;
    }
}

