/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.QListFloat;
import net.osmand.core.jni.QListPointI;
import net.osmand.core.jni.SWIGTYPE_p_float;
import net.osmand.core.jni.SWIGTYPE_p_void;
import net.osmand.core.jni.TileId;
import net.osmand.core.jni.ZoomLevel;

public class IGeoTiffCollection {
    private transient long swigCPtr;
    private transient boolean swigCMemOwn;

    protected IGeoTiffCollection(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(IGeoTiffCollection iGeoTiffCollection) {
        return iGeoTiffCollection == null ? 0L : iGeoTiffCollection.swigCPtr;
    }

    protected void swigSetCMemOwn(boolean bl) {
        this.swigCMemOwn = bl;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_IGeoTiffCollection(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public boolean hasDataResources() {
        return OsmAndCoreJNI.IGeoTiffCollection_hasDataResources(this.swigCPtr, this);
    }

    public ZoomLevel getMinZoom() {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IGeoTiffCollection_getMinZoom(this.swigCPtr, this));
    }

    public ZoomLevel getMaxZoom(long l) {
        return ZoomLevel.swigToEnum(OsmAndCoreJNI.IGeoTiffCollection_getMaxZoom(this.swigCPtr, this, l));
    }

    public CallResult getGeoTiffData(TileId tileId, ZoomLevel zoomLevel, long l, long l2, long l3, boolean bl, SWIGTYPE_p_float sWIGTYPE_p_float, SWIGTYPE_p_float sWIGTYPE_p_float2, SWIGTYPE_p_void sWIGTYPE_p_void, ProcessingParameters processingParameters) {
        return CallResult.swigToEnum(OsmAndCoreJNI.IGeoTiffCollection_getGeoTiffData__SWIG_0(this.swigCPtr, this, TileId.getCPtr(tileId), tileId, zoomLevel.swigValue(), l, l2, l3, bl, SWIGTYPE_p_float.getCPtr(sWIGTYPE_p_float), SWIGTYPE_p_float.getCPtr(sWIGTYPE_p_float2), SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void), ProcessingParameters.getCPtr(processingParameters), processingParameters));
    }

    public CallResult getGeoTiffData(TileId tileId, ZoomLevel zoomLevel, long l, long l2, long l3, boolean bl, SWIGTYPE_p_float sWIGTYPE_p_float, SWIGTYPE_p_float sWIGTYPE_p_float2, SWIGTYPE_p_void sWIGTYPE_p_void) {
        return CallResult.swigToEnum(OsmAndCoreJNI.IGeoTiffCollection_getGeoTiffData__SWIG_1(this.swigCPtr, this, TileId.getCPtr(tileId), tileId, zoomLevel.swigValue(), l, l2, l3, bl, SWIGTYPE_p_float.getCPtr(sWIGTYPE_p_float), SWIGTYPE_p_float.getCPtr(sWIGTYPE_p_float2), SWIGTYPE_p_void.getCPtr(sWIGTYPE_p_void)));
    }

    public boolean calculateHeights(ZoomLevel zoomLevel, long l, QListPointI qListPointI, QListFloat qListFloat) {
        return OsmAndCoreJNI.IGeoTiffCollection_calculateHeights(this.swigCPtr, this, zoomLevel.swigValue(), l, QListPointI.getCPtr(qListPointI), qListPointI, QListFloat.getCPtr(qListFloat), qListFloat);
    }

    public static class ProcessingParameters {
        private transient long swigCPtr;
        protected transient boolean swigCMemOwn;

        protected ProcessingParameters(long l, boolean bl) {
            this.swigCMemOwn = bl;
            this.swigCPtr = l;
        }

        protected static long getCPtr(ProcessingParameters processingParameters) {
            return processingParameters == null ? 0L : processingParameters.swigCPtr;
        }

        protected static long swigRelease(ProcessingParameters processingParameters) {
            long l = 0L;
            if (processingParameters != null) {
                if (!processingParameters.swigCMemOwn) {
                    throw new RuntimeException("Cannot release ownership as memory is not owned");
                }
                l = processingParameters.swigCPtr;
                processingParameters.swigCMemOwn = false;
                processingParameters.delete();
            }
            return l;
        }

        protected void finalize() {
            this.delete();
        }

        public synchronized void delete() {
            if (this.swigCPtr != 0L) {
                if (this.swigCMemOwn) {
                    this.swigCMemOwn = false;
                    OsmAndCoreJNI.delete_IGeoTiffCollection_ProcessingParameters(this.swigCPtr);
                }
                this.swigCPtr = 0L;
            }
        }

        public void setRasterType(RasterType rasterType) {
            OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_rasterType_set(this.swigCPtr, this, rasterType.swigValue());
        }

        public RasterType getRasterType() {
            return RasterType.swigToEnum(OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_rasterType_get(this.swigCPtr, this));
        }

        public void setColorsFilename(String string) {
            OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_colorsFilename_set(this.swigCPtr, this, string);
        }

        public String getColorsFilename() {
            return OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_colorsFilename_get(this.swigCPtr, this);
        }

        public void setResultColorsFilename(String string) {
            OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_resultColorsFilename_set(this.swigCPtr, this, string);
        }

        public String getResultColorsFilename() {
            return OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_resultColorsFilename_get(this.swigCPtr, this);
        }

        public void setIntermediateColorsFilename(String string) {
            OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_intermediateColorsFilename_set(this.swigCPtr, this, string);
        }

        public String getIntermediateColorsFilename() {
            return OsmAndCoreJNI.IGeoTiffCollection_ProcessingParameters_intermediateColorsFilename_get(this.swigCPtr, this);
        }

        public ProcessingParameters() {
            this(OsmAndCoreJNI.new_IGeoTiffCollection_ProcessingParameters(), true);
        }
    }

    public static enum CallResult {
        Empty,
        Completed,
        Failed;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static CallResult swigToEnum(int n) {
            CallResult[] callResultArray = (CallResult[])CallResult.class.getEnumConstants();
            if (n < callResultArray.length && n >= 0 && callResultArray[n].swigValue == n) {
                return callResultArray[n];
            }
            for (CallResult callResult : callResultArray) {
                if (callResult.swigValue != n) continue;
                return callResult;
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(CallResult.class) + " with value " + n);
        }

        private CallResult() {
            this.swigValue = SwigNext.next++;
        }

        private CallResult(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private CallResult(CallResult callResult) {
            this.swigValue = callResult.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }

    public static enum RasterType {
        Heightmap,
        Hillshade,
        Slope,
        Height;

        private final int swigValue;

        public final int swigValue() {
            return this.swigValue;
        }

        public static RasterType swigToEnum(int n) {
            RasterType[] rasterTypeArray = (RasterType[])RasterType.class.getEnumConstants();
            if (n < rasterTypeArray.length && n >= 0 && rasterTypeArray[n].swigValue == n) {
                return rasterTypeArray[n];
            }
            for (RasterType rasterType : rasterTypeArray) {
                if (rasterType.swigValue != n) continue;
                return rasterType;
            }
            throw new IllegalArgumentException("No enum " + String.valueOf(RasterType.class) + " with value " + n);
        }

        private RasterType() {
            this.swigValue = SwigNext.next++;
        }

        private RasterType(int n2) {
            this.swigValue = n2;
            SwigNext.next = n2 + 1;
        }

        private RasterType(RasterType rasterType) {
            this.swigValue = rasterType.swigValue;
            SwigNext.next = this.swigValue + 1;
        }

        private static class SwigNext {
            private static int next = 0;

            private SwigNext() {
            }
        }
    }
}

