/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.util;

import kotlin.Metadata;
import net.osmand.shared.settings.enums.AltitudeMetrics;
import net.osmand.shared.settings.enums.MetricsConstants;
import net.osmand.shared.settings.enums.SpeedConstants;
import net.osmand.shared.util.PlatformUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\t\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005J\u000e\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0005J\u000e\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lnet/osmand/shared/util/OsmAndFormatter;", "", "<init>", "()V", "METERS_IN_KILOMETER", "", "METERS_IN_ONE_MILE", "METERS_IN_ONE_NAUTICALMILE", "YARDS_IN_ONE_METER", "FEET_IN_ONE_METER", "INCHES_IN_ONE_METER", "KILOGRAMS_IN_ONE_TON", "", "POUNDS_IN_ONE_KILOGRAM", "POUNDS_IN_ONE_TON", "convertSpeedToMetersPerSecond", "formattedValueSrc", "getMetersFromFormattedAltitudeValue", "altitude", "convertToMeters", "distance", "OsmAnd-shared"})
public final class OsmAndFormatter {
    @NotNull
    public static final OsmAndFormatter INSTANCE = new OsmAndFormatter();
    public static final float METERS_IN_KILOMETER = 1000.0f;
    public static final float METERS_IN_ONE_MILE = 1609.344f;
    public static final float METERS_IN_ONE_NAUTICALMILE = 1852.0f;
    public static final float YARDS_IN_ONE_METER = 1.0936f;
    public static final float FEET_IN_ONE_METER = 3.2808f;
    public static final float INCHES_IN_ONE_METER = 39.369602f;
    public static final int KILOGRAMS_IN_ONE_TON = 1000;
    public static final float POUNDS_IN_ONE_KILOGRAM = 2.2046f;
    public static final float POUNDS_IN_ONE_TON = 2204.6f;

    private OsmAndFormatter() {
    }

    public final float convertSpeedToMetersPerSecond(float formattedValueSrc) {
        SpeedConstants mc;
        SpeedConstants speedConstants = mc = PlatformUtil.INSTANCE.getOsmAndContext().getSpeedSystem();
        return switch (speedConstants == null ? -1 : WhenMappings.$EnumSwitchMapping$0[speedConstants.ordinal()]) {
            case 1 -> formattedValueSrc / 3.6f;
            case 2 -> (float)((double)(formattedValueSrc * 1609.344f) / 3.6 / (double)1000);
            case 3 -> (float)((double)(formattedValueSrc * 1852.0f) / 3.6 / (double)1000);
            default -> formattedValueSrc;
        };
    }

    public final float getMetersFromFormattedAltitudeValue(float altitude) {
        AltitudeMetrics am = PlatformUtil.INSTANCE.getOsmAndContext().getAltitudeMetric();
        boolean useFeet = AltitudeMetrics.FEET == am;
        return useFeet ? altitude / 3.2808f : altitude;
    }

    public final float convertToMeters(float distance) {
        MetricsConstants mc;
        float mainUnitInMeters = 0.0f;
        MetricsConstants metricsConstants = mc = PlatformUtil.INSTANCE.getOsmAndContext().getMetricSystem();
        mainUnitInMeters = switch (metricsConstants == null ? -1 : WhenMappings.$EnumSwitchMapping$1[metricsConstants.ordinal()]) {
            case 1, 2 -> 1609.344f;
            case 3, 4 -> 1852.0f;
            default -> 1000.0f;
        };
        return distance * mainUnitInMeters;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[SpeedConstants.values().length];
            try {
                nArray[SpeedConstants.KILOMETERS_PER_HOUR.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpeedConstants.MILES_PER_HOUR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SpeedConstants.NAUTICALMILES_PER_HOUR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[MetricsConstants.values().length];
            try {
                nArray[MetricsConstants.MILES_AND_FEET.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.MILES_AND_METERS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.NAUTICAL_MILES_AND_METERS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[MetricsConstants.NAUTICAL_MILES_AND_FEET.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

