/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.EquatorEpoch;
import io.github.cosinekitty.astronomy.PrecessDirection;
import io.github.cosinekitty.astronomy.StateVector;
import io.github.cosinekitty.astronomy.Time;
import io.github.cosinekitty.astronomy.Vector;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\t\u00a8\u0006\u001f"}, d2={"Lio/github/cosinekitty/astronomy/Observer;", "", "latitude", "", "longitude", "height", "<init>", "(DDD)V", "getLatitude", "()D", "getLongitude", "getHeight", "toVector", "Lio/github/cosinekitty/astronomy/Vector;", "time", "Lio/github/cosinekitty/astronomy/Time;", "equator", "Lio/github/cosinekitty/astronomy/EquatorEpoch;", "toStateVector", "Lio/github/cosinekitty/astronomy/StateVector;", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "", "OsmAnd-shared"})
public final class Observer {
    private final double latitude;
    private final double longitude;
    private final double height;

    public Observer(double latitude, double longitude, double height) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.height = height;
    }

    public final double getLatitude() {
        return this.latitude;
    }

    public final double getLongitude() {
        return this.longitude;
    }

    public final double getHeight() {
        return this.height;
    }

    @NotNull
    public final Vector toVector(@NotNull Time time, @NotNull EquatorEpoch equator) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)equator), (String)"equator");
        return this.toStateVector(time, equator).position();
    }

    @NotNull
    public final StateVector toStateVector(@NotNull Time time, @NotNull EquatorEpoch equator) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Intrinsics.checkNotNullParameter((Object)((Object)equator), (String)"equator");
        StateVector state = Astronomy.access$terra(this, time);
        return switch (WhenMappings.$EnumSwitchMapping$0[equator.ordinal()]) {
            case 1 -> state;
            case 2 -> Astronomy.access$gyrationPosVel(state, PrecessDirection.Into2000);
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    public final double component1() {
        return this.latitude;
    }

    public final double component2() {
        return this.longitude;
    }

    public final double component3() {
        return this.height;
    }

    @NotNull
    public final Observer copy(double latitude, double longitude, double height) {
        return new Observer(latitude, longitude, height);
    }

    public static /* synthetic */ Observer copy$default(Observer observer, double d, double d2, double d3, int n, Object object) {
        if ((n & 1) != 0) {
            d = observer.latitude;
        }
        if ((n & 2) != 0) {
            d2 = observer.longitude;
        }
        if ((n & 4) != 0) {
            d3 = observer.height;
        }
        return observer.copy(d, d2, d3);
    }

    @NotNull
    public String toString() {
        return "Observer(latitude=" + this.latitude + ", longitude=" + this.longitude + ", height=" + this.height + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.latitude);
        result = result * 31 + Double.hashCode(this.longitude);
        result = result * 31 + Double.hashCode(this.height);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Observer)) {
            return false;
        }
        Observer observer = (Observer)other;
        if (Double.compare(this.latitude, observer.latitude) != 0) {
            return false;
        }
        if (Double.compare(this.longitude, observer.longitude) != 0) {
            return false;
        }
        return Double.compare(this.height, observer.height) == 0;
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquatorEpoch.values().length];
            try {
                nArray[EquatorEpoch.OfDate.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquatorEpoch.J2000.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

