/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.wiki.commonswiki.parser;

import java.util.Arrays;
import net.osmand.wiki.commonswiki.parser.ParserUtils;

public final class DateParser {
    private static final String DATE_PATTERN = "\\d{4}-\\d{2}-\\d{2}";
    private static final String OTHER_DATE_TEMPLATE = "other date";

    private DateParser() {
    }

    public static String parse(String line) {
        String dateValue = DateParser.extractDateValue(line);
        if (dateValue == null || dateValue.isEmpty()) {
            return null;
        }
        String date = DateParser.parseDateFromValue(dateValue);
        return DateParser.cleanDate(date);
    }

    private static String extractDateValue(String line) {
        return ParserUtils.extractFieldValue(line, "date");
    }

    private static String parseDateFromValue(String dateValue) {
        if (dateValue.startsWith("{{")) {
            return DateParser.parseDateFromTemplate(dateValue);
        }
        return DateParser.parseDateFromPlainText(dateValue);
    }

    private static String parseDateFromTemplate(String dateValue) {
        String templateContent = ParserUtils.extractTemplateContent(dateValue);
        if (templateContent == null) {
            return null;
        }
        String[] parts = templateContent.split("\\|");
        if (parts.length > 1 && parts[0].equalsIgnoreCase(OTHER_DATE_TEMPLATE)) {
            return String.join((CharSequence)" ", Arrays.copyOfRange(parts, 1, parts.length)).trim();
        }
        for (String part : parts) {
            if (!part.matches(DATE_PATTERN)) continue;
            return part.trim();
        }
        return null;
    }

    private static String parseDateFromPlainText(String dateValue) {
        String[] parts = dateValue.split(" ");
        return parts[0].trim();
    }

    private static String cleanDate(String date) {
        if (date == null || date.isEmpty()) {
            return null;
        }
        return ParserUtils.removeWikiLinkBrackets(date);
    }
}

