/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.internal.renderer.xhtml.link;

import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.rendering.internal.renderer.xhtml.link.AbstractXHTMLLinkTypeRenderer;
import org.xwiki.rendering.listener.reference.ResourceReference;
import org.xwiki.rendering.renderer.reference.ResourceReferenceTypeSerializer;
import org.xwiki.rendering.wiki.WikiModel;

@Component
@Named(value="attach")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class AttachmentXHTMLLinkTypeRenderer
extends AbstractXHTMLLinkTypeRenderer
implements Initializable {
    @Inject
    @Named(value="xwiki/2.0")
    private ResourceReferenceTypeSerializer defaultResourceReferenceTypeSerializer;
    private WikiModel wikiModel;

    public void initialize() throws InitializationException {
        try {
            this.wikiModel = (WikiModel)this.componentManager.getInstance(WikiModel.class);
        }
        catch (ComponentLookupException componentLookupException) {
            // empty catch block
        }
    }

    @Override
    protected void beginLinkExtraAttributes(ResourceReference reference, Map<String, String> spanAttributes, Map<String, String> anchorAttributes) {
        if (this.wikiModel != null) {
            anchorAttributes.put("href", this.wikiModel.getLinkURL(reference));
            spanAttributes.put("class", "wikiattachmentlink");
        } else {
            anchorAttributes.put("href", this.defaultResourceReferenceTypeSerializer.serialize(reference));
            spanAttributes.put("class", "wikiattachmentlink wikiexternallink");
        }
    }

    @Override
    protected boolean isExternalLink(ResourceReference reference) {
        return false;
    }
}

