/*
 * Decompiled with CFR 0.152.
 */
package rtree;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import rtree.ABL;
import rtree.LeafElement;
import rtree.Point;
import rtree.RTree;
import rtree.RTreeRead;
import rtree.Rect;
import rtree.join.IntersectPred;
import rtree.join.Join;
import rtree.join.Pair;
import rtree.seeded.SdTree;

class TreeThread
implements Runnable {
    static String fileName = "c:\\temp\\temp.tree";
    static long seed = 1015395880L;
    static int h = 15000000;
    static int w = 6000000;
    Thread tree;

    TreeThread() {
        for (int i = 0; i < 1; ++i) {
            this.tree = new Thread((Runnable)this, Integer.toString(i));
            this.tree.start();
        }
    }

    @Override
    public void run() {
        try {
            RTreeRead rd = new RTreeRead(fileName + "1");
            rd.readSeq();
            rd = new RTreeRead(fileName + "2");
            rd.readSeq();
        }
        catch (Exception e) {
            try {
                e.printStackTrace();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public void entryRand(String fileName) throws Exception {
        int xx;
        int xy;
        LeafElement lf;
        int ix;
        int iy;
        int i;
        ArrayList vct = new ArrayList(0);
        RTree rt = new RTree(fileName);
        Random rnd = new Random(seed);
        long start = System.currentTimeMillis();
        Rect rect = new Rect();
        for (i = 0; i < 2000; ++i) {
            iy = rnd.nextInt(h);
            ix = rnd.nextInt(w);
            lf = new LeafElement(new Rect(ix, iy, ix, iy), 218L);
            rt.insert(lf);
        }
        for (i = 0; i < 30000; ++i) {
            iy = rnd.nextInt(h - 2);
            ix = rnd.nextInt(w - 2);
            xy = rnd.nextInt(h - iy);
            xx = rnd.nextInt(w - ix);
            lf = new LeafElement(new Rect(ix, iy, ix + xx, iy + xy), 218L);
            rt.insert(lf);
        }
        for (i = 0; i < 20000; ++i) {
            iy = rnd.nextInt(h);
            ix = rnd.nextInt(w);
            lf = new LeafElement(new Rect(ix, iy, ix, iy), 218L);
            rt.insert(lf);
        }
        for (i = 0; i < 30000; ++i) {
            iy = rnd.nextInt(h - 2);
            ix = rnd.nextInt(w - 2);
            xy = rnd.nextInt(h - iy);
            xx = rnd.nextInt(w - ix);
            lf = new LeafElement(new Rect(ix, iy, ix + xx, iy + xy), 218L);
            rt.insert(lf);
            rect.expandToInclude(lf.getRect());
        }
        System.out.println("Entry over in ms : " + (System.currentTimeMillis() - start) + " for thread " + String.valueOf(Thread.currentThread()));
    }

    public void entry(String fileName) {
        try {
            long start = System.currentTimeMillis();
            RTree rtree = new RTree(fileName);
            LeafElement lf1 = new LeafElement(new Rect(3, 2, 4, 3), 3243L);
            rtree.insert(lf1);
            rtree.delete(lf1);
            System.out.println("Time in ms:" + (System.currentTimeMillis() - start));
            System.out.println("Entry over");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void overlapRR(String name) throws Exception {
        RTree rt = new RTree(name);
        Random rnd = new Random(System.currentTimeMillis());
        for (int i = 0; i < 1; ++i) {
            int iy = rnd.nextInt(h - 2);
            int ix = rnd.nextInt(w - 2);
            int xy = rnd.nextInt(h - iy);
            int xx = rnd.nextInt(w - ix);
            long start4 = System.currentTimeMillis();
            System.out.println("Sweep");
            start4 = System.currentTimeMillis();
            List elmts = rt.overlapsSweep(new Rect(ix, iy, ix + xx, iy + xy));
            System.out.println("Time in ms:" + (System.currentTimeMillis() - start4));
            System.out.println("Search result-Total elements:" + elmts.size());
        }
    }

    public void overlapRP(String name) throws Exception {
        RTree rt = new RTree(name);
        Random rnd = new Random(System.currentTimeMillis());
        for (int i = 0; i < 10; ++i) {
            int iy = rnd.nextInt(h);
            int ix = rnd.nextInt(w);
            long start4 = System.currentTimeMillis();
            List elmts = rt.overlaps(new Rect(ix, iy, ix, iy));
            System.out.println("Time in ms:" + (System.currentTimeMillis() - start4));
            System.out.println("Search result-Total elements:" + elmts.size());
        }
    }

    public void getall(String name) {
        try {
            RTree rt = new RTree(name);
            long start1 = System.currentTimeMillis();
            List elmts1 = rt.getAllElements();
            System.out.println("Time in ms:" + (System.currentTimeMillis() - start1));
            System.out.println("Record fetched by " + Thread.currentThread().getName() + ": " + elmts1.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void overlap(String name, Rect rect) {
        try {
            RTree rt = new RTree(name);
            long start4 = System.currentTimeMillis();
            List elmts = rt.nonDisjoint(rect);
            System.out.println("Time in ms:" + (System.currentTimeMillis() - start4));
            System.out.println("overlap Search -Total elements:" + elmts.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void search(String name) {
        try {
            RTree rt = new RTree(name);
            Random rnd = new Random(System.currentTimeMillis());
            int iy = rnd.nextInt(h);
            int ix = rnd.nextInt(w);
            Point pt = new Point(ix, iy);
            long start5 = System.currentTimeMillis();
            ABL[] nrst = rt.nearestSearch(pt, 50000000000L, 10);
            System.out.println("Time in ms for NNSearch(Limited):" + (System.currentTimeMillis() - start5));
            System.out.println("List");
            start5 = System.currentTimeMillis();
            List vec = rt.nearestSearch(pt, 10000000000L);
            System.out.println("Time in ms for NNSearch(Unlimited):" + (System.currentTimeMillis() - start5));
            System.out.println("Retrieved: " + vec.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public void delete(String name, LeafElement element) {
        try {
            RTree rt = new RTree(fileName);
            rt.delete(element);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void tryOverlap() {
        try {
            Rect rect1 = new Rect();
            Rect rect2 = new Rect(4, 2, 5, 3);
            System.out.println(rect1.toString() + " \nand\n" + rect2.toString() + "\noverlap? \n\tAns- " + rect2.contains(rect1));
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
        }
    }

    public void tryIntersection() {
        try {
            Rect rect1 = new Rect(9, 6, 10, 7);
            Rect rect2 = new Rect(8, 5, 11, 8);
            System.out.println(rect1.toString() + " \nand\n" + rect2.toString() + "\nIntersection \n\tAns- " + String.valueOf(rect2.intersection(rect1)));
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
        }
    }

    public void tryCvr() {
        try {
            Rect rect1 = new Rect(3, 2, 5, 4);
            Rect rect2 = new Rect(3, 2, 4, 4);
            System.out.println(rect1.toString() + " \nand\n" + rect2.toString() + "\nDoes first Eclose second? \n\tAns- " + rect1.covers(rect2));
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
        }
    }

    public void tryIntsct() {
        try {
            Rect rect1 = new Rect(3, 2, 5, 4);
            Rect rect2 = new Rect(3, 2, 3, 2);
            System.out.println(rect1.toString() + " \nand\n" + rect2.toString() + "\nDo Both Intersect? \n\tAns- " + rect1.meet(rect2));
        }
        catch (Exception e) {
            System.out.println("Exception " + e.getMessage());
        }
    }

    public void trySeed(String sdTree, RTree rtree) {
        try {
            SdTree sdt = new SdTree(sdTree, rtree);
            Random rnd = new Random(seed);
            long start = System.currentTimeMillis();
            for (int i = 0; i < 2000000; ++i) {
                int iy = rnd.nextInt(h - 2);
                int ix = rnd.nextInt(w - 2);
                int xy = rnd.nextInt(h - iy);
                int xx = rnd.nextInt(w - ix);
                LeafElement lf = new LeafElement(new Rect(ix, iy, ix + xx, iy + xy), 218L);
                sdt.growLeaf(lf);
            }
            sdt.cleanUp();
            new RTree(sdTree).flush();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public List tryJoin() {
        try {
            RTree ltTree = new RTree(fileName + "1");
            RTree rtTree = new RTree(fileName + "2");
            Join join = new Join(ltTree, rtTree, new Pair(), new IntersectPred());
            System.out.println("rTreeDemo : left tree size " + ltTree.getAllElements().size() + "\nright tree size " + rtTree.getAllElements().size() + "\n join size " + join.relate().size());
            long t = System.currentTimeMillis();
            List list = join.relate();
            System.out.println("Join returned " + list.size() + " pointers in " + (System.currentTimeMillis() - t) + " ms");
            return list;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

