/*
 * Decompiled with CFR 0.152.
 */
package crosby.binary.file;

import com.google.protobuf.ByteString;
import crosby.binary.Fileformat;
import crosby.binary.file.BlockOutputStream;
import crosby.binary.file.BlockReaderAdapter;
import crosby.binary.file.FileBlockBase;
import crosby.binary.file.FileBlockHead;
import crosby.binary.file.FileBlockPosition;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.Deflater;

public class FileBlock
extends FileBlockBase {
    ByteString data;
    static int warncount = 0;

    private FileBlock(String type, ByteString blob, ByteString indexdata) {
        super(type, indexdata);
        this.data = blob;
    }

    public static FileBlock newInstance(String type, ByteString blob, ByteString indexdata) {
        if (blob != null && blob.size() > 0x1000000) {
            System.err.println("Warning: Fileblock has body size too large and may be considered corrupt");
            if (blob != null && blob.size() > 0x1F00000) {
                throw new Error("This file has too many entities in a block. Parsers will reject it.");
            }
        }
        if (indexdata != null && indexdata.size() > 32768) {
            System.err.println("Warning: Fileblock has indexdata too large and may be considered corrupt");
            if (indexdata != null && indexdata.size() > 65024) {
                throw new Error("This file header is too large. Parsers will reject it.");
            }
        }
        return new FileBlock(type, blob, indexdata);
    }

    protected void deflateInto(Fileformat.Blob.Builder blobbuilder) {
        int size = this.data.size();
        Deflater deflater = new Deflater();
        deflater.setInput(this.data.toByteArray());
        deflater.finish();
        byte[] out = new byte[size];
        deflater.deflate(out);
        if (!deflater.finished()) {
            if (++warncount > 10 && warncount % 100 == 0) {
                System.out.println("Compressed buffers are too short, causing extra copy");
            }
            int newLength = size + size / 64 + 16;
            byte[] copy = new byte[newLength];
            System.arraycopy(out, 0, copy, 0, Math.min(out.length, newLength));
            out = copy;
            deflater.deflate(out, deflater.getTotalOut(), out.length - deflater.getTotalOut());
            if (!deflater.finished()) {
                throw new Error("Internal error in compressor");
            }
        }
        ByteString compressed = ByteString.copyFrom((byte[])out, (int)0, (int)deflater.getTotalOut());
        blobbuilder.setZlibData(compressed);
        deflater.end();
    }

    public FileBlockPosition writeTo(OutputStream outwrite, BlockOutputStream.CompressFlags flags) throws IOException {
        Fileformat.BlockHeader.Builder builder = Fileformat.BlockHeader.newBuilder();
        if (this.indexdata != null) {
            builder.setIndexdata(this.indexdata);
        }
        builder.setType(this.type);
        Fileformat.Blob.Builder blobbuilder = Fileformat.Blob.newBuilder();
        if (flags == BlockOutputStream.CompressFlags.NONE) {
            blobbuilder.setRaw(this.data);
        } else {
            blobbuilder.setRawSize(this.data.size());
            if (flags == BlockOutputStream.CompressFlags.DEFLATE) {
                this.deflateInto(blobbuilder);
            } else {
                throw new Error("Compression flag not understood");
            }
        }
        Fileformat.Blob blob = blobbuilder.build();
        builder.setDatasize(blob.getSerializedSize());
        Fileformat.BlockHeader message = builder.build();
        int size = message.getSerializedSize();
        new DataOutputStream(outwrite).writeInt(size);
        message.writeTo(outwrite);
        long offset = -1L;
        if (outwrite instanceof FileOutputStream) {
            offset = ((FileOutputStream)outwrite).getChannel().position();
        }
        blob.writeTo(outwrite);
        return FileBlockPosition.newInstance(this, offset, size);
    }

    static void process(InputStream input, BlockReaderAdapter callback) throws IOException {
        FileBlockHead fileblock = FileBlockHead.readHead(input);
        if (callback.skipBlock(fileblock)) {
            fileblock.skipContents(input);
        } else {
            callback.handleBlock(fileblock.readContents(input));
        }
    }

    public ByteString getData() {
        return this.data;
    }
}

