/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.samples;

import com.jogamp.opengl.util.Animator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.awt.GLCanvas;
import net.osmand.core.jni.AreaI;
import net.osmand.core.jni.AtlasMapRendererConfiguration;
import net.osmand.core.jni.CoreResourcesEmbeddedBundle;
import net.osmand.core.jni.IMapRenderer;
import net.osmand.core.jni.IMapStylesCollection;
import net.osmand.core.jni.Logger;
import net.osmand.core.jni.MapObjectsSymbolsProvider;
import net.osmand.core.jni.MapPresentationEnvironment;
import net.osmand.core.jni.MapPrimitivesProvider;
import net.osmand.core.jni.MapPrimitiviser;
import net.osmand.core.jni.MapRasterLayerProvider;
import net.osmand.core.jni.MapRasterLayerProvider_Software;
import net.osmand.core.jni.MapRendererClass;
import net.osmand.core.jni.MapRendererSetupOptions;
import net.osmand.core.jni.MapStylesCollection;
import net.osmand.core.jni.ObfMapObjectsProvider;
import net.osmand.core.jni.ObfsCollection;
import net.osmand.core.jni.OsmAndCore;
import net.osmand.core.jni.PointI;
import net.osmand.core.jni.QIODeviceLogSink;
import net.osmand.core.jni.ResolvedMapStyle;

public class Sample1
implements GLEventListener {
    private static final boolean LOAD_STATIC = true;
    private static CoreResourcesEmbeddedBundle _coreResourcesEmbeddedBundle;
    private GLCanvas _canvas;
    private float _displayDensityFactor;
    private int _referenceTileSize;
    private int _rasterTileSize;
    private IMapStylesCollection _mapStylesCollection;
    private ResolvedMapStyle _mapStyle;
    private ObfsCollection _obfsCollection;
    private MapPresentationEnvironment _mapPresentationEnvironment;
    private MapPrimitiviser _mapPrimitiviser;
    private ObfMapObjectsProvider _obfMapObjectsProvider;
    private MapPrimitivesProvider _mapPrimitivesProvider;
    private MapObjectsSymbolsProvider _mapObjectsSymbolsProvider;
    private MapRasterLayerProvider _mapRasterLayerProvider;
    private IMapRenderer _mapRenderer;
    private RenderRequestCallback _renderRequestCallback;
    private QIODeviceLogSink _fileLogSink;

    public static void main(String[] stringArray) {
        try {
            System.loadLibrary("gnustl_shared");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Failed to load gnustl_shared:" + String.valueOf(unsatisfiedLinkError));
            System.exit(0);
        }
        try {
            System.loadLibrary("Qt5Core");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Failed to load Qt5Core:" + String.valueOf(unsatisfiedLinkError));
            System.exit(0);
        }
        try {
            System.loadLibrary("Qt5Network");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Failed to load Qt5Network:" + String.valueOf(unsatisfiedLinkError));
            System.exit(0);
        }
        try {
            System.loadLibrary("Qt5Sql");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Failed to load Qt5Sql:" + String.valueOf(unsatisfiedLinkError));
            System.exit(0);
        }
        try {
            System.loadLibrary("OsmAndCoreWithJNI");
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            System.err.println("Failed to load OsmAndCoreWithJNI:" + String.valueOf(unsatisfiedLinkError));
            System.exit(0);
        }
        _coreResourcesEmbeddedBundle = CoreResourcesEmbeddedBundle.loadFromLibrary("OsmAndCore_ResourcesBundle_shared");
        final Animator animator = new Animator();
        GLCanvas gLCanvas = new GLCanvas();
        Sample1 sample1 = new Sample1(gLCanvas);
        Frame frame = new Frame("OsmAnd Core API samples for Java");
        frame.setSize(800, 600);
        frame.setLayout(new BorderLayout());
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        animator.stop();
                        OsmAndCore.ReleaseCore();
                        System.exit(0);
                    }
                }).start();
            }
        });
        animator.add((GLAutoDrawable)gLCanvas);
        gLCanvas.addGLEventListener((GLEventListener)sample1);
        frame.add((Component)gLCanvas, "Center");
        frame.validate();
        frame.setVisible(true);
        animator.start();
    }

    private Sample1(GLCanvas gLCanvas) {
        this._canvas = gLCanvas;
    }

    public void init(GLAutoDrawable gLAutoDrawable) {
        OsmAndCore.InitializeCore(_coreResourcesEmbeddedBundle);
        this._fileLogSink = QIODeviceLogSink.createFileLogSink("osmandcore.log");
        Logger.get().addLogSink(this._fileLogSink);
        this._displayDensityFactor = 1.0f;
        this._referenceTileSize = 256;
        this._rasterTileSize = 256;
        this._mapStylesCollection = new MapStylesCollection();
        this._mapStyle = this._mapStylesCollection.getResolvedStyleByName("default");
        if (this._mapStyle == null) {
            System.err.println("Failed to resolve style 'default'");
            this.release();
            OsmAndCore.ReleaseCore();
            System.exit(0);
        }
        this._obfsCollection = new ObfsCollection();
        this._obfsCollection.addDirectory("data", false);
        this._mapPresentationEnvironment = new MapPresentationEnvironment(this._mapStyle, this._displayDensityFactor, 1.0f, 1.0f);
        this._mapPresentationEnvironment.setLocaleLanguageId("en");
        this._mapPrimitiviser = new MapPrimitiviser(this._mapPresentationEnvironment);
        this._obfMapObjectsProvider = new ObfMapObjectsProvider(this._obfsCollection);
        this._mapPrimitivesProvider = new MapPrimitivesProvider(this._obfMapObjectsProvider, this._mapPrimitiviser, this._rasterTileSize);
        this._mapObjectsSymbolsProvider = new MapObjectsSymbolsProvider(this._mapPrimitivesProvider, this._rasterTileSize);
        this._mapRasterLayerProvider = new MapRasterLayerProvider_Software(this._mapPrimitivesProvider);
        this._mapRenderer = OsmAndCore.createMapRenderer(MapRendererClass.AtlasMapRenderer_OpenGL2plus);
        if (this._mapRenderer == null) {
            System.err.println("Failed to create map renderer 'AtlasMapRenderer_OpenGL2plus'");
            this.release();
            OsmAndCore.ReleaseCore();
            System.exit(0);
        }
        MapRendererSetupOptions mapRendererSetupOptions = new MapRendererSetupOptions();
        mapRendererSetupOptions.setGpuWorkerThreadEnabled(false);
        this._renderRequestCallback = new RenderRequestCallback();
        mapRendererSetupOptions.setFrameUpdateRequestCallback(this._renderRequestCallback.getBinding());
        this._mapRenderer.setup(mapRendererSetupOptions);
        AtlasMapRendererConfiguration atlasMapRendererConfiguration = AtlasMapRendererConfiguration.Casts.upcastFrom(this._mapRenderer.getConfiguration());
        atlasMapRendererConfiguration.setReferenceTileSizeOnScreenInPixels(this._referenceTileSize);
        this._mapRenderer.setConfiguration(AtlasMapRendererConfiguration.Casts.downcastTo_MapRendererConfiguration(atlasMapRendererConfiguration));
        this._mapRenderer.addSymbolsProvider(this._mapObjectsSymbolsProvider);
        this._mapRenderer.setAzimuth(0.0f);
        this._mapRenderer.setElevationAngle(35.0f);
        this._mapRenderer.setTarget(new PointI(1102430866, 704978668));
        this._mapRenderer.setZoom(10.0f);
        this._mapRenderer.setMapLayerProvider(0, this._mapRasterLayerProvider);
    }

    public void reshape(GLAutoDrawable gLAutoDrawable, int n, int n2, int n3, int n4) {
        this._mapRenderer.setViewport(new AreaI(0, 0, n4, n3));
        this._mapRenderer.setWindowSize(new PointI(n3, n4));
        if (!this._mapRenderer.isRenderingInitialized() && !this._mapRenderer.initializeRendering(true)) {
            System.err.println("Failed to initialize rendering");
        }
    }

    public void display(GLAutoDrawable gLAutoDrawable) {
        if (this._mapRenderer == null || !this._mapRenderer.isRenderingInitialized()) {
            return;
        }
        this._mapRenderer.update();
        if (this._mapRenderer.prepareFrame()) {
            this._mapRenderer.renderFrame();
        }
    }

    public void dispose(GLAutoDrawable gLAutoDrawable) {
        if (this._mapRenderer != null && this._mapRenderer.isRenderingInitialized()) {
            this._mapRenderer.releaseRendering();
        }
        this.release();
    }

    public void release() {
        if (this._mapStylesCollection != null) {
            this._mapStylesCollection.delete();
            this._mapStylesCollection = null;
        }
        if (this._mapStyle != null) {
            this._mapStyle.delete();
            this._mapStyle = null;
        }
        if (this._obfsCollection != null) {
            this._obfsCollection.delete();
            this._obfsCollection = null;
        }
        if (this._mapPresentationEnvironment != null) {
            this._mapPresentationEnvironment.delete();
            this._mapPresentationEnvironment = null;
        }
        if (this._mapPrimitiviser != null) {
            this._mapPrimitiviser.delete();
            this._mapPrimitiviser = null;
        }
        if (this._obfMapObjectsProvider != null) {
            this._obfMapObjectsProvider.delete();
            this._obfMapObjectsProvider = null;
        }
        if (this._mapPrimitivesProvider != null) {
            this._mapPrimitivesProvider.delete();
            this._mapPrimitivesProvider = null;
        }
        if (this._mapObjectsSymbolsProvider != null) {
            this._mapObjectsSymbolsProvider.delete();
            this._mapObjectsSymbolsProvider = null;
        }
        if (this._mapRasterLayerProvider != null) {
            this._mapRasterLayerProvider.delete();
            this._mapRasterLayerProvider = null;
        }
        if (this._mapRenderer != null) {
            this._mapRenderer.delete();
            this._mapRenderer = null;
        }
    }

    private class RenderRequestCallback
    extends MapRendererSetupOptions.IFrameUpdateRequestCallback {
        private RenderRequestCallback() {
        }

        @Override
        public void method(IMapRenderer iMapRenderer) {
            Sample1.this._canvas.repaint();
        }
    }
}

