/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime.format;

import java.time.DayOfWeek;
import java.time.Month;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.reflect.KMutableProperty0;
import kotlin.reflect.KProperty;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.DayOfWeekKt;
import kotlinx.datetime.Instant;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateKt;
import kotlinx.datetime.LocalDateTime;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.TimeZoneKt;
import kotlinx.datetime.UtcOffset;
import kotlinx.datetime.format.AmPmMarker;
import kotlinx.datetime.format.DateTimeComponents;
import kotlinx.datetime.format.DateTimeComponentsContents;
import kotlinx.datetime.format.DateTimeComponentsFormat;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.IncompleteLocalDate;
import kotlinx.datetime.format.IncompleteLocalTime;
import kotlinx.datetime.format.IncompleteUtcOffset;
import kotlinx.datetime.format.LocalDateFormatKt;
import kotlinx.datetime.format.TwoDigitNumber;
import kotlinx.datetime.internal.MathJvmKt;
import kotlinx.datetime.internal.format.AppendableFormatStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 q2\u00020\u0001:\u0002qrB\u0011\b\u0000\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\\\u001a\u00020]2\u0006\u0010^\u001a\u00020_J\u000e\u0010`\u001a\u00020]2\u0006\u0010a\u001a\u00020bJ\u0016\u0010c\u001a\u00020]2\u0006\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020gJ\u0016\u0010c\u001a\u00020]2\u0006\u0010a\u001a\u00020b2\u0006\u0010f\u001a\u00020gJ\u000e\u0010h\u001a\u00020]2\u0006\u0010f\u001a\u00020gJ\u000e\u0010i\u001a\u00020]2\u0006\u0010j\u001a\u00020kJ\u0006\u0010l\u001a\u00020eJ\u0006\u0010m\u001a\u00020_J\u0006\u0010n\u001a\u00020bJ\u0006\u0010o\u001a\u00020kJ\u0006\u0010p\u001a\u00020gR/\u0010\u0007\u001a\u0004\u0018\u00010\u00062\b\u0010\u0005\u001a\u0004\u0018\u00010\u00068F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\r*\u0004\b\b\u0010\tR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR/\u0010\u0011\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R4\u0010\u001b\u001a\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001a2\u000e\u0010\u0018\u001a\n\u0018\u00010\u0019j\u0004\u0018\u0001`\u001a8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001fR/\u0010 \u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b#\u0010\u0017\u001a\u0004\b!\u0010\u0013\"\u0004\b\"\u0010\u0015R/\u0010$\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b'\u0010\u0017\u001a\u0004\b%\u0010\u0013\"\u0004\b&\u0010\u0015R/\u0010(\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b+\u0010\u0017\u001a\u0004\b)\u0010\u0013\"\u0004\b*\u0010\u0015R4\u0010.\u001a\n\u0018\u00010,j\u0004\u0018\u0001`-2\u000e\u0010\u0018\u001a\n\u0018\u00010,j\u0004\u0018\u0001`-8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R/\u00103\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b6\u0010\u0017\u001a\u0004\b4\u0010\u0013\"\u0004\b5\u0010\u0015R(\u00107\u001a\u0004\u0018\u00010\u00102\b\u0010\u0018\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b8\u0010\u0013\"\u0004\b9\u0010\u0015R/\u0010:\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b=\u0010\u0017\u001a\u0004\b;\u0010\u0013\"\u0004\b<\u0010\u0015R/\u0010?\u001a\u0004\u0018\u00010>2\b\u0010\u0005\u001a\u0004\u0018\u00010>8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bA\u0010B\"\u0004\bC\u0010D*\u0004\b@\u0010\tR/\u0010E\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bH\u0010\u0017\u001a\u0004\bF\u0010\u0013\"\u0004\bG\u0010\u0015R/\u0010I\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bL\u0010\u0017\u001a\u0004\bJ\u0010\u0013\"\u0004\bK\u0010\u0015R/\u0010M\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\bP\u0010\u0017\u001a\u0004\bN\u0010\u0013\"\u0004\bO\u0010\u0015R/\u0010R\u001a\u0004\u0018\u00010Q2\b\u0010\u0005\u001a\u0004\u0018\u00010Q8F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bT\u0010U\"\u0004\bV\u0010W*\u0004\bS\u0010\tR/\u0010X\u001a\u0004\u0018\u00010\u00102\b\u0010\u0005\u001a\u0004\u0018\u00010\u00108F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\u001a\u0004\bZ\u0010\u0013\"\u0004\b[\u0010\u0015*\u0004\bY\u0010\t\u00a8\u0006s"}, d2={"Lkotlinx/datetime/format/DateTimeComponents;", "", "contents", "Lkotlinx/datetime/format/DateTimeComponentsContents;", "(Lkotlinx/datetime/format/DateTimeComponentsContents;)V", "<set-?>", "Lkotlinx/datetime/format/AmPmMarker;", "amPm", "getAmPm$delegate", "(Lkotlinx/datetime/format/DateTimeComponents;)Ljava/lang/Object;", "getAmPm", "()Lkotlinx/datetime/format/AmPmMarker;", "setAmPm", "(Lkotlinx/datetime/format/AmPmMarker;)V", "getContents$kotlinx_datetime", "()Lkotlinx/datetime/format/DateTimeComponentsContents;", "", "dayOfMonth", "getDayOfMonth", "()Ljava/lang/Integer;", "setDayOfMonth", "(Ljava/lang/Integer;)V", "dayOfMonth$delegate", "Lkotlinx/datetime/format/TwoDigitNumber;", "value", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "dayOfWeek", "getDayOfWeek", "()Ljava/time/DayOfWeek;", "setDayOfWeek", "(Ljava/time/DayOfWeek;)V", "hour", "getHour", "setHour", "hour$delegate", "hourOfAmPm", "getHourOfAmPm", "setHourOfAmPm", "hourOfAmPm$delegate", "minute", "getMinute", "setMinute", "minute$delegate", "Ljava/time/Month;", "Lkotlinx/datetime/Month;", "month", "getMonth", "()Ljava/time/Month;", "setMonth", "(Ljava/time/Month;)V", "monthNumber", "getMonthNumber", "setMonthNumber", "monthNumber$delegate", "nanosecond", "getNanosecond", "setNanosecond", "offsetHours", "getOffsetHours", "setOffsetHours", "offsetHours$delegate", "", "offsetIsNegative", "getOffsetIsNegative$delegate", "getOffsetIsNegative", "()Ljava/lang/Boolean;", "setOffsetIsNegative", "(Ljava/lang/Boolean;)V", "offsetMinutesOfHour", "getOffsetMinutesOfHour", "setOffsetMinutesOfHour", "offsetMinutesOfHour$delegate", "offsetSecondsOfMinute", "getOffsetSecondsOfMinute", "setOffsetSecondsOfMinute", "offsetSecondsOfMinute$delegate", "second", "getSecond", "setSecond", "second$delegate", "", "timeZoneId", "getTimeZoneId$delegate", "getTimeZoneId", "()Ljava/lang/String;", "setTimeZoneId", "(Ljava/lang/String;)V", "year", "getYear$delegate", "getYear", "setYear", "setDate", "", "localDate", "Lkotlinx/datetime/LocalDate;", "setDateTime", "localDateTime", "Lkotlinx/datetime/LocalDateTime;", "setDateTimeOffset", "instant", "Lkotlinx/datetime/Instant;", "utcOffset", "Lkotlinx/datetime/UtcOffset;", "setOffset", "setTime", "localTime", "Lkotlinx/datetime/LocalTime;", "toInstantUsingOffset", "toLocalDate", "toLocalDateTime", "toLocalTime", "toUtcOffset", "Companion", "Formats", "kotlinx-datetime"})
@SourceDebugExtension(value={"SMAP\nDateTimeComponents.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeComponents.kt\nkotlinx/datetime/format/DateTimeComponents\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,608:1\n1#2:609\n*E\n"})
public final class DateTimeComponents {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final DateTimeComponentsContents contents;
    @NotNull
    private final TwoDigitNumber monthNumber$delegate;
    @NotNull
    private final TwoDigitNumber dayOfMonth$delegate;
    @NotNull
    private final TwoDigitNumber hour$delegate;
    @NotNull
    private final TwoDigitNumber hourOfAmPm$delegate;
    @NotNull
    private final TwoDigitNumber minute$delegate;
    @NotNull
    private final TwoDigitNumber second$delegate;
    @NotNull
    private final TwoDigitNumber offsetHours$delegate;
    @NotNull
    private final TwoDigitNumber offsetMinutesOfHour$delegate;
    @NotNull
    private final TwoDigitNumber offsetSecondsOfMinute$delegate;

    public DateTimeComponents(@NotNull DateTimeComponentsContents contents) {
        Intrinsics.checkNotNullParameter((Object)contents, (String)"contents");
        this.contents = contents;
        this.contents.getDate();
        this.monthNumber$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getDate()){

            @Nullable
            public Object get() {
                return ((IncompleteLocalDate)this.receiver).getMonthNumber();
            }

            public void set(@Nullable Object value) {
                ((IncompleteLocalDate)this.receiver).setMonthNumber((Integer)value);
            }
        }));
        this.dayOfMonth$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getDate()){

            @Nullable
            public Object get() {
                return ((IncompleteLocalDate)this.receiver).getDayOfMonth();
            }

            public void set(@Nullable Object value) {
                ((IncompleteLocalDate)this.receiver).setDayOfMonth((Integer)value);
            }
        }));
        this.hour$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getTime()){

            @Nullable
            public Object get() {
                return ((IncompleteLocalTime)this.receiver).getHour();
            }

            public void set(@Nullable Object value) {
                ((IncompleteLocalTime)this.receiver).setHour((Integer)value);
            }
        }));
        this.hourOfAmPm$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getTime()){

            @Nullable
            public Object get() {
                return ((IncompleteLocalTime)this.receiver).getHourOfAmPm();
            }

            public void set(@Nullable Object value) {
                ((IncompleteLocalTime)this.receiver).setHourOfAmPm((Integer)value);
            }
        }));
        this.contents.getTime();
        this.minute$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getTime()){

            @Nullable
            public Object get() {
                return ((IncompleteLocalTime)this.receiver).getMinute();
            }

            public void set(@Nullable Object value) {
                ((IncompleteLocalTime)this.receiver).setMinute((Integer)value);
            }
        }));
        this.second$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getTime()){

            @Nullable
            public Object get() {
                return ((IncompleteLocalTime)this.receiver).getSecond();
            }

            public void set(@Nullable Object value) {
                ((IncompleteLocalTime)this.receiver).setSecond((Integer)value);
            }
        }));
        this.contents.getOffset();
        this.offsetHours$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getOffset()){

            @Nullable
            public Object get() {
                return ((IncompleteUtcOffset)this.receiver).getTotalHoursAbs();
            }

            public void set(@Nullable Object value) {
                ((IncompleteUtcOffset)this.receiver).setTotalHoursAbs((Integer)value);
            }
        }));
        this.offsetMinutesOfHour$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getOffset()){

            @Nullable
            public Object get() {
                return ((IncompleteUtcOffset)this.receiver).getMinutesOfHour();
            }

            public void set(@Nullable Object value) {
                ((IncompleteUtcOffset)this.receiver).setMinutesOfHour((Integer)value);
            }
        }));
        this.offsetSecondsOfMinute$delegate = new TwoDigitNumber((KMutableProperty0<Integer>)((KMutableProperty0)new MutablePropertyReference0Impl(this.contents.getOffset()){

            @Nullable
            public Object get() {
                return ((IncompleteUtcOffset)this.receiver).getSecondsOfMinute();
            }

            public void set(@Nullable Object value) {
                ((IncompleteUtcOffset)this.receiver).setSecondsOfMinute((Integer)value);
            }
        }));
    }

    public /* synthetic */ DateTimeComponents(DateTimeComponentsContents dateTimeComponentsContents, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            dateTimeComponentsContents = new DateTimeComponentsContents(null, null, null, null, 15, null);
        }
        this(dateTimeComponentsContents);
    }

    @NotNull
    public final DateTimeComponentsContents getContents$kotlinx_datetime() {
        return this.contents;
    }

    public final void setTime(@NotNull LocalTime localTime) {
        Intrinsics.checkNotNullParameter((Object)localTime, (String)"localTime");
        this.contents.getTime().populateFrom(localTime);
    }

    public final void setDate(@NotNull LocalDate localDate) {
        Intrinsics.checkNotNullParameter((Object)localDate, (String)"localDate");
        this.contents.getDate().populateFrom(localDate);
    }

    public final void setDateTime(@NotNull LocalDateTime localDateTime) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"localDateTime");
        this.contents.getDate().populateFrom(localDateTime.getDate());
        this.contents.getTime().populateFrom(localDateTime.getTime());
    }

    public final void setOffset(@NotNull UtcOffset utcOffset) {
        Intrinsics.checkNotNullParameter((Object)utcOffset, (String)"utcOffset");
        this.contents.getOffset().populateFrom(utcOffset);
    }

    public final void setDateTimeOffset(@NotNull Instant instant, @NotNull UtcOffset utcOffset) {
        Intrinsics.checkNotNullParameter((Object)instant, (String)"instant");
        Intrinsics.checkNotNullParameter((Object)utcOffset, (String)"utcOffset");
        Instant smallerInstant = Instant.Companion.fromEpochSeconds(instant.getEpochSeconds() % 315569520000L, instant.getNanosecondsOfSecond());
        this.setDateTime(TimeZoneKt.toLocalDateTime(smallerInstant, utcOffset));
        this.setOffset(utcOffset);
        Integer n = this.getYear();
        Intrinsics.checkNotNull((Object)n);
        this.setYear(n + (int)(instant.getEpochSeconds() / 315569520000L * (long)10000));
    }

    public final void setDateTimeOffset(@NotNull LocalDateTime localDateTime, @NotNull UtcOffset utcOffset) {
        Intrinsics.checkNotNullParameter((Object)localDateTime, (String)"localDateTime");
        Intrinsics.checkNotNullParameter((Object)utcOffset, (String)"utcOffset");
        this.setDateTime(localDateTime);
        this.setOffset(utcOffset);
    }

    @Nullable
    public final Integer getYear() {
        return this.contents.getDate().getYear();
    }

    public final void setYear(@Nullable Integer n) {
        this.contents.getDate().setYear(n);
    }

    private static Object getYear$delegate(DateTimeComponents dateTimeComponents) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)dateTimeComponents.contents.getDate(), IncompleteLocalDate.class, "year", "getYear()Ljava/lang/Integer;", 0)));
    }

    @Nullable
    public final Integer getMonthNumber() {
        return this.monthNumber$delegate.getValue(this, $$delegatedProperties[0]);
    }

    public final void setMonthNumber(@Nullable Integer n) {
        this.monthNumber$delegate.setValue(this, $$delegatedProperties[0], n);
    }

    @Nullable
    public final Month getMonth() {
        Month month2;
        Integer n = this.getMonthNumber();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            month2 = MonthKt.Month(it);
        } else {
            month2 = null;
        }
        return month2;
    }

    public final void setMonth(@Nullable Month value) {
        Month month2 = value;
        this.setMonthNumber(month2 != null ? Integer.valueOf(MonthKt.getNumber(month2)) : null);
    }

    @Nullable
    public final Integer getDayOfMonth() {
        return this.dayOfMonth$delegate.getValue(this, $$delegatedProperties[1]);
    }

    public final void setDayOfMonth(@Nullable Integer n) {
        this.dayOfMonth$delegate.setValue(this, $$delegatedProperties[1], n);
    }

    @Nullable
    public final DayOfWeek getDayOfWeek() {
        DayOfWeek dayOfWeek;
        Integer n = this.contents.getDate().getIsoDayOfWeek();
        if (n != null) {
            int it = ((Number)n).intValue();
            boolean bl = false;
            dayOfWeek = DayOfWeekKt.DayOfWeek(it);
        } else {
            dayOfWeek = null;
        }
        return dayOfWeek;
    }

    public final void setDayOfWeek(@Nullable DayOfWeek value) {
        DayOfWeek dayOfWeek = value;
        this.contents.getDate().setIsoDayOfWeek(dayOfWeek != null ? Integer.valueOf(DayOfWeekKt.getIsoDayNumber(dayOfWeek)) : null);
    }

    @Nullable
    public final Integer getHour() {
        return this.hour$delegate.getValue(this, $$delegatedProperties[2]);
    }

    public final void setHour(@Nullable Integer n) {
        this.hour$delegate.setValue(this, $$delegatedProperties[2], n);
    }

    @Nullable
    public final Integer getHourOfAmPm() {
        return this.hourOfAmPm$delegate.getValue(this, $$delegatedProperties[3]);
    }

    public final void setHourOfAmPm(@Nullable Integer n) {
        this.hourOfAmPm$delegate.setValue(this, $$delegatedProperties[3], n);
    }

    @Nullable
    public final AmPmMarker getAmPm() {
        return this.contents.getTime().getAmPm();
    }

    public final void setAmPm(@Nullable AmPmMarker amPmMarker) {
        this.contents.getTime().setAmPm(amPmMarker);
    }

    private static Object getAmPm$delegate(DateTimeComponents dateTimeComponents) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)dateTimeComponents.contents.getTime(), IncompleteLocalTime.class, "amPm", "getAmPm()Lkotlinx/datetime/format/AmPmMarker;", 0)));
    }

    @Nullable
    public final Integer getMinute() {
        return this.minute$delegate.getValue(this, $$delegatedProperties[4]);
    }

    public final void setMinute(@Nullable Integer n) {
        this.minute$delegate.setValue(this, $$delegatedProperties[4], n);
    }

    @Nullable
    public final Integer getSecond() {
        return this.second$delegate.getValue(this, $$delegatedProperties[5]);
    }

    public final void setSecond(@Nullable Integer n) {
        this.second$delegate.setValue(this, $$delegatedProperties[5], n);
    }

    @Nullable
    public final Integer getNanosecond() {
        return this.contents.getTime().getNanosecond();
    }

    public final void setNanosecond(@Nullable Integer value) {
        if (!(value == null || new IntRange(0, 999999999).contains(value.intValue()))) {
            boolean bl = false;
            String string = "Nanosecond must be in the range [0, 999_999_999].";
            throw new IllegalArgumentException(string.toString());
        }
        this.contents.getTime().setNanosecond(value);
    }

    @Nullable
    public final Boolean getOffsetIsNegative() {
        return this.contents.getOffset().isNegative();
    }

    public final void setOffsetIsNegative(@Nullable Boolean bl) {
        this.contents.getOffset().setNegative(bl);
    }

    private static Object getOffsetIsNegative$delegate(DateTimeComponents dateTimeComponents) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)dateTimeComponents.contents.getOffset(), IncompleteUtcOffset.class, "isNegative", "isNegative()Ljava/lang/Boolean;", 0)));
    }

    @Nullable
    public final Integer getOffsetHours() {
        return this.offsetHours$delegate.getValue(this, $$delegatedProperties[6]);
    }

    public final void setOffsetHours(@Nullable Integer n) {
        this.offsetHours$delegate.setValue(this, $$delegatedProperties[6], n);
    }

    @Nullable
    public final Integer getOffsetMinutesOfHour() {
        return this.offsetMinutesOfHour$delegate.getValue(this, $$delegatedProperties[7]);
    }

    public final void setOffsetMinutesOfHour(@Nullable Integer n) {
        this.offsetMinutesOfHour$delegate.setValue(this, $$delegatedProperties[7], n);
    }

    @Nullable
    public final Integer getOffsetSecondsOfMinute() {
        return this.offsetSecondsOfMinute$delegate.getValue(this, $$delegatedProperties[8]);
    }

    public final void setOffsetSecondsOfMinute(@Nullable Integer n) {
        this.offsetSecondsOfMinute$delegate.setValue(this, $$delegatedProperties[8], n);
    }

    @Nullable
    public final String getTimeZoneId() {
        return this.contents.getTimeZoneId();
    }

    public final void setTimeZoneId(@Nullable String string) {
        this.contents.setTimeZoneId(string);
    }

    private static Object getTimeZoneId$delegate(DateTimeComponents dateTimeComponents) {
        return Reflection.mutableProperty0((MutablePropertyReference0)((MutablePropertyReference0)new MutablePropertyReference0Impl((Object)dateTimeComponents.contents, DateTimeComponentsContents.class, "timeZoneId", "getTimeZoneId()Ljava/lang/String;", 0)));
    }

    @NotNull
    public final UtcOffset toUtcOffset() {
        return this.contents.getOffset().toUtcOffset();
    }

    @NotNull
    public final LocalDate toLocalDate() {
        return this.contents.getDate().toLocalDate();
    }

    @NotNull
    public final LocalTime toLocalTime() {
        return this.contents.getTime().toLocalTime();
    }

    @NotNull
    public final LocalDateTime toLocalDateTime() {
        return LocalDateKt.atTime(this.toLocalDate(), this.toLocalTime());
    }

    @NotNull
    public final Instant toInstantUsingOffset() {
        long l;
        UtcOffset offset = this.toUtcOffset();
        LocalTime time = this.toLocalTime();
        IncompleteLocalDate truncatedDate = this.contents.getDate().copy();
        truncatedDate.setYear(((Number)LocalDateFormatKt.requireParsedField(truncatedDate.getYear(), "year")).intValue() % 10000);
        try {
            Integer n = this.getYear();
            Intrinsics.checkNotNull((Object)n);
            long secDelta = MathJvmKt.safeMultiply((long)(n / 10000), 315569520000L);
            long epochDays = truncatedDate.toLocalDate().toEpochDays();
            l = MathJvmKt.safeAdd(secDelta, epochDays * (long)86400 + (long)time.toSecondOfDay() - (long)offset.getTotalSeconds());
        }
        catch (ArithmeticException e) {
            throw new DateTimeFormatException("The parsed date is outside the range representable by Instant", e);
        }
        long totalSeconds = l;
        if (totalSeconds < Instant.Companion.getMIN$kotlinx_datetime().getEpochSeconds() || totalSeconds > Instant.Companion.getMAX$kotlinx_datetime().getEpochSeconds()) {
            throw new DateTimeFormatException("The parsed date is outside the range representable by Instant");
        }
        Integer n = this.getNanosecond();
        return Instant.Companion.fromEpochSeconds(totalSeconds, n != null ? n : 0);
    }

    public DateTimeComponents() {
        this(null, 1, null);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "monthNumber", "getMonthNumber()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "dayOfMonth", "getDayOfMonth()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "hour", "getHour()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "hourOfAmPm", "getHourOfAmPm()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "minute", "getMinute()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "second", "getSecond()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "offsetHours", "getOffsetHours()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "offsetMinutesOfHour", "getOffsetMinutesOfHour()Ljava/lang/Integer;", 0))), Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(DateTimeComponents.class, "offsetSecondsOfMinute", "getOffsetSecondsOfMinute()Ljava/lang/Integer;", 0)))};
        $$delegatedProperties = kPropertyArray;
        Companion = new Companion(null);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0017\u0010\u0006\u001a\u0013\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lkotlinx/datetime/format/DateTimeComponents$Companion;", "", "()V", "Format", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "block", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithDateTimeComponents;", "", "Lkotlin/ExtensionFunctionType;", "kotlinx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DateTimeFormat<DateTimeComponents> Format(@NotNull Function1<? super DateTimeFormatBuilder.WithDateTimeComponents, Unit> block) {
            Intrinsics.checkNotNullParameter(block, (String)"block");
            DateTimeComponentsFormat.Builder builder = new DateTimeComponentsFormat.Builder(new AppendableFormatStructure<DateTimeComponentsContents>());
            block.invoke((Object)builder);
            return new DateTimeComponentsFormat(builder.build());
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\n"}, d2={"Lkotlinx/datetime/format/DateTimeComponents$Formats;", "", "()V", "ISO_DATE_TIME_OFFSET", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/format/DateTimeComponents;", "getISO_DATE_TIME_OFFSET", "()Lkotlinx/datetime/format/DateTimeFormat;", "RFC_1123", "getRFC_1123", "kotlinx-datetime"})
    public static final class Formats {
        @NotNull
        public static final Formats INSTANCE = new Formats();
        @NotNull
        private static final DateTimeFormat<DateTimeComponents> ISO_DATE_TIME_OFFSET = Companion.Format((Function1<? super DateTimeFormatBuilder.WithDateTimeComponents, Unit>)((Function1)ISO_DATE_TIME_OFFSET.1.INSTANCE));
        @NotNull
        private static final DateTimeFormat<DateTimeComponents> RFC_1123 = Companion.Format((Function1<? super DateTimeFormatBuilder.WithDateTimeComponents, Unit>)((Function1)RFC_1123.1.INSTANCE));

        private Formats() {
        }

        @NotNull
        public final DateTimeFormat<DateTimeComponents> getISO_DATE_TIME_OFFSET() {
            return ISO_DATE_TIME_OFFSET;
        }

        @NotNull
        public final DateTimeFormat<DateTimeComponents> getRFC_1123() {
            return RFC_1123;
        }
    }
}

