/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.data;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.data.KLatLon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 -2\u00020\u0001:\u0001-B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB\u0011\b\u0016\u0012\u0006\u0010\t\u001a\u00020\u0000\u00a2\u0006\u0004\b\u0007\u0010\nB\t\b\u0016\u00a2\u0006\u0004\b\u0007\u0010\u000bJ\u0006\u0010\u0016\u001a\u00020\u0017J&\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u0006\u0010\u001a\u001a\u00020\u0003J\u0006\u0010\u001b\u001a\u00020\u0003J&\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u0003J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u0000J\u000e\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001e\u001a\u00020\u001fJ\u0006\u0010 \u001a\u00020\u0003J\u0006\u0010!\u001a\u00020\u0003J\u0016\u0010\"\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\u0016\u0010%\u001a\u00020\u00192\u0006\u0010#\u001a\u00020\u00032\u0006\u0010$\u001a\u00020\u0003J\u0006\u0010&\u001a\u00020\u0017J\u0013\u0010'\u001a\u00020\u00172\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\r\"\u0004\b\u0011\u0010\u000fR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\r\"\u0004\b\u0013\u0010\u000fR\u001a\u0010\u0006\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000f\u00a8\u0006."}, d2={"Lnet/osmand/shared/data/KQuadRect;", "", "left", "", "top", "right", "bottom", "<init>", "(DDDD)V", "a", "(Lnet/osmand/shared/data/KQuadRect;)V", "()V", "getLeft", "()D", "setLeft", "(D)V", "getRight", "setRight", "getTop", "setTop", "getBottom", "setBottom", "invertedY", "", "expand", "", "width", "height", "contains", "box", "point", "Lnet/osmand/shared/data/KLatLon;", "centerX", "centerY", "offset", "dx", "dy", "inset", "hasInitialState", "equals", "other", "hashCode", "", "toString", "", "Companion", "OsmAnd-shared"})
public final class KQuadRect {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private double left;
    private double right;
    private double top;
    private double bottom;

    public final double getLeft() {
        return this.left;
    }

    public final void setLeft(double d) {
        this.left = d;
    }

    public final double getRight() {
        return this.right;
    }

    public final void setRight(double d) {
        this.right = d;
    }

    public final double getTop() {
        return this.top;
    }

    public final void setTop(double d) {
        this.top = d;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final void setBottom(double d) {
        this.bottom = d;
    }

    public KQuadRect(double left, double top, double right, double bottom) {
        this.left = left;
        this.right = right;
        this.top = top;
        this.bottom = bottom;
    }

    public KQuadRect(@NotNull KQuadRect a) {
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        this(a.left, a.top, a.right, a.bottom);
    }

    public KQuadRect() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public final boolean invertedY() {
        return this.top > this.bottom;
    }

    public final void expand(double left, double top, double right, double bottom) {
        if (this.hasInitialState()) {
            this.left = left;
            this.right = right;
            this.top = top;
            this.bottom = bottom;
        } else {
            this.left = left <= right ? Math.min(left, this.left) : Math.max(left, this.left);
            this.right = left <= right ? Math.max(right, this.right) : Math.min(right, this.right);
            this.top = top <= bottom ? Math.min(top, this.top) : Math.max(top, this.top);
            this.bottom = top <= bottom ? Math.max(bottom, this.bottom) : Math.min(bottom, this.bottom);
        }
    }

    public final double width() {
        return Math.abs(this.right - this.left);
    }

    public final double height() {
        return Math.abs(this.bottom - this.top);
    }

    public final boolean contains(double left, double top, double right, double bottom) {
        return Math.min(this.left, this.right) <= Math.min(left, right) && Math.max(this.left, this.right) >= Math.max(left, right) && Math.min(this.top, this.bottom) <= Math.min(top, bottom) && Math.max(this.top, this.bottom) >= Math.max(top, bottom);
    }

    public final boolean contains(@NotNull KQuadRect box) {
        Intrinsics.checkNotNullParameter((Object)box, (String)"box");
        return this.contains(box.left, box.top, box.right, box.bottom);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean contains(@NotNull KLatLon point) {
        Intrinsics.checkNotNullParameter((Object)point, (String)"point");
        double d = this.left;
        double d2 = this.right;
        double d3 = point.getLongitude();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        boolean bl = true;
        if (!bl) return false;
        d = this.bottom;
        d2 = this.top;
        d3 = point.getLatitude();
        if (!(d <= d3)) return false;
        if (!(d3 <= d2)) return false;
        return true;
    }

    public final double centerX() {
        return (this.left + this.right) / (double)2;
    }

    public final double centerY() {
        return (this.top + this.bottom) / (double)2;
    }

    public final void offset(double dx, double dy) {
        this.left += dx;
        this.top += dy;
        this.right += dx;
        this.bottom += dy;
    }

    public final void inset(double dx, double dy) {
        this.left += dx;
        this.top += dy;
        this.right -= dx;
        this.bottom -= dy;
    }

    public final boolean hasInitialState() {
        return this.left == 0.0 && this.right == 0.0 && this.top == 0.0 && this.bottom == 0.0;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof KQuadRect)) {
            return false;
        }
        return this.left == ((KQuadRect)other).left && this.right == ((KQuadRect)other).right && this.top == ((KQuadRect)other).top && this.bottom == ((KQuadRect)other).bottom;
    }

    public int hashCode() {
        int result = Double.hashCode(this.left);
        result = 31 * result + Double.hashCode(this.right);
        result = 31 * result + Double.hashCode(this.top);
        result = 31 * result + Double.hashCode(this.bottom);
        return result;
    }

    @NotNull
    public String toString() {
        return "[" + (float)this.left + "," + (float)this.top + " - " + (float)this.right + "," + (float)this.bottom + "]";
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007J\u0016\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\f"}, d2={"Lnet/osmand/shared/data/KQuadRect$Companion;", "", "<init>", "()V", "intersects", "", "a", "Lnet/osmand/shared/data/KQuadRect;", "b", "intersectionArea", "", "trivialOverlap", "OsmAnd-shared"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean intersects(@NotNull KQuadRect a, @NotNull KQuadRect b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return Math.min(a.getLeft(), a.getRight()) <= Math.max(b.getLeft(), b.getRight()) && Math.max(a.getLeft(), a.getRight()) >= Math.min(b.getLeft(), b.getRight()) && Math.min(a.getBottom(), a.getTop()) <= Math.max(b.getBottom(), b.getTop()) && Math.max(a.getBottom(), a.getTop()) >= Math.min(b.getBottom(), b.getTop());
        }

        public final double intersectionArea(@NotNull KQuadRect a, @NotNull KQuadRect b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            double xleft = Math.max(Math.min(a.getLeft(), a.getRight()), Math.min(b.getLeft(), b.getRight()));
            double xright = Math.min(Math.max(a.getLeft(), a.getRight()), Math.max(b.getLeft(), b.getRight()));
            double ytop = Math.max(Math.min(a.getTop(), a.getBottom()), Math.min(b.getTop(), b.getBottom()));
            double ybottom = Math.min(Math.max(a.getTop(), a.getBottom()), Math.max(b.getTop(), b.getBottom()));
            return xright <= xleft || ybottom <= ytop ? 0.0 : (xright - xleft) * (ybottom - ytop);
        }

        public final boolean trivialOverlap(@NotNull KQuadRect a, @NotNull KQuadRect b) {
            Intrinsics.checkNotNullParameter((Object)a, (String)"a");
            Intrinsics.checkNotNullParameter((Object)b, (String)"b");
            return this.intersects(a, b);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

