/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.data.QuadRect;
import net.osmand.map.WorldRegion;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.Relation;
import net.osmand.osm.edit.Way;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IndexRegionBboxFilter {
    private static final double INFLATE_REGION_BBOX_KM = 20.0;
    private static final Map<String, String> LOFAR_TELESCOPE_SYMPTOMS = Map.of("name", "LOFAR", "barrier", "gate", "landuse", "grass", "man_made", "telescope");
    private List<QuadRect> inflatedRegionQuads = null;
    private static final Log log = LogFactory.getLog(IndexRegionBboxFilter.class);

    public void initRegionQuads(WorldRegion region) {
        this.inflatedRegionQuads = region.getAllPolygonsBounds();
        double inflate = 0.17966223499820339;
        for (QuadRect rect : this.inflatedRegionQuads) {
            MapUtils.inflateBBoxLatLon((QuadRect)rect, (double)inflate, (double)inflate);
        }
    }

    public boolean shouldFilterPoiEntity(Entity entity) {
        return !this.isInsideRegionBbox(entity);
    }

    public boolean shouldFilterPoiAmenity(Amenity amenity) {
        return !this.isInsideRegionBbox(amenity);
    }

    public boolean shouldFilterMapEntity(Entity entity) {
        Map tags = entity.getTags();
        if (!tags.isEmpty()) {
            for (Map.Entry<String, String> filter : LOFAR_TELESCOPE_SYMPTOMS.entrySet()) {
                if (!filter.getValue().equals(tags.get(filter.getKey()))) continue;
                return !this.isInsideRegionBbox(entity);
            }
        }
        return false;
    }

    public void logEntity(Entity e) {
        log.warn((Object)String.format("MAP out-of-bbox %s [%s]", e.getOsmUrl(), e.getTags()));
    }

    public void logEntityWithAmenity(Entity entity, Amenity amenity) {
        Way way;
        LatLon ll = entity.getLatLon();
        if (entity instanceof Way && !(way = (Way)entity).getNodes().isEmpty()) {
            ll = way.getFirstNode().getLatLon();
        }
        if (entity instanceof Relation && amenity.getLocation() != null) {
            ll = amenity.getLocation();
        }
        if (ll != null) {
            String type = amenity.getType().getKeyName();
            String subtype = amenity.getSubType();
            String name = amenity.getName();
            log.warn((Object)String.format(Locale.US, "POI out-of-bbox %s %.4f %.4f %s %s %s", entity.getOsmUrl(), ll.getLatitude(), ll.getLongitude(), type, subtype, name));
        }
    }

    private boolean isInsideRegionBbox(double lat, double lon) {
        if (this.inflatedRegionQuads == null) {
            return true;
        }
        for (QuadRect quad : this.inflatedRegionQuads) {
            if (!quad.contains(lon, lat, lon, lat)) continue;
            return true;
        }
        return false;
    }

    private boolean isInsideRegionBbox(Amenity amenity) {
        if (amenity == null || amenity.getLocation() == null) {
            return true;
        }
        return this.isInsideRegionBbox(amenity.getLocation().getLatitude(), amenity.getLocation().getLongitude());
    }

    private boolean isInsideRegionBbox(Entity entity) {
        Way way;
        if (this.inflatedRegionQuads == null) {
            return true;
        }
        if (entity instanceof Node) {
            Node node = (Node)entity;
            return this.isInsideRegionBbox(node.getLatitude(), node.getLongitude());
        }
        if (entity instanceof Way && (way = (Way)entity).getFirstNode() != null) {
            ArrayList<LatLon> latLons = new ArrayList<LatLon>();
            latLons.add(way.getFirstNode().getLatLon());
            latLons.add(way.getLastNode().getLatLon());
            if (way.getNodes().size() > 2) {
                latLons.add(((Node)way.getNodes().get(way.getNodes().size() / 2)).getLatLon());
            }
            for (LatLon l : latLons) {
                if (!this.isInsideRegionBbox(l.getLatitude(), l.getLongitude())) continue;
                return true;
            }
            return false;
        }
        if (entity instanceof Relation) {
            Relation relation = (Relation)entity;
            for (Relation.RelationMember member : relation.getMembers()) {
                if (!this.isInsideRegionBbox(member.getEntity())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

