/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.EquatorEpoch;
import io.github.cosinekitty.astronomy.Equatorial;
import io.github.cosinekitty.astronomy.Observer;
import io.github.cosinekitty.astronomy.PrecessDirection;
import io.github.cosinekitty.astronomy.Refraction;
import io.github.cosinekitty.astronomy.Spherical;
import io.github.cosinekitty.astronomy.Time;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0010\u001a\u00020\u0003J\u0011\u0010\u0011\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u0014\u001a\u00020\u0000H\u0086\u0002J\u0011\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0004J\u000e\u0010\u0016\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000J\u0011\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001fJ\u000e\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#J\u000e\u0010$\u001a\u00020\u00002\u0006\u0010%\u001a\u00020\u0007J\t\u0010&\u001a\u00020\u0003H\u00c6\u0003J\t\u0010'\u001a\u00020\u0003H\u00c6\u0003J\t\u0010(\u001a\u00020\u0003H\u00c6\u0003J\t\u0010)\u001a\u00020\u0007H\u00c6\u0003J1\u0010*\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010+\u001a\u00020,2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010-\u001a\u00020.H\u00d6\u0001J\t\u0010/\u001a\u000200H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u00061"}, d2={"Lio/github/cosinekitty/astronomy/Vector;", "", "x", "", "y", "z", "t", "Lio/github/cosinekitty/astronomy/Time;", "<init>", "(DDDLio/github/cosinekitty/astronomy/Time;)V", "getX", "()D", "getY", "getZ", "getT", "()Lio/github/cosinekitty/astronomy/Time;", "length", "plus", "other", "minus", "unaryMinus", "dot", "angleWith", "div", "denom", "toSpherical", "Lio/github/cosinekitty/astronomy/Spherical;", "toEquatorial", "Lio/github/cosinekitty/astronomy/Equatorial;", "toHorizontal", "refraction", "Lio/github/cosinekitty/astronomy/Refraction;", "toObserver", "Lio/github/cosinekitty/astronomy/Observer;", "equator", "Lio/github/cosinekitty/astronomy/EquatorEpoch;", "withTime", "time", "component1", "component2", "component3", "component4", "copy", "equals", "", "hashCode", "", "toString", "", "OsmAnd-shared"})
public final class Vector {
    private final double x;
    private final double y;
    private final double z;
    @NotNull
    private final Time t;

    public Vector(double x, double y, double z, @NotNull Time t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.x = x;
        this.y = y;
        this.z = z;
        this.t = t;
    }

    public final double getX() {
        return this.x;
    }

    public final double getY() {
        return this.y;
    }

    public final double getZ() {
        return this.z;
    }

    @NotNull
    public final Time getT() {
        return this.t;
    }

    public final double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    @NotNull
    public final Vector plus(@NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector(this.x + other.x, this.y + other.y, this.z + other.z, Astronomy.verifyIdenticalTimes(this.t, other.t));
    }

    @NotNull
    public final Vector minus(@NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return new Vector(this.x - other.x, this.y - other.y, this.z - other.z, Astronomy.verifyIdenticalTimes(this.t, other.t));
    }

    @NotNull
    public final Vector unaryMinus() {
        return new Vector(-this.x, -this.y, -this.z, this.t);
    }

    public final double dot(@NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        Astronomy.verifyIdenticalTimes(this.t, other.t);
        return this.x * other.x + this.y * other.y + this.z * other.z;
    }

    public final double angleWith(@NotNull Vector other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        double d = this.dot(other) / (this.length() * other.length());
        return d <= -1.0 ? 180.0 : (d >= 1.0 ? 0.0 : Astronomy.radiansToDegrees(Math.acos(d)));
    }

    @NotNull
    public final Vector div(double denom) {
        return new Vector(this.x / denom, this.y / denom, this.z / denom, this.t);
    }

    @NotNull
    public final Spherical toSpherical() {
        double xyproj = this.x * this.x + this.y * this.y;
        double dist = Math.sqrt(xyproj + this.z * this.z);
        double lat = 0.0;
        double lon = 0.0;
        if (xyproj == 0.0) {
            if (this.z == 0.0) {
                throw new IllegalArgumentException("Cannot convert zero-length vector to spherical coordinates.");
            }
            lon = 0.0;
            lat = this.z < 0.0 ? -90.0 : 90.0;
        } else {
            lon = Astronomy.access$withMinDegreeValue(Astronomy.datan2(this.y, this.x), 0.0);
            lat = Astronomy.datan2(this.z, Math.sqrt(xyproj));
        }
        return new Spherical(lat, lon, dist);
    }

    @NotNull
    public final Equatorial toEquatorial() {
        Spherical sphere = this.toSpherical();
        return new Equatorial(sphere.getLon() / 15.0, sphere.getLat(), sphere.getDist(), this);
    }

    @NotNull
    public final Spherical toHorizontal(@NotNull Refraction refraction) {
        Intrinsics.checkNotNullParameter((Object)((Object)refraction), (String)"refraction");
        Spherical sphere = this.toSpherical();
        return new Spherical(sphere.getLat() + Astronomy.refractionAngle(refraction, sphere.getLat()), Astronomy.access$toggleAzimuthDirection(sphere.getLon()), sphere.getDist());
    }

    @NotNull
    public final Observer toObserver(@NotNull EquatorEpoch equator) {
        Intrinsics.checkNotNullParameter((Object)((Object)equator), (String)"equator");
        Vector vector = switch (WhenMappings.$EnumSwitchMapping$0[equator.ordinal()]) {
            case 1 -> Astronomy.access$gyration(this, PrecessDirection.From2000);
            case 2 -> this;
            default -> throw new NoWhenBranchMatchedException();
        };
        return Astronomy.access$inverseTerra(vector);
    }

    @NotNull
    public final Vector withTime(@NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        return new Vector(this.x, this.y, this.z, time);
    }

    public final double component1() {
        return this.x;
    }

    public final double component2() {
        return this.y;
    }

    public final double component3() {
        return this.z;
    }

    @NotNull
    public final Time component4() {
        return this.t;
    }

    @NotNull
    public final Vector copy(double x, double y, double z, @NotNull Time t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        return new Vector(x, y, z, t);
    }

    public static /* synthetic */ Vector copy$default(Vector vector, double d, double d2, double d3, Time time, int n, Object object) {
        if ((n & 1) != 0) {
            d = vector.x;
        }
        if ((n & 2) != 0) {
            d2 = vector.y;
        }
        if ((n & 4) != 0) {
            d3 = vector.z;
        }
        if ((n & 8) != 0) {
            time = vector.t;
        }
        return vector.copy(d, d2, d3, time);
    }

    @NotNull
    public String toString() {
        return "Vector(x=" + this.x + ", y=" + this.y + ", z=" + this.z + ", t=" + this.t + ")";
    }

    public int hashCode() {
        int result = Double.hashCode(this.x);
        result = result * 31 + Double.hashCode(this.y);
        result = result * 31 + Double.hashCode(this.z);
        result = result * 31 + this.t.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Vector)) {
            return false;
        }
        Vector vector = (Vector)other;
        if (Double.compare(this.x, vector.x) != 0) {
            return false;
        }
        if (Double.compare(this.y, vector.y) != 0) {
            return false;
        }
        if (Double.compare(this.z, vector.z) != 0) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.t, (Object)vector.t);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[EquatorEpoch.values().length];
            try {
                nArray[EquatorEpoch.J2000.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[EquatorEpoch.OfDate.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

