/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.reflect.InvocationTargetException;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import net.osmand.IProgress;
import net.osmand.PlatformUtil;
import net.osmand.swing.Messages;
import org.apache.commons.logging.Log;

public class ProgressDialog
extends JDialog
implements IProgress {
    private static final long serialVersionUID = -3915486672514402269L;
    private static final Log log = PlatformUtil.getLog(ProgressDialog.class);
    private JProgressBar progressBar;
    private JLabel label;
    private Runnable run;
    private InvocationTargetException exception = null;
    private Object result;
    private static final float deltaToChange = 0.001f;
    private String taskName;
    private int deltaWork;
    private WorkerThread workerThread;
    private String genProgress;
    private long previousTaskStarted = 0L;

    public ProgressDialog(Component parent, String name) {
        super(JOptionPane.getFrameForComponent(parent), true);
        this.setTitle(name);
        this.initDialog();
    }

    public boolean isInterrupted() {
        return !this.isVisible();
    }

    public Object run() throws InvocationTargetException, InterruptedException {
        this.result = null;
        this.workerThread = new WorkerThread();
        this.workerThread.start();
        this.setVisible(true);
        if (this.workerThread.checkIsLive()) {
            this.workerThread.stop();
            throw new InterruptedException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.result;
    }

    private void initDialog() {
        JPanel pane = new JPanel(new BorderLayout());
        pane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.progressBar = new JProgressBar();
        pane.add((Component)this.progressBar, "South");
        this.label = new JLabel();
        pane.add((Component)this.label, "Center");
        this.add(pane);
        this.label.setText(Messages.getString("OsmExtractionUI.PLEASE.WAIT"));
        this.progressBar.setIndeterminate(true);
        this.setSize(550, 100);
        double x = this.getParent().getBounds().getCenterX();
        double y = this.getParent().getBounds().getCenterY();
        this.setLocation((int)x - this.getWidth() / 2, (int)y - this.getHeight() / 2);
    }

    public Object getResult() {
        return this.result;
    }

    public void setResult(Object result) {
        this.result = result;
    }

    public void setRunnable(Runnable run) {
        this.run = run;
    }

    public void progress(int deltaWork) {
        this.deltaWork += deltaWork;
        if (this.change(this.progressBar.getValue() + this.deltaWork)) {
            this.progressBar.setValue(this.progressBar.getValue() + this.deltaWork);
            this.deltaWork = 0;
            this.updateMessage();
        }
    }

    private void updateMessage() {
        if (!this.progressBar.isIndeterminate()) {
            String format = String.format("\t %.1f %%", Float.valueOf((float)this.progressBar.getValue() * 100.0f / (float)this.progressBar.getMaximum()));
            this.label.setText(this.taskName + format + (String)(this.genProgress == null ? "" : "   " + this.genProgress));
        }
    }

    public boolean change(int newProgress) {
        if (newProgress < this.progressBar.getValue()) {
            return false;
        }
        return !((float)(newProgress - this.progressBar.getValue()) / (float)this.progressBar.getMaximum() < 0.001f);
    }

    public void remaining(int remainingWork) {
        if (this.change(this.progressBar.getMaximum() - remainingWork)) {
            this.progressBar.setValue(this.progressBar.getMaximum() - remainingWork);
            this.updateMessage();
        }
        this.deltaWork = this.progressBar.getMaximum() - remainingWork - this.progressBar.getValue();
    }

    public boolean isIndeterminate() {
        return this.progressBar.isIndeterminate();
    }

    public void setGeneralProgress(String genProgress) {
        this.genProgress = genProgress;
    }

    public void startTask(String taskName, int work) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Memory before task exec: " + Runtime.getRuntime().totalMemory() + " free : " + Runtime.getRuntime().freeMemory()));
            if (this.previousTaskStarted == 0L) {
                log.debug((Object)(taskName + " started"));
            } else {
                log.debug((Object)(taskName + " started after " + (System.currentTimeMillis() - this.previousTaskStarted) + " ms"));
            }
        }
        this.previousTaskStarted = System.currentTimeMillis();
        if (taskName == null) {
            taskName = "";
        }
        this.label.setText(taskName + (String)(this.genProgress == null ? "" : "   " + this.genProgress));
        this.taskName = taskName;
        this.startWork(work);
    }

    public void finishTask() {
        if (this.taskName != null) {
            this.label.setText(this.taskName);
        }
        this.progressBar.setIndeterminate(true);
    }

    public void startWork(int work) {
        if (work == 0) {
            work = 1;
        }
        final int w = work;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (w != -1) {
                    ProgressDialog.this.progressBar.setMinimum(0);
                    ProgressDialog.this.progressBar.setMaximum(w);
                    ProgressDialog.this.progressBar.setValue(0);
                    ProgressDialog.this.progressBar.setIndeterminate(false);
                } else {
                    ProgressDialog.this.progressBar.setIndeterminate(true);
                }
            }
        });
        this.deltaWork = 0;
    }

    private class WorkerThread
    extends Thread {
        private boolean isLive = true;

        private WorkerThread() {
        }

        public boolean checkIsLive() {
            return this.isLive;
        }

        @Override
        public void run() {
            try {
                if (ProgressDialog.this.run != null) {
                    ProgressDialog.this.run.run();
                }
            }
            catch (RuntimeException e) {
                ProgressDialog.this.exception = new InvocationTargetException(e);
            }
            finally {
                this.isLive = false;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProgressDialog.this.setVisible(false);
                }
            });
        }
    }
}

