/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm.oauth;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.exceptions.OAuthException;
import com.github.scribejava.core.httpclient.jdk.JDKHttpClientConfig;
import com.github.scribejava.core.model.OAuth2AccessToken;
import com.github.scribejava.core.model.OAuthAsyncRequestCallback;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.model.Response;
import com.github.scribejava.core.model.Verb;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import net.osmand.PlatformUtil;
import net.osmand.osm.oauth.OsmAndJDKHttpClient;
import net.osmand.osm.oauth.ServiceBuilder;
import org.apache.commons.logging.Log;

public class OsmOAuthAuthorizationClient {
    private OAuth2AccessToken accessToken;
    private String apiSecret;
    private final OAuth20Service service;
    private final OsmAndJDKHttpClient httpClient;
    public static final Log log = PlatformUtil.getLog(OsmOAuthAuthorizationClient.class);

    public OsmOAuthAuthorizationClient(String key, String apiSecret, DefaultApi20 api, String redirectUri, String scope) {
        this.apiSecret = apiSecret;
        this.httpClient = new OsmAndJDKHttpClient(JDKHttpClientConfig.defaultConfig());
        this.service = new ServiceBuilder(key).apiSecret(apiSecret).httpClient(this.httpClient).defaultScope(scope).callback(redirectUri).build(api);
    }

    public OsmAndJDKHttpClient getHttpClient() {
        return this.httpClient;
    }

    public OAuth20Service getService() {
        return this.service;
    }

    public void setAccessToken(OAuth2AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    public OAuth2AccessToken getAccessToken() {
        return this.accessToken;
    }

    public String getApiSecret() {
        return this.apiSecret;
    }

    public Response performRequestWithoutAuth(String url, String requestMethod, String requestBody) throws InterruptedException, ExecutionException, IOException {
        Verb verb = this.parseRequestMethod(requestMethod);
        OAuthRequest req = new OAuthRequest(verb, url);
        req.setPayload(requestBody);
        return this.service.execute(req);
    }

    public void performGetRequest(String url, OAuthAsyncRequestCallback<Response> callback) {
        if (this.accessToken == null) {
            throw new IllegalStateException("Access token is null");
        }
        OAuthRequest req = new OAuthRequest(Verb.GET, url);
        this.service.signRequest(this.accessToken, req);
        this.service.execute(req, callback);
    }

    public Response performRequest(String url, String method, String body) throws InterruptedException, ExecutionException, IOException {
        if (this.accessToken == null) {
            throw new IllegalStateException("Access token is null");
        }
        Verb verbMethod = this.parseRequestMethod(method);
        OAuthRequest req = new OAuthRequest(verbMethod, url);
        req.setPayload(body);
        this.service.signRequest(this.accessToken, req);
        req.addHeader("Content-Type", "application/xml");
        return this.service.execute(req);
    }

    public OAuth2AccessToken authorize(String oauthVerifier) {
        try {
            this.setAccessToken(this.service.getAccessToken(oauthVerifier));
        }
        catch (OAuthException | IOException | IllegalArgumentException | InterruptedException | ExecutionException e) {
            log.error((Object)e);
        }
        return this.accessToken;
    }

    public boolean isValidToken() {
        return this.accessToken != null;
    }

    private Verb parseRequestMethod(String method) {
        Verb m = Verb.GET;
        if (method.equals("POST")) {
            m = Verb.POST;
        }
        if (method.equals("PUT")) {
            m = Verb.PUT;
        }
        if (method.equals("DELETE")) {
            m = Verb.DELETE;
        }
        return m;
    }

    public static class OsmDevApi
    extends DefaultApi20 {
        public String getAccessTokenEndpoint() {
            return "https://master.apis.dev.openstreetmap.org/oauth2/token";
        }

        protected String getAuthorizationBaseUrl() {
            return "https://master.apis.dev.openstreetmap.org/oauth2/authorize";
        }
    }

    public static class OsmApi
    extends DefaultApi20 {
        public String getAccessTokenEndpoint() {
            return "https://www.openstreetmap.org/oauth2/token";
        }

        protected String getAuthorizationBaseUrl() {
            return "https://www.openstreetmap.org/oauth2/authorize";
        }
    }
}

