/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.osmand.impl.ConsoleProgressImplementation;

public class FileProgressImplementation
extends ConsoleProgressImplementation {
    private long length;
    private long read = 0L;
    private File file;
    private long lastPrintedTime;
    private long lastPrintedBytes;

    public FileProgressImplementation(String taskName, File toRead) {
        this.file = toRead;
        this.length = toRead.length();
        this.startTaskLong(taskName, this.length);
    }

    public void update() {
        this.remainingLong(this.length - this.read);
    }

    @Override
    protected String getPrintMessage() {
        long now = System.currentTimeMillis();
        double spd = 0.0;
        if (this.lastPrintedTime != 0L && now - this.lastPrintedTime > 0L) {
            spd = ((double)this.read - (double)this.lastPrintedBytes) / 1048576.0 / ((double)(now - this.lastPrintedTime) / 1000.0);
        }
        String msg = String.format("Done %.2f%% %.2f MBs", this.getCurrentPercent(), spd);
        this.lastPrintedTime = now;
        this.lastPrintedBytes = this.read;
        return msg;
    }

    public InputStream openFileInputStream() throws IOException {
        final FileInputStream is = new FileInputStream(this.file);
        return new InputStream(){

            @Override
            public int read() throws IOException {
                int r = is.read();
                if (r >= 0) {
                    ++FileProgressImplementation.this.read;
                }
                return r;
            }

            @Override
            public int read(byte[] b, int off, int len) throws IOException {
                int rd = is.read(b, off, len);
                if (rd >= 0) {
                    FileProgressImplementation.this.read += (long)rd;
                }
                return rd;
            }

            @Override
            public long skip(long n) throws IOException {
                long skip = is.skip(n);
                if (skip >= 0L) {
                    FileProgressImplementation.this.read += skip;
                }
                return skip;
            }

            @Override
            public int read(byte[] b) throws IOException {
                int rd = is.read(b);
                if (rd >= 0) {
                    FileProgressImplementation.this.read += (long)rd;
                }
                return rd;
            }

            @Override
            public void close() throws IOException {
                is.close();
            }
        };
    }
}

