/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.parser;

import com.steadystate.css.parser.CharStream;
import com.steadystate.css.parser.CssCharStream;
import com.steadystate.css.parser.HandlerBase;
import com.steadystate.css.parser.LexicalUnitImpl;
import com.steadystate.css.parser.LocatorImpl;
import com.steadystate.css.parser.ParseException;
import com.steadystate.css.parser.SACMediaListImpl;
import com.steadystate.css.parser.Token;
import com.steadystate.css.parser.TokenMgrError;
import com.steadystate.css.parser.selectors.ConditionFactoryImpl;
import com.steadystate.css.parser.selectors.SelectorFactoryImpl;
import com.steadystate.css.sac.DocumentHandlerExt;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.ConditionFactory;
import org.w3c.css.sac.DocumentHandler;
import org.w3c.css.sac.ErrorHandler;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;
import org.w3c.css.sac.Locator;
import org.w3c.css.sac.Parser;
import org.w3c.css.sac.SACMediaList;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SelectorFactory;
import org.w3c.css.sac.SelectorList;

abstract class AbstractSACParser
implements Parser {
    private DocumentHandler documentHandler_;
    private ErrorHandler errorHandler_;
    private InputSource source_;
    private Locale locale_;
    private SelectorFactory selectorFactory_;
    private ConditionFactory conditionFactory_;
    private ResourceBundle sacParserMessages_;
    private static final String NUM_CHARS = "0123456789.";

    AbstractSACParser() {
    }

    protected abstract Token getToken();

    protected DocumentHandler getDocumentHandler() {
        if (this.documentHandler_ == null) {
            this.setDocumentHandler(new HandlerBase());
        }
        return this.documentHandler_;
    }

    public void setDocumentHandler(DocumentHandler handler) {
        this.documentHandler_ = handler;
    }

    protected ErrorHandler getErrorHandler() {
        if (this.errorHandler_ == null) {
            this.setErrorHandler(new HandlerBase());
        }
        return this.errorHandler_;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.errorHandler_ = eh;
    }

    protected InputSource getInputSource() {
        return this.source_;
    }

    public void setLocale(Locale locale) {
        if (this.locale_ != locale) {
            this.sacParserMessages_ = null;
        }
        this.locale_ = locale;
    }

    protected Locale getLocale() {
        if (this.locale_ == null) {
            this.setLocale(Locale.getDefault());
        }
        return this.locale_;
    }

    protected SelectorFactory getSelectorFactory() {
        if (this.selectorFactory_ == null) {
            this.selectorFactory_ = new SelectorFactoryImpl();
        }
        return this.selectorFactory_;
    }

    public void setSelectorFactory(SelectorFactory selectorFactory) {
        this.selectorFactory_ = selectorFactory;
    }

    protected ConditionFactory getConditionFactory() {
        if (this.conditionFactory_ == null) {
            this.conditionFactory_ = new ConditionFactoryImpl();
        }
        return this.conditionFactory_;
    }

    public void setConditionFactory(ConditionFactory conditionFactory) {
        this.conditionFactory_ = conditionFactory;
    }

    protected ResourceBundle getSACParserMessages() {
        if (this.sacParserMessages_ == null) {
            try {
                this.sacParserMessages_ = ResourceBundle.getBundle("com.steadystate.css.parser.SACParserMessages", this.getLocale());
            }
            catch (MissingResourceException e) {
                e.printStackTrace();
            }
        }
        return this.sacParserMessages_;
    }

    public Locator getLocator() {
        return this.createLocator(this.getToken());
    }

    protected Locator createLocator(Token t) {
        return new LocatorImpl(this.getInputSource().getURI(), t == null ? 0 : t.beginLine, t == null ? 0 : t.beginColumn);
    }

    protected String add_escapes(String str) {
        StringBuilder retval = new StringBuilder();
        block11: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\u0000': {
                    continue block11;
                }
                case '\b': {
                    retval.append("\\b");
                    continue block11;
                }
                case '\t': {
                    retval.append("\\t");
                    continue block11;
                }
                case '\n': {
                    retval.append("\\n");
                    continue block11;
                }
                case '\f': {
                    retval.append("\\f");
                    continue block11;
                }
                case '\r': {
                    retval.append("\\r");
                    continue block11;
                }
                case '\"': {
                    retval.append("\\\"");
                    continue block11;
                }
                case '\'': {
                    retval.append("\\'");
                    continue block11;
                }
                case '\\': {
                    retval.append("\\\\");
                    continue block11;
                }
                default: {
                    if (ch < ' ' || ch > '~') {
                        String s = "0000" + Integer.toString(ch, 16);
                        retval.append("\\u" + s.substring(s.length() - 4, s.length()));
                        continue block11;
                    }
                    retval.append(ch);
                }
            }
        }
        return retval.toString();
    }

    protected CSSParseException toCSSParseException(String key, ParseException e) {
        String messagePattern1 = this.getSACParserMessages().getString("invalidExpectingOne");
        String messagePattern2 = this.getSACParserMessages().getString("invalidExpectingMore");
        int maxSize = 0;
        StringBuilder expected = new StringBuilder();
        for (int i = 0; i < e.expectedTokenSequences.length; ++i) {
            if (maxSize < e.expectedTokenSequences[i].length) {
                maxSize = e.expectedTokenSequences[i].length;
            }
            for (int j = 0; j < e.expectedTokenSequences[i].length; ++j) {
                expected.append(e.tokenImage[e.expectedTokenSequences[i][j]]);
            }
            if (i >= e.expectedTokenSequences.length - 1) continue;
            expected.append(", ");
        }
        StringBuilder invalid = new StringBuilder();
        Token tok = e.currentToken.next;
        for (int i = 0; i < maxSize; ++i) {
            if (i != 0) {
                invalid.append(" ");
            }
            if (tok.kind == 0) {
                invalid.append(e.tokenImage[0]);
                break;
            }
            invalid.append(this.add_escapes(tok.image));
            tok = tok.next;
        }
        String s = null;
        try {
            s = this.getSACParserMessages().getString(key);
        }
        catch (MissingResourceException ex) {
            s = key;
        }
        StringBuilder message = new StringBuilder(s);
        message.append(" (");
        if (e.expectedTokenSequences.length == 1) {
            message.append(MessageFormat.format(messagePattern1, invalid, expected));
        } else {
            message.append(MessageFormat.format(messagePattern2, invalid, expected));
        }
        message.append(")");
        return new CSSParseException(message.toString(), this.getInputSource().getURI(), e.currentToken.next.beginLine, e.currentToken.next.beginColumn);
    }

    protected CSSParseException toCSSParseException(TokenMgrError e) {
        String messagePattern = this.getSACParserMessages().getString("tokenMgrError");
        return new CSSParseException(messagePattern, this.getInputSource().getURI(), 1, 1);
    }

    protected CSSParseException toCSSParseException(String messageKey, Object[] msgParams, Locator locator) {
        String messagePattern = this.getSACParserMessages().getString(messageKey);
        return new CSSParseException(MessageFormat.format(messagePattern, msgParams), locator);
    }

    protected CSSParseException createSkipWarning(String key, CSSParseException e) {
        String s = null;
        try {
            s = this.getSACParserMessages().getString(key);
        }
        catch (MissingResourceException ex) {
            s = key;
        }
        return new CSSParseException(s, e.getURI(), e.getLineNumber(), e.getColumnNumber());
    }

    public void parseStyleSheet(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(this.getCharStream(source));
        try {
            this.styleSheet();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidStyleSheet", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
    }

    public void parseStyleSheet(String uri) throws IOException {
        this.parseStyleSheet(new InputSource(uri));
    }

    public void parseStyleDeclaration(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(this.getCharStream(source));
        try {
            this.styleDeclaration();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidStyleDeclaration", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
    }

    public void parseRule(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(this.getCharStream(source));
        try {
            this.styleSheetRuleSingle();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidRule", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
    }

    public SelectorList parseSelectors(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(this.getCharStream(source));
        SelectorList sl = null;
        try {
            sl = this.parseSelectorsInternal();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidSelectorList", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return sl;
    }

    public LexicalUnit parsePropertyValue(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(this.getCharStream(source));
        LexicalUnit lu = null;
        try {
            lu = this.expr();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidExpr", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return lu;
    }

    public boolean parsePriority(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(this.getCharStream(source));
        boolean b = false;
        try {
            b = this.prio();
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidPrio", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return b;
    }

    public SACMediaList parseMedia(InputSource source) throws IOException {
        this.source_ = source;
        this.ReInit(this.getCharStream(source));
        SACMediaListImpl ml = new SACMediaListImpl();
        try {
            this.mediaList(ml);
        }
        catch (ParseException e) {
            this.getErrorHandler().error(this.toCSSParseException("invalidMediaList", e));
        }
        catch (TokenMgrError e) {
            this.getErrorHandler().error(this.toCSSParseException(e));
        }
        catch (CSSParseException e) {
            this.getErrorHandler().error(e);
        }
        return ml;
    }

    private CharStream getCharStream(InputSource source) throws IOException {
        if (source.getCharacterStream() != null) {
            return new CssCharStream(source.getCharacterStream(), 1, 1);
        }
        if (source.getByteStream() != null) {
            return new CssCharStream(new InputStreamReader(source.getByteStream()), 1, 1);
        }
        if (source.getURI() != null) {
            return new CssCharStream(new InputStreamReader(new URL(source.getURI()).openStream()), 1, 1);
        }
        return null;
    }

    public abstract String getParserVersion();

    protected abstract String getGrammarUri();

    protected abstract void ReInit(CharStream var1);

    protected abstract void styleSheet() throws CSSParseException, ParseException;

    protected abstract void styleDeclaration() throws ParseException;

    protected abstract void styleSheetRuleSingle() throws ParseException;

    protected abstract SelectorList parseSelectorsInternal() throws ParseException;

    protected abstract SelectorList selectorList() throws ParseException;

    protected abstract LexicalUnit expr() throws ParseException;

    protected abstract boolean prio() throws ParseException;

    protected abstract void mediaList(SACMediaListImpl var1) throws ParseException;

    protected void handleStartDocument() {
        this.getDocumentHandler().startDocument(this.getInputSource());
    }

    protected void handleEndDocument() {
        this.getDocumentHandler().endDocument(this.getInputSource());
    }

    protected void handleIgnorableAtRule(String s, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).ignorableAtRule(s, locator);
        } else {
            documentHandler.ignorableAtRule(s);
        }
    }

    protected void handleCharset(String characterEncoding, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).charset(characterEncoding, locator);
        }
    }

    protected void handleImportStyle(String uri, SACMediaList media, String defaultNamespaceURI, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).importStyle(uri, media, defaultNamespaceURI, locator);
        } else {
            documentHandler.importStyle(uri, media, defaultNamespaceURI);
        }
    }

    protected void handleStartMedia(SACMediaList media, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startMedia(media, locator);
        } else {
            documentHandler.startMedia(media);
        }
    }

    protected void handleMedium(String medium, Locator locator) {
    }

    protected void handleEndMedia(SACMediaList media) {
        this.getDocumentHandler().endMedia(media);
    }

    protected void handleStartPage(String name, String pseudoPage, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startPage(name, pseudoPage, locator);
        } else {
            documentHandler.startPage(name, pseudoPage);
        }
    }

    protected void handleEndPage(String name, String pseudoPage) {
        this.getDocumentHandler().endPage(name, pseudoPage);
    }

    protected void handleStartFontFace(Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startFontFace(locator);
        } else {
            documentHandler.startFontFace();
        }
    }

    protected void handleEndFontFace() {
        this.getDocumentHandler().endFontFace();
    }

    protected void handleSelector(Selector selector) {
    }

    protected void handleStartSelector(SelectorList selectors, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).startSelector(selectors, locator);
        } else {
            documentHandler.startSelector(selectors);
        }
    }

    protected void handleEndSelector(SelectorList selectors) {
        this.getDocumentHandler().endSelector(selectors);
    }

    protected void handleProperty(String name, LexicalUnit value, boolean important, Locator locator) {
        DocumentHandler documentHandler = this.getDocumentHandler();
        if (documentHandler instanceof DocumentHandlerExt) {
            ((DocumentHandlerExt)documentHandler).property(name, value, important, locator);
        } else {
            documentHandler.property(name, value, important);
        }
    }

    protected LexicalUnit functionInternal(LexicalUnit prev, String funct, LexicalUnit params) {
        if ("counter(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createCounter(prev, params);
        }
        if ("counters(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createCounters(prev, params);
        }
        if ("attr(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createAttr(prev, params.getStringValue());
        }
        if ("rect(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createRect(prev, params);
        }
        if ("rgb(".equalsIgnoreCase(funct)) {
            return LexicalUnitImpl.createRgbColor(prev, params);
        }
        return LexicalUnitImpl.createFunction(prev, funct.substring(0, funct.length() - 1), params);
    }

    protected LexicalUnit hexcolorInternal(LexicalUnit prev, Token t) {
        boolean i = true;
        int r = 0;
        int g = 0;
        int b = 0;
        int len = t.image.length() - 1;
        try {
            if (len == 3) {
                r = Integer.parseInt(t.image.substring(1, 2), 16);
                g = Integer.parseInt(t.image.substring(2, 3), 16);
                b = Integer.parseInt(t.image.substring(3, 4), 16);
                r = r << 4 | r;
                g = g << 4 | g;
                b = b << 4 | b;
            } else if (len == 6) {
                r = Integer.parseInt(t.image.substring(1, 3), 16);
                g = Integer.parseInt(t.image.substring(3, 5), 16);
                b = Integer.parseInt(t.image.substring(5, 7), 16);
            } else {
                String pattern = this.getSACParserMessages().getString("invalidColor");
                throw new CSSParseException(MessageFormat.format(pattern, t), this.getInputSource().getURI(), t.beginLine, t.beginColumn);
            }
            LexicalUnit lr = LexicalUnitImpl.createNumber(null, r);
            LexicalUnit lc1 = LexicalUnitImpl.createComma(lr);
            LexicalUnit lg = LexicalUnitImpl.createNumber(lc1, g);
            LexicalUnit lc2 = LexicalUnitImpl.createComma(lg);
            LexicalUnitImpl.createNumber(lc2, b);
            return LexicalUnitImpl.createRgbColor(prev, lr);
        }
        catch (NumberFormatException ex) {
            String pattern = this.getSACParserMessages().getString("invalidColor");
            throw new CSSParseException(MessageFormat.format(pattern, t), this.getInputSource().getURI(), t.beginLine, t.beginColumn, (Exception)ex);
        }
    }

    int intValue(char op, String s) {
        int result = Integer.parseInt(s);
        if (op == '-') {
            return -1 * result;
        }
        return result;
    }

    float floatValue(char op, String s) {
        float result = Float.parseFloat(s);
        if (op == '-') {
            return -1.0f * result;
        }
        return result;
    }

    int getLastNumPos(String s) {
        int i;
        for (i = 0; i < s.length() && NUM_CHARS.indexOf(s.charAt(i)) >= 0; ++i) {
        }
        return i - 1;
    }

    public String unescape(String s, boolean unescapeDoubleQuotes) {
        if (s == null) {
            return s;
        }
        StringBuilder buf = null;
        int index = -1;
        int len = s.length();
        --len;
        if (unescapeDoubleQuotes) {
            while (index < len) {
                char c;
                if ((c = s.charAt(++index)) != '\\' && c != '\"') continue;
                buf = new StringBuilder(len);
                buf.append(s.substring(0, index));
                --index;
                break;
            }
        } else {
            while (index < len) {
                if ('\\' != s.charAt(++index)) continue;
                buf = new StringBuilder(len);
                buf.append(s.substring(0, index));
                --index;
                break;
            }
        }
        if (null == buf) {
            return s;
        }
        int numValue = -1;
        int digitCount = 0;
        while (index < len) {
            char c = s.charAt(++index);
            if (numValue > -1) {
                int hexval = AbstractSACParser.hexval(c);
                if (hexval != -1) {
                    numValue = numValue * 16 + hexval;
                    if (++digitCount < 6) continue;
                    if (numValue > 65535 || numValue == 0) {
                        numValue = 65533;
                    }
                    buf.append((char)numValue);
                    numValue = -1;
                    continue;
                }
                if (digitCount > 0) {
                    if (numValue > 65535 || numValue == 0) {
                        numValue = 65533;
                    }
                    buf.append((char)numValue);
                    if (c == ' ' || c == '\t') {
                        numValue = -1;
                        continue;
                    }
                }
                numValue = -1;
                if (digitCount == 0 && c == '\\') {
                    buf.append('\\');
                    continue;
                }
                if (c == '\n' || c == '\f') continue;
                if (c == '\r') {
                    if (index >= len || s.charAt(index + 1) != '\n') continue;
                    ++index;
                    continue;
                }
            }
            if (c == '\\') {
                numValue = 0;
                digitCount = 0;
                continue;
            }
            if (c == '\"' && !unescapeDoubleQuotes) {
                buf.append('\\');
            }
            buf.append(c);
        }
        if (numValue > -1) {
            if (digitCount == 0) {
                buf.append('\\');
            } else {
                if (numValue > 65535 || numValue == 0) {
                    numValue = 65533;
                }
                buf.append((char)numValue);
            }
        }
        return buf.toString();
    }

    private static int hexval(char c) {
        switch (c) {
            case '0': {
                return 0;
            }
            case '1': {
                return 1;
            }
            case '2': {
                return 2;
            }
            case '3': {
                return 3;
            }
            case '4': {
                return 4;
            }
            case '5': {
                return 5;
            }
            case '6': {
                return 6;
            }
            case '7': {
                return 7;
            }
            case '8': {
                return 8;
            }
            case '9': {
                return 9;
            }
            case 'A': 
            case 'a': {
                return 10;
            }
            case 'B': 
            case 'b': {
                return 11;
            }
            case 'C': 
            case 'c': {
                return 12;
            }
            case 'D': 
            case 'd': {
                return 13;
            }
            case 'E': 
            case 'e': {
                return 14;
            }
            case 'F': 
            case 'f': {
                return 15;
            }
        }
        return -1;
    }
}

