/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.apis.polar;

import com.github.scribejava.core.builder.api.DefaultApi20;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuthRequest;
import com.github.scribejava.core.oauth.AccessTokenRequestParams;
import com.github.scribejava.core.oauth.OAuth20Service;
import java.io.OutputStream;

public class PolarOAuthService
extends OAuth20Service {
    public PolarOAuthService(DefaultApi20 api, String apiKey, String apiSecret, String callback, String defaultScope, String responseType, OutputStream debugStream, String userAgent, HttpClientConfig httpClientConfig, HttpClient httpClient) {
        super(api, apiKey, apiSecret, callback, defaultScope, responseType, debugStream, userAgent, httpClientConfig, httpClient);
    }

    protected OAuthRequest createAccessTokenRequest(AccessTokenRequestParams params) {
        OAuthRequest request = new OAuthRequest(this.getApi().getAccessTokenVerb(), this.getApi().getAccessTokenEndpoint());
        this.getApi().getClientAuthentication().addClientAuthentication(request, this.getApiKey(), this.getApiSecret());
        request.addParameter("code", params.getCode());
        String callback = this.getCallback();
        if (callback != null) {
            request.addParameter("redirect_uri", callback);
        }
        request.addParameter("grant_type", "authorization_code");
        String pkceCodeVerifier = params.getPkceCodeVerifier();
        if (pkceCodeVerifier != null) {
            request.addParameter("code_verifier", pkceCodeVerifier);
        }
        if (this.isDebug()) {
            this.log("created access token request with body params [%s], query string params [%s]", new Object[]{request.getBodyParams().asFormUrlEncodedString(), request.getQueryStringParams().asFormUrlEncodedString()});
        }
        return request;
    }
}

