/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageioimpl.plugins.tiff;

import it.geosolutions.imageio.plugins.tiff.TIFFDecompressor;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.IIOException;

public class TIFFLZWDecompressor
extends TIFFDecompressor {
    private static final boolean DEBUG = false;
    private static final int[] andTable = new int[]{511, 1023, 2047, 4095};
    int predictor;
    byte[] srcData;
    byte[] dstData;
    int srcIndex;
    int dstIndex;
    byte[][] stringTable;
    int tableIndex;
    int bitsToGet = 9;
    int nextData = 0;
    int nextBits = 0;

    public TIFFLZWDecompressor(int predictor) throws IIOException {
        if (predictor != 1 && predictor != 2) {
            throw new IIOException("Illegal value for Predictor in TIFF file");
        }
        this.predictor = predictor;
    }

    @Override
    public void decodeRaw(byte[] b, int dstOffset, int bitsPerPixel, int scanlineStride) throws IOException {
        int bufOffset;
        byte[] buf;
        if (this.predictor == 2) {
            int len = this.bitsPerSample.length;
            int bps = this.bitsPerSample[0];
            if (bps != 8 && bps != 16 && bps != 32) {
                throw new IIOException(bps + "-bit samples are not supported for Horizontal differencing Predictor");
            }
            for (int i = 1; i < len; ++i) {
                if (this.bitsPerSample[i] == bps) continue;
                throw new IIOException("Varying sample width is not supported for Horizontal differencing Predictor (first: " + bps + ", unexpected:" + this.bitsPerSample[i] + ")");
            }
        }
        this.stream.seek(this.offset);
        byte[] sdata = new byte[this.byteCount];
        this.stream.readFully(sdata);
        int bytesPerRow = (this.srcWidth * bitsPerPixel + 7) / 8;
        if (bytesPerRow == scanlineStride) {
            buf = b;
            bufOffset = dstOffset;
        } else {
            buf = new byte[bytesPerRow * this.srcHeight];
            bufOffset = 0;
        }
        int numBytesDecoded = this.decode(sdata, 0, buf, bufOffset);
        if (bytesPerRow != scanlineStride) {
            int off = 0;
            for (int y = 0; y < this.srcHeight; ++y) {
                System.arraycopy(buf, off, b, dstOffset, bytesPerRow);
                off += bytesPerRow;
                dstOffset += scanlineStride;
            }
        }
    }

    public int decode(byte[] sdata, int srcOffset, byte[] ddata, int dstOffset) throws IOException {
        int code;
        if (sdata[0] == 0 && sdata[1] == 1) {
            throw new IIOException("TIFF 5.0-style LZW compression is not supported!");
        }
        this.srcData = sdata;
        this.dstData = ddata;
        this.srcIndex = srcOffset;
        this.dstIndex = dstOffset;
        this.nextData = 0;
        this.nextBits = 0;
        this.initializeStringTable();
        int oldCode = 0;
        while ((code = this.getNextCode()) != 257) {
            byte[] string;
            if (code == 256) {
                this.initializeStringTable();
                code = this.getNextCode();
                if (code == 257) break;
                this.writeString(this.stringTable[code]);
                oldCode = code;
                continue;
            }
            if (code < this.tableIndex) {
                string = this.stringTable[code];
                this.writeString(string);
                this.addStringToTable(this.stringTable[oldCode], string[0]);
                oldCode = code;
                continue;
            }
            string = this.stringTable[oldCode];
            string = this.composeString(string, string[0]);
            this.writeString(string);
            this.addStringToTable(string);
            oldCode = code;
        }
        if (this.predictor == 2) {
            if (this.bitsPerSample[0] == 8) {
                for (int j = 0; j < this.srcHeight; ++j) {
                    int count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1);
                    for (int i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                        int n = count;
                        this.dstData[n] = (byte)(this.dstData[n] + this.dstData[count - this.samplesPerPixel]);
                        ++count;
                    }
                }
            } else if (this.bitsPerSample[0] == 16) {
                if (this.stream.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                    for (int j = 0; j < this.srcHeight; ++j) {
                        int count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 2;
                        for (int i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            int curr = (this.dstData[count] & 0xFF) + (this.dstData[count + 1] << 8);
                            int prev = (this.dstData[count - this.samplesPerPixel * 2] & 0xFF) + (this.dstData[count + 1 - this.samplesPerPixel * 2] << 8);
                            this.dstData[count] = (byte)(curr += prev);
                            this.dstData[count + 1] = (byte)(curr >> 8);
                            count += 2;
                        }
                    }
                } else {
                    for (int j = 0; j < this.srcHeight; ++j) {
                        int count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 2;
                        for (int i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            int curr = (this.dstData[count + 1] & 0xFF) + (this.dstData[count] << 8);
                            int prev = (this.dstData[count + 1 - this.samplesPerPixel * 2] & 0xFF) + (this.dstData[count - this.samplesPerPixel * 2] << 8);
                            this.dstData[count + 1] = (byte)(curr += prev);
                            this.dstData[count] = (byte)(curr >> 8);
                            count += 2;
                        }
                    }
                }
            } else if (this.bitsPerSample[0] == 32) {
                if (this.stream.getByteOrder() == ByteOrder.LITTLE_ENDIAN) {
                    for (int j = 0; j < this.srcHeight; ++j) {
                        int count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 4;
                        int prevBase = count - this.samplesPerPixel * 4;
                        int prev = TIFFLZWDecompressor.readIntegerFromBuffer(this.dstData, prevBase, prevBase + 1, prevBase + 2, prevBase + 3);
                        for (int i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            int curr = TIFFLZWDecompressor.readIntegerFromBuffer(this.dstData, count, count + 1, count + 2, count + 3);
                            int sum = curr + prev;
                            this.dstData[count] = (byte)(sum & 0xFF);
                            this.dstData[count + 1] = (byte)(sum >> 8 & 0xFF);
                            this.dstData[count + 2] = (byte)(sum >> 16 & 0xFF);
                            this.dstData[count + 3] = (byte)(sum >> 24 & 0xFF);
                            count += 4;
                            prev = sum;
                        }
                    }
                } else {
                    for (int j = 0; j < this.srcHeight; ++j) {
                        int count = dstOffset + this.samplesPerPixel * (j * this.srcWidth + 1) * 4;
                        int prevBase = count - this.samplesPerPixel * 4;
                        int prev = TIFFLZWDecompressor.readIntegerFromBuffer(this.dstData, prevBase + 3, prevBase + 2, prevBase + 1, prevBase);
                        for (int i = this.samplesPerPixel; i < this.srcWidth * this.samplesPerPixel; ++i) {
                            int curr = TIFFLZWDecompressor.readIntegerFromBuffer(this.dstData, count + 3, count + 2, count + 1, count);
                            int sum = curr + prev;
                            this.dstData[count + 3] = (byte)(sum & 0xFF);
                            this.dstData[count + 2] = (byte)(sum >> 8 & 0xFF);
                            this.dstData[count + 1] = (byte)(sum >> 16 & 0xFF);
                            this.dstData[count] = (byte)(sum >> 24 & 0xFF);
                            count += 4;
                            prev = sum;
                        }
                    }
                }
            } else {
                throw new IIOException("Unexpected branch of Horizontal differencing Predictor, bps=" + this.bitsPerSample[0]);
            }
        }
        return this.dstIndex - dstOffset;
    }

    public void initializeStringTable() {
        this.stringTable = new byte[4096][];
        for (int i = 0; i < 256; ++i) {
            this.stringTable[i] = new byte[1];
            this.stringTable[i][0] = (byte)i;
        }
        this.tableIndex = 258;
        this.bitsToGet = 9;
    }

    public void writeString(byte[] string) {
        if (this.dstIndex < this.dstData.length) {
            int maxIndex = Math.min(string.length, this.dstData.length - this.dstIndex);
            for (int i = 0; i < maxIndex; ++i) {
                this.dstData[this.dstIndex++] = string[i];
            }
        }
    }

    public void addStringToTable(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        this.stringTable[this.tableIndex++] = string;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public void addStringToTable(byte[] string) {
        this.stringTable[this.tableIndex++] = string;
        if (this.tableIndex == 511) {
            this.bitsToGet = 10;
        } else if (this.tableIndex == 1023) {
            this.bitsToGet = 11;
        } else if (this.tableIndex == 2047) {
            this.bitsToGet = 12;
        }
    }

    public byte[] composeString(byte[] oldString, byte newString) {
        int length = oldString.length;
        byte[] string = new byte[length + 1];
        System.arraycopy(oldString, 0, string, 0, length);
        string[length] = newString;
        return string;
    }

    public int getNextCode() {
        try {
            this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
            this.nextBits += 8;
            if (this.nextBits < this.bitsToGet) {
                this.nextData = this.nextData << 8 | this.srcData[this.srcIndex++] & 0xFF;
                this.nextBits += 8;
            }
            int code = this.nextData >> this.nextBits - this.bitsToGet & andTable[this.bitsToGet - 9];
            this.nextBits -= this.bitsToGet;
            return code;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return 257;
        }
    }
}

