/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.core;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ExtCaches {
    private static final Logger LOGGER = Logger.getLogger(ExtCaches.class.getName());
    private static List<Listener> LISTENERS = new CopyOnWriteArrayList<Listener>();

    public static void clean() {
        for (Listener listener : LISTENERS) {
            try {
                listener.clean();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Clean up invocation failed on listener: " + listener, e);
            }
        }
    }

    public static void addListener(Listener listener) {
        LISTENERS.add(listener);
    }

    public static boolean removeListener(Listener listener) {
        return LISTENERS.remove(listener);
    }

    public static interface Listener {
        public void clean();
    }
}

