/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util.translit;

import com.atilika.kuromoji.ipadic.Token;
import com.atilika.kuromoji.ipadic.Tokenizer;
import java.util.List;
import net.osmand.util.translit.japanese.JapaneseMapper;
import net.osmand.util.translit.japanese.NumberCreator;

public class JapaneseTranslitHelper {
    private static Tokenizer tokenizer;
    private static final String SPACE = " ";
    private static final String JAPANESE_NUMBER = "\u6570";
    private static final String JAPANESE_SYMBOL = "\u8a18\u53f7";
    private static final String UNDEFINED_VALUE = "\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8";

    public static String getEnglishTransliteration(String text) {
        return JapaneseTranslitHelper.japanese2Romaji(text);
    }

    JapaneseTranslitHelper() {
    }

    private static String japanese2Romaji(String text) {
        if (tokenizer == null) {
            tokenizer = new Tokenizer();
        }
        boolean capitalizeWords = true;
        List tokens = tokenizer.tokenize(text);
        StringBuilder builder = new StringBuilder();
        StringBuilder number = new StringBuilder();
        block8: for (Token token : tokens) {
            String lastFeature;
            if (token.getAllFeaturesArray()[0].equals(JAPANESE_SYMBOL)) {
                builder.append(token.getSurface());
                continue;
            }
            switch (token.getAllFeaturesArray()[1]) {
                case "\u6570": {
                    number.append(token.getSurface());
                    if (tokens.indexOf(token) != tokens.size() - 1) continue block8;
                    builder.append(NumberCreator.convertNumber(number.toString()));
                    continue block8;
                }
                case "\u30a2\u30eb\u30d5\u30a1\u30d9\u30c3\u30c8": {
                    builder.append(token.getSurface()).append(SPACE);
                    continue block8;
                }
            }
            if (!number.toString().equals("")) {
                builder.append(NumberCreator.convertNumber(number.toString())).append(SPACE);
                number = new StringBuilder();
            }
            if ((lastFeature = token.getAllFeaturesArray()[8]).equals("*")) {
                builder.append(token.getSurface());
            } else {
                String romaji = JapaneseTranslitHelper.convertKanaToRomaji(token.getAllFeaturesArray()[8]);
                if (capitalizeWords) {
                    builder.append(romaji.substring(0, 1).toUpperCase());
                    builder.append(romaji.substring(1));
                } else {
                    if (token.getSurface().equals(token.getPronunciation())) {
                        romaji = romaji.toUpperCase();
                    }
                    builder.append(romaji);
                }
            }
            builder.append(SPACE);
        }
        return builder.toString().trim();
    }

    private static String createLongSounds(String romaji) {
        StringBuilder res = new StringBuilder();
        char hyphen = '-';
        for (int i = 0; i < romaji.length(); ++i) {
            char next;
            char curr = romaji.charAt(i);
            if (i + 1 < romaji.length() && (next = romaji.charAt(i + 1)) == hyphen && JapaneseMapper.isLongSoundLetter(Character.valueOf(curr))) {
                res.append(JapaneseMapper.getLetterWithDiacritic(Character.valueOf(curr)));
                ++i;
                continue;
            }
            res.append(curr);
        }
        return res.toString();
    }

    private static String convertKanaToRomaji(String s) {
        StringBuilder t = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            if (i <= s.length() - 2) {
                if (JapaneseMapper.isKatakana(s.substring(i, i + 2))) {
                    t.append(JapaneseMapper.getRomaji(s.substring(i, i + 2)));
                    ++i;
                    continue;
                }
                if (JapaneseMapper.isKatakana(s.substring(i, i + 1))) {
                    t.append(JapaneseMapper.getRomaji(s.substring(i, i + 1)));
                    continue;
                }
                if (s.charAt(i) == '\u30c3') {
                    t.append(JapaneseMapper.getRomaji(s.substring(i + 1, i + 2)).charAt(0));
                    continue;
                }
                t.append(s.charAt(i));
                continue;
            }
            if (JapaneseMapper.isKatakana(s.substring(i, i + 1))) {
                t.append(JapaneseMapper.getRomaji(s.substring(i, i + 1)));
                continue;
            }
            t.append(s.charAt(i));
        }
        String res = t.toString();
        return res.contains("-") ? JapaneseTranslitHelper.createLongSounds(res) : res;
    }
}

