/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.travel;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.GZIPOutputStream;
import net.osmand.PlatformUtil;
import net.osmand.binary.MapZooms;
import net.osmand.impl.ConsoleProgressImplementation;
import net.osmand.obf.preparation.DBDialect;
import net.osmand.obf.preparation.IndexCreator;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.osm.MapRenderingTypesEncoder;
import net.osmand.travel.WikivoyageGenOSM;
import net.osmand.travel.WikivoyageLangPreparation;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParserException;

public class TravelGuideCreatorMain {
    private static final int BATCH_SIZE = 30;
    private static final Log LOG = PlatformUtil.getLog(TravelGuideCreatorMain.class);
    public static final String TRAVEL_GUIDE_NAME = "travel_guide";

    public static void main(String[] args) throws SQLException, IOException, XmlPullParserException, InterruptedException {
        String dir = "";
        if (args.length < 1) {
            while (dir.isEmpty()) {
                System.out.print("Please provide the path to the data directory: ");
                Scanner scanner = new Scanner(System.in);
                dir = scanner.nextLine().trim();
                scanner.close();
            }
        } else {
            dir = args[0];
        }
        if (dir.equals("--help") || dir.equals("-h")) {
            TravelGuideCreatorMain.printHelp();
            return;
        }
        new TravelGuideCreatorMain().generateTravelGuide(dir);
    }

    private static void printHelp() {
        System.out.println("Usage: <path to directory with html and gpx files (should contain gpx and html files with identical names)>: The utility creates an .travel.obf file that contains articles and points from the specified directory.");
    }

    private void generateTravelGuide(String dir) throws SQLException, IOException, XmlPullParserException, InterruptedException {
        File directory = new File(dir);
        if (!directory.isDirectory()) {
            throw new RuntimeException("Supplied path is not a directory");
        }
        File[] files = directory.listFiles();
        File sqliteFile = new File(directory, "travel_guide.sqlite");
        Connection conn = DBDialect.SQLITE.getDatabaseConnection(sqliteFile.getCanonicalPath(), LOG);
        if (conn == null) {
            LOG.error((Object)"Couldn't establish the database connection");
            System.exit(1);
        }
        Map<String, List<File>> mapping = this.getFileMapping(files);
        this.generateTravelSqlite(mapping, conn);
        conn.close();
        File osmFile = new File(directory, "travel_guide.osm.gz");
        WikivoyageGenOSM.genWikivoyageOsm(sqliteFile, osmFile, -1);
        IndexCreatorSettings settings = new IndexCreatorSettings();
        settings.indexPOI = true;
        IndexCreator ic = new IndexCreator(directory, settings);
        ic.setMapFileName(directory.getName() + ".travel.obf");
        MapRenderingTypesEncoder types = new MapRenderingTypesEncoder(settings.renderingTypesFile, osmFile.getName());
        ic.generateIndexes(osmFile, new ConsoleProgressImplementation(), null, MapZooms.getDefault(), types, LOG);
        osmFile.delete();
        sqliteFile.delete();
    }

    private void addColumn(Connection conn, String col) {
        try {
            conn.createStatement().execute(String.format("ALTER TABLE travel_articles ADD COLUMN %s", col));
        }
        catch (Exception e) {
            System.err.printf("Column %s already exists\n", col);
        }
    }

    private void generateTravelSqlite(Map<String, List<File>> mapping, Connection conn) throws SQLException, IOException {
        WikivoyageLangPreparation.createInitialDbStructure(conn, "en", false);
        this.addColumn(conn, "aggregated_part_of");
        this.addColumn(conn, "agg_part_of_wid");
        this.addColumn(conn, "is_parent_of");
        PreparedStatement prep = WikivoyageLangPreparation.generateInsertPrep(conn, false);
        int count = 0;
        int batch = 0;
        for (String title : mapping.keySet()) {
            List<File> files = mapping.get(title);
            File gpx = null;
            File html = null;
            for (File f : files) {
                if (f.getName().endsWith(".gpx")) {
                    gpx = f;
                    continue;
                }
                if (!f.getName().endsWith(".html")) continue;
                html = f;
            }
            if (gpx == null || html == null) continue;
            byte[] gpxBytes = this.compress(Files.readAllBytes(gpx.toPath()));
            byte[] htmlBytes = this.compress(Files.readAllBytes(html.toPath()));
            int column = 1;
            prep.setString(column++, title);
            prep.setBytes(column++, htmlBytes);
            prep.setString(column++, "");
            prep.setNull(column++, 8);
            prep.setNull(column++, 8);
            prep.setString(column++, "");
            prep.setString(column++, "");
            prep.setBytes(column++, gpxBytes);
            prep.setLong(column++, ++count);
            prep.setLong(column++, count);
            prep.setString(column++, "en");
            prep.setString(column, "");
            prep.addBatch();
            if (batch++ <= 30) continue;
            prep.executeBatch();
            batch = 0;
        }
        if (batch > 0) {
            prep.executeBatch();
        }
        prep.close();
        LOG.debug((Object)("Successfully created a travel book. Size: " + count));
    }

    private byte[] compress(byte[] content) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzipOutputStream = new GZIPOutputStream(byteArrayOutputStream);
            gzipOutputStream.write(content);
            gzipOutputStream.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return byteArrayOutputStream.toByteArray();
    }

    private Map<String, List<File>> getFileMapping(File[] files) {
        HashMap<String, List<File>> result = new HashMap<String, List<File>>();
        for (File f : files) {
            String filename = f.getName();
            if (!filename.endsWith(".html") && !filename.endsWith(".gpx")) continue;
            ArrayList<File> currList = (ArrayList<File>)result.get(filename = filename.substring(0, filename.lastIndexOf(".")));
            if (currList == null) {
                currList = new ArrayList<File>();
                currList.add(f);
                result.put(filename, currList);
                continue;
            }
            currList.add(f);
            result.put(filename, currList);
        }
        return result;
    }
}

