/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.core.jni;

import net.osmand.core.jni.OsmAndCoreJNI;
import net.osmand.core.jni.SWIGTYPE_p_double;

public class DoublePtr {
    private transient long swigCPtr;
    protected transient boolean swigCMemOwn;

    protected DoublePtr(long l, boolean bl) {
        this.swigCMemOwn = bl;
        this.swigCPtr = l;
    }

    protected static long getCPtr(DoublePtr doublePtr) {
        return doublePtr == null ? 0L : doublePtr.swigCPtr;
    }

    protected static long swigRelease(DoublePtr doublePtr) {
        long l = 0L;
        if (doublePtr != null) {
            if (!doublePtr.swigCMemOwn) {
                throw new RuntimeException("Cannot release ownership as memory is not owned");
            }
            l = doublePtr.swigCPtr;
            doublePtr.swigCMemOwn = false;
            doublePtr.delete();
        }
        return l;
    }

    protected void finalize() {
        this.delete();
    }

    public synchronized void delete() {
        if (this.swigCPtr != 0L) {
            if (this.swigCMemOwn) {
                this.swigCMemOwn = false;
                OsmAndCoreJNI.delete_DoublePtr(this.swigCPtr);
            }
            this.swigCPtr = 0L;
        }
    }

    public DoublePtr() {
        this(OsmAndCoreJNI.new_DoublePtr(), true);
    }

    public void assign(double d) {
        OsmAndCoreJNI.DoublePtr_assign(this.swigCPtr, this, d);
    }

    public double value() {
        return OsmAndCoreJNI.DoublePtr_value(this.swigCPtr, this);
    }

    public SWIGTYPE_p_double cast() {
        long l = OsmAndCoreJNI.DoublePtr_cast(this.swigCPtr, this);
        return l == 0L ? null : new SWIGTYPE_p_double(l, false);
    }

    public static DoublePtr frompointer(SWIGTYPE_p_double sWIGTYPE_p_double) {
        long l = OsmAndCoreJNI.DoublePtr_frompointer(SWIGTYPE_p_double.getCPtr(sWIGTYPE_p_double));
        return l == 0L ? null : new DoublePtr(l, false);
    }
}

