/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.opengl.util.texture.spi;

import com.jogamp.common.util.IOUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class SGIImage {
    private final Header header;
    private int format;
    private byte[] data;
    private int[] rowStart;
    private int[] rowSize;
    private int rleEnd;
    private byte[] tmpData;
    private byte[] tmpRead;
    private static final int MAGIC = 474;

    private SGIImage(Header header) {
        this.header = header;
    }

    public static SGIImage read(String string) throws IOException {
        return SGIImage.read(new FileInputStream(string));
    }

    public static SGIImage read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(inputStream));
        Header header = new Header(dataInputStream);
        SGIImage sGIImage = new SGIImage(header);
        sGIImage.decodeImage(dataInputStream);
        return sGIImage;
    }

    public void write(String string, boolean bl) throws IOException {
        this.write(new File(string), bl);
    }

    public void write(File file, boolean bl) throws IOException {
        this.writeImage(file, this.data, this.header.xsize, this.header.ysize, this.header.zsize, bl);
    }

    public static SGIImage createFromData(int n, int n2, boolean bl, byte[] byArray) {
        Header header = new Header();
        header.xsize = (short)n;
        header.ysize = (short)n2;
        header.zsize = (short)(bl ? 4 : 3);
        SGIImage sGIImage = new SGIImage(header);
        sGIImage.data = byArray;
        return sGIImage;
    }

    public static boolean isSGIImage(InputStream inputStream) throws IOException {
        if (!(inputStream instanceof BufferedInputStream)) {
            inputStream = new BufferedInputStream(inputStream);
        }
        if (!inputStream.markSupported()) {
            throw new IOException("Can not test non-destructively whether given InputStream is an SGI RGB image");
        }
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        dataInputStream.mark(4);
        short s = dataInputStream.readShort();
        dataInputStream.reset();
        return s == 474;
    }

    public int getWidth() {
        return this.header.xsize;
    }

    public int getHeight() {
        return this.header.ysize;
    }

    public int getFormat() {
        return this.format;
    }

    public byte[] getData() {
        return this.data;
    }

    public String toString() {
        return this.header.toString();
    }

    private void decodeImage(DataInputStream dataInputStream) throws IOException {
        int n;
        int n2;
        if (this.header.storage == 1) {
            n2 = this.header.ysize * this.header.zsize;
            this.rowStart = new int[n2];
            this.rowSize = new int[n2];
            this.rleEnd = 8 * n2 + 512;
            for (n = 0; n < n2; ++n) {
                this.rowStart[n] = dataInputStream.readInt();
            }
            for (n = 0; n < n2; ++n) {
                this.rowSize[n] = dataInputStream.readInt();
            }
            this.tmpRead = new byte[this.header.xsize * 256];
        }
        this.tmpData = this.readAll(dataInputStream);
        n2 = this.header.xsize;
        n = this.header.ysize;
        short s = this.header.zsize;
        int n3 = 0;
        this.data = new byte[n2 * n * 4];
        byte[] byArray = new byte[n2];
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        for (int i = 0; i < n; ++i) {
            if (s >= 4) {
                this.getRow(byArray, i, 0);
                this.getRow(byArray2, i, 1);
                this.getRow(byArray3, i, 2);
                this.getRow(byArray4, i, 3);
                this.rgbatorgba(byArray, byArray2, byArray3, byArray4, this.data, n3);
            } else if (s == 3) {
                this.getRow(byArray, i, 0);
                this.getRow(byArray2, i, 1);
                this.getRow(byArray3, i, 2);
                this.rgbtorgba(byArray, byArray2, byArray3, this.data, n3);
            } else if (s == 2) {
                this.getRow(byArray, i, 0);
                this.getRow(byArray4, i, 1);
                this.latorgba(byArray, byArray4, this.data, n3);
            } else {
                this.getRow(byArray, i, 0);
                this.bwtorgba(byArray, this.data, n3);
            }
            n3 += 4 * n2;
        }
        this.rowStart = null;
        this.rowSize = null;
        this.tmpData = null;
        this.tmpRead = null;
        this.format = 6408;
        this.header.zsize = (short)4;
    }

    /*
     * Unable to fully structure code
     */
    private void getRow(byte[] var1_1, int var2_2, int var3_3) {
        block4: {
            if (this.header.storage != 1) break block4;
            var4_4 = this.rowStart[var2_2 + var3_3 * this.header.ysize] - this.rleEnd;
            System.arraycopy(this.tmpData, var4_4, this.tmpRead, 0, this.rowSize[var2_2 + var3_3 * this.header.ysize]);
            var5_6 = 0;
            var6_7 = 0;
            block0: while (true) lbl-1000:
            // 3 sources

            {
                block5: {
                    if ((var8_9 = (var7_8 = this.tmpRead[var5_6++]) & 127) == 0) {
                        return;
                    }
                    if ((var7_8 & 128) == 0) break block5;
                    while (true) {
                        if (var8_9-- <= 0) ** GOTO lbl-1000
                        var1_1[var6_7++] = this.tmpRead[var5_6++];
                    }
                }
                var7_8 = this.tmpRead[var5_6++];
                while (true) {
                    if (var8_9-- <= 0) continue block0;
                    var1_1[var6_7++] = var7_8;
                }
                break;
            }
        }
        var4_5 = var2_2 * this.header.xsize + var3_3 * this.header.xsize * this.header.ysize;
        System.arraycopy(this.tmpData, var4_5, var1_1, 0, this.header.xsize);
    }

    private void bwtorgba(byte[] byArray, byte[] byArray2, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray2[4 * i + n + 0] = byArray[i];
            byArray2[4 * i + n + 1] = byArray[i];
            byArray2[4 * i + n + 2] = byArray[i];
            byArray2[4 * i + n + 3] = -1;
        }
    }

    private void latorgba(byte[] byArray, byte[] byArray2, byte[] byArray3, int n) {
        for (int i = 0; i < byArray.length; ++i) {
            byArray3[4 * i + n + 0] = byArray[i];
            byArray3[4 * i + n + 1] = byArray[i];
            byArray3[4 * i + n + 2] = byArray[i];
            byArray3[4 * i + n + 3] = byArray2[i];
        }
    }

    private void rgbtorgba(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, int n) {
        for (int i = 0; i < byArray3.length; ++i) {
            byArray4[4 * i + n + 0] = byArray[i];
            byArray4[4 * i + n + 1] = byArray2[i];
            byArray4[4 * i + n + 2] = byArray3[i];
            byArray4[4 * i + n + 3] = -1;
        }
    }

    private void rgbatorgba(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, int n) {
        for (int i = 0; i < byArray3.length; ++i) {
            byArray5[4 * i + n + 0] = byArray[i];
            byArray5[4 * i + n + 1] = byArray2[i];
            byArray5[4 * i + n + 2] = byArray3[i];
            byArray5[4 * i + n + 3] = byArray4[i];
        }
    }

    private static byte imgref(byte[] byArray, int n, int n2, int n3, int n4, int n5, int n6) {
        return byArray[n4 * n5 * n3 + n4 * n2 + n];
    }

    private void writeHeader(DataOutputStream dataOutputStream, int n, int n2, int n3, boolean bl) throws IOException {
        int n4;
        dataOutputStream.writeShort(474);
        dataOutputStream.write(bl ? 1 : 0);
        dataOutputStream.write(1);
        dataOutputStream.writeShort(3);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(n2);
        dataOutputStream.writeShort(n3);
        dataOutputStream.writeInt(0);
        dataOutputStream.writeInt(255);
        dataOutputStream.writeInt(0);
        for (n4 = 0; n4 < 80; ++n4) {
            dataOutputStream.write(0);
        }
        dataOutputStream.writeInt(0);
        for (n4 = 0; n4 < 404; ++n4) {
            dataOutputStream.write(0);
        }
    }

    private void writeImage(File file, byte[] byArray, int n, int n2, int n3, boolean bl) throws IOException {
        int n4;
        byte[] byArray2 = new byte[n * n2 * n3];
        int n5 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = i; j < n * n2 * n3; j += n3) {
                byArray2[n5++] = byArray[j];
            }
        }
        byArray = byArray2;
        int[] nArray = new int[n2 * n3];
        int[] nArray2 = new int[n2 * n3];
        byte[] byArray3 = new byte[2 * n * n2 * n3];
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        int n10 = 1;
        int n11 = n2;
        if (bl) {
            n9 = n2 - 1;
            n11 = -1;
            n10 = -1;
        }
        for (int i = 0; i < n3; ++i) {
            for (int j = n9; j != n11; j += n10) {
                int n12;
                int n13 = 0;
                boolean bl2 = false;
                boolean bl3 = false;
                int n14 = n7;
                int n15 = n7++;
                byte by = 0;
                for (n4 = 0; n4 < n; ++n4) {
                    bl3 = false;
                    if (bl2) {
                        if (SGIImage.imgref(byArray, n4, j, i, n, n2, n3) != by) {
                            bl3 = true;
                        }
                    } else if (n4 + 3 < n) {
                        bl3 = true;
                        for (n12 = 1; n12 <= 3; ++n12) {
                            if (SGIImage.imgref(byArray, n4, j, i, n, n2, n3) == SGIImage.imgref(byArray, n4 + n12, j, i, n, n2, n3)) continue;
                            bl3 = false;
                        }
                    }
                    if (bl3 || n13 == 127) {
                        if (n4 > 0) {
                            byArray3[n15] = bl2 ? n13 : (byte)(n13 | 0x80);
                        }
                        if (bl2) {
                            if (bl3) {
                                bl2 = false;
                            }
                            byArray3[n7++] = by;
                        } else {
                            if (bl3) {
                                bl2 = true;
                            }
                            by = SGIImage.imgref(byArray, n4, j, i, n, n2, n3);
                        }
                        if (n4 > 0) {
                            n15 = n7++;
                            n13 = 0;
                        }
                    }
                    if (!bl2) {
                        byArray3[n7++] = SGIImage.imgref(byArray, n4, j, i, n, n2, n3);
                    }
                    n13 = (byte)(n13 + 1);
                    if (n4 != n - 1) continue;
                    if (bl2) {
                        byArray3[n15] = n13;
                        byArray3[n7++] = by;
                    } else {
                        byArray3[n15] = (byte)(n13 | 0x80);
                    }
                    byArray3[n7++] = 0;
                }
                n12 = n7 - n14;
                if (bl) {
                    nArray2[n2 * i + (n2 - j - 1)] = n12;
                } else {
                    nArray2[n2 * i + j] = n12;
                }
                if (bl) {
                    nArray[n2 * i + (n2 - j - 1)] = n6;
                } else {
                    nArray[n2 * i + j] = n6;
                }
                n6 += n12;
            }
        }
        n8 = n7;
        DataOutputStream dataOutputStream = new DataOutputStream(new BufferedOutputStream(IOUtil.getFileOutputStream((File)file, (boolean)true)));
        this.writeHeader(dataOutputStream, n, n2, n3, true);
        for (n4 = 0; n4 < n2 * n3; ++n4) {
            dataOutputStream.writeInt(nArray[n4] + 512 + 2 * n2 * n3 * 4);
        }
        for (n4 = 0; n4 < n2 * n3; ++n4) {
            dataOutputStream.writeInt(nArray2[n4]);
        }
        for (n4 = 0; n4 < n8; ++n4) {
            dataOutputStream.write(byArray3[n4]);
        }
        dataOutputStream.close();
    }

    private byte[] readAll(DataInputStream dataInputStream) throws IOException {
        byte[] byArray;
        byte[] byArray2 = new byte[16384];
        int n = 0;
        int n2 = 0;
        boolean bl = false;
        do {
            n2 = dataInputStream.read(byArray2, n, byArray2.length - n);
            if (n == byArray2.length) {
                byArray = new byte[2 * byArray2.length];
                System.arraycopy(byArray2, 0, byArray, 0, n);
                byArray2 = byArray;
            }
            if (n2 <= 0) continue;
            n += n2;
        } while (!(bl = n2 == -1 || dataInputStream.available() == 0));
        if (n != byArray2.length) {
            byArray = new byte[n];
            System.arraycopy(byArray2, 0, byArray, 0, n);
            byArray2 = byArray;
        }
        return byArray2;
    }

    static class Header {
        short magic;
        byte storage;
        byte bpc;
        short dimension;
        short xsize;
        short ysize;
        short zsize;
        int pixmin;
        int pixmax;
        int dummy;
        String imagename;
        int colormap;

        Header() {
            this.magic = (short)474;
        }

        Header(DataInputStream dataInputStream) throws IOException {
            this.magic = dataInputStream.readShort();
            this.storage = dataInputStream.readByte();
            this.bpc = dataInputStream.readByte();
            this.dimension = dataInputStream.readShort();
            this.xsize = dataInputStream.readShort();
            this.ysize = dataInputStream.readShort();
            this.zsize = dataInputStream.readShort();
            this.pixmin = dataInputStream.readInt();
            this.pixmax = dataInputStream.readInt();
            this.dummy = dataInputStream.readInt();
            byte[] byArray = new byte[80];
            dataInputStream.read(byArray);
            int n = 0;
            while (byArray[n++] != 0) {
            }
            this.imagename = new String(byArray, 0, n);
            this.colormap = dataInputStream.readInt();
            byte[] byArray2 = new byte[404];
            dataInputStream.read(byArray2);
        }

        public String toString() {
            return "magic: " + this.magic + " storage: " + this.storage + " bpc: " + this.bpc + " dimension: " + this.dimension + " xsize: " + this.xsize + " ysize: " + this.ysize + " zsize: " + this.zsize + " pixmin: " + this.pixmin + " pixmax: " + this.pixmax + " imagename: " + this.imagename + " colormap: " + this.colormap;
        }
    }
}

