/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.osm;

import gnu.trove.list.array.TIntArrayList;
import java.awt.Color;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import net.osmand.PlatformUtil;
import net.osmand.osm.MapRenderingTypes;
import net.osmand.osm.OsmcSymbol;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OSMSettings;
import net.osmand.util.Algorithms;
import org.apache.commons.logging.Log;
import org.xmlpull.v1.XmlPullParser;

public class MapRenderingTypesEncoder
extends MapRenderingTypes {
    private static final String HIGH_CHARGING_OUT = "high";
    private static final String MEDIUM_CHARGING_OUT = "medium";
    private static final String LOW_CHARGING_OUT = "low";
    public static final char SOCKET_KEY_DELIMITER = ':';
    private static Log log = PlatformUtil.getLog(MapRenderingTypesEncoder.class);
    private List<MapRouteTag> routeTags = new ArrayList<MapRouteTag>();
    private Map<String, List<EntityConvert>> convertTags = new LinkedHashMap<String, List<EntityConvert>>();
    private MapRenderingTypes.MapRulType coastlineRuleType;
    private String regionName;
    public static final String OSMAND_REGION_NAME_TAG = "osmand_region_name";
    private static final Collection<String> NODE_NETWORK_IDS = Arrays.asList("network:type", "expected_rcn_route_relations");
    private static final Collection<String> NODE_NETWORKS_REF_TYPES = new TreeSet<String>(Arrays.asList("icn_ref", "ncn_ref", "rcn_ref", "lcn_ref", "iwn_ref", "nwn_ref", "rwn_ref", "lwn_ref"));
    private static final String NODE_NETWORK_TAG = "node_network_point";
    private static final String NODE_NETWORK_MULTIPLE_VALUE = "multiple";
    private static final boolean DELETE_AFTER_38_RELEASE = false;
    private static final Map<String, String> OSMC_NO_NAME_FOREGROUND = Map.of("hiking", "black_hiker", "bicycle", "black_bicycle", "mtb", "black_bicycle", "horse", "black_horse", "fitness_trail", "black_runner", "running", "black_runner");
    private Map<String, TIntArrayList> socketTypes;
    final Set<String> barValues = new HashSet<String>(Arrays.asList("", "bar", "stripe", "cross", "x", "slash", "rectangle", "fork", "turned_t", "l", "lower", "corner", "backslash", "wolfshook", "rectangle_line"));
    final Map<String, String> precolors = new HashMap<String, String>();

    public MapRenderingTypesEncoder(String fileName, String regionName) {
        super((String)(fileName != null && fileName.length() == 0 ? null : fileName));
        this.precolors.put("white_red_diamond", "red");
        this.precolors.put("black_red_diamond", "red");
        this.precolors.put("shell_modern", "yellow");
        this.precolors.put("shell", "yellow");
        this.precolors.put("wolfshook", "white");
        this.precolors.put("ammonit", "white");
        this.precolors.put("mine", "white");
        this.precolors.put("hiker", "black");
        this.precolors.put("heart", "red");
        this.precolors.put("tower", "black");
        this.precolors.put("bridleway", "white");
        this.regionName = "$" + regionName.toLowerCase() + "^";
    }

    public MapRenderingTypesEncoder(String regionName) {
        super(null);
        this.precolors.put("white_red_diamond", "red");
        this.precolors.put("black_red_diamond", "red");
        this.precolors.put("shell_modern", "yellow");
        this.precolors.put("shell", "yellow");
        this.precolors.put("wolfshook", "white");
        this.precolors.put("ammonit", "white");
        this.precolors.put("mine", "white");
        this.precolors.put("hiker", "black");
        this.precolors.put("heart", "red");
        this.precolors.put("tower", "black");
        this.precolors.put("bridleway", "white");
        this.regionName = "$" + regionName.toLowerCase() + "^";
    }

    private void initSocketTypes() {
        this.socketTypes = Map.ofEntries(Map.entry("socket:type2:output", new TIntArrayList(new int[]{20, 35})), Map.entry("socket:type2_combo:output", new TIntArrayList(new int[]{30, 70})), Map.entry("socket:type2_cable:output", new TIntArrayList(new int[]{30, 70})), Map.entry("socket:type3a:output", new TIntArrayList(new int[]{10, 20})), Map.entry("socket:type3c:output", new TIntArrayList(new int[]{10, 20})), Map.entry("socket:cee_blue:output", new TIntArrayList(new int[]{2, 5})), Map.entry("socket:chademo:output", new TIntArrayList(new int[]{30, 70})), Map.entry("socket:schuko:output", new TIntArrayList(new int[]{2, 3})), Map.entry("socket:type2:voltage", new TIntArrayList(new int[]{230, 500})), Map.entry("socket:type2_combo:voltage", new TIntArrayList(new int[]{500, 800})), Map.entry("socket:type2_cable:voltage", new TIntArrayList(new int[]{230, 500})), Map.entry("socket:cee_blue:voltage", new TIntArrayList(new int[]{220, 250})), Map.entry("socket:chademo:voltage", new TIntArrayList(new int[]{230, 500})), Map.entry("socket:schuko:voltage", new TIntArrayList(new int[]{220, 240})));
    }

    protected MapRenderingTypes.MapRulType registerRuleType(MapRenderingTypes.MapRulType rt) {
        rt = super.registerRuleType(rt);
        String tag = rt.tagValuePattern.tag;
        String val = rt.tagValuePattern.value;
        if ("natural".equals(tag) && "coastline".equals(val)) {
            this.coastlineRuleType = rt;
        }
        return rt;
    }

    private MapRenderingTypes.MapRulType getMapRuleType(String tag, String val) {
        return this.getRuleType(tag, val, false, true);
    }

    public MapRenderingTypes.MapRulType getCoastlineRuleType() {
        this.getEncodingRuleTypes();
        return this.coastlineRuleType;
    }

    public List<MapRouteTag> getRouteTags() {
        this.checkIfInitNeeded();
        return this.routeTags;
    }

    protected void parseEntityConvertXML(XmlPullParser parser) {
        String seq = parser.getAttributeValue("", "seq");
        if (Algorithms.isEmpty((CharSequence)seq)) {
            seq = "1:1";
        }
        String[] ls = seq.split(":");
        for (int ind = Integer.parseInt(ls[0]); ind <= Integer.parseInt(ls[1]); ++ind) {
            String[] tps;
            String appTo;
            LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String at = parser.getAttributeName(i);
                mp.put(at, parser.getAttributeValue("", at).replace("*", "" + ind));
            }
            EntityConvert ec = new EntityConvert();
            String tg = (String)mp.get("if_region_name");
            if (tg != null) {
                ec.ifRegionName.addAll(Arrays.asList(tg.split("\\,")));
            }
            if ((tg = (String)mp.get("if_not_region_name")) != null) {
                ec.ifNotRegionName.addAll(Arrays.asList(tg.split("\\,")));
            }
            ec.lang = "true".equals(mp.get("lang"));
            ec.verbose = "true".equals(mp.get("verbose"));
            this.parseConvertCol(mp, ec.ifTags, "if_");
            this.parseConvertCol(mp, ec.ifStartsTags, "if_starts_with_");
            this.parseConvertCol(mp, ec.ifNotStartsTags, "if_not_starts_with_");
            this.parseConvertCol(mp, ec.ifEndsTags, "if_ends_with_");
            this.parseConvertCol(mp, ec.ifNotEndsTags, "if_not_ends_with_");
            this.parseConvertCol(mp, ec.ifContainsTags, "if_contains_");
            this.parseConvertCol(mp, ec.ifNotContainsTags, "if_not_contains_");
            this.parseConvertCol(mp, ec.ifNotTags, "if_not_");
            this.parseConvertCol(mp, ec.ifTagsNotLess, "if_not_less_");
            this.parseConvertCol(mp, ec.ifTagsLess, "if_less_");
            ec.type = EntityConvertType.valueOf(((String)mp.get("pattern")).toUpperCase());
            ec.applyToType = EnumSet.allOf(EntityConvertApplyType.class);
            if ("no".equals(mp.get("routing")) || "false".equals(mp.get("routing"))) {
                ec.applyToType.remove((Object)EntityConvertApplyType.ROUTING);
            }
            if ("no".equals(mp.get("map")) || "false".equals(mp.get("map"))) {
                ec.applyToType.remove((Object)EntityConvertApplyType.MAP);
            }
            if ("no".equals(mp.get("poi")) || "false".equals(mp.get("poi"))) {
                ec.applyToType.remove((Object)EntityConvertApplyType.POI);
            }
            this.parseConvertCol(mp, ec.toTags, "to_", "");
            tg = (String)mp.get("from_tag");
            String value = (String)mp.get("from_value");
            if (tg != null) {
                ec.fromTag = new MapRenderingTypes.TagValuePattern(tg, "".equals(value) ? null : value);
                if (ec.type == EntityConvertType.TAG_COMBINE) {
                    this.parseConvertCol(mp, ec.fromTagList, "from_");
                    String string = ec.separator = mp.get("separator") != null ? (String)mp.get("separator") : " ";
                }
                if (!this.convertTags.containsKey(ec.fromTag.tag)) {
                    this.convertTags.put(ec.fromTag.tag, new ArrayList());
                }
                this.convertTags.get(ec.fromTag.tag).add(ec);
            }
            if ((appTo = (String)mp.get("apply_to")) == null) continue;
            ec.applyTo = EnumSet.noneOf(Entity.EntityType.class);
            for (String t : tps = appTo.split(",")) {
                Entity.EntityType et = Entity.EntityType.valueOf((String)t.toUpperCase());
                ec.applyTo.add(et);
            }
        }
    }

    protected void parseConvertCol(Map<String, String> mp, List<MapRenderingTypes.TagValuePattern> col, String prefix) {
        this.parseConvertCol(mp, col, prefix, null);
    }

    protected void parseConvertCol(Map<String, String> mp, List<MapRenderingTypes.TagValuePattern> col, String prefix, String emptyVal) {
        for (int i = 1; i <= 20; ++i) {
            String tg = mp.get(prefix + "tag" + i);
            String value = mp.get(prefix + "value" + i);
            String tgPrefix = mp.get(prefix + "tag_prefix" + i);
            if (tg == null) {
                tg = tgPrefix;
            }
            if (tg == null) continue;
            MapRenderingTypes.TagValuePattern pt = new MapRenderingTypes.TagValuePattern(tg, "".equals(value) ? emptyVal : value);
            pt.tagPrefix = tgPrefix;
            col.add(pt);
            String substr = mp.get(prefix + "substr" + i);
            if (substr == null) continue;
            String[] ls = substr.split(":");
            if (ls.length > 0) {
                pt.substrSt = Integer.parseInt(ls[0]);
            }
            if (ls.length <= 1) continue;
            pt.substrEnd = Integer.parseInt(ls[0]);
        }
    }

    protected void parseRouteTagFromXML(XmlPullParser parser) {
        String seq = parser.getAttributeValue("", "seq");
        if (Algorithms.isEmpty((CharSequence)seq)) {
            seq = "1:1";
        }
        String[] ls = seq.split(":");
        for (int ind = Integer.parseInt(ls[0]); ind <= Integer.parseInt(ls[1]); ++ind) {
            MapRouteTag rtype = new MapRouteTag();
            String mode = parser.getAttributeValue("", "mode");
            rtype.tag = this.lc(parser.getAttributeValue("", "tag"), ind);
            rtype.value = this.lc(parser.getAttributeValue("", "value"), ind);
            rtype.tag2 = this.lc(parser.getAttributeValue("", "tag2"), ind);
            rtype.value2 = this.lc(parser.getAttributeValue("", "value2"), ind);
            rtype.base = Boolean.parseBoolean(parser.getAttributeValue("", "base"));
            rtype.replace = "replace".equalsIgnoreCase(mode);
            rtype.register = "register".equalsIgnoreCase(mode);
            rtype.type = this.lc(parser.getAttributeValue("", "type"), ind);
            rtype.amend = "amend".equalsIgnoreCase(mode);
            rtype.text = "text".equalsIgnoreCase(mode);
            this.routeTags.add(rtype);
        }
    }

    private String lc(String a, int seq) {
        if (a != null) {
            return a.toLowerCase().replace("*", "" + seq);
        }
        return a;
    }

    protected void parsePropagate(XmlPullParser parser, MapRenderingTypes.MapRulType parentType) {
        MapRenderingTypes.PropagateToNode ptype = this.parsePropagateType(parser);
        if (ptype != null && parentType != null) {
            parentType.propagateToNodes.add(ptype);
        }
    }

    protected MapRenderingTypes.MapRulType parseAndRegisterTypeFromXML(XmlPullParser parser, MapRenderingTypes.MapRulType parent) {
        String seq = parser.getAttributeValue("", "seq");
        if (Algorithms.isEmpty((CharSequence)seq)) {
            seq = "1:1";
        }
        MapRenderingTypes.MapRulType mainType = null;
        String[] ls = seq.split(":");
        for (int ind = Integer.parseInt(ls[0]); ind <= Integer.parseInt(ls[1]); ++ind) {
            Object tag = this.lc(parser.getAttributeValue("", "tag"), ind);
            mainType = this.parseBaseRuleType(parser, parent, (String)tag);
            this.registerMapRule(parser, mainType);
            if (!"true".equals(parser.getAttributeValue("", "lang"))) continue;
            for (String lng : langs) {
                tag = this.lc(parser.getAttributeValue("", "tag"), ind) + ":" + lng;
                if (this.types.containsKey(MapRenderingTypesEncoder.constructRuleKey((String)tag, null))) continue;
                MapRenderingTypes.MapRulType retype = this.parseBaseRuleType(parser, parent, (String)tag);
                this.registerMapRule(parser, retype);
            }
        }
        return mainType;
    }

    public boolean encodeEntityWithType(Entity e, int zoom, TIntArrayList outTypes, TIntArrayList outAddTypes, TreeMap<MapRenderingTypes.MapRulType, String> namesToEncode, List<MapRenderingTypes.MapRulType> tempListNotUsed) {
        return this.encodeEntityWithType(e instanceof Node, e.getModifiableTags(), zoom, outTypes, outAddTypes, namesToEncode, tempListNotUsed);
    }

    public boolean encodeEntityWithType(boolean node, Map<String, String> tags, int zoom, TIntArrayList outTypes, TIntArrayList outAddTypes, TreeMap<MapRenderingTypes.MapRulType, String> namesToEncode, List<MapRenderingTypes.MapRulType> tempListNotUsed) {
        outTypes.clear();
        outAddTypes.clear();
        namesToEncode.clear();
        tags = this.transformTags(tags, node ? Entity.EntityType.NODE : Entity.EntityType.WAY, EntityConvertApplyType.MAP);
        boolean area = "yes".equals(tags.get("area"));
        for (String tag : tags.keySet()) {
            MapRenderingTypes.MapRulType rType;
            String val = tags.get(tag);
            if (tag.equals("seamark:notice:orientation")) {
                val = this.simplifyValueTo45(val);
            }
            if (tag.equals("direction")) {
                val = this.simplifyDirection(val);
            }
            if ((rType = this.getMapRuleType(tag, val)) == null && val.contains(";")) {
                String v;
                String[] stringArray = val.split(";");
                int n = stringArray.length;
                for (int i = 0; i < n && (rType = this.getMapRuleType(tag, v = stringArray[i])) == null; ++i) {
                }
            }
            if (rType == null || rType.minzoom > zoom || rType.maxzoom < zoom || rType.onlyPoint && !node || rType == this.nameEnRuleType && Algorithms.objectEquals((Object)val, (Object)tags.get(OSMSettings.OSMTagKey.NAME.getValue()))) continue;
            rType.updateFreq();
            if (rType.isMain()) {
                outTypes.add(this.combineOrderAndId(rType));
            }
            if (!rType.isAdditionalOrText() || !rType.isMap()) continue;
            if (rType.isAdditional()) {
                outAddTypes.add(this.combineOrderAndId(rType));
                continue;
            }
            if (!rType.isText()) continue;
            namesToEncode.put(rType, val);
        }
        this.sortAndUpdateTypes(outTypes);
        this.sortAndUpdateTypes(outAddTypes);
        return area;
    }

    public Map<String, String> transformTags(Map<String, String> tags, Entity.EntityType entity, EntityConvertApplyType appType) {
        this.checkIfInitNeeded();
        tags = this.transformShieldTags(tags, entity, appType);
        tags = this.transformIntegrityTags(tags, entity, appType);
        tags = this.transformOpeningHoursTags(tags, appType);
        tags = this.transformChargingTags(tags, entity);
        tags = this.transformOsmcAndColorTags(tags);
        tags = this.transformAddMultipleNetwoksTag(tags);
        tags = this.transformRouteLimitationTags(tags);
        tags = this.transformTurnLanesTags(tags);
        tags = this.addEleFeetTags(tags);
        List<EntityConvert> listToTransform = this.getApplicableConverts(tags, entity, EntityConvertType.TAG_TRANSFORM, appType);
        List<EntityConvert> listToCombine = this.getApplicableConverts(tags, entity, EntityConvertType.TAG_COMBINE, appType);
        if (listToTransform == null && listToCombine == null) {
            return this.postTransform(tags);
        }
        LinkedHashMap<String, String> rtags = new LinkedHashMap<String, String>(tags);
        if (listToTransform != null) {
            for (EntityConvert ec : listToTransform) {
                this.applyTagTransforms(rtags, ec, tags);
            }
        }
        if (listToCombine != null) {
            for (EntityConvert ec : listToCombine) {
                this.applyTagCombines(rtags, ec, entity, tags);
            }
        }
        return this.postTransform(rtags);
    }

    private Map<String, String> postTransform(Map<String, String> tags) {
        boolean transform = false;
        for (String t : tags.keySet()) {
            if (!t.startsWith("route_road_")) continue;
            transform = true;
        }
        if (transform) {
            LinkedHashMap<String, String> rtags = new LinkedHashMap<String, String>(tags);
            for (String t : tags.keySet()) {
                if (!t.startsWith("route_road_") || t.length() <= "route_road_".length() + 3) continue;
                String tag = t.substring("route_road_".length() + 2);
                String ind = t.substring("route_road_".length(), "route_road_".length() + 1);
                rtags.put("road_" + tag + "_" + ind, tags.get(t));
            }
            return rtags;
        }
        return tags;
    }

    private Map<String, String> transformOpeningHoursTags(Map<String, String> tags, EntityConvertApplyType appType) {
        String originalOH = tags.get("opening_hours");
        if (appType == EntityConvertApplyType.POI && originalOH != null) {
            Object oh = originalOH;
            for (Map.Entry<String, String> e : tags.entrySet()) {
                String subkey;
                if (!e.getKey().startsWith("opening_hours:") || (subkey = e.getKey().substring("opening_hours:".length())).equals("lastcheck") || subkey.equals("last_check") || subkey.equals("signed")) continue;
                oh = (String)oh + " || " + e.getValue() + " \"" + Algorithms.capitalizeFirstLetter((String)subkey) + "\"";
            }
            if (((String)oh).length() > originalOH.length()) {
                tags = new LinkedHashMap<String, String>(tags);
                tags.put("opening_hours", (String)oh);
            }
        }
        return tags;
    }

    private Map<String, String> transformChargingTags(Map<String, String> tags, Entity.EntityType entity) {
        if (entity == Entity.EntityType.NODE) {
            if (this.socketTypes == null) {
                this.initSocketTypes();
            }
            tags = new LinkedHashMap<String, String>(tags);
            for (String key : this.socketTypes.keySet()) {
                String val = tags.get(key);
                String socketType = this.parseSocketType(key);
                String socketParam = this.parseSocketParam(key);
                if (val == null || socketType == null || socketParam == null) continue;
                String newKey = "osmand_socket_" + socketType + "_" + socketParam;
                tags.put(newKey, this.filterValues(val, this.socketTypes.get(key)));
            }
        }
        return tags;
    }

    private String parseSocketParam(String key) {
        int lastColon = key.lastIndexOf(58);
        if (lastColon != -1) {
            return key.substring(lastColon + 1);
        }
        return null;
    }

    private String parseSocketType(String string) {
        int firstColon = string.indexOf(58);
        int secondColon = string.indexOf(58, firstColon + 1);
        if (firstColon != -1 && secondColon != -1) {
            return string.substring(firstColon + 1, secondColon);
        }
        return null;
    }

    private String filterValues(String val, TIntArrayList limits) {
        String standard = val.toLowerCase().replaceAll(" ", "");
        if (standard.contains("x")) {
            standard = standard.substring(standard.indexOf("x"), standard.length() - 1);
        }
        if (standard.contains(";")) {
            String[] vals;
            int out = 0;
            for (String value : vals = standard.split(";")) {
                out = Math.max(out, this.getNumericValue(value));
            }
            return this.getAppropriateVal(out, limits);
        }
        return this.getAppropriateVal(this.getNumericValue(standard), limits);
    }

    private int getNumericValue(String value) {
        value = value.replaceAll("[^\\d.,]", "").replaceAll(",", ".");
        double tmp = 0.0;
        if (!value.isEmpty()) {
            try {
                tmp = Double.valueOf(value);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return (int)tmp;
    }

    private String getAppropriateVal(int output, TIntArrayList limits) {
        if (output > 1000) {
            output /= 1000;
        }
        if (output <= limits.get(0)) {
            return LOW_CHARGING_OUT;
        }
        if (output <= limits.get(1)) {
            return MEDIUM_CHARGING_OUT;
        }
        return HIGH_CHARGING_OUT;
    }

    private Map<String, String> transformIntegrityTags(Map<String, String> tags, Entity.EntityType entity, EntityConvertApplyType appType) {
        if (tags.containsKey("highway") && entity == Entity.EntityType.WAY) {
            tags = new LinkedHashMap<String, String>(tags);
            int[] integrityResult = MapRenderingTypesEncoder.calculateIntegrity(tags);
            int integrity = integrityResult[0];
            int integrity_bicycle_routing = integrityResult[1];
            int max_integrity = 30;
            int normalised_integrity_brouting = 0;
            normalised_integrity_brouting = integrity_bicycle_routing >= 0 ? integrity_bicycle_routing * 10 / max_integrity : -1;
            int normalised_integrity = integrity * 10 / max_integrity;
            if (integrity < 100) {
                tags.put("osmand_highway_integrity", "" + normalised_integrity);
            }
            tags.put("osmand_highway_integrity_brouting", "" + normalised_integrity_brouting);
            if (normalised_integrity_brouting > 4 && normalised_integrity_brouting <= 10) {
                tags.put("osmand_highway_integrity_brouting_low", "yes");
            }
        }
        return tags;
    }

    private Map<String, String> transformAddMultipleNetwoksTag(Map<String, String> tags) {
        int networkTypesCount = 0;
        boolean networkId = false;
        for (String tag : tags.keySet()) {
            if (NODE_NETWORKS_REF_TYPES.contains(tag)) {
                ++networkTypesCount;
            }
            if (!NODE_NETWORK_IDS.contains(tag)) continue;
            networkId = true;
        }
        if (networkTypesCount > 1 && networkId) {
            LinkedHashMap<String, String> rtags = new LinkedHashMap<String, String>(tags);
            rtags.put(NODE_NETWORK_TAG, NODE_NETWORK_MULTIPLE_VALUE);
            return rtags;
        }
        return tags;
    }

    private Map<String, String> transformShieldTags(Map<String, String> tags, Entity.EntityType entity, EntityConvertApplyType appType) {
        String name;
        if (entity == Entity.EntityType.WAY && !Algorithms.isEmpty((CharSequence)tags.get("ref")) && tags.containsKey("highway")) {
            String wayRef = tags.get("ref");
            String wayRefColor = tags.get("ref:colour");
            LinkedHashSet<String> wayRefs = new LinkedHashSet<String>();
            for (String r : Arrays.asList(wayRef.split(";"))) {
                wayRefs.add(r.trim());
            }
            LinkedHashSet<String> exisitingRefs = new LinkedHashSet<String>();
            LinkedHashMap<CallSite, String> missingColors = new LinkedHashMap<CallSite, String>();
            int maxModifier = 1;
            for (int modifier = 1; modifier < 10; ++modifier) {
                String ref = tags.get("route_road_" + modifier + "_ref");
                if (Algorithms.isEmpty((CharSequence)ref)) continue;
                exisitingRefs.add(ref);
                exisitingRefs.add(ref.replaceAll("-", "").replaceAll(" ", ""));
                maxModifier = modifier + 1;
                String routeRoadRefColorTag = "route_road_" + modifier + "_ref:colour";
                if (Algorithms.isEmpty((CharSequence)wayRefColor) || tags.get(routeRoadRefColorTag) != null || !wayRefs.contains(ref)) continue;
                missingColors.put((CallSite)((Object)routeRoadRefColorTag), wayRefColor);
            }
            wayRefs.removeAll(exisitingRefs);
            if (wayRefs.size() > 0 || missingColors.size() > 0) {
                tags = new LinkedHashMap<String, String>(tags);
                tags.putAll(missingColors);
                for (String ref : wayRefs) {
                    String wayRefNetwork;
                    String s = ref.replaceAll("-", "").replaceAll(" ", "");
                    if (ref.length() == 0 || exisitingRefs.contains(s)) continue;
                    this.checkOrMainRule("route_road", "", 1);
                    tags.put("route_road", "");
                    String basePart = "route_road_" + maxModifier;
                    this.checkOrCreateAdditional(basePart, "", null);
                    tags.put(basePart, "");
                    this.checkOrCreateTextRule(basePart + "_ref", this.getRuleType("ref", null, appType));
                    tags.put(basePart + "_ref", ref);
                    if (!Algorithms.isEmpty((CharSequence)wayRefColor)) {
                        this.checkOrCreateTextRule(basePart + "_ref:colour", this.getRuleType("ref:colour", null, appType));
                        tags.put(basePart + "_ref:colour", wayRefColor);
                    }
                    if (!Algorithms.isEmpty((CharSequence)(wayRefNetwork = this.getNetwork(ref)))) {
                        this.checkOrCreateTextRule(basePart + "_network", this.getRuleType("network", null, appType));
                        tags.put(basePart + "_network", wayRefNetwork);
                    }
                    ++maxModifier;
                }
            }
        }
        if (entity == Entity.EntityType.WAY && tags.containsKey("highway") && tags.containsKey("name") && ((name = (tags = new LinkedHashMap<String, String>(tags)).get("name")).toLowerCase().contains("transcanad") || name.toLowerCase().contains("trans canad") || name.toLowerCase().contains("trans-canad") || name.toLowerCase().contains("yellowhead"))) {
            tags.put("tch", "yes");
        }
        if (entity == Entity.EntityType.WAY && tags.containsKey("highway")) {
            tags = new LinkedHashMap<String, String>(tags);
            for (int i = 1; i < 10; ++i) {
                String name2 = tags.get("road_name_" + i);
                if (name2 == null || !name2.toLowerCase().contains("transcanad") && !name2.toLowerCase().contains("trans canad") && !name2.toLowerCase().contains("trans-canad") && !name2.toLowerCase().contains("yellowhead")) continue;
                tags.put("tch", "yes");
            }
        }
        tags = this.transformRouteRoadTags(tags);
        return tags;
    }

    public Map<String, String> transformRouteLimitationTags(Map<String, String> tags) {
        String[] validatedTags = new String[]{"length", "maxspeed", "weight", "speed"};
        for (Map.Entry<String, String> e : tags.entrySet()) {
            String val = e.getValue();
            String key = e.getKey();
            for (String valTag : validatedTags) {
                int i;
                if (!key.startsWith(valTag) || (i = Algorithms.findFirstNumberEndIndexLegacy((String)val)) <= 0) continue;
                try {
                    Float.parseFloat(val.substring(0, i));
                }
                catch (Exception es) {
                    System.err.println(String.format("! Error parsing float number %s", val));
                    tags = new LinkedHashMap<String, String>(tags);
                    int ik = Algorithms.findFirstNumberEndIndex((String)val);
                    String ending = "";
                    if (val.indexOf(32) != -1) {
                        ending = val.substring(val.indexOf(32));
                    }
                    float f = 0.0f;
                    if (ik >= 0) {
                        f = Float.parseFloat(val.substring(0, ik));
                    }
                    System.err.println(String.format("! Parsed number -> '%s' ", f + ending));
                    tags.put(key, f + ending);
                }
            }
        }
        return tags;
    }

    public Map<String, String> transformTurnLanesTags(Map<String, String> tags) {
        if (tags.containsKey("turn:lanes:both_ways")) {
            tags = new LinkedHashMap<String, String>(tags);
            String value = tags.get("turn:lanes:both_ways");
            if (tags.containsKey("turn:lanes:forward")) {
                this.addBothWayValue(tags, "turn:lanes:forward", value);
            }
            if (tags.containsKey("turn:lanes:backward")) {
                this.addBothWayValue(tags, "turn:lanes:backward", value);
            }
        }
        return tags;
    }

    private void addBothWayValue(Map<String, String> tags, String tag, String bothWayValue) {
        if (bothWayValue.equals("left")) {
            tags.put(tag, bothWayValue + "|" + tags.get(tag));
        } else if (bothWayValue.equals("right")) {
            tags.put(tag, tags.get(tag) + "|" + bothWayValue);
        }
    }

    protected MapRenderingTypes.MapRulType getRuleType(String tag, String val, EntityConvertApplyType appType) {
        return this.getRuleType(tag, val, appType == EntityConvertApplyType.POI, appType != EntityConvertApplyType.POI);
    }

    private Map<String, String> transformRouteRoadTags(Map<String, String> tags) {
        if (!tags.containsKey("route") && !"road".equals(tags.get("route"))) {
            return tags;
        }
        LinkedHashMap<String, String> rtags = new LinkedHashMap<String, String>(tags);
        String[] countyArray = new String[]{"luc", "herkimer", "montgomery", "guadalupe", "cumberland", "cass", "koochiching", "bergen", "saint lawrence", "schenectady", "log", "sullivan", "wil", "oneida", "le sueur", "way", "tus", "kandiyohi", "beltrami", "becker", "madison", "passaic", "douglas", "rensselaer", "dutchess", "freeborn", "ful", "crow wing", "hennepin", "orange", "clearwater", "sum", "hubbard", "hol", "otsego", "stearns", "carlton", "itasca", "anoka", "kanabec", "cook", "atlantic", "benton", "saratoga", "albany", "essex", "aitkin", "mah", "isanti", "faribault", "washington", "rockland", "cape_may", "ramsey", "lac qui parle", "warren", "greene", "chisago", "blue earth", "ulster", "somerset", "ott", "sussex", "morris", "kittson", "car", "pine", "big stone", "fillmore", "dakota", "monmouth", "col", "kane", "goodhue", "vin", "med", "middlesex", "lake", "columbia", "dodge", "hoc", "yellow medicine", "rice", "murray", "per", "steele", "outagamie", "asd", "lake of the woods", "mchenry", "fulton", "cottonwood", "carver", "ocean", "mille lacs", "redwood", "meeker", "winona", "renville", "brown", "swift", "pope", "martin", "delaware", "fay", "houston", "union", "chippewa", "nobles", "lyon", "wright", "sibley", "nicollet", "jef", "watonwan", "schoharie", "mcleod", "chenango", "hudson", "winnipeg", "pipestone", "mrw", "woodbury", "gue", "moe", "uni", "stevens", "wilkin", "traverse", "leelanau", "sen", "cook", "woo", "camden", "sta", "lic", "h", "cth", "ath", "burlington", "gonzales", "hamilton", "sauk", "colorado", "westchester", "story", "bel", "pau", "san", "lor", "ozaukee", "jasper", "waupaca", "dane", "belt", "oswego", "erie", "floyd", "bremer", "fond du lac", "sheboygan", "har", "macon", "chickasaw", "hays", "caldwell", "wya", "cos", "shelby", "monona", "clayton", "winnebago", "langlade", "hen", "gea", "eri", "chp", "but", "dupage", "ida", "hardin", "buena vista", "waushara", "walworth", "shawano", "saint croix", "rock", "portage", "milwaukee", "door", "put", "pre", "por", "odnr", "mei", "jac", "hur", "ham", "gac", "fra", "cli", "ash", "onondaga", "gloucester", "cape may", "charlotte", "waseca", "olmsted", "marquette", "fulton", "champaign", "worth", "sac", "pottawattamie", "polk", "lucas", "keokuk", "franklin", "cedar", "adams", "escambia", "kent", "santa clara", "chautauqua", "yates", "steuben", "chemung", "tioga", "tompkins", "schuyler", "allegany", "cattaraugus", "broome", "livingston"};
        if (rtags.containsKey("network")) {
            String network = (String)rtags.get("network");
            if (network.startsWith("US:")) {
                if (!(network.equalsIgnoreCase("US:I") || network.startsWith("US:I:") || network.toUpperCase().startsWith("US:US"))) {
                    if (network.length() > 7 && network.substring(6, 8).equals("CR") || network.toLowerCase().contains("county") || network.length() > 7 && Arrays.asList(countyArray).contains(network.substring(6).toLowerCase()) && network.split(":", -1).length - 1 < 3) {
                        rtags.put("us_county_network", "yes");
                    } else {
                        rtags.put("us_state_network", "yes");
                    }
                    if (network.length() > 5) {
                        rtags.put("network", network);
                    }
                }
                if (network.equalsIgnoreCase("US:I")) {
                    rtags.put("network", "us:i");
                }
                if (network.toUpperCase().startsWith("US:US")) {
                    rtags.put("network", "us:us");
                }
            }
        } else {
            String network;
            String rf = (String)rtags.get("ref");
            if (!Algorithms.isEmpty((CharSequence)rf) && !Algorithms.isEmpty((CharSequence)(network = this.getNetwork(rf = rf.trim())))) {
                rtags.put("network", network);
            }
        }
        if (rtags.containsKey("network") && !Algorithms.isEmpty((CharSequence)((CharSequence)rtags.get("network")))) {
            rtags.put("network", ((String)rtags.get("network")).toLowerCase());
        }
        if (rtags.containsKey("modifier") && !Algorithms.isEmpty((CharSequence)((CharSequence)rtags.get("modifier")))) {
            rtags.put("modifier", ((String)rtags.get("modifier")).toLowerCase());
        }
        if (rtags.containsKey("ref") && !Algorithms.isEmpty((CharSequence)((CharSequence)rtags.get("ref")))) {
            rtags.put("ref", (String)rtags.get("ref"));
        }
        return rtags;
    }

    private String getNetwork(String rf) {
        boolean numbers = true;
        String network = "";
        if (rf.length() != 0 && !Character.isDigit(rf.charAt(0))) {
            numbers = false;
        }
        if (numbers) {
            network = "#";
        }
        return network;
    }

    public List<Map<String, String>> splitTags(Map<String, String> tags, Entity.EntityType entity) {
        EntityConvertType filter = EntityConvertType.SPLIT;
        List<EntityConvert> listToConvert = this.getApplicableConverts(tags, entity, filter, EntityConvertApplyType.MAP);
        ArrayList<Map<String, String>> result = null;
        if (listToConvert == null) {
            return result;
        }
        result = new ArrayList<Map<String, String>>();
        LinkedHashMap<String, String> ctags = new LinkedHashMap<String, String>(tags);
        result.add(ctags);
        for (EntityConvert ec : listToConvert) {
            LinkedHashMap<String, String> mp = new LinkedHashMap<String, String>();
            for (MapRenderingTypes.TagValuePattern ift : ec.toTags) {
                String vl = ift.value;
                if (vl == null) {
                    vl = (String)ctags.get(ift.tag);
                }
                if ((vl = this.processSubstr(ift, vl)) == null) continue;
                mp.put(ift.tag, vl);
            }
            ctags.remove(ec.fromTag.tag);
            result.add(mp);
        }
        return result;
    }

    protected List<EntityConvert> getApplicableConverts(Map<String, String> tags, Entity.EntityType entity, EntityConvertType filterTransform, EntityConvertApplyType filterProcessingType) {
        ArrayList<EntityConvert> listToConvert = null;
        block0: for (Map.Entry<String, String> e : tags.entrySet()) {
            List<EntityConvert> list = this.convertTags.get(e.getKey());
            if (list == null) continue;
            for (EntityConvert ec : list) {
                String skipMsg = null;
                if (skipMsg == null && ec.type != filterTransform) {
                    skipMsg = " transform " + String.valueOf((Object)filterTransform) + "!= " + String.valueOf((Object)ec.type) + ";";
                }
                if (skipMsg == null && !ec.applyToType.contains((Object)filterProcessingType)) {
                    skipMsg = " appFilter " + String.valueOf(ec.applyToType) + ";";
                }
                if (skipMsg == null && !this.checkConvertValue(ec.fromTag, e.getValue())) {
                    skipMsg = " value mismatch " + e.getValue();
                }
                if (skipMsg != null) {
                    if (!ec.verbose) continue;
                    log.info((Object)("Skip entity convert from '" + String.valueOf(ec.fromTag) + "' to " + String.valueOf(tags) + " in " + String.valueOf((Object)filterProcessingType) + skipMsg));
                    continue;
                }
                Object verbose = null;
                if (ec.verbose) {
                    verbose = "Apply entity convert from '" + String.valueOf(ec.fromTag) + "' to " + String.valueOf(tags) + " in " + String.valueOf((Object)filterProcessingType);
                }
                if (ec.type == EntityConvertType.TAG_COMBINE) {
                    if (ec.fromTagList.size() > 0) {
                        boolean tagPresent = false;
                        Object tagListVerbose = "";
                        for (MapRenderingTypes.TagValuePattern ft : ec.fromTagList) {
                            tagListVerbose = (String)tagListVerbose + ft.tag + " ";
                            if (!tags.containsKey(ft.tag)) continue;
                            tagPresent = true;
                            break;
                        }
                        if (!tagPresent) {
                            if (verbose == null) continue block0;
                            verbose = " - has failed due to tags are not contain any +'" + (String)tagListVerbose + "' for combine";
                            log.info(verbose);
                            continue block0;
                        }
                    } else {
                        if (verbose == null) continue block0;
                        verbose = " - has failed due to additional list of 'from_tag1, from_tag2, ...' for combine is empty";
                        log.info(verbose);
                        continue block0;
                    }
                }
                if (this.checkConvert(tags, ec, entity)) {
                    if (listToConvert == null) {
                        listToConvert = new ArrayList<EntityConvert>();
                    }
                    listToConvert.add(ec);
                    if (verbose != null) {
                        verbose = (String)verbose + " - has succeeded";
                    }
                } else if (verbose != null) {
                    verbose = (String)verbose + " - has failed due to if conditions";
                }
                if (verbose == null) continue;
                log.info(verbose);
            }
        }
        return listToConvert;
    }

    private void applyTagTransforms(Map<String, String> resultTags, EntityConvert ec, Map<String, String> originalTags) {
        this.applyTagTransforms(resultTags, ec, originalTags, "");
        if (ec.lang) {
            for (String lang : langs) {
                this.applyTagTransforms(resultTags, ec, originalTags, lang);
            }
            this.applyTagTransforms(resultTags, ec, originalTags, "en");
        }
    }

    private void applyTagTransforms(Map<String, String> tags, EntityConvert ec, Map<String, String> originaltags, String lang) {
        Object langSuffix = lang.isEmpty() ? "" : ":" + lang;
        String fromTag = ec.fromTag.tag + (String)langSuffix;
        String fromValue = originaltags.get(fromTag);
        if (tags.remove(fromTag) == null) {
            return;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.toTags) {
            String vl = ift.value;
            if (vl == null) {
                vl = fromValue;
            }
            vl = this.processSubstr(ift, vl);
            if (ift.tagPrefix != null) {
                for (String vlSplit : fromValue.split(";")) {
                    tags.put(ift.tagPrefix + vlSplit.trim(), vl);
                }
                continue;
            }
            tags.put(ift.tag + (String)langSuffix, vl);
        }
    }

    private void applyTagCombines(Map<String, String> tags, EntityConvert ec, Entity.EntityType entity, Map<String, String> originaltags) {
        Object fromValue = originaltags.get(ec.fromTag.tag);
        tags.remove(ec.fromTag.tag);
        for (MapRenderingTypes.TagValuePattern ft : ec.fromTagList) {
            if (!tags.containsKey(ft.tag)) continue;
            tags.remove(ft.tag);
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.toTags) {
            String sep = ec.separator.isEmpty() ? " " : ec.separator;
            for (MapRenderingTypes.TagValuePattern ft : ec.fromTagList) {
                if (!originaltags.containsKey(ft.tag)) continue;
                fromValue = (String)fromValue + sep + originaltags.get(ft.tag);
            }
            tags.put(ift.tag, (String)fromValue);
        }
    }

    private String processSubstr(MapRenderingTypes.TagValuePattern ift, String vl) {
        int s;
        if (vl == null) {
            return null;
        }
        if (ift.substrSt != 0) {
            s = ift.substrSt;
            if (s > 0) {
                vl = vl.length() < s ? "" : vl.substring(s).trim();
            } else if (vl.length() > -s) {
                vl = vl.substring(vl.length() + s).trim();
            }
        }
        if (ift.substrEnd != -1) {
            s = ift.substrEnd;
            if (s > 0) {
                if (vl.length() > s) {
                    vl = vl.substring(0, s).trim();
                }
            } else {
                vl = vl.length() < -s ? "" : vl.substring(0, vl.length() + s).trim();
            }
        }
        return vl;
    }

    protected boolean checkConvert(Map<String, String> tags, EntityConvert ec, Entity.EntityType entity) {
        long vl;
        String val;
        if (ec.applyTo != null && !ec.applyTo.contains(entity)) {
            return false;
        }
        boolean empty = ec.ifRegionName.isEmpty();
        if (!empty) {
            boolean found = false;
            Object rg = tags.get(OSMAND_REGION_NAME_TAG);
            rg = Algorithms.isEmpty((CharSequence)rg) ? this.regionName : "$" + (String)rg + "^";
            for (String s : ec.ifRegionName) {
                if (!((String)rg).contains(s)) continue;
                found = true;
                break;
            }
            if (!found) {
                return false;
            }
        }
        for (String s : ec.ifNotRegionName) {
            Object rg = tags.get(OSMAND_REGION_NAME_TAG);
            rg = Algorithms.isEmpty((CharSequence)rg) ? this.regionName : "$" + (String)rg + "^";
            if (!((String)rg).contains(s)) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifTags) {
            if (this.checkConvertValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifNotTags) {
            if (!this.checkConvertValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifStartsTags) {
            if (this.checkStartsWithValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifNotStartsTags) {
            if (!this.checkStartsWithValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifEndsTags) {
            if (this.checkEndsWithValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifNotEndsTags) {
            if (!this.checkEndsWithValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifContainsTags) {
            if (this.checkContainsValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifNotContainsTags) {
            if (!this.checkContainsValue(ift, val = tags.get(ift.tag))) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifTagsNotLess) {
            val = tags.get(ift.tag);
            double nt = Double.parseDouble(ift.value);
            vl = Algorithms.parseLongSilently((String)val, (long)0L);
            if (!((double)vl < nt)) continue;
            return false;
        }
        for (MapRenderingTypes.TagValuePattern ift : ec.ifTagsLess) {
            val = tags.get(ift.tag);
            double nt = Double.parseDouble(ift.value);
            vl = Algorithms.parseLongSilently((String)val, (long)0L);
            if (!((double)vl >= nt)) continue;
            return false;
        }
        return true;
    }

    private boolean checkConvertValue(MapRenderingTypes.TagValuePattern fromTag, String value) {
        if (value == null) {
            return false;
        }
        if (fromTag.value == null) {
            return true;
        }
        if (fromTag.value.equals(value)) {
            return true;
        }
        if (fromTag.value.length() != value.length()) {
            return false;
        }
        return fromTag.value.toLowerCase().equals(value.toLowerCase());
    }

    private boolean checkStartsWithValue(MapRenderingTypes.TagValuePattern fromTag, String value) {
        if (value == null) {
            return false;
        }
        if (fromTag.value == null) {
            return true;
        }
        return value.toLowerCase().startsWith(fromTag.value.toLowerCase());
    }

    private boolean checkContainsValue(MapRenderingTypes.TagValuePattern fromTag, String value) {
        if (value == null) {
            return false;
        }
        if (fromTag.value == null) {
            return true;
        }
        return value.toLowerCase().contains(fromTag.value.toLowerCase());
    }

    private boolean checkEndsWithValue(MapRenderingTypes.TagValuePattern fromTag, String value) {
        if (value == null) {
            return false;
        }
        if (fromTag.value == null) {
            return true;
        }
        return value.toLowerCase().endsWith(fromTag.value.toLowerCase());
    }

    private Map<String, String> addEleFeetTags(Map<String, String> tags) {
        double FEET = 3.2808399;
        double eleMeters = Algorithms.parseDoubleSilently((String)tags.get("ele"), (double)Double.NaN);
        double eleFeet = Algorithms.parseDoubleSilently((String)tags.get("ele_feet"), (double)Double.NaN);
        if (!Double.isNaN(eleMeters) && Double.isNaN(eleFeet)) {
            eleFeet = eleMeters * 3.2808399;
        } else if (!Double.isNaN(eleFeet) && Double.isNaN(eleMeters)) {
            eleMeters = eleFeet / 3.2808399;
        } else if (Double.isNaN(eleMeters) && Double.isNaN(eleFeet)) {
            return tags;
        }
        tags = new LinkedHashMap<String, String>(tags);
        tags.put("ele", String.valueOf(Math.round(eleMeters)));
        tags.put("ele_feet", String.valueOf(Math.round(eleFeet)));
        return tags;
    }

    protected String simplifyValueTo45(String val) {
        int rad = 8;
        double circle = 360.0;
        try {
            double simple01;
            for (simple01 = Double.parseDouble((String)val) / circle; simple01 < 0.0; simple01 += 1.0) {
            }
            while (simple01 >= 1.0) {
                simple01 -= 1.0;
            }
            int rnd = (int)Math.round(simple01 * (double)rad);
            val = "" + (double)rnd * circle / (double)rad;
        }
        catch (NumberFormatException e) {
            log.error((Object)("Wrong value of \"seamark:notice:orientation\" " + (String)val));
        }
        return val;
    }

    protected String simplifyDirection(String val) {
        if ("down".equals(val) || "forward".equals(val) || "backward".equals(val) || "anticlockwise".equals(val) || "clockwise".equals(val) || "up".equals(val) || "all".equals(val)) {
            return val;
        }
        if ("N".equalsIgnoreCase((String)val) || "NNW".equalsIgnoreCase((String)val) || "NW".equalsIgnoreCase((String)val) || "NNE".equalsIgnoreCase((String)val) || "NE".equalsIgnoreCase((String)val) || "E".equalsIgnoreCase((String)val) || "ESE".equalsIgnoreCase((String)val) || "ENE".equalsIgnoreCase((String)val) || "W".equalsIgnoreCase((String)val) || "WSW".equalsIgnoreCase((String)val) || "WNW".equalsIgnoreCase((String)val) || "S".equalsIgnoreCase((String)val) || "SSW".equalsIgnoreCase((String)val) || "SW".equalsIgnoreCase((String)val) || "SSE".equalsIgnoreCase((String)val) || "SE".equalsIgnoreCase((String)val)) {
            return ((String)val).toLowerCase();
        }
        int rad = 16;
        double circle = 360.0;
        try {
            double simple01 = Double.parseDouble((String)val) / circle;
            if (simple01 > 2.147483647E9 || simple01 < -2.147483648E9) {
                return "n";
            }
            if (simple01 < 0.0) {
                simple01 -= (double)((int)simple01);
            }
            if (simple01 >= 1.0) {
                simple01 -= (double)((int)simple01);
            }
            int rnd = (int)Math.round(simple01 * (double)rad);
            switch (val = "" + (int)((double)rnd * circle / (double)rad)) {
                case "0": {
                    val = "n";
                    break;
                }
                case "22": {
                    val = "nne";
                    break;
                }
                case "45": {
                    val = "ne";
                    break;
                }
                case "67": {
                    val = "ene";
                    break;
                }
                case "90": {
                    val = "e";
                    break;
                }
                case "112": {
                    val = "ese";
                    break;
                }
                case "135": {
                    val = "se";
                    break;
                }
                case "157": {
                    val = "sse";
                    break;
                }
                case "180": {
                    val = "s";
                    break;
                }
                case "202": {
                    val = "ssw";
                    break;
                }
                case "225": {
                    val = "sw";
                    break;
                }
                case "247": {
                    val = "wsw";
                    break;
                }
                case "270": {
                    val = "w";
                    break;
                }
                case "292": {
                    val = "wnw";
                    break;
                }
                case "315": {
                    val = "nw";
                    break;
                }
                case "337": {
                    val = "nnw";
                    break;
                }
                case "360": {
                    val = "n";
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return val;
    }

    private void prepareColorTag(Map<String, String> tags, String tag) {
        String vl = tags.get(tag);
        vl = MapRenderingTypesEncoder.formatColorToPalette(vl, false);
        tags.put("colour_" + vl, "");
        tags.put("color_" + vl, "");
    }

    private void sortAndUpdateTypes(TIntArrayList outTypes) {
        outTypes.sort();
        for (int i = 0; i < outTypes.size(); ++i) {
            int k = outTypes.get(i) & Short.MAX_VALUE;
            outTypes.set(i, k);
        }
    }

    private int combineOrderAndId(MapRenderingTypes.MapRulType rType) {
        if (rType.id > 32768) {
            throw new UnsupportedOperationException();
        }
        if (rType.order << 15 < 0) {
            throw new UnsupportedOperationException();
        }
        return rType.order << 15 | rType.id;
    }

    public static double[] RGBtoHSV(double r, double g, double b) {
        double max;
        double min = Math.min(Math.min(r, g), b);
        double v = max = Math.max(Math.max(r, g), b);
        double delta = max - min;
        if (max == 0.0) {
            double s = 0.0;
            double h = -1.0;
            return new double[]{h, s, v};
        }
        double s = delta / max;
        double h = r == max ? (g - b) / delta : (g == max ? 2.0 + (b - r) / delta : 4.0 + (r - g) / delta);
        h *= 60.0;
        if (h < 0.0) {
            h += 360.0;
        }
        return new double[]{h, s, v};
    }

    public static String formatColorToPalette(String vl, boolean palette6) {
        vl = vl.toLowerCase();
        int color = -1;
        int r = -1;
        int g = -1;
        int b = -1;
        if (vl.length() > 1 && vl.charAt(0) == '#') {
            try {
                color = Algorithms.parseColor((String)vl);
                r = color >> 16 & 0xFF;
                g = color >> 8 & 0xFF;
                b = color >> 0 & 0xFF;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        float[] hsv = new float[3];
        Color.RGBtoHSB(r, g, b, hsv);
        float h = hsv[0];
        float s = hsv[1];
        float v = hsv[2];
        h *= 360.0f;
        s *= 100.0f;
        v *= 100.0f;
        if (h < 16.0f && s > 25.0f && v > 30.0f || h > 326.0f && s > 25.0f && v > 30.0f || h < 16.0f && s > 10.0f && s < 25.0f && v > 90.0f || h > 326.0f && s > 10.0f && s < 25.0f && v > 90.0f || vl.contains("red") || vl.equals("pink/white") || vl.equals("white-red") || vl.equals("ff0000") || vl.equals("800000") || vl.equals("red/tan") || vl.equals("tan/red") || vl.equals("rose") || vl.equals("salmon")) {
            vl = "red";
        } else if (h >= 16.0f && h < 50.0f && s > 25.0f && v > 20.0f && v < 60.0f || vl.equals("brown") || vl.equals("darkbrown") || vl.equals("tan/brown") || vl.equals("tan_brown") || vl.equals("brown/tan") || vl.equals("light_brown") || vl.equals("brown/white") || vl.equals("tan")) {
            vl = palette6 ? "red" : "brown";
        } else if (h >= 16.0f && h < 45.0f && v > 60.0f || vl.equals("orange") || vl.equals("cream") || vl.equals("gold") || vl.equals("yellow-red") || vl.equals("ff8c00") || vl.equals("peach")) {
            vl = palette6 ? "red" : "orange";
        } else if (h >= 46.0f && h < 66.0f && s > 30.0f && v > 83.0f || vl.equals("yellow") || vl.equals("gelb") || vl.equals("ffff00") || vl.equals("beige") || vl.equals("lightyellow") || vl.equals("jaune")) {
            vl = "yellow";
        } else if (h >= 46.0f && h < 66.0f && s > 30.0f && v > 30.0f && v < 82.0f) {
            vl = palette6 ? "yellow" : "darkyellow";
        } else if (h >= 67.0f && h < 178.0f && s > 30.0f && v > 77.0f || vl.equals("lightgreen") || vl.equals("lime") || vl.equals("seagreen") || vl.equals("00ff00") || vl.equals("yellow/green")) {
            vl = palette6 ? "green" : "lightgreen";
        } else if (h >= 74.0f && h < 174.0f && s > 30.0f && v > 30.0f && v < 77.0f || vl.contains("green") || vl.equals("darkgreen") || vl.equals("natural") || vl.equals("natur") || vl.equals("mediumseagreen") || vl.equals("green/white") || vl.equals("white/green") || vl.equals("blue/yellow") || vl.equals("vert") || vl.equals("green/blue") || vl.equals("olive")) {
            vl = "green";
        } else if (h >= 178.0f && h < 210.0f && s > 40.0f && v > 80.0f || h >= 178.0f && h < 265.0f && s > 25.0f && s < 61.0f && v > 90.0f || vl.equals("lightblue") || vl.equals("aqua") || vl.equals("cyan") || vl.equals("87ceeb") || vl.equals("turquoise")) {
            vl = palette6 ? "blue" : "lightblue";
        } else if (h >= 178.0f && h < 210.0f && s > 40.0f && v > 35.0f && v <= 80.0f || h >= 210.0f && h < 265.0f && s > 40.0f && v > 30.0f || vl.contains("blue") || vl.equals("0000ff") || vl.equals("darkblue") || vl.equals("blu") || vl.equals("navy")) {
            vl = "blue";
        } else if (h >= 265.0f && h < 325.0f && s > 15.0f && v >= 27.0f || h > 250.0f && h < 325.0f && s > 10.0f && s < 25.0f && v > 90.0f || vl.equals("purple") || vl.equals("violet") || vl.equals("magenta") || vl.equals("maroon") || vl.equals("fuchsia") || vl.equals("800080")) {
            vl = palette6 ? "blue" : "purple";
        } else if (color != -1 & v < 27.0f || vl.contains("black") || vl.equals("darkgrey")) {
            vl = "black";
        } else if (s < 32.0f && v > 30.0f && v < 90.0f || vl.equals("gray") || vl.equals("grey") || vl.equals("grey/tan") || vl.equals("silver") || vl.equals("srebrny") || vl.equals("lightgrey") || vl.equals("lightgray") || vl.equals("metal")) {
            vl = palette6 ? "white" : "gray";
        } else if (s < 5.0f && v > 95.0f || vl.contains("white")) {
            vl = "white";
        } else if (vl.contains("pink")) {
            vl = "pink";
        } else if (vl.contains("teal")) {
            vl = "teal";
        } else if (r != -1 && g != -1 && b != -1) {
            vl = "gray";
        }
        return vl;
    }

    public Map<String, String> transformOsmcAndColorTags(Map<String, String> tags) {
        if (tags.containsKey("osmc:symbol")) {
            tags = new LinkedHashMap<String, String>(tags);
            String value = tags.get("osmc:symbol");
            OsmcSymbol osmcSymbol = new OsmcSymbol(value);
            osmcSymbol.addOsmcNewTags(tags);
        } else if (tags.containsKey("route") && !tags.containsKey("name") && !tags.containsKey("ref")) {
            String route = tags.get("route");
            String foreground = OSMC_NO_NAME_FOREGROUND.get(route);
            if (foreground != null) {
                String color;
                OsmcSymbol osmcSymbol = new OsmcSymbol("white", "", "black");
                osmcSymbol.setForeground(foreground);
                String string = color = tags.containsKey("color") ? tags.get("color") : tags.get("colour");
                if (color != null) {
                    osmcSymbol.setWaycolor(color);
                }
                osmcSymbol.addOsmcNewTags(tags);
                tags.put("osmc_order", "1");
            }
        } else if (tags.containsKey("route") && (tags.get("route").equals("hiking") || tags.get("route").equals("mtb") || tags.get("route").equals("bicycle") || tags.get("route").equals("horse") || tags.get("route").equals("running"))) {
            if (tags.containsKey("ref")) {
                String ref = (tags = new LinkedHashMap<String, String>(tags)).get("ref");
                if (!ref.isEmpty()) {
                    OsmcSymbol osmcSymbol = new OsmcSymbol("white", ref.toUpperCase(), "black");
                    osmcSymbol.addOsmcNewTags(tags);
                }
            } else if (tags.containsKey("name")) {
                tags = new LinkedHashMap<String, String>(tags);
                String name = tags.get("name");
                int count = name.codePointCount(0, name.length());
                Object text = "";
                for (int i = 0; i < count; ++i) {
                    int codePoint = name.codePointAt(i);
                    if (!Character.isUpperCase(codePoint)) continue;
                    char[] c = Character.toChars(codePoint);
                    text = (String)text + new String(c);
                }
                if (!((String)text).isEmpty()) {
                    OsmcSymbol osmcSymbol = new OsmcSymbol("white", (String)text, "black");
                    osmcSymbol.addOsmcNewTags(tags);
                }
            }
        }
        if (tags.containsKey("color")) {
            tags = new LinkedHashMap<String, String>(tags);
            this.prepareColorTag(tags, "color");
        }
        if (tags.containsKey("colour")) {
            tags = new LinkedHashMap<String, String>(tags);
            this.prepareColorTag(tags, "colour");
        }
        return tags;
    }

    private static int[] calculateIntegrity(Map<String, String> mp) {
        int result = 0;
        int result_bicycle_routing = 0;
        String surface = mp.get("surface");
        String smoothness = mp.get("smoothness");
        String tracktype = mp.get("tracktype");
        String highway = mp.get("highway");
        String bicycle = mp.get("bicycle");
        String foot = mp.get("foot");
        if (surface != null) {
            surface = surface.toLowerCase();
        }
        if (smoothness != null) {
            smoothness = smoothness.toLowerCase();
        }
        if (tracktype != null) {
            tracktype = tracktype.toLowerCase();
        }
        if ("paved".equals(surface) || "concrete".equals(surface) || "concrete:lanes".equals(surface) || "concrete:plates".equals(surface) || "sett".equals(surface) || "paving_stones".equals(surface) || "metal".equals(surface) || "wood".equals(surface) || "chipseal".equals(surface)) {
            result += 3;
            result_bicycle_routing += 3;
        } else if ("fine_gravel".equals(surface) || "grass_paver".equals(surface)) {
            result += 4;
            result_bicycle_routing += 4;
        } else if ("compacted".equals(surface)) {
            result += 8;
            result_bicycle_routing += 8;
        } else if ("cobblestone".equals(surface)) {
            result += 8;
            result_bicycle_routing += 8;
        } else if ("pebblestone".equals(surface)) {
            result += 9;
            result_bicycle_routing += 9;
        } else if ("ground".equals(surface) || "earth".equals(surface) || "dirt".equals(surface)) {
            result += 9;
            result_bicycle_routing += 9;
        } else if ("grass".equals(surface)) {
            result += 12;
            result_bicycle_routing += 12;
        } else if ("gravel".equals(surface)) {
            result += 12;
            result_bicycle_routing += 12;
        } else if ("stone".equals(surface) || "rock".equals(surface) || "rocky".equals(surface)) {
            result += 13;
            result_bicycle_routing += 13;
        } else if ("unpaved".equals(surface)) {
            result += 14;
            result_bicycle_routing += 14;
        } else if ("salt".equals(surface) || "ice".equals(surface) || "snow".equals(surface)) {
            result += 15;
            result_bicycle_routing += 15;
        } else if ("sand".equals(surface)) {
            result += 16;
            result_bicycle_routing += 16;
        } else if ("mud".equals(surface)) {
            result += 18;
            result_bicycle_routing += 18;
        }
        if ("excellent".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 7;
                result_bicycle_routing = 6;
            } else {
                result -= 5;
                result_bicycle_routing -= 5;
            }
        } else if ("very_good".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 6;
                result_bicycle_routing = 6;
            } else {
                result -= 4;
                result_bicycle_routing -= 6;
            }
        } else if ("good".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 8;
                result_bicycle_routing = 6;
            } else {
                result -= 2;
                result_bicycle_routing -= 2;
            }
        } else if ("intermediate".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 9;
                result_bicycle_routing = 9;
            }
        } else if ("bad".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 9;
                result_bicycle_routing = 9;
            } else if ("asphalt".equals(surface)) {
                result += 7;
                result_bicycle_routing += 7;
            } else {
                result += 6;
                result_bicycle_routing += 6;
            }
        } else if ("very_bad".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 12;
                result_bicycle_routing = 12;
            } else if ("asphalt".equals(surface)) {
                result += 12;
                result_bicycle_routing += 12;
            } else {
                result += 7;
                result_bicycle_routing += 7;
            }
        } else if ("horrible".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 15;
                result_bicycle_routing = 15;
            } else if ("asphalt".equals(surface)) {
                result += 19;
                result_bicycle_routing += 19;
            } else {
                result += 9;
                result_bicycle_routing += 9;
            }
        } else if ("very_horrible".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 18;
                result_bicycle_routing = 18;
            } else if ("asphalt".equals(surface)) {
                result += 22;
                result_bicycle_routing += 22;
            } else {
                result += 11;
                result_bicycle_routing += 11;
            }
        } else if ("impassable".equals(smoothness)) {
            if (("track".equals(highway) || "path".equals(highway)) && surface == null) {
                result = 24;
                result_bicycle_routing = 24;
            } else if ("asphalt".equals(surface)) {
                result += 26;
                result_bicycle_routing += 26;
            } else {
                result += 12;
                result_bicycle_routing += 12;
            }
        }
        if (surface == null) {
            if ("grade1".equals(tracktype)) {
                ++result;
                result_bicycle_routing += 6;
            } else if ("grade2".equals(tracktype)) {
                result += 3;
                result_bicycle_routing += 9;
            } else if ("grade3".equals(tracktype)) {
                result += 7;
                result_bicycle_routing += 9;
            } else if ("grade4".equals(tracktype)) {
                result += 10;
                result_bicycle_routing += 12;
            } else if ("grade5".equals(tracktype)) {
                result += 15;
                result_bicycle_routing += 16;
            }
        }
        if (("motorway".equals(highway) || "motorway_link".equals(highway) || "trunk".equals(highway) || "trunk_link".equals(highway) || "primary".equals(highway) || "primary_link".equals(highway) || "secondary".equals(highway) || "secondary_link".equals(highway) || "tertiary".equals(highway) || "tertiary_link".equals(highway) || "unclassified".equals(highway) || "residential".equals(highway) || "service".equals(highway) || "pedestrian".equals(highway) || "living_street".equals(highway) || "footway".equals(highway) || "cycleway".equals(highway)) && surface == null && smoothness == null) {
            result = 100;
        }
        if (("track".equals(highway) || "path".equals(highway)) && surface == null && smoothness == null && tracktype == null) {
            result = 100;
        }
        if ("track".equals(highway) && surface == null && smoothness == null && tracktype == null) {
            result_bicycle_routing = 9;
        }
        if ("path".equals(highway) && surface == null && smoothness == null && tracktype == null) {
            result_bicycle_routing = 12;
        }
        if ("footway".equals(highway) && surface == null && smoothness == null && tracktype == null) {
            result_bicycle_routing = 6;
        }
        if ("path".equals(highway)) {
            if ("designated".equals(bicycle)) {
                result = 0;
                result_bicycle_routing = 0;
            } else if ("designated".equals(foot)) {
                result = 2;
            }
        }
        if (result < 0) {
            result = 0;
        }
        int[] result_array = new int[]{result, result_bicycle_routing};
        return result_array;
    }

    public void addExternalAdditionalText(String tag, boolean lang) {
        this.checkIfInitNeeded();
        if (!this.types.containsKey(tag)) {
            this.registerRuleType(MapRenderingTypes.MapRulType.createText((String)tag, null));
        }
        if (lang) {
            for (String lng : langs) {
                String langTag = tag + ":" + lng;
                if (this.types.containsKey(langTag)) continue;
                this.registerRuleType(MapRenderingTypes.MapRulType.createText((String)langTag, null));
            }
            String enTag = tag + ":en";
            if (!this.types.containsKey(enTag)) {
                this.registerRuleType(MapRenderingTypes.MapRulType.createText((String)enTag, null));
            }
        }
    }

    public static class EntityConvert {
        public boolean verbose;
        public MapRenderingTypes.TagValuePattern fromTag;
        public List<MapRenderingTypes.TagValuePattern> fromTagList = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public String separator;
        public EntityConvertType type;
        public EnumSet<EntityConvertApplyType> applyToType;
        public EnumSet<Entity.EntityType> applyTo;
        public List<String> ifRegionName = new ArrayList<String>();
        public List<String> ifNotRegionName = new ArrayList<String>();
        public List<MapRenderingTypes.TagValuePattern> ifStartsTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifNotStartsTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifEndsTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifNotEndsTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifContainsTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifNotContainsTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifTagsLess = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifTagsNotLess = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> ifNotTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public List<MapRenderingTypes.TagValuePattern> toTags = new ArrayList<MapRenderingTypes.TagValuePattern>();
        public boolean lang;
    }

    private static enum EntityConvertType {
        TAG_TRANSFORM,
        SPLIT,
        TAG_COMBINE;

    }

    public static enum EntityConvertApplyType {
        MAP,
        ROUTING,
        POI;

    }

    public static class MapRouteTag {
        String tag;
        String value;
        String tag2;
        String value2;
        String type;
        boolean register;
        boolean amend;
        boolean base;
        boolean text;
        boolean replace;
    }
}

