/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.xml.internal.renderer;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.xml.sax.ContentHandler;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.listener.Listener;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.PrintRenderer;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.renderer.xml.ContentHandlerBlockRenderer;
import org.xwiki.rendering.renderer.xml.ContentHandlerStreamRenderer;
import org.xwiki.rendering.xml.internal.renderer.AbstractStreamRendererFactory;

public abstract class AbstractRenderer
extends AbstractStreamRendererFactory
implements ContentHandlerBlockRenderer,
BlockRenderer {
    public void render(Block block, ContentHandler contentHandler) {
        this.render(Arrays.asList(block), contentHandler);
    }

    public void render(Collection<Block> blocks, ContentHandler contentHandler) {
        ContentHandlerStreamRenderer renderer = this.createRenderer(contentHandler);
        for (Block block : blocks) {
            block.traverse((Listener)renderer);
        }
    }

    public void render(Block block, WikiPrinter printer) {
        this.render(Collections.singletonList(block), printer);
    }

    public void render(Collection<Block> blocks, WikiPrinter printer) {
        PrintRenderer renderer = this.createRenderer(printer);
        for (Block block : blocks) {
            block.traverse((Listener)renderer);
        }
    }
}

