/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.osmand.osm.edit.Relation;

public class TransportTags {
    public static final int POPULARITY_THRESHOLD = 3;
    private final Map<Long, List<TransportTagValue>> tags = new HashMap<Long, List<TransportTagValue>>();
    Map<String, TransportTagValue> allTags = new HashMap<String, TransportTagValue>();
    private static final Set<String> tagsFilter = new HashSet<String>();

    public void add(Long routeId, List<TransportTagValue> transportTags) {
        this.tags.put(routeId, transportTags);
    }

    public List<TransportTagValue> get(long idRoute) {
        List<TransportTagValue> res = this.tags.get(idRoute);
        if (res != null) {
            return res;
        }
        return Collections.emptyList();
    }

    public void registerTagValues(Relation rel, long routeId) {
        Map relTags = rel.getTags();
        this.registerTagValues(routeId, relTags);
    }

    public void registerTagValues(long routeId, Map<String, String> relTags) {
        ArrayList<TransportTagValue> filteredTags = new ArrayList<TransportTagValue>();
        block0: for (String tagKey : relTags.keySet()) {
            for (String neededTag : tagsFilter) {
                if (!tagKey.startsWith(neededTag)) continue;
                TransportTagValue tagValue = this.allTags.get(TransportTagValue.createKey(tagKey, relTags.get(tagKey)));
                if (tagValue != null) {
                    ++tagValue.count;
                } else {
                    tagValue = new TransportTagValue(tagKey, relTags.get(tagKey));
                    this.allTags.put(tagValue.getKey(), tagValue);
                }
                filteredTags.add(tagValue);
                continue block0;
            }
        }
        if (!filteredTags.isEmpty()) {
            this.tags.put(routeId, filteredTags);
        }
    }

    static {
        tagsFilter.add("interval");
        tagsFilter.add("opening_hours");
        tagsFilter.add("duration");
    }

    public static class TransportTagValue {
        int id;
        String tag;
        String value;
        String key;
        int count;

        public TransportTagValue(String tag, String value) {
            this.tag = tag;
            this.value = value;
            this.key = TransportTagValue.createKey(tag, value);
        }

        private static String createKey(String tag, String value) {
            return tag + "/" + value;
        }

        public boolean isPopular() {
            return this.count > 3;
        }

        public String getTag() {
            return this.tag;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
            result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            TransportTagValue other = (TransportTagValue)obj;
            if (this.tag == null ? other.tag != null : !this.tag.equals(other.tag)) {
                return false;
            }
            if (this.value == null) {
                return other.value == null;
            }
            return this.value.equals(other.value);
        }
    }
}

