/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.gpx;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.osmand.gpx.ElevationApproximator;
import net.osmand.gpx.GPXFile;
import net.osmand.gpx.GPXUtilities;
import net.osmand.util.MapUtils;

public abstract class ElevationDiffsCalculator {
    private static double ELE_THRESHOLD = 7.0;
    private double diffElevationUp = 0.0;
    private double diffElevationDown = 0.0;
    private List<Extremum> extremums = new ArrayList<Extremum>();

    public abstract double getPointDistance(int var1);

    public abstract double getPointElevation(int var1);

    public abstract int getPointsCount();

    public double getDiffElevationUp() {
        return this.diffElevationUp;
    }

    public double getDiffElevationDown() {
        return this.diffElevationDown;
    }

    public List<Extremum> getExtremums() {
        return Collections.unmodifiableList(this.extremums);
    }

    private static double getProjectionDist(double x, double y, double fromx, double fromy, double tox, double toy) {
        double pry;
        double prx;
        double mDist = (fromx - tox) * (fromx - tox) + (fromy - toy) * (fromy - toy);
        double projection = MapUtils.scalarMultiplication(fromx, fromy, tox, toy, x, y);
        if (projection < 0.0) {
            prx = fromx;
            pry = fromy;
        } else if (projection >= mDist) {
            prx = tox;
            pry = toy;
        } else {
            prx = fromx + (tox - fromx) * (projection / mDist);
            pry = fromy + (toy - fromy) * (projection / mDist);
        }
        return Math.sqrt((prx - x) * (prx - x) + (pry - y) * (pry - y));
    }

    private void findMaximumExtremumBetween(int start, int end, boolean[] points) {
        double firstPointDist = this.getPointDistance(start);
        double firstPointEle = this.getPointElevation(start);
        double endPointEle = this.getPointElevation(end);
        double endPointDist = this.getPointDistance(end);
        int max = start;
        double maxDiff = ELE_THRESHOLD;
        for (int i = start + 1; i < end; ++i) {
            double md = ElevationDiffsCalculator.getProjectionDist(this.getPointDistance(i), this.getPointElevation(i), firstPointDist, firstPointEle, endPointDist, endPointEle);
            if (!(md > maxDiff)) continue;
            max = i;
            maxDiff = md;
        }
        if (max != start) {
            points[max] = true;
            this.findMaximumExtremumBetween(start, max, points);
            this.findMaximumExtremumBetween(max, end, points);
        }
    }

    public void calculateElevationDiffs() {
        int i;
        int pointsCount = this.getPointsCount();
        if (pointsCount < 2) {
            return;
        }
        boolean[] points = new boolean[pointsCount];
        points[0] = true;
        points[pointsCount - 1] = true;
        this.findMaximumExtremumBetween(0, pointsCount - 1, points);
        this.extremums = new ArrayList<Extremum>();
        for (i = 0; i < points.length; ++i) {
            if (!points[i]) continue;
            this.extremums.add(new Extremum(this.getPointDistance(i), this.getPointElevation(i)));
        }
        for (i = 1; i < this.extremums.size(); ++i) {
            double elevation = this.extremums.get((int)i).ele;
            double prevElevation = this.extremums.get((int)(i - 1)).ele;
            double eleDiffSumm = elevation - prevElevation;
            if (eleDiffSumm > 0.0) {
                this.diffElevationUp += eleDiffSumm;
                continue;
            }
            this.diffElevationDown -= eleDiffSumm;
        }
    }

    public static void main(String[] args) {
        GPXFile gpxFile = GPXUtilities.loadGPXFile(new File("/Users/crimean/Downloads/2011-09-27_Mulhacen.gpx"));
        List<GPXUtilities.WptPt> points = gpxFile.tracks.get((int)0).segments.get((int)0).points;
        ElevationDiffsCalculator.calculateDiffs(points);
        int start = 200;
        for (int i = start + 150; i < start + 160; ++i) {
            ElevationDiffsCalculator.calculateDiffs(points.subList(start, i));
        }
    }

    private static void calculateDiffs(final List<GPXUtilities.WptPt> points) {
        ElevationApproximator approximator = new ElevationApproximator(){

            @Override
            public double getPointLatitude(int index) {
                return ((GPXUtilities.WptPt)points.get((int)index)).lat;
            }

            @Override
            public double getPointLongitude(int index) {
                return ((GPXUtilities.WptPt)points.get((int)index)).lon;
            }

            @Override
            public double getPointElevation(int index) {
                return ((GPXUtilities.WptPt)points.get((int)index)).ele;
            }

            @Override
            public int getPointsCount() {
                return points.size();
            }
        };
        approximator.approximate();
        final double[] distances = approximator.getDistances();
        final double[] elevations = approximator.getElevations();
        if (distances != null && elevations != null) {
            double diffElevationUp = 0.0;
            double diffElevationDown = 0.0;
            ElevationDiffsCalculator elevationDiffsCalc = new ElevationDiffsCalculator(){

                @Override
                public double getPointDistance(int index) {
                    return distances[index];
                }

                @Override
                public double getPointElevation(int index) {
                    return elevations[index];
                }

                @Override
                public int getPointsCount() {
                    return distances.length;
                }
            };
            elevationDiffsCalc.calculateElevationDiffs();
            System.out.println("GPX points=" + points.size() + " approx points=" + distances.length + " diffUp=" + (diffElevationUp += elevationDiffsCalc.getDiffElevationUp()) + " diffDown=" + (diffElevationDown += elevationDiffsCalc.getDiffElevationDown()));
        }
    }

    public static class Extremum {
        private final double dist;
        private final double ele;

        public Extremum(double dist, double ele) {
            this.dist = dist;
            this.ele = ele;
        }

        public double getDist() {
            return this.dist;
        }

        public double getEle() {
            return this.ele;
        }
    }
}

