/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pinyin4j;

import com.hp.hpl.sparta.Document;
import com.hp.hpl.sparta.Element;
import com.hp.hpl.sparta.ParseException;
import net.sourceforge.pinyin4j.PinyinRomanizationResource;
import net.sourceforge.pinyin4j.PinyinRomanizationType;
import net.sourceforge.pinyin4j.TextHelper;

class PinyinRomanizationTranslator {
    PinyinRomanizationTranslator() {
    }

    static String convertRomanizationSystem(String sourcePinyinStr, PinyinRomanizationType sourcePinyinSystem, PinyinRomanizationType targetPinyinSystem) {
        String pinyinString = TextHelper.extractPinyinString(sourcePinyinStr);
        String toneNumberStr = TextHelper.extractToneNumber(sourcePinyinStr);
        String targetPinyinStr = null;
        try {
            String xpathQuery1 = "//" + sourcePinyinSystem.getTagName() + "[text()='" + pinyinString + "']";
            Document pinyinMappingDoc = PinyinRomanizationResource.getInstance().getPinyinMappingDoc();
            Element hanyuNode = pinyinMappingDoc.xpathSelectElement(xpathQuery1);
            if (null != hanyuNode) {
                String xpathQuery2 = "../" + targetPinyinSystem.getTagName() + "/text()";
                String targetPinyinStrWithoutToneNumber = hanyuNode.xpathSelectString(xpathQuery2);
                targetPinyinStr = targetPinyinStrWithoutToneNumber + toneNumberStr;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return targetPinyinStr;
    }
}

