/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.osmand.CallbackWithObject;
import net.osmand.util.Algorithms;

public class CollectionUtils {
    @SafeVarargs
    public static <T> List<T> asOneList(Collection<T> ... collections) {
        ArrayList<T> result = new ArrayList<T>();
        for (Collection<T> collection : collections) {
            result.addAll(collection);
        }
        return result;
    }

    public static <T> List<T> addToList(Collection<T> original, T element) {
        ArrayList<T> copy = new ArrayList<T>(original);
        copy.add(element);
        return copy;
    }

    public static <T> List<T> addAllToList(Collection<T> original, Collection<T> elements) {
        ArrayList<T> copy = new ArrayList<T>(original);
        copy.addAll(elements);
        return copy;
    }

    public static <T> List<T> setInList(Collection<T> original, int position, T element) {
        ArrayList<T> copy = new ArrayList<T>(original);
        copy.set(position, element);
        return copy;
    }

    public static <T> List<T> removeFromList(Collection<T> original, T element) {
        ArrayList<T> copy = new ArrayList<T>(original);
        copy.remove(element);
        return copy;
    }

    public static <T> List<T> removeAllFromList(Collection<T> original, Collection<T> elements) {
        ArrayList<T> copy = new ArrayList<T>(original);
        copy.removeAll(elements);
        return copy;
    }

    public static <T> void addAllIfNotContains(Collection<T> collection, Collection<T> elements) {
        for (T element : elements) {
            CollectionUtils.addIfNotContains(collection, element);
        }
    }

    public static <T> void addIfNotContains(T element, Collection<T> ... collections) {
        for (Collection<T> collection : collections) {
            CollectionUtils.addIfNotContains(collection, element);
        }
    }

    public static <T> void addIfNotContains(Collection<T> collection, T element) {
        if (!collection.contains(element)) {
            collection.add(element);
        }
    }

    public static <T> T searchElementWithCondition(Collection<T> collection, CallbackWithObject<T> condition) {
        for (T element : collection) {
            if (!condition.processResult(element)) continue;
            return element;
        }
        return null;
    }

    public static <T> List<T> filterElementsWithCondition(Collection<T> collection, CallbackWithObject<T> condition) {
        ArrayList<T> result = new ArrayList<T>();
        for (T element : collection) {
            if (!condition.processResult(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static <T> boolean containsAny(Collection<T> collection, T ... objects) {
        for (T object : objects) {
            if (!collection.contains(object)) continue;
            return true;
        }
        return false;
    }

    public static boolean startsWithAny(String s, String ... args) {
        if (!Algorithms.isEmpty(s) && args != null) {
            for (String arg : args) {
                if (!s.startsWith(arg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsAny(String s, String ... args) {
        if (!Algorithms.isEmpty(s) && args != null) {
            for (String arg : args) {
                if (!s.contains(arg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean endsWithAny(String s, String ... args) {
        if (!Algorithms.isEmpty(s) && args != null) {
            for (String arg : args) {
                if (!s.endsWith(arg)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean equalsToAny(Object o, Object ... args) {
        if (args != null) {
            for (Object o1 : args) {
                if (!Objects.equals(o, o1)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean anyIsNull(Object ... args) {
        if (args != null) {
            for (Object o : args) {
                if (o != null) continue;
                return true;
            }
        }
        return false;
    }

    public static <T> void reverseArray(T[] array) {
        for (int i = 0; i < array.length / 2; ++i) {
            T temp = array[i];
            array[i] = array[array.length - i - 1];
            array[array.length - i - 1] = temp;
        }
    }

    public static boolean containsInArrayL(long[] array, long value) {
        return Arrays.binarySearch(array, value) >= 0;
    }

    public static long[] addToArrayL(long[] array, long value, boolean skipIfExists) {
        long[] result;
        if (array == null) {
            result = new long[]{value};
        } else if (skipIfExists && Arrays.binarySearch(array, value) >= 0) {
            result = array;
        } else {
            result = new long[array.length + 1];
            System.arraycopy(array, 0, result, 0, array.length);
            result[result.length - 1] = value;
            Arrays.sort(result);
        }
        return result;
    }

    public static long[] removeFromArrayL(long[] array, long value) {
        if (array != null) {
            int index = Arrays.binarySearch(array, value);
            if (index >= 0) {
                long[] result = new long[array.length - 1];
                System.arraycopy(array, 0, result, 0, index);
                if (index < result.length) {
                    System.arraycopy(array, index + 1, result, index, array.length - (index + 1));
                }
                return result;
            }
            return array;
        }
        return array;
    }

    public static String arrayToString(int[] a) {
        if (a == null || a.length == 0) {
            return null;
        }
        StringBuilder b = new StringBuilder();
        for (int value : a) {
            if (b.length() > 0) {
                b.append(",");
            }
            b.append(value);
        }
        return b.toString();
    }

    public static int[] stringToArray(String array) throws NumberFormatException {
        if (array == null || array.length() == 0) {
            return null;
        }
        String[] items = array.split(",");
        int[] res = new int[items.length];
        for (int i = 0; i < items.length; ++i) {
            res[i] = Integer.parseInt(items[i]);
        }
        return res;
    }
}

