/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.obf.preparation;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.FactoryConfigurationError;
import net.osmand.IProgress;
import net.osmand.MainUtilities;
import net.osmand.PlatformUtil;
import net.osmand.binary.MapZooms;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.obf.BinaryInspector;
import net.osmand.obf.preparation.IndexCreatorSettings;
import net.osmand.osm.edit.Entity;
import net.osmand.osm.edit.Node;
import net.osmand.osm.edit.OsmMapUtils;
import net.osmand.osm.edit.Way;
import net.osmand.osm.io.OsmBaseStorage;
import net.osmand.osm.io.OsmStorageWriter;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;
import rtree.RTree;

public class LightSectorProcessor {
    private static final Log log = PlatformUtil.getLog(LightSectorProcessor.class);
    private static final AtomicLong entityIdCounter = new AtomicLong(-1000L);
    private static final double SCALE_RANGE_DIFF_PYTHON = 0.62;
    private static final List<String> LEADING_LIGHT_CATEGORIES = Arrays.asList("leading", "front", "rear", "lower", "upper");
    private static final Set<String> NAV_LIGHT_CATEGORIES = new HashSet<String>(Arrays.asList("directional", "leading", "front", "rear", "lower", "upper", "moire", "bearing"));
    private static final String LIGHTSECTOR_TAG = "lightsector";
    private static final String LIGHTSECTOR_LOW_TAG = "lightsector:low";
    private static final String LIGHTSECTOR_SOURCE_VALUE = "source";
    private static final String LIGHTSECTOR_ORIENTATION_VALUE = "orientation";
    private static final String LIGHTSECTOR_LIMIT_VALUE = "limit";
    private static final String LIGHTSECTOR_ARC_VALUE = "arc";
    private static final String NAME_TAG = "name";
    private static final Set<String> LOW_LIGHT_CATEGORIES = new HashSet<String>(Arrays.asList("fog", "low", "faint", "obscured", "part_obscured", "occasional", "not_in_use", "temporary", "extinguished", "existence_doubtful"));
    private static final Map<String, String> ABBREVIATIONS = new HashMap<String, String>();
    private static final double NAUTICAL_MILE_IN_M = 1852.0;

    public static void main(String[] args) throws FactoryConfigurationError, Exception {
        if (args.length < 2) {
            log.error((Object)"Usage: LightSectorProcessor <input.osm/input.osm.gz> <output_directory>");
            return;
        }
        File inputFile = new File(args[0]);
        if (!inputFile.exists()) {
            log.error((Object)("Input file not found: " + inputFile.getAbsolutePath()));
            return;
        }
        File outputDir = new File(".");
        if (args.length > 0) {
            outputDir = new File(args[1]);
        }
        outputDir.mkdirs();
        log.info((Object)"Starting light sectors generation...");
        String basename = inputFile.getName().substring(0, inputFile.getName().indexOf(46));
        File out = new File(outputDir, basename + ".obf");
        new LightSectorProcessor().generateLightSectorIndex(inputFile, out, LightSectorProcessor.defaultLightSectorsConfig(), args);
        log.info((Object)("Successfully generated " + out.getAbsolutePath()));
    }

    private static List<LightSectorConfigLayer> defaultLightSectorsConfig() {
        ArrayList<LightSectorConfigLayer> configs = new ArrayList<LightSectorConfigLayer>();
        configs.add(new LightSectorConfigLayer(0, 0.3, 1.6, 16, new MapZooms.MapZoomPair(9, 11)));
        configs.add(new LightSectorConfigLayer(1, 0.2, 0.8, 8, new MapZooms.MapZoomPair(12, 13)));
        configs.add(new LightSectorConfigLayer(2, 0.15, 0.4, 4, new MapZooms.MapZoomPair(14, 15)));
        configs.add(new LightSectorConfigLayer(3, 0.1, 0.2, 2, new MapZooms.MapZoomPair(16, MapZooms.MapZoomPair.MAX_ALLOWED_ZOOM)));
        return configs;
    }

    public void generateLightSectorIndex(File inputFile, File outputFile, List<LightSectorConfigLayer> configs, String ... argsGen) throws Exception {
        long start = System.currentTimeMillis();
        InputStream is = inputFile.getName().endsWith(".gz") ? new GZIPInputStream(new FileInputStream(inputFile)) : new FileInputStream(inputFile);
        BufferedInputStream stream = new BufferedInputStream(is, 32768);
        OsmBaseStorage storage = new OsmBaseStorage();
        storage.parseOSM((InputStream)stream, IProgress.EMPTY_PROGRESS);
        long t1 = System.currentTimeMillis() - start;
        log.info((Object)("Parse " + inputFile.getName() + ": " + (float)((double)t1 / 1000.0) + " sec."));
        ((InputStream)stream).close();
        ArrayList<File> fls = new ArrayList<File>();
        int ind = 0;
        for (LightSectorConfigLayer config : configs) {
            File osmFile = new File(outputFile.getParentFile(), outputFile.getName().replace(".obf", "_" + ind + ".osm"));
            fls.add(new File(outputFile.getParentFile(), outputFile.getName().replace(".obf", "_" + ind + ".obf")));
            HashMap<Entity.EntityId, Entity> entities = new HashMap<Entity.EntityId, Entity>();
            log.info((Object)String.format("--- Processing for Level %d (min_range: %d, f_range: %.2f, f_arc: %.2f) ---", config.level, config.min_range, config.f_range, config.f_arc));
            int count = 0;
            for (Entity entity : storage.getRegisteredEntities().values()) {
                List<Entity> genEntities = this.processEntity(entity, config);
                if (genEntities.size() <= 0) continue;
                count += genEntities.size();
                for (Entity e : genEntities) {
                    entities.put(Entity.EntityId.valueOf((Entity)e), e);
                }
            }
            log.info((Object)String.format("-------- %d generated entities ----------", count));
            OsmStorageWriter osmStorageWriter = new OsmStorageWriter();
            FileOutputStream fout = new FileOutputStream(osmFile);
            osmStorageWriter.saveStorage(fout, entities, null, null, false);
            fout.close();
            IndexCreatorSettings settings = new IndexCreatorSettings();
            settings.indexMap = true;
            ArrayList<String> subArgs = new ArrayList<String>(Arrays.asList(argsGen));
            MainUtilities.parseIndexCreatorArgs(subArgs, settings);
            subArgs.add(0, osmFile.getAbsolutePath());
            MapZooms ms = new MapZooms();
            ms.setLevels(config.mapZooms);
            MainUtilities.generateObf(subArgs, ms, settings);
            RTree.clearCache();
            ++ind;
        }
        BinaryInspector.FileExtractFrom fileExtractFrom = new BinaryInspector.FileExtractFrom();
        fileExtractFrom.from = fls;
        BinaryInspector.combineParts(outputFile, Collections.singletonList(fileExtractFrom), null);
    }

    private List<Entity> processEntity(Entity entity, LightSectorConfigLayer config) {
        if (!(entity instanceof Node) && !(entity instanceof Way)) {
            return Collections.emptyList();
        }
        List<Map<String, String>> sectors = LightSectorProcessor.getSectors(entity);
        if (sectors.isEmpty()) {
            return Collections.emptyList();
        }
        String seamarkType = entity.getTag("seamark:type");
        boolean isMajorLight = config.major_lights.contains(seamarkType);
        boolean rangeSufficient = false;
        for (Map<String, String> sector : sectors) {
            String rng = sector.getOrDefault(LIGHT_PROPERTY.RANGE.tag, String.valueOf(config.default_range));
            try {
                double range = LightSectorProcessor.parseRange(rng);
                if (!(range >= (double)config.min_range)) continue;
                rangeSufficient = true;
                break;
            }
            catch (NumberFormatException e) {
                System.err.printf("Error parsing range %s\n", rng);
            }
        }
        if (isMajorLight || rangeSufficient) {
            return this.generateSectorsForLight(entity, sectors, config);
        }
        return Collections.emptyList();
    }

    private static float parseRange(String rng) {
        rng = rng.toLowerCase();
        boolean miles = false;
        if (rng.contains("nm")) {
            rng = rng.replace("nmi", "").replace("nm", "");
            miles = true;
        }
        rng = rng.replace("m", "");
        float range = (float)Double.parseDouble(rng);
        if (miles) {
            range = (float)((double)range * 1852.0);
        }
        return range;
    }

    private Map<String, List<Map<String, String>>> groupSectorByCombinedKey(List<Map<String, String>> sectors) {
        LinkedHashMap<String, List<Map<String, String>>> grouped = new LinkedHashMap<String, List<Map<String, String>>>();
        for (Map<String, String> sector : sectors) {
            String key = sector.getOrDefault("character", "?") + "-" + sector.getOrDefault("group", "?") + "-" + sector.getOrDefault("period", "?");
            ArrayList<Map<String, String>> groupList = (ArrayList<Map<String, String>>)grouped.get(key);
            if (groupList == null) {
                groupList = new ArrayList<Map<String, String>>();
                grouped.put(key, groupList);
            }
            groupList.add(sector);
        }
        return grouped;
    }

    private static String nformat(double v) {
        return String.format(Locale.US, "%.1f", v).replace(".0", "");
    }

    private Map<String, Object> mergeSectors(List<Map<String, String>> sectors) {
        HashMap<String, Object> merged = new HashMap<String, Object>();
        for (Map<String, String> s : sectors) {
            for (Map.Entry<String, String> entry : s.entrySet()) {
                String k = entry.getKey();
                String v = entry.getValue();
                if (v == null) continue;
                if (LIGHT_PROPERTY.RANGE.tag.equals(k) || LIGHT_PROPERTY.HEIGHT.tag.equals(k)) {
                    List values = (List)merged.computeIfAbsent(k, key -> new ArrayList());
                    try {
                        double vl = LIGHT_PROPERTY.RANGE.tag.equals(k) ? (double)LightSectorProcessor.parseRange(v) : (double)RouteDataObject.parseLength((String)v, (float)0.0f);
                        values.add(vl);
                    }
                    catch (NumberFormatException e) {
                        System.err.printf("Error parsing %s %s \n", k, v);
                    }
                    continue;
                }
                if (merged.containsKey(k)) {
                    String existing = (String)merged.get(k);
                    if (existing.equals(v)) continue;
                    LinkedHashSet<String> values = new LinkedHashSet<String>(Arrays.asList(existing.split(";")));
                    values.addAll(Arrays.asList(v.split(";")));
                    merged.put(k, String.join((CharSequence)";", values));
                    continue;
                }
                merged.put(k, v);
            }
        }
        return merged;
    }

    public static String getColors(List<Map<String, String>> sectors) {
        TreeSet colors = new TreeSet(Collections.reverseOrder());
        for (Map<String, String> sector : sectors) {
            String colorStr = sector.get(LIGHT_PROPERTY.COLOUR.tag);
            if (colorStr == null) continue;
            colors.addAll(Arrays.asList(colorStr.split(";")));
        }
        return String.join((CharSequence)";", colors);
    }

    public static String generateLabel(Map<String, ?> sector, boolean heightRange) {
        String period;
        String colour;
        StringBuilder l = new StringBuilder();
        String sep = "\u00a0";
        String character = (String)sector.get(LIGHT_PROPERTY.CHARACTER.tag);
        if (character != null && !"?".equals(character)) {
            l.append(character);
        }
        String group = (String)sector.get(LIGHT_PROPERTY.GROUP.tag);
        if (l.length() > 0 && group != null && !"?".equals(group)) {
            l.append("(").append(group).append(")");
        }
        if ((colour = (String)sector.get(LIGHT_PROPERTY.COLOUR.tag)) != null && !"?".equals(colour)) {
            if (l.length() > 0 && !l.toString().endsWith(")")) {
                l.append(sep);
            }
            String[] colors = colour.split(";");
            Arrays.sort(colors, Collections.reverseOrder());
            for (String c : colors) {
                l.append(c.substring(0, 1).toUpperCase());
            }
        }
        if ((period = (String)sector.get(LIGHT_PROPERTY.PERIOD.tag)) != null && !"?".equals(period)) {
            l.append(sep).append(period).append("s");
        }
        if (heightRange) {
            List ranges;
            Object rangeObj;
            List heights;
            Object heightObj = sector.get(LIGHT_PROPERTY.HEIGHT.tag);
            if (heightObj instanceof List && !(heights = (List)heightObj).isEmpty()) {
                double minH = (Double)Collections.min(heights);
                double maxH = (Double)Collections.max(heights);
                l.append(sep);
                if (minH != maxH) {
                    l.append(LightSectorProcessor.nformat(minH)).append("-").append(LightSectorProcessor.nformat(maxH)).append("m");
                } else {
                    l.append(LightSectorProcessor.nformat(minH)).append("m");
                }
            }
            if ((rangeObj = sector.get(LIGHT_PROPERTY.RANGE.tag)) instanceof List && !(ranges = (List)rangeObj).isEmpty()) {
                double minR = (Double)Collections.min(ranges);
                double maxR = (Double)Collections.max(ranges);
                l.append(sep);
                if (minR != maxR) {
                    l.append(LightSectorProcessor.nformat(minR)).append("-").append(LightSectorProcessor.nformat(maxR)).append("M");
                } else {
                    l.append(LightSectorProcessor.nformat(minR)).append("M");
                }
            }
        }
        ArrayList<String> misc = new ArrayList<String>();
        for (String p : new String[]{LIGHT_PROPERTY.STATUS.tag, LIGHT_PROPERTY.VISIBILITY.tag, LIGHT_PROPERTY.EXHIBITION.tag}) {
            String s = (String)sector.get(p);
            if (s == null) continue;
            for (String part : s.split(";")) {
                if (!ABBREVIATIONS.containsKey(part)) continue;
                misc.add(ABBREVIATIONS.get(part));
            }
        }
        if (!misc.isEmpty()) {
            l.append(sep).append("(").append(String.join((CharSequence)",", misc)).append(")");
        }
        return l.toString().replace(";", "/");
    }

    private List<Entity> generateSectorsForLight(Entity lightSource, List<Map<String, String>> sectors, LightSectorConfigLayer config) {
        ArrayList<Entity> newEntities = new ArrayList<Entity>();
        LatLon centerPoint = LightSectorProcessor.getCenterLatLon(lightSource);
        if (centerPoint == null) {
            return newEntities;
        }
        String name = lightSource.getTag("seamark:name") != null ? lightSource.getTag("seamark:name") : lightSource.getTag(NAME_TAG);
        String lnam = lightSource.getTag("seamark:lnam");
        Map<String, List<Map<String, String>>> groupedSectors = this.groupSectorByCombinedKey(sectors);
        ArrayList<String> labels = new ArrayList<String>();
        for (List<Map<String, String>> sectorGroup : groupedSectors.values()) {
            labels.add(LightSectorProcessor.generateLabel(this.mergeSectors(sectorGroup), true));
        }
        String mergedLabel = String.join((CharSequence)" ", labels);
        Node centerNode = new Node(centerPoint.getLatitude(), centerPoint.getLongitude(), LightSectorProcessor.nextId());
        centerNode.putTag(LIGHTSECTOR_TAG, LIGHTSECTOR_SOURCE_VALUE);
        centerNode.putTag("seamark:type", config.major_lights.contains(lightSource.getTag("seamark:type")) ? "light_major" : "light_minor");
        if (name != null) {
            centerNode.putTag("seamark:name", name);
        }
        if (lnam != null) {
            centerNode.putTag("seamark:lnam", lnam);
        }
        centerNode.putTag("seamark:light:character", mergedLabel);
        centerNode.putTag("seamark:light:colour", LightSectorProcessor.getColors(sectors));
        newEntities.add((Entity)centerNode);
        if (config.add_sector_data_to_source) {
            for (int i = 0; i < sectors.size(); ++i) {
                String prefix = "seamark:light:" + (String)(sectors.size() == 1 ? "" : i + 1 + ":");
                for (Map.Entry<String, String> tag : sectors.get(i).entrySet()) {
                    centerNode.putTag(prefix + tag.getKey(), tag.getValue());
                }
            }
        }
        HashMap<Double, Object> lines = new HashMap<Double, Object>();
        for (Map<String, String> s : sectors) {
            double end;
            boolean isFullCircle;
            String sAsString = s.toString();
            boolean isLow = false;
            for (String category : LOW_LIGHT_CATEGORIES) {
                if ("low".equals(category) || !sAsString.contains(category)) continue;
                isLow = true;
                break;
            }
            double nominalRange = config.default_range;
            try {
                if (s.containsKey(LIGHT_PROPERTY.RANGE.tag)) {
                    nominalRange = Double.parseDouble(s.get(LIGHT_PROPERTY.RANGE.tag));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            nominalRange = Math.max(nominalRange, (double)config.min_range);
            double renderedRange = Math.min(nominalRange * config.f_range, config.max_range);
            Double orientation = s.containsKey(LIGHT_PROPERTY.ORIENTATION.tag) ? Double.valueOf(Double.parseDouble(s.get(LIGHT_PROPERTY.ORIENTATION.tag))) : null;
            Double sectorStart = s.containsKey(LIGHT_PROPERTY.SECTOR_START.tag) ? Double.valueOf(Double.parseDouble(s.get(LIGHT_PROPERTY.SECTOR_START.tag))) : null;
            Double sectorEnd = s.containsKey(LIGHT_PROPERTY.SECTOR_END.tag) ? Double.valueOf(Double.parseDouble(s.get(LIGHT_PROPERTY.SECTOR_END.tag))) : null;
            boolean isSector = sectorStart != null && sectorEnd != null;
            boolean bl = isFullCircle = isSector && sectorStart % 360.0 == sectorEnd % 360.0;
            if (sectors.size() == 1 && !config.process_leading_lights) {
                String category = s.getOrDefault(LIGHT_PROPERTY.CATEGORY.tag, "");
                boolean isLeading = false;
                for (String leadingCat : LEADING_LIGHT_CATEGORIES) {
                    if (!category.contains(leadingCat)) continue;
                    isLeading = true;
                    break;
                }
                if (isLeading) continue;
            }
            if (renderedRange > 0.0 && orientation != null) {
                HashMap<String, String> attrs = new HashMap<String, String>();
                attrs.put(LIGHTSECTOR_TAG, LIGHTSECTOR_ORIENTATION_VALUE);
                attrs.put(LIGHT_PROPERTY.ORIENTATION.tag, (String)((Object)orientation));
                attrs.put(LIGHT_PROPERTY.RANGE.tag, (String)((Object)Double.valueOf(renderedRange)));
                attrs.put(LIGHT_PROPERTY.COLOUR.tag, s.get(LIGHT_PROPERTY.COLOUR.tag));
                HashMap<String, String> simpleSectorObjectMap = new HashMap<String, String>(s);
                String nameTag = LightSectorProcessor.nformat(orientation) + "\u00b0 " + LightSectorProcessor.generateLabel(simpleSectorObjectMap, false);
                attrs.put(NAME_TAG, nameTag);
                lines.put(orientation, attrs);
            }
            if (renderedRange > 0.0 && isSector && !isFullCircle) {
                for (Object bearing : (HashMap<String, String>)new double[]{sectorStart, sectorEnd}) {
                    double existingRange;
                    Map existingLine = lines.getOrDefault((double)bearing, new HashMap());
                    double d = existingRange = existingLine.get(LIGHT_PROPERTY.RANGE.tag) instanceof Number ? ((Number)existingLine.get(LIGHT_PROPERTY.RANGE.tag)).doubleValue() : 0.0;
                    if (!(existingRange < renderedRange) || LIGHTSECTOR_ORIENTATION_VALUE.equals(existingLine.get(LIGHTSECTOR_TAG))) continue;
                    HashMap<String, Object> attrs = new HashMap<String, Object>();
                    attrs.put(LIGHTSECTOR_TAG, LIGHTSECTOR_LIMIT_VALUE);
                    attrs.put(LIGHT_PROPERTY.ORIENTATION.tag, (double)bearing);
                    attrs.put(LIGHT_PROPERTY.RANGE.tag, renderedRange);
                    attrs.put(NAME_TAG, LightSectorProcessor.nformat((double)bearing) + "\u00b0");
                    lines.put((double)bearing, attrs);
                }
            }
            for (Map.Entry entry : lines.entrySet()) {
                Map attrs = (Map)entry.getValue();
                double bearing = (Double)attrs.get(LIGHT_PROPERTY.ORIENTATION.tag);
                double range = (Double)attrs.get(LIGHT_PROPERTY.RANGE.tag);
                LatLon endPoint = MapUtils.rhumbDestinationPoint((LatLon)centerPoint, (double)(range * 1852.0), (double)(bearing + 180.0));
                Node endNode = new Node(endPoint.getLatitude(), endPoint.getLongitude(), LightSectorProcessor.nextId());
                Way lineWay = new Way(LightSectorProcessor.nextId());
                lineWay.addNode(centerNode);
                lineWay.addNode(endNode);
                for (Map.Entry tag : attrs.entrySet()) {
                    if (tag.getValue() == null) continue;
                    lineWay.putTag((String)tag.getKey(), String.valueOf(tag.getValue()));
                }
                newEntities.add((Entity)endNode);
                newEntities.add((Entity)lineWay);
            }
            if (!(renderedRange > 0.0) || !isSector || isFullCircle && !(nominalRange >= config.full_range_threshold)) continue;
            double start = sectorStart;
            if (start >= (end = sectorEnd.doubleValue())) {
                end += 360.0;
            }
            double arcRadius = renderedRange * config.f_arc;
            int pointsCount = Math.max(3, (int)Math.ceil(Math.abs(end - start) / 5.0));
            Way arcWay = new Way(LightSectorProcessor.nextId());
            for (int i = 0; i <= pointsCount; ++i) {
                double bearing = start + (double)i * (end - start) / (double)pointsCount;
                LatLon arcPoint = MapUtils.rhumbDestinationPoint((LatLon)centerPoint, (double)(arcRadius * 1852.0), (double)(bearing + 180.0));
                Node arcNode = new Node(arcPoint.getLatitude(), arcPoint.getLongitude(), LightSectorProcessor.nextId());
                arcWay.addNode(arcNode);
                newEntities.add((Entity)arcNode);
            }
            arcWay.putTag(LIGHTSECTOR_TAG, LIGHTSECTOR_ARC_VALUE);
            if (s.get(LIGHT_PROPERTY.COLOUR.tag) != null) {
                arcWay.putTag(LIGHT_PROPERTY.COLOUR.tag, s.get(LIGHT_PROPERTY.COLOUR.tag));
            }
            arcWay.putTag(NAME_TAG, LightSectorProcessor.generateLabel(s, false));
            if (isLow) {
                arcWay.putTag(LIGHTSECTOR_LOW_TAG, "yes");
            }
            newEntities.add((Entity)arcWay);
        }
        return newEntities;
    }

    private static List<Map<String, String>> getSectors(Entity entity) {
        ArrayList<Map<String, String>> sectors = new ArrayList<Map<String, String>>();
        Map allTags = entity.getTags();
        for (int i = 0; i < 50; ++i) {
            HashMap<String, String> currentSector = new HashMap<String, String>();
            String prefix = "seamark:light:" + (String)(i == 0 ? "" : i + ":");
            boolean hasSSO = false;
            for (LIGHT_PROPERTY l : LIGHT_PROPERTY.values()) {
                String vl = l.parseValue((String)allTags.get(prefix + l.tag));
                if (vl == null) continue;
                if (l.isSSO()) {
                    hasSSO = true;
                }
                currentSector.put(l.tag, vl);
            }
            if (currentSector.isEmpty() && i > 0) break;
            if (currentSector.isEmpty()) continue;
            String category = (String)currentSector.get("category");
            if (category != null) {
                HashSet<String> cats = new HashSet<String>(Arrays.asList(category.split(";")));
                cats.retainAll(NAV_LIGHT_CATEGORIES);
                if (cats.isEmpty()) continue;
            }
            if (!hasSSO) {
                currentSector.put(LIGHT_PROPERTY.SECTOR_START.tag, "0");
                currentSector.put(LIGHT_PROPERTY.SECTOR_END.tag, "360");
            }
            sectors.add(currentSector);
        }
        return sectors;
    }

    private static LatLon getCenterLatLon(Entity entity) {
        return OsmMapUtils.getCenter((Entity)entity);
    }

    private static long nextId() {
        return entityIdCounter.getAndDecrement();
    }

    static {
        ABBREVIATIONS.put("permanent", "perm");
        ABBREVIATIONS.put("occasional", "occas");
        ABBREVIATIONS.put("recommended", "rcmnd");
        ABBREVIATIONS.put("not_in_use", "unused");
        ABBREVIATIONS.put("intermittent", "interm");
        ABBREVIATIONS.put("reserved", "resvd");
        ABBREVIATIONS.put("temporary", "temp");
        ABBREVIATIONS.put("private", "priv");
        ABBREVIATIONS.put("mandatory", "mand");
        ABBREVIATIONS.put("extinguished", "exting");
        ABBREVIATIONS.put("illuminated", "illum");
        ABBREVIATIONS.put("historic", "hist");
        ABBREVIATIONS.put("public", "pub");
        ABBREVIATIONS.put("synchronized", "sync");
        ABBREVIATIONS.put("watched", "watchd");
        ABBREVIATIONS.put("unwatched", "unwtchd");
        ABBREVIATIONS.put("existence_doubtful", "ED");
        ABBREVIATIONS.put("high", "high");
        ABBREVIATIONS.put("low", "low");
        ABBREVIATIONS.put("faint", "faint");
        ABBREVIATIONS.put("intensified", "intens");
        ABBREVIATIONS.put("unintensified", "uintens");
        ABBREVIATIONS.put("restricted", "restr");
        ABBREVIATIONS.put("obscured", "obscd");
        ABBREVIATIONS.put("part_obscured", "p.obscd");
        ABBREVIATIONS.put("fog", "fog");
    }

    private static class LightSectorConfigLayer {
        final int level;
        final List<MapZooms.MapZoomPair> mapZooms;
        final double f_arc;
        final double f_range;
        final int min_range;
        final List<String> major_lights;
        final double max_range;
        final double full_range_threshold;
        final double default_range;
        final boolean process_leading_lights;
        final boolean add_sector_data_to_source;

        LightSectorConfigLayer(int level, double f_arc, double f_range, int min_range, MapZooms.MapZoomPair ... pairs) {
            this.level = level;
            this.mapZooms = Arrays.asList(pairs);
            this.f_arc = f_arc;
            this.f_range = f_range * 0.62;
            this.min_range = min_range;
            this.major_lights = Arrays.asList("light_major");
            this.max_range = 7.4399999999999995;
            this.full_range_threshold = 19.0;
            this.default_range = 0.0;
            this.process_leading_lights = false;
            this.add_sector_data_to_source = false;
        }
    }

    public static enum LIGHT_PROPERTY {
        SECTOR_START("sector_start", true),
        SECTOR_END("sector_end", true),
        ORIENTATION("orientation", true),
        HEIGHT("height", true),
        RANGE("range", true),
        COLOUR("colour", false),
        CHARACTER("character", false),
        CATEGORY("category", false),
        STATUS("status", false),
        VISIBILITY("visibility", false),
        EXHIBITION("exhibition", false),
        GROUP("group", false),
        PERIOD("period", false),
        SEQUENCE("sequence", false);

        public boolean num;
        public String tag;

        public boolean isSSO() {
            return SECTOR_START == this || SECTOR_END == this || ORIENTATION == this;
        }

        public String parseValue(String vl) {
            if (!Algorithms.isEmpty((CharSequence)vl)) {
                if (this.num) {
                    float v = -1.0f;
                    try {
                        v = this == HEIGHT ? RouteDataObject.parseLength((String)vl, (float)v) : (this == RANGE ? LightSectorProcessor.parseRange(vl) : Float.parseFloat(vl.split(" ")[0]));
                    }
                    catch (NumberFormatException e) {
                        System.err.printf("Error parsing %s - %s\n", this.tag, vl);
                    }
                    if (v < 0.0f) {
                        return null;
                    }
                }
                return vl;
            }
            return null;
        }

        private LIGHT_PROPERTY(String tag, boolean num) {
            this.tag = tag;
            this.num = num;
        }
    }
}

