/*
 * Decompiled with CFR 0.152.
 */
package com.atilika.kuromoji.trie;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PatriciaTrie<V>
implements Map<String, V> {
    protected PatriciaNode<V> root;
    protected int entries = 0;
    private final KeyMapper<String> keyMapper = new StringKeyMapper();

    public PatriciaTrie() {
        this.clear();
    }

    @Override
    public V get(Object key) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Only String keys are supported -- got " + key.getClass());
        }
        if (key.equals("")) {
            if (this.root.getRight() == null) {
                return null;
            }
            return this.root.getRight().getValue();
        }
        PatriciaNode<V> nearest = this.findNearestNode((String)key);
        if (key.equals(nearest.getKey())) {
            return nearest.getValue();
        }
        return null;
    }

    @Override
    public V put(String key, V value) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        if (key.equals("")) {
            PatriciaNode<V> node = new PatriciaNode<V>(key, value, -1);
            node.setValue(value);
            this.root.setRight(node);
            ++this.entries;
            return value;
        }
        PatriciaNode<V> nearest = this.findNearestNode(key);
        if (key.equals(nearest.getKey())) {
            nearest.setValue(value);
            return value;
        }
        int bit = this.findFirstDifferingBit(key, nearest.getKey());
        PatriciaNode<V> node = new PatriciaNode<V>(key, value, bit);
        this.insertNode(node);
        ++this.entries;
        return value;
    }

    @Override
    public void putAll(Map<? extends String, ? extends V> map) {
        for (Map.Entry<String, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("Remove is currently unsupported");
    }

    @Override
    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException("Key can not be null");
        }
        if (!(key instanceof String)) {
            throw new ClassCastException("Only String keys are supported -- got " + key.getClass());
        }
        return this.get(key) != null;
    }

    @Override
    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        this.keysR(this.root.getLeft(), -1, keys);
        return keys;
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        this.valuesR(this.root.getLeft(), -1, values);
        return values;
    }

    public boolean containsKeyPrefix(String prefix) {
        if (prefix == null) {
            throw new NullPointerException("Prefix key can not be null");
        }
        if (prefix.equals("")) {
            return true;
        }
        PatriciaNode<V> nearest = this.findNearestNode(prefix);
        if (nearest == null) {
            return false;
        }
        if (nearest.getKey() == null) {
            return false;
        }
        return nearest.getKey().startsWith(prefix);
    }

    @Override
    public int size() {
        return this.entries;
    }

    @Override
    public boolean isEmpty() {
        return this.entries == 0;
    }

    @Override
    public void clear() {
        this.root = new PatriciaNode<Object>(null, null, -1);
        this.root.setLeft(this.root);
        this.entries = 0;
    }

    @Override
    public boolean containsValue(Object value) {
        for (V v : this.values()) {
            if (!v.equals(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<Map.Entry<String, V>> entrySet() {
        HashMap entries = new HashMap();
        this.entriesR(this.root.getLeft(), -1, entries);
        return entries.entrySet();
    }

    private PatriciaNode<V> findNearestNode(String key) {
        PatriciaNode<V> current = this.root.getLeft();
        PatriciaNode<V> parent = this.root;
        while (parent.getBit() < current.getBit()) {
            parent = current;
            if (!this.keyMapper.isSet(current.getBit(), key)) {
                current = current.getLeft();
                continue;
            }
            current = current.getRight();
        }
        return current;
    }

    private int findFirstDifferingBit(String key1, String key2) {
        int bit = 0;
        while (this.keyMapper.isSet(bit, key1) == this.keyMapper.isSet(bit, key2)) {
            ++bit;
        }
        return bit;
    }

    private void insertNode(PatriciaNode<V> node) {
        PatriciaNode<V> current = this.root.getLeft();
        PatriciaNode<V> parent = this.root;
        while (parent.getBit() < current.getBit() && current.getBit() < node.getBit()) {
            parent = current;
            if (!this.keyMapper.isSet(current.getBit(), node.getKey())) {
                current = current.getLeft();
                continue;
            }
            current = current.getRight();
        }
        if (!this.keyMapper.isSet(node.getBit(), node.getKey())) {
            node.setLeft(node);
            node.setRight(current);
        } else {
            node.setLeft(current);
            node.setRight(node);
        }
        if (!this.keyMapper.isSet(parent.getBit(), node.getKey())) {
            parent.setLeft(node);
        } else {
            parent.setRight(node);
        }
    }

    public PatriciaNode<V> getRoot() {
        return this.root;
    }

    public KeyMapper<String> getKeyMapper() {
        return this.keyMapper;
    }

    private void valuesR(PatriciaNode<V> node, int bit, List<V> list) {
        if (node.getBit() <= bit) {
            return;
        }
        this.valuesR(node.getLeft(), node.getBit(), list);
        this.valuesR(node.getRight(), node.getBit(), list);
        list.add(node.getValue());
    }

    private void keysR(PatriciaNode<V> node, int bit, Set<String> keys) {
        if (node.getBit() <= bit) {
            return;
        }
        this.keysR(node.getLeft(), node.getBit(), keys);
        this.keysR(node.getRight(), node.getBit(), keys);
        keys.add(node.getKey());
    }

    private void entriesR(PatriciaNode<V> node, int bit, Map<String, V> entries) {
        if (node.getBit() <= bit) {
            return;
        }
        this.entriesR(node.getLeft(), node.getBit(), entries);
        this.entriesR(node.getRight(), node.getBit(), entries);
        entries.put(node.getKey(), node.getValue());
    }

    public static class PatriciaNode<V> {
        private String key;
        private V value;
        private int bit;
        private PatriciaNode<V> left = null;
        private PatriciaNode<V> right = null;

        public PatriciaNode(String key, V value, int bit) {
            this.key = key;
            this.value = value;
            this.bit = bit;
        }

        public String getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public void setValue(V value) {
            this.value = value;
        }

        public int getBit() {
            return this.bit;
        }

        public PatriciaNode<V> getLeft() {
            return this.left;
        }

        public PatriciaNode<V> getRight() {
            return this.right;
        }

        public void setLeft(PatriciaNode<V> left) {
            this.left = left;
        }

        public void setRight(PatriciaNode<V> right) {
            this.right = right;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("key: " + this.key);
            builder.append(", ");
            builder.append("bit: " + this.bit);
            builder.append(", ");
            builder.append("value: " + this.value);
            builder.append(", ");
            if (this.left != null) {
                builder.append("left: " + this.left.getKey());
            } else {
                builder.append("left: null");
            }
            builder.append(", ");
            if (this.right != null) {
                builder.append("right: " + this.right.getKey());
            } else {
                builder.append("right: null");
            }
            return builder.toString();
        }
    }

    public static class StringKeyMapper
    implements KeyMapper<String> {
        @Override
        public boolean isSet(int bit, String key) {
            int mask;
            if (key == null) {
                return false;
            }
            if (bit >= this.length(key)) {
                return true;
            }
            int codePoint = Character.codePointAt(key, bit / 16);
            int result = codePoint & (mask = 1 << 15 - bit % 16);
            return result != 0;
        }

        @Override
        public String toBitString(String key) {
            StringBuilder builder = new StringBuilder();
            for (int i = 0; i < this.length(key); ++i) {
                if (this.isSet(i, key)) {
                    builder.append("1");
                } else {
                    builder.append("0");
                }
                if ((i + 1) % 4 != 0 || i >= this.length(key)) continue;
                builder.append(" ");
            }
            return builder.toString();
        }

        private int length(String key) {
            if (key == null) {
                return 0;
            }
            return key.length() * 16;
        }
    }

    public static interface KeyMapper<K> {
        public boolean isSet(int var1, K var2);

        public String toBitString(K var1);
    }
}

