/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router.tester;

import java.util.List;
import net.osmand.binary.RouteDataObject;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingContext;
import net.osmand.router.TransportRoutePlanner;
import net.osmand.router.TransportRouteResult;
import net.osmand.router.tester.RandomRouteEntry;
import net.osmand.util.MapUtils;

class RandomRouteResult {
    String type;
    double cost;
    long runTime;
    int visitedSegments;
    float distance;
    RandomRouteEntry entry;

    RandomRouteResult(String type, RandomRouteEntry entry, long runTime, List<TransportRouteResult> results) {
        this.type = type;
        this.entry = entry;
        this.runTime = runTime;
        this.cost = this.calcTransportRouteAvgCost(results);
        this.distance = this.calcTransportRouteAvgDistance(results);
        this.visitedSegments = this.calcTransportRouteResultsWithAlternatives(results);
    }

    RandomRouteResult(String type, RandomRouteEntry entry, long runTime, RoutingContext ctx, List<RouteSegmentResult> segments) {
        this.type = type;
        this.entry = entry;
        this.runTime = runTime;
        this.distance = 0.0f;
        this.cost = ctx.routingTime;
        this.visitedSegments = ctx.calculationProgress.visitedSegments;
        if (segments != null) {
            float untrustedDistance = 0.0f;
            for (RouteSegmentResult r : segments) {
                untrustedDistance += r.getDistance();
                this.distance += this.calcSegmentDistance(r);
            }
            if (Float.compare(this.distance, untrustedDistance) != 0) {
                System.err.printf("WARN: %s got different distance (%f != %f)\n", type, Float.valueOf(this.distance), Float.valueOf(untrustedDistance));
            }
        }
    }

    private int calcTransportRouteResultsWithAlternatives(List<TransportRouteResult> results) {
        int counter = results.size();
        for (TransportRouteResult r : results) {
            counter += r.getAlternativeRoutes().size();
        }
        return counter;
    }

    private double calcTransportRouteAvgCost(List<TransportRouteResult> results) {
        double cost = 0.0;
        if (!results.isEmpty()) {
            int counter = results.size();
            for (TransportRouteResult r : results) {
                cost += r.getRouteTime();
                List alternatives = r.getAlternativeRoutes();
                if (alternatives.isEmpty()) continue;
                counter += alternatives.size();
                for (TransportRouteResult alt : alternatives) {
                    cost += alt.getRouteTime();
                }
            }
            cost /= (double)counter;
        }
        return cost;
    }

    private float calcTransportRouteAvgDistance(List<TransportRouteResult> results) {
        double dist = 0.0;
        if (!results.isEmpty()) {
            int counter = results.size();
            for (TransportRouteResult r : results) {
                for (TransportRoutePlanner.TransportRouteResultSegment segment : r.getSegments()) {
                    dist += segment.travelDistApproximate + segment.walkDist;
                }
                dist += r.getFinishWalkDist();
                List alternatives = r.getAlternativeRoutes();
                if (alternatives.isEmpty()) continue;
                counter += alternatives.size();
                for (TransportRouteResult alt : alternatives) {
                    for (TransportRoutePlanner.TransportRouteResultSegment segment : alt.getSegments()) {
                        dist += segment.travelDistApproximate + segment.walkDist;
                    }
                    dist += alt.getFinishWalkDist();
                }
            }
            dist /= (double)counter;
        }
        return (float)dist;
    }

    private float calcSegmentDistance(RouteSegmentResult rr) {
        double distance = 0.0;
        RouteDataObject road = rr.getObject();
        boolean plus = rr.getStartPointIndex() < rr.getEndPointIndex();
        int j = rr.getStartPointIndex();
        while (j != rr.getEndPointIndex()) {
            int next = plus ? j + 1 : j - 1;
            double d = this.measuredDist(road.getPoint31XTile(j), road.getPoint31YTile(j), road.getPoint31XTile(next), road.getPoint31YTile(next));
            distance += d;
            j = next;
        }
        return (float)distance;
    }

    private double measuredDist(int x1, int y1, int x2, int y2) {
        return MapUtils.getDistance((double)MapUtils.get31LatitudeY((int)y1), (double)MapUtils.get31LongitudeX((int)x1), (double)MapUtils.get31LatitudeY((int)y2), (double)MapUtils.get31LongitudeX((int)x2));
    }

    public String toString() {
        return this.entry.toURL(this.type);
    }

    public String toURL(String domain, boolean car2phase) {
        return this.entry.toURL(this.type, domain, car2phase);
    }
}

