/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.data;

import gnu.trove.TIntCollection;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.osmand.NativeLibrary;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.ObfConstants;
import net.osmand.data.Amenity;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.TransportStop;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.edit.Entity;
import net.osmand.search.core.SearchResult;
import net.osmand.util.Algorithms;
import net.osmand.util.MapUtils;

public class BaseDetailsObject {
    private static final int MAX_DISTANCE_BETWEEN_AMENITY_AND_LOCAL_STOPS = 30;
    private final Set<Long> osmIds = new HashSet<Long>();
    private final Set<String> wikidataIds = new HashSet<String>();
    private final List<Object> objects = new ArrayList<Object>();
    private final String lang;
    private String obfResourceName;
    private SearchResult.SearchResultResource searchResultResource;
    protected Amenity syntheticAmenity = new Amenity();
    private ObjectCompleteness objectCompleteness = ObjectCompleteness.EMPTY;

    public BaseDetailsObject(String lang) {
        this.lang = lang;
    }

    public BaseDetailsObject(Object object, String lang) {
        this(Algorithms.isEmpty(lang) ? "en" : lang);
        this.addObject(object);
    }

    public BaseDetailsObject(List<? extends MapObject> mapObjects, String lang) {
        this(Algorithms.isEmpty(lang) ? "en" : lang);
        boolean containsAmenity = false;
        for (MapObject mapObject : mapObjects) {
            this.addObject(mapObject);
            if (!(mapObject instanceof Amenity)) continue;
            containsAmenity = true;
        }
        if (!this.objects.isEmpty()) {
            this.objectCompleteness = containsAmenity ? ObjectCompleteness.FULL : ObjectCompleteness.COMBINED;
        }
    }

    public Amenity getSyntheticAmenity() {
        return this.syntheticAmenity;
    }

    public LatLon getLocation() {
        return this.syntheticAmenity.getLocation();
    }

    public List<Object> getObjects() {
        return this.objects;
    }

    public boolean isObjectFull() {
        return this.objectCompleteness == ObjectCompleteness.FULL || this.objectCompleteness == ObjectCompleteness.COMBINED;
    }

    public boolean isObjectEmpty() {
        return this.objectCompleteness == ObjectCompleteness.EMPTY;
    }

    public boolean addObject(Object object) {
        if (!this.isSupportedObjectType(object)) {
            return false;
        }
        if (object instanceof BaseDetailsObject) {
            BaseDetailsObject detailsObject = (BaseDetailsObject)object;
            for (Object obj : detailsObject.getObjects()) {
                this.addObject(obj);
            }
        } else {
            this.objects.add(object);
            Long osmId = this.getOsmId(object);
            String wikidata = this.getWikidata(object);
            if (osmId != null && osmId != -1L) {
                this.osmIds.add(osmId);
            }
            if (!Algorithms.isEmpty(wikidata)) {
                this.wikidataIds.add(wikidata);
            }
        }
        this.combineData();
        return true;
    }

    protected String getWikidata(Object object) {
        if (object instanceof Amenity) {
            Amenity amenity = (Amenity)object;
            return amenity.getWikidata();
        }
        if (object instanceof TransportStop) {
            TransportStop transportStop = (TransportStop)object;
            Amenity amenity = transportStop.getAmenity();
            return amenity != null ? amenity.getWikidata() : null;
        }
        if (object instanceof NativeLibrary.RenderedObject) {
            NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)object;
            return renderedObject.getTagValue("wikidata");
        }
        return null;
    }

    private Long getOsmId(Object object) {
        if (object instanceof Amenity) {
            Amenity amenity = (Amenity)object;
            return amenity.getOsmId();
        }
        if (object instanceof MapObject) {
            MapObject mapObject = (MapObject)object;
            return ObfConstants.getOsmObjectId(mapObject);
        }
        return null;
    }

    public boolean overlapsWith(Object object) {
        boolean wikidataEqual;
        Long osmId = this.getOsmId(object);
        String wikidata = this.getWikidata(object);
        boolean osmIdEqual = osmId != null && osmId != -1L && this.osmIds.contains(osmId);
        boolean bl = wikidataEqual = !Algorithms.isEmpty(wikidata) && this.wikidataIds.contains(wikidata);
        if (osmIdEqual || wikidataEqual) {
            return true;
        }
        if (object instanceof NativeLibrary.RenderedObject) {
            NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)object;
            List<TransportStop> stops = this.getTransportStops();
            return this.overlapPublicTransport(Collections.singletonList(renderedObject), stops);
        }
        if (object instanceof TransportStop) {
            TransportStop transportStop = (TransportStop)object;
            List<NativeLibrary.RenderedObject> renderedObjects = this.getRenderedObjects();
            return this.overlapPublicTransport(renderedObjects, Collections.singletonList(transportStop));
        }
        return false;
    }

    private boolean overlapPublicTransport(List<NativeLibrary.RenderedObject> renderedObjects, List<TransportStop> stops) {
        for (NativeLibrary.RenderedObject renderedObject : renderedObjects) {
            if (!this.overlapPublicTransport(renderedObject, stops)) continue;
            return true;
        }
        return false;
    }

    private boolean overlapPublicTransport(NativeLibrary.RenderedObject renderedObject, List<TransportStop> stops) {
        List<String> transportTypes = MapPoiTypes.getDefault().getPublicTransportTypes();
        if (Algorithms.isEmpty(stops) || Algorithms.isEmpty(transportTypes)) {
            return false;
        }
        Map<String, String> tags = renderedObject.getTags();
        String name = renderedObject.getName();
        if (!Algorithms.isEmpty(name)) {
            boolean namesEqual = false;
            for (TransportStop transportStop : stops) {
                if (!transportStop.getName().contains(name) && !name.contains(transportStop.getName())) continue;
                namesEqual = true;
                break;
            }
            if (!namesEqual) {
                return false;
            }
        }
        boolean isStop = false;
        for (Map.Entry entry : tags.entrySet()) {
            String tag = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (!transportTypes.contains(value) && !transportTypes.contains(tag + "_" + value)) continue;
            isStop = true;
            break;
        }
        if (isStop) {
            for (TransportStop transportStop : stops) {
                if (!(MapUtils.getDistance(transportStop.getLocation(), renderedObject.getLatLon()) < 30.0)) continue;
                return true;
            }
        }
        return false;
    }

    public void merge(Object object) {
        if (object instanceof BaseDetailsObject) {
            BaseDetailsObject baseDetailsObject = (BaseDetailsObject)object;
            this.merge(baseDetailsObject);
        }
        if (object instanceof TransportStop) {
            TransportStop transportStop = (TransportStop)object;
            this.merge(transportStop);
        }
        if (object instanceof NativeLibrary.RenderedObject) {
            NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)object;
            this.merge(renderedObject);
        }
    }

    private void merge(BaseDetailsObject other) {
        this.osmIds.addAll(other.osmIds);
        this.wikidataIds.addAll(other.wikidataIds);
        this.objects.addAll(other.getObjects());
    }

    private void merge(TransportStop other) {
        String wikidata;
        this.osmIds.add(ObfConstants.getOsmObjectId(other));
        Amenity amenity = other.getAmenity();
        if (amenity != null && (wikidata = amenity.getWikidata()) != null) {
            this.wikidataIds.add(amenity.getWikidata());
        }
        this.objects.add(other);
    }

    private void merge(NativeLibrary.RenderedObject renderedObject) {
        this.osmIds.add(ObfConstants.getOsmObjectId(renderedObject));
        String wikidata = renderedObject.getTagValue("wikidata");
        if (!Algorithms.isEmpty(wikidata)) {
            this.wikidataIds.add(wikidata);
        }
        this.objects.add(renderedObject);
    }

    private void combineData() {
        this.syntheticAmenity = new Amenity();
        this.sortObjects();
        TreeSet<String> contentLocales = new TreeSet<String>();
        for (Object object : this.objects) {
            this.mergeObject(object, contentLocales, this.objects.size() == 1);
        }
        if (!Algorithms.isEmpty(contentLocales)) {
            this.syntheticAmenity.updateContentLocales(contentLocales);
        }
        if (this.objectCompleteness.ordinal() < ObjectCompleteness.FULL.ordinal()) {
            ObjectCompleteness objectCompleteness = this.objectCompleteness = this.syntheticAmenity.getType() == null ? ObjectCompleteness.EMPTY : ObjectCompleteness.COMBINED;
        }
        if (this.syntheticAmenity.getType() == null) {
            this.syntheticAmenity.setType(MapPoiTypes.getDefault().getUserDefinedCategory());
            this.syntheticAmenity.setSubType("");
            this.objectCompleteness = ObjectCompleteness.EMPTY;
        }
    }

    protected void mergeObject(Object object, Set<String> contentLocales, boolean isSingleObject) {
        if (object instanceof Amenity) {
            Amenity amenity = (Amenity)object;
            this.processAmenity(amenity, contentLocales, isSingleObject);
        } else if (object instanceof TransportStop) {
            TransportStop transportStop = (TransportStop)object;
            Amenity amenity = transportStop.getAmenity();
            if (amenity != null) {
                this.processAmenity(amenity, contentLocales, isSingleObject);
            } else {
                this.processId(transportStop);
                this.syntheticAmenity.copyNames(transportStop);
                if (this.syntheticAmenity.getLocation() == null) {
                    this.syntheticAmenity.setLocation(transportStop.getLocation());
                }
            }
        } else if (object instanceof NativeLibrary.RenderedObject) {
            NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)object;
            Entity.EntityType type = ObfConstants.getOsmEntityType(renderedObject);
            if (type != null) {
                long osmId = ObfConstants.getOsmObjectId(renderedObject);
                long objectId = ObfConstants.createMapObjectIdFromCleanOsmId(osmId, type);
                if (this.syntheticAmenity.getId() == null && objectId > 0L) {
                    this.syntheticAmenity.setId(objectId);
                }
            }
            if (this.syntheticAmenity.getType() == null) {
                this.syntheticAmenity.copyAdditionalInfo(renderedObject.getTags(), false);
            }
            this.syntheticAmenity.copyNames(renderedObject);
            if (this.syntheticAmenity.getLocation() == null) {
                this.syntheticAmenity.setLocation(renderedObject.getLocation());
            }
            if (this.syntheticAmenity.getLocation() == null) {
                this.syntheticAmenity.setLocation(renderedObject.getLabelLatLon());
            }
            this.processPolygonCoordinates(renderedObject.getX(), renderedObject.getY());
        }
    }

    protected void processId(MapObject object) {
        if (this.syntheticAmenity.getId() == null && ObfConstants.isOsmUrlAvailable(object)) {
            this.syntheticAmenity.setId(object.getId());
        }
    }

    private void updateAmenitySubTypes(Amenity amenity, String subTypesToAdd) {
        if (amenity.getSubType() == null) {
            amenity.setSubType(subTypesToAdd);
        } else {
            for (String subType : subTypesToAdd.split(";")) {
                boolean isSubTypeUnique = true;
                for (String s : amenity.getSubType().split(";")) {
                    if (!s.equals(subType)) continue;
                    isSubTypeUnique = false;
                    break;
                }
                if (!isSubTypeUnique) continue;
                amenity.setSubType(amenity.getSubType() + ";" + subType);
            }
        }
    }

    protected void processAmenity(Amenity amenity, Set<String> contentLocales, boolean isSingleObject) {
        boolean shouldCopyAdditionalInfo;
        String subType;
        this.processId(amenity);
        LatLon location = amenity.getLocation();
        if (this.syntheticAmenity.getLocation() == null && location != null) {
            this.syntheticAmenity.setLocation(location);
        }
        PoiCategory type = amenity.getType();
        if (this.syntheticAmenity.getType() == null && type != null) {
            this.syntheticAmenity.setType(type);
        }
        if ((subType = amenity.getSubType()) != null) {
            this.updateAmenitySubTypes(this.syntheticAmenity, subType);
        }
        String mapIconName = amenity.getMapIconName();
        if (this.syntheticAmenity.getMapIconName() == null && mapIconName != null) {
            this.syntheticAmenity.setMapIconName(mapIconName);
        }
        String regionName = amenity.getRegionName();
        if (this.syntheticAmenity.getRegionName() == null && regionName != null) {
            this.syntheticAmenity.setRegionName(regionName);
        }
        Map<Integer, List<BinaryMapIndexReader.TagValuePair>> groups = amenity.getTagGroups();
        if (this.syntheticAmenity.getTagGroups() == null && groups != null) {
            this.syntheticAmenity.setTagGroups(new HashMap<Integer, List<BinaryMapIndexReader.TagValuePair>>(groups));
        }
        int travelElo = amenity.getTravelEloNumber();
        if (this.syntheticAmenity.getTravelEloNumber() == 900 && travelElo != 900) {
            this.syntheticAmenity.setTravelEloNumber(travelElo);
        }
        this.syntheticAmenity.copyNames(amenity);
        boolean bl = shouldCopyAdditionalInfo = BaseDetailsObject.getResourceType(amenity) != SearchResult.SearchResultResource.TRAVEL || BaseDetailsObject.getLangForTravel(amenity).equals(this.lang);
        if (isSingleObject || shouldCopyAdditionalInfo) {
            this.syntheticAmenity.copyAdditionalInfo(amenity, false);
        }
        this.processPolygonCoordinates(amenity.getX(), amenity.getY());
        contentLocales.addAll(amenity.getSupportedContentLocales());
    }

    private void processPolygonCoordinates(TIntArrayList x, TIntArrayList y) {
        if (this.syntheticAmenity.getX().isEmpty() && !x.isEmpty()) {
            this.syntheticAmenity.getX().addAll((TIntCollection)x);
        }
        if (this.syntheticAmenity.getY().isEmpty() && !y.isEmpty()) {
            this.syntheticAmenity.getY().addAll((TIntCollection)y);
        }
    }

    public void processPolygonCoordinates(Object object) {
        if (object instanceof Amenity) {
            Amenity amenity = (Amenity)object;
            this.processPolygonCoordinates(amenity.getX(), amenity.getY());
        }
        if (object instanceof NativeLibrary.RenderedObject) {
            NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)object;
            this.processPolygonCoordinates(renderedObject.getX(), renderedObject.getY());
        }
    }

    private void sortObjects() {
        this.sortObjectsByLang();
        this.sortObjectsByResourceType();
        this.sortObjectsByClass();
    }

    private void sortObjectsByLang() {
        this.objects.sort((o1, o2) -> {
            boolean preferred2;
            String l1 = BaseDetailsObject.getLangForTravel(o1);
            String l2 = BaseDetailsObject.getLangForTravel(o2);
            boolean preferred1 = Algorithms.stringsEqual(l1, this.lang);
            if (preferred1 == (preferred2 = Algorithms.stringsEqual(l2, this.lang))) {
                return 0;
            }
            return preferred1 ? -1 : 1;
        });
    }

    private void sortObjectsByResourceType() {
        this.objects.sort((o1, o2) -> {
            int ord2;
            int ord1 = BaseDetailsObject.getResourceType(o1).ordinal();
            if (ord1 != (ord2 = BaseDetailsObject.getResourceType(o2).ordinal())) {
                return ord2 > ord1 ? -1 : 1;
            }
            return 0;
        });
    }

    private void sortObjectsByClass() {
        this.objects.sort((o1, o2) -> {
            int ord2;
            int ord1 = BaseDetailsObject.getClassOrder(o1);
            if (ord1 != (ord2 = BaseDetailsObject.getClassOrder(o2))) {
                return ord2 > ord1 ? -1 : 1;
            }
            return 0;
        });
    }

    public void setObfResourceName(String obfName) {
        this.obfResourceName = obfName;
    }

    public SearchResult.SearchResultResource getResourceType() {
        if (this.searchResultResource == null) {
            this.searchResultResource = BaseDetailsObject.findObfType(this.obfResourceName, this.syntheticAmenity);
        }
        return this.searchResultResource;
    }

    public String getLang() {
        return this.lang;
    }

    public void setMapIconName(String mapIconName) {
        this.syntheticAmenity.setMapIconName(mapIconName);
    }

    public void setX(TIntArrayList x) {
        this.syntheticAmenity.getX().addAll((TIntCollection)x);
    }

    public void setY(TIntArrayList y) {
        this.syntheticAmenity.getY().addAll((TIntCollection)y);
    }

    public void addX(int x) {
        this.syntheticAmenity.getX().add(x);
    }

    public void addY(int y) {
        this.syntheticAmenity.getY().add(y);
    }

    public boolean hasGeometry() {
        return !this.syntheticAmenity.getX().isEmpty() && !this.syntheticAmenity.getY().isEmpty();
    }

    public int getPointsLength() {
        return this.syntheticAmenity.getX().size();
    }

    public void clearGeometry() {
        this.syntheticAmenity.getY().clear();
        this.syntheticAmenity.getX().clear();
    }

    protected boolean isSupportedObjectType(Object object) {
        return object instanceof Amenity || object instanceof TransportStop || object instanceof NativeLibrary.RenderedObject || object instanceof BaseDetailsObject;
    }

    public List<Amenity> getAmenities() {
        ArrayList<Amenity> amenities = new ArrayList<Amenity>();
        for (Object object : this.objects) {
            if (!(object instanceof Amenity)) continue;
            Amenity amenity = (Amenity)object;
            amenities.add(amenity);
        }
        return amenities;
    }

    public List<TransportStop> getTransportStops() {
        ArrayList<TransportStop> stops = new ArrayList<TransportStop>();
        for (Object object : this.objects) {
            if (!(object instanceof TransportStop)) continue;
            TransportStop transportStop = (TransportStop)object;
            stops.add(transportStop);
        }
        return stops;
    }

    public List<NativeLibrary.RenderedObject> getRenderedObjects() {
        ArrayList<NativeLibrary.RenderedObject> renderedObjects = new ArrayList<NativeLibrary.RenderedObject>();
        for (Object object : this.objects) {
            if (!(object instanceof NativeLibrary.RenderedObject)) continue;
            NativeLibrary.RenderedObject renderedObject = (NativeLibrary.RenderedObject)object;
            renderedObjects.add(renderedObject);
        }
        return renderedObjects;
    }

    private static SearchResult.SearchResultResource findObfType(String obfResourceName, Amenity amenity) {
        if (obfResourceName != null && obfResourceName.contains("basemap")) {
            return SearchResult.SearchResultResource.BASEMAP;
        }
        if (obfResourceName != null && (obfResourceName.contains("travel") || obfResourceName.contains("wikivoyage"))) {
            return SearchResult.SearchResultResource.TRAVEL;
        }
        if (amenity.getType().isWiki()) {
            return SearchResult.SearchResultResource.WIKIPEDIA;
        }
        return SearchResult.SearchResultResource.DETAILED;
    }

    private static SearchResult.SearchResultResource getResourceType(Object object) {
        if (object instanceof BaseDetailsObject) {
            BaseDetailsObject detailsObject = (BaseDetailsObject)object;
            return detailsObject.getResourceType();
        }
        if (object instanceof Amenity) {
            Amenity amenity = (Amenity)object;
            return BaseDetailsObject.findObfType(amenity.getRegionName(), amenity);
        }
        return SearchResult.SearchResultResource.DETAILED;
    }

    private static String getLangForTravel(Object object) {
        String lang;
        Amenity amenity = null;
        if (object instanceof Amenity) {
            amenity = (Amenity)object;
        }
        if (object instanceof BaseDetailsObject) {
            amenity = ((BaseDetailsObject)object).syntheticAmenity;
        }
        if (amenity != null && BaseDetailsObject.getResourceType(object) == SearchResult.SearchResultResource.TRAVEL && (lang = amenity.getTagSuffix("lang_yes:")) != null) {
            return lang;
        }
        return "en";
    }

    private static int getClassOrder(Object object) {
        if (object instanceof BaseDetailsObject) {
            return 1;
        }
        if (object instanceof Amenity) {
            return 2;
        }
        if (object instanceof TransportStop) {
            return 3;
        }
        if (object instanceof NativeLibrary.RenderedObject) {
            return 4;
        }
        return 5;
    }

    public String toString() {
        return this.getSyntheticAmenity().toString();
    }

    private static enum ObjectCompleteness {
        EMPTY,
        COMBINED,
        FULL;

    }
}

