/*
 * Decompiled with CFR 0.152.
 */
package com.vividsolutions.jts.util;

public class Stopwatch {
    private long startTimestamp;
    private long totalTime = 0L;
    private boolean isRunning = false;

    public Stopwatch() {
        this.start();
    }

    public void start() {
        if (this.isRunning) {
            return;
        }
        this.startTimestamp = System.currentTimeMillis();
        this.isRunning = true;
    }

    public long stop() {
        if (this.isRunning) {
            this.updateTotalTime();
            this.isRunning = false;
        }
        return this.totalTime;
    }

    public void reset() {
        this.totalTime = 0L;
        this.startTimestamp = System.currentTimeMillis();
    }

    public long split() {
        if (this.isRunning) {
            this.updateTotalTime();
        }
        return this.totalTime;
    }

    private void updateTotalTime() {
        long endTimestamp = System.currentTimeMillis();
        long elapsedTime = endTimestamp - this.startTimestamp;
        this.startTimestamp = endTimestamp;
        this.totalTime += elapsedTime;
    }

    public long getTime() {
        this.updateTotalTime();
        return this.totalTime;
    }

    public String getTimeString() {
        long totalTime = this.getTime();
        return Stopwatch.getTimeString(totalTime);
    }

    public static String getTimeString(long timeMillis) {
        String totalTimeStr = timeMillis < 10000L ? String.valueOf(timeMillis) + " ms" : String.valueOf((double)timeMillis / 1000.0) + " s";
        return totalTimeStr;
    }
}

