/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.time.DateTimeException;
import java.time.DayOfWeek;
import java.time.Month;
import java.time.format.DateTimeParseException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTimeKt;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.LocalDateTimeFormat;
import kotlinx.datetime.format.LocalDateTimeFormatKt;
import kotlinx.datetime.serializers.LocalDateTimeIso8601Serializer;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Serializable(with=LocalDateTimeIso8601Serializer.class)
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u0000 62\b\u0012\u0004\u0012\u00020\u00000\u0001:\u000267BC\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nBG\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u000b\u001a\u00060\fj\u0002`\r\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\b\b\u0002\u0010\b\u001a\u00020\u0003\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u000eB\u0017\b\u0016\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\u0002\u0010\u0013B\u000f\b\u0000\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0002\u0010\u0016J\u0011\u0010.\u001a\u00020\u00032\u0006\u0010/\u001a\u00020\u0000H\u0096\u0002J\u0013\u00100\u001a\u0002012\b\u0010/\u001a\u0004\u0018\u000102H\u0096\u0002J\b\u00103\u001a\u00020\u0003H\u0016J\b\u00104\u001a\u000205H\u0016R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0005\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0015\u0010\u001b\u001a\u00060\u001cj\u0002`\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\u001aR\u0011\u0010\u0007\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u001aR\u0015\u0010\u000b\u001a\u00060\fj\u0002`\r8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010%R\u0011\u0010\u0004\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001aR\u0011\u0010\t\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\u001aR\u0011\u0010\b\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\u001aR\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010\u0014\u001a\u00020\u0015X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\u0002\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001a\u00a8\u00068"}, d2={"Lkotlinx/datetime/LocalDateTime;", "", "year", "", "monthNumber", "dayOfMonth", "hour", "minute", "second", "nanosecond", "(IIIIIII)V", "month", "Ljava/time/Month;", "Lkotlinx/datetime/Month;", "(ILjava/time/Month;IIIII)V", "date", "Lkotlinx/datetime/LocalDate;", "time", "Lkotlinx/datetime/LocalTime;", "(Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalTime;)V", "value", "Ljava/time/LocalDateTime;", "(Ljava/time/LocalDateTime;)V", "getDate", "()Lkotlinx/datetime/LocalDate;", "getDayOfMonth", "()I", "dayOfWeek", "Ljava/time/DayOfWeek;", "Lkotlinx/datetime/DayOfWeek;", "getDayOfWeek", "()Ljava/time/DayOfWeek;", "dayOfYear", "getDayOfYear", "getHour", "getMinute", "getMonth", "()Ljava/time/Month;", "getMonthNumber", "getNanosecond", "getSecond", "getTime", "()Lkotlinx/datetime/LocalTime;", "getValue$kotlinx_datetime", "()Ljava/time/LocalDateTime;", "getYear", "compareTo", "other", "equals", "", "", "hashCode", "toString", "", "Companion", "Formats", "kotlinx-datetime"})
public final class LocalDateTime
implements Comparable<LocalDateTime> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.LocalDateTime value;
    @NotNull
    private static final LocalDateTime MIN;
    @NotNull
    private static final LocalDateTime MAX;

    public LocalDateTime(@NotNull java.time.LocalDateTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final java.time.LocalDateTime getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalDateTime(int year2, int monthNumber2, int dayOfMonth2, int hour2, int minute2, int second2, int nanosecond) {
        java.time.LocalDateTime localDateTime;
        LocalDateTime localDateTime2;
        LocalDateTime localDateTime3 = this;
        try {
            localDateTime2 = localDateTime3;
            localDateTime = java.time.LocalDateTime.of(year2, monthNumber2, dayOfMonth2, hour2, minute2, second2, nanosecond);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            LocalDateTime localDateTime4 = localDateTime3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.LocalDateTime localDateTime5 = localDateTime;
        Intrinsics.checkNotNull((Object)localDateTime5);
        localDateTime2(localDateTime5);
    }

    public /* synthetic */ LocalDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n8 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x40) != 0) {
            n7 = 0;
        }
        this(n, n2, n3, n4, n5, n6, n7);
    }

    public LocalDateTime(int year2, @NotNull Month month2, int dayOfMonth2, int hour2, int minute2, int second2, int nanosecond) {
        Intrinsics.checkNotNullParameter((Object)month2, (String)"month");
        this(year2, MonthKt.getNumber(month2), dayOfMonth2, hour2, minute2, second2, nanosecond);
    }

    public /* synthetic */ LocalDateTime(int n, Month month2, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x20) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x40) != 0) {
            n6 = 0;
        }
        this(n, month2, n2, n3, n4, n5, n6);
    }

    public LocalDateTime(@NotNull LocalDate date, @NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        java.time.LocalDateTime localDateTime = java.time.LocalDateTime.of(date.getValue$kotlinx_datetime(), time.getValue$kotlinx_datetime());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
        this(localDateTime);
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber() {
        return this.value.getMonthValue();
    }

    @NotNull
    public final Month getMonth() {
        Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month2, (String)"getMonth(...)");
        return month2;
    }

    public final int getDayOfMonth() {
        return this.value.getDayOfMonth();
    }

    @NotNull
    public final DayOfWeek getDayOfWeek() {
        DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return dayOfWeek;
    }

    public final int getDayOfYear() {
        return this.value.getDayOfYear();
    }

    public final int getHour() {
        return this.value.getHour();
    }

    public final int getMinute() {
        return this.value.getMinute();
    }

    public final int getSecond() {
        return this.value.getSecond();
    }

    public final int getNanosecond() {
        return this.value.getNano();
    }

    @NotNull
    public final LocalDate getDate() {
        java.time.LocalDate localDate = this.value.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        return new LocalDate(localDate);
    }

    @NotNull
    public final LocalTime getTime() {
        java.time.LocalTime localTime = this.value.toLocalTime();
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"toLocalTime(...)");
        return new LocalTime(localTime);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LocalDateTime && Intrinsics.areEqual((Object)this.value, (Object)((LocalDateTime)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull LocalDateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other.value);
    }

    static {
        java.time.LocalDateTime localDateTime = java.time.LocalDateTime.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"MIN");
        MIN = new LocalDateTime(localDateTime);
        java.time.LocalDateTime localDateTime2 = java.time.LocalDateTime.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"MAX");
        MAX = new LocalDateTime(localDateTime2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J%\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n2\u0017\u0010\u000b\u001a\u0013\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\f\u00a2\u0006\u0002\b\u000fJ\u001e\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u00122\u000e\b\u0002\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00040\nJ\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00040\u0017H\u00c6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u0018"}, d2={"Lkotlinx/datetime/LocalDateTime$Companion;", "", "()V", "MAX", "Lkotlinx/datetime/LocalDateTime;", "getMAX$kotlinx_datetime", "()Lkotlinx/datetime/LocalDateTime;", "MIN", "getMIN$kotlinx_datetime", "Format", "Lkotlinx/datetime/format/DateTimeFormat;", "builder", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithDateTime;", "", "Lkotlin/ExtensionFunctionType;", "parse", "input", "", "format", "isoString", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    @SourceDebugExtension(value={"SMAP\nLocalDateTime.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateTime.kt\nkotlinx/datetime/LocalDateTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,88:1\n1#2:89\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDateTime parse(@NotNull CharSequence input, @NotNull DateTimeFormat<LocalDateTime> format2) {
            LocalDateTime localDateTime;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format2, (String)"format");
            if (format2 == Formats.INSTANCE.getISO()) {
                LocalDateTime localDateTime2;
                try {
                    java.time.LocalDateTime p0 = java.time.LocalDateTime.parse(input);
                    boolean bl = false;
                    localDateTime2 = new LocalDateTime(p0);
                }
                catch (DateTimeParseException e) {
                    throw new DateTimeFormatException(e);
                }
                localDateTime = localDateTime2;
            } else {
                localDateTime = format2.parse(input);
            }
            return localDateTime;
        }

        public static /* synthetic */ LocalDateTime parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = LocalDateTimeKt.getIsoDateTimeFormat();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        @Deprecated(message="This overload is only kept for binary compatibility", level=DeprecationLevel.HIDDEN)
        public final /* synthetic */ LocalDateTime parse(String isoString) {
            Intrinsics.checkNotNullParameter((Object)isoString, (String)"isoString");
            return kotlinx.datetime.LocalDateTime$Companion.parse$default(this, isoString, null, 2, null);
        }

        @NotNull
        public final LocalDateTime getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final LocalDateTime getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final DateTimeFormat<LocalDateTime> Format(@NotNull Function1<? super DateTimeFormatBuilder.WithDateTime, Unit> builder) {
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            return LocalDateTimeFormat.Companion.build(builder);
        }

        @NotNull
        public final KSerializer<LocalDateTime> serializer() {
            return LocalDateTimeIso8601Serializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lkotlinx/datetime/LocalDateTime$Formats;", "", "()V", "ISO", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDateTime;", "getISO", "()Lkotlinx/datetime/format/DateTimeFormat;", "kotlinx-datetime"})
    public static final class Formats {
        @NotNull
        public static final Formats INSTANCE = new Formats();
        @NotNull
        private static final DateTimeFormat<LocalDateTime> ISO = LocalDateTimeFormatKt.getISO_DATETIME();

        private Formats() {
        }

        @NotNull
        public final DateTimeFormat<LocalDateTime> getISO() {
            return ISO;
        }
    }
}

