/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.search.core;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.osmand.Collator;
import net.osmand.CollatorStringMatcher;
import net.osmand.OsmAndCollator;
import net.osmand.ResultMatcher;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.CommonWords;
import net.osmand.binary.ObfConstants;
import net.osmand.data.Amenity;
import net.osmand.data.Building;
import net.osmand.data.City;
import net.osmand.data.LatLon;
import net.osmand.data.MapObject;
import net.osmand.data.QuadRect;
import net.osmand.data.QuadTree;
import net.osmand.data.Street;
import net.osmand.osm.AbstractPoiType;
import net.osmand.osm.MapPoiTypes;
import net.osmand.osm.PoiCategory;
import net.osmand.osm.PoiFilter;
import net.osmand.osm.PoiType;
import net.osmand.search.SearchUICore;
import net.osmand.search.core.CustomSearchPoiFilter;
import net.osmand.search.core.ObjectType;
import net.osmand.search.core.SearchCoreAPI;
import net.osmand.search.core.SearchPhrase;
import net.osmand.search.core.SearchResult;
import net.osmand.search.core.SearchSettings;
import net.osmand.search.core.SearchWord;
import net.osmand.search.core.TopIndexFilter;
import net.osmand.util.Algorithms;
import net.osmand.util.GeoParsedPoint;
import net.osmand.util.GeoPointParserUtil;
import net.osmand.util.LocationParser;
import net.osmand.util.MapUtils;

public class SearchCoreFactory {
    public static final int PREFERRED_STREET_ZOOM = 17;
    public static final int PREFERRED_INDEX_ITEM_ZOOM = 17;
    public static final int PREFERRED_BUILDING_ZOOM = 16;
    public static final int PREFERRED_COUNTRY_ZOOM = 7;
    public static final int PREFERRED_CITY_ZOOM = 13;
    public static final int PREFERRED_POI_ZOOM = 16;
    public static final int PREFERRED_NEARBY_POINT_ZOOM = 16;
    public static final int PREFERRED_WPT_ZOOM = 16;
    public static final int PREFERRED_GPX_FILE_ZOOM = 17;
    public static final int PREFERRED_DEFAULT_RECENT_ZOOM = 17;
    public static final int PREFERRED_FAVORITES_GROUP_ZOOM = 17;
    public static final int PREFERRED_FAVORITE_ZOOM = 16;
    public static final int PREFERRED_STREET_INTERSECTION_ZOOM = 16;
    public static final int PREFERRED_REGION_ZOOM = 6;
    public static final int PREFERRED_DEFAULT_ZOOM = 15;
    public static boolean DISPLAY_DEFAULT_POI_TYPES = false;
    public static final int MAX_DEFAULT_SEARCH_RADIUS = 7;
    public static final int SEARCH_MAX_PRIORITY = Integer.MAX_VALUE;
    public static final int SEARCH_REGION_API_PRIORITY = 300;
    public static final int SEARCH_REGION_OBJECT_PRIORITY = 1000;
    public static final int SEARCH_LOCATION_PRIORITY = 0;
    public static final int SEARCH_AMENITY_TYPE_PRIORITY = 100;
    public static final int SEARCH_AMENITY_TYPE_API_PRIORITY = 100;
    public static final int SEARCH_STREET_BY_CITY_PRIORITY = 200;
    public static final int SEARCH_BUILDING_BY_CITY_PRIORITY = 300;
    public static final int SEARCH_BUILDING_BY_STREET_PRIORITY = 100;
    public static final int SEARCH_AMENITY_BY_TYPE_PRIORITY = 300;
    public static final int SEARCH_ADDRESS_BY_NAME_API_PRIORITY = 500;
    public static final int SEARCH_ADDRESS_BY_NAME_API_PRIORITY_RADIUS2 = 500;
    public static final int SEARCH_ADDRESS_BY_NAME_PRIORITY = 500;
    public static final int SEARCH_ADDRESS_BY_NAME_PRIORITY_RADIUS2 = 500;
    public static final int SEARCH_AMENITY_BY_NAME_PRIORITY = 500;
    public static final int SEARCH_AMENITY_BY_NAME_API_PRIORITY_IF_POI_TYPE = 500;
    public static final int SEARCH_AMENITY_BY_NAME_API_PRIORITY_IF_3_CHAR = 500;
    private static final double SEARCH_AMENITY_BY_NAME_CITY_PRIORITY_DISTANCE = 0.001;
    private static final double SEARCH_AMENITY_BY_NAME_TOWN_PRIORITY_DISTANCE = 0.005;
    public static final int SEARCH_OLC_WITH_CITY_PRIORITY = 8;
    public static final int SEARCH_OLC_WITH_CITY_TOTAL_LIMIT = 500;

    public static boolean isLastWordCityGroup(SearchPhrase p) {
        return p.isLastWord(ObjectType.CITY) || p.isLastWord(ObjectType.POSTCODE) || p.isLastWord(ObjectType.VILLAGE) || p.isLastWord(ObjectType.BOUNDARY);
    }

    public static SearchResult createSearchResult(Amenity amenity, SearchPhrase phrase, MapPoiTypes poiTypes) {
        SearchResult result = new SearchResult(phrase);
        result.object = amenity;
        result.objectType = ObjectType.POI;
        result.location = amenity.getLocation();
        result.preferredZoom = 16;
        SearchSettings settings = phrase.getSettings();
        result.otherNames = amenity.getOtherNames(true);
        result.cityName = amenity.getCityFromTagGroups(settings.getLang());
        result.localeName = amenity.getName(settings.getLang(), settings.isTransliterate());
        if (Algorithms.isEmpty(result.localeName)) {
            AbstractPoiType poiType = poiTypes.getAnyPoiTypeByKey(amenity.getSubType());
            result.localeName = poiType != null ? poiType.getTranslation() : amenity.getSubType();
        }
        return result;
    }

    private static String getMapObjectName(MapObject mapObject, SearchSettings settings) {
        return SearchCoreFactory.getMapObjectName(mapObject, settings.getLang(), settings.getAppLang(), settings.isTransliterate());
    }

    private static String getMapObjectName(MapObject mapObject, String mapLang, String appLang, boolean transliterate) {
        String name = mapObject.getName(mapLang, transliterate);
        if (Algorithms.isEmpty(name) && !Algorithms.stringsEqual(appLang, mapLang)) {
            name = mapObject.getName(appLang, transliterate);
        }
        return name;
    }

    private static class TopIndexMatch {
        BinaryMapPoiReaderAdapter.PoiSubType subType;
        String value;
        String translatedValue;

        TopIndexMatch(BinaryMapPoiReaderAdapter.PoiSubType subType, String value, String translatedValue) {
            this.subType = subType;
            this.value = value;
            this.translatedValue = translatedValue;
        }
    }

    public static class SearchLocationAndUrlAPI
    extends SearchBaseAPI {
        private static final int OLC_RECALC_DISTANCE_THRESHOLD = 100000;
        private int olcPhraseHash;
        private LatLon olcPhraseLocation;
        private LocationParser.ParsedOpenLocationCode cachedParsedCode;
        private final DecimalFormat latLonFormatter = new DecimalFormat("#.0####", new DecimalFormatSymbols(Locale.US));
        private SearchAmenityByNameAPI amenitiesApi;

        public SearchLocationAndUrlAPI(SearchAmenityByNameAPI amenitiesApi) {
            super(ObjectType.LOCATION, ObjectType.PARTIAL_LOCATION);
            this.amenitiesApi = amenitiesApi;
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return false;
        }

        @Override
        public boolean search(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            if (!phrase.isUnknownSearchWordPresent()) {
                return false;
            }
            boolean parseUrl = this.parseUrl(phrase, resultMatcher);
            if (!parseUrl) {
                this.parseLocation(phrase, resultMatcher);
            }
            return super.search(phrase, resultMatcher);
        }

        LatLon parsePartialLocation(String s) {
            if ((s = s.trim()).length() == 0 || s.charAt(0) != '-' && !Character.isDigit(s.charAt(0)) && s.charAt(0) != 'S' && s.charAt(0) != 's' && s.charAt(0) != 'N' && s.charAt(0) != 'n' && !s.contains("://")) {
                return null;
            }
            boolean[] partial = new boolean[]{false};
            ArrayList<Double> d = new ArrayList<Double>();
            ArrayList<Object> all = new ArrayList<Object>();
            ArrayList<String> strings = new ArrayList<String>();
            LocationParser.splitObjects(s, d, all, strings, partial);
            if (partial[0]) {
                double lat = LocationParser.parse1Coordinate(all, 0, all.size());
                return new LatLon(lat, 0.0);
            }
            return null;
        }

        private void parseLocation(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            String lw = phrase.getUnknownSearchPhrase();
            LocationParser.ParsedOpenLocationCode parsedCode = this.cachedParsedCode;
            if (parsedCode == null) {
                parsedCode = LocationParser.parseOpenLocationCode(lw);
            }
            if (parsedCode != null) {
                LatLon cityLocation;
                LatLon latLon = parsedCode.getLatLon();
                if (!parsedCode.isFull() && !Algorithms.isEmpty(parsedCode.getPlaceName()) && (cityLocation = this.searchOLCLocation(phrase, resultMatcher)) != null) {
                    latLon = parsedCode.recover(cityLocation);
                }
                if (latLon == null && !parsedCode.isFull()) {
                    latLon = parsedCode.recover(phrase.getSettings().getOriginalLocation());
                }
                if (latLon != null) {
                    this.publishLocation(phrase, resultMatcher, lw, latLon);
                }
            } else {
                LatLon ll;
                LatLon l = LocationParser.parseLocation(lw);
                if (l != null && phrase.isSearchTypeAllowed(ObjectType.LOCATION)) {
                    this.publishLocation(phrase, resultMatcher, lw, l);
                } else if (l == null && phrase.isNoSelectedType() && phrase.isSearchTypeAllowed(ObjectType.PARTIAL_LOCATION) && (ll = this.parsePartialLocation(lw)) != null) {
                    SearchResult sp = new SearchResult(phrase);
                    sp.priority = 0.0;
                    sp.location = ll;
                    sp.object = sp.location;
                    sp.localeName = this.formatLatLon(sp.location.getLatitude()) + ", <input> ";
                    sp.objectType = ObjectType.PARTIAL_LOCATION;
                    resultMatcher.publish(sp);
                }
            }
        }

        private LatLon searchOLCLocation(SearchPhrase phrase, final SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            List<String> unknownWords = phrase.getUnknownSearchWords();
            String text = !unknownWords.isEmpty() ? unknownWords.get(0) : phrase.getUnknownWordToSearch();
            final List<String> allowedTypes = Arrays.asList("city", "town", "village");
            QuadRect searchBBox31 = new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9);
            final SearchPhrase.NameStringMatcher nm = new SearchPhrase.NameStringMatcher(text, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE);
            final String lang = phrase.getSettings().getLang();
            final boolean transliterate = phrase.getSettings().isTransliterate();
            SearchSettings settings = phrase.getSettings().setSearchBBox31(searchBBox31);
            settings = settings.setSortByName(false);
            settings = settings.setAddressSearch(true);
            settings = settings.setEmptyQueryAllowed(true);
            SearchPhrase olcPhrase = phrase.generateNewPhrase(text, settings);
            final ArrayList result = new ArrayList();
            ResultMatcher<SearchResult> matcher = new ResultMatcher<SearchResult>(){
                int count = 0;

                @Override
                public boolean publish(SearchResult object) {
                    if (this.count > 500) {
                        return false;
                    }
                    Amenity amenity = null;
                    if (object.objectType == ObjectType.POI) {
                        amenity = (Amenity)object.object;
                    }
                    if (amenity == null) {
                        return false;
                    }
                    String subType = amenity.getSubType();
                    String localeName = amenity.getName(lang, transliterate);
                    Collection<String> otherNames = object.otherNames;
                    if (!allowedTypes.contains(subType) || !nm.matches(localeName) && !nm.matches(otherNames)) {
                        return false;
                    }
                    result.add(object);
                    ++this.count;
                    return true;
                }

                @Override
                public boolean isCancelled() {
                    return this.count > 500 || resultMatcher.isCancelled();
                }
            };
            SearchUICore.SearchResultMatcher rm = new SearchUICore.SearchResultMatcher(matcher, olcPhrase, 0, new AtomicInteger(0), 500);
            this.amenitiesApi.search(olcPhrase, rm);
            final SearchPhrase.NameStringMatcher nmEquals = new SearchPhrase.NameStringMatcher(text, CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS);
            Collections.sort(result, new Comparator<SearchResult>(){

                @Override
                public int compare(SearchResult sr1, SearchResult sr2) {
                    Amenity poi1 = new Amenity();
                    Amenity poi2 = new Amenity();
                    if (sr1.objectType == ObjectType.POI) {
                        poi1 = (Amenity)sr1.object;
                    }
                    if (sr2.objectType == ObjectType.POI) {
                        poi2 = (Amenity)sr2.object;
                    }
                    if (poi1 != null && poi2 != null) {
                        int o1 = this.getIndex(poi1);
                        int o2 = this.getIndex(poi2);
                        return Algorithms.compare(o2, o1);
                    }
                    return 0;
                }

                private int getIndex(Amenity poi) {
                    int res = 0;
                    int poiTypeIndex = allowedTypes.indexOf(poi.getSubType());
                    if (poiTypeIndex != -1) {
                        res += poiTypeIndex;
                        if (nmEquals.matches(poi.getName()) || nmEquals.matches(poi.getOtherNames())) {
                            res += 8;
                        }
                    }
                    return res;
                }
            });
            return !result.isEmpty() ? ((SearchResult)result.get((int)0)).location : null;
        }

        private void publishLocation(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher, String lw, LatLon l) {
            SearchResult sp = new SearchResult(phrase);
            sp.priority = 0.0;
            sp.location = l;
            sp.object = sp.location;
            sp.localeName = this.formatLatLon(sp.location.getLatitude()) + ", " + this.formatLatLon(sp.location.getLongitude());
            sp.objectType = ObjectType.LOCATION;
            sp.wordsSpan = lw;
            resultMatcher.publish(sp);
        }

        private boolean parseUrl(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) {
            String text = phrase.getUnknownSearchPhrase();
            GeoParsedPoint pnt = GeoPointParserUtil.parse(text);
            if (pnt != null && pnt.isGeoPoint() && phrase.isSearchTypeAllowed(ObjectType.LOCATION)) {
                SearchResult sp = new SearchResult(phrase);
                sp.priority = 0.0;
                sp.object = pnt;
                sp.wordsSpan = text;
                sp.location = new LatLon(pnt.getLatitude(), pnt.getLongitude());
                sp.localeName = this.formatLatLon(pnt.getLatitude()) + ", " + this.formatLatLon(pnt.getLongitude());
                if (pnt.getZoom() > 0) {
                    sp.preferredZoom = pnt.getZoom();
                }
                sp.objectType = ObjectType.LOCATION;
                resultMatcher.publish(sp);
                return true;
            }
            return false;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            double distance;
            if (!p.isNoSelectedType() || !p.isUnknownSearchWordPresent()) {
                return -1;
            }
            int olcPhraseHash = p.getUnknownSearchPhrase().hashCode();
            if (this.olcPhraseHash == olcPhraseHash && this.olcPhraseLocation != null && (distance = MapUtils.getDistance(p.getSettings().getOriginalLocation(), this.olcPhraseLocation)) > 100000.0) {
                ++olcPhraseHash;
            }
            if (this.olcPhraseHash != olcPhraseHash) {
                this.olcPhraseHash = olcPhraseHash;
                this.olcPhraseLocation = p.getSettings().getOriginalLocation();
                this.cachedParsedCode = LocationParser.parseOpenLocationCode(p.getUnknownSearchPhrase());
            }
            return 0;
        }

        private String formatLatLon(double latLon) {
            return this.latLonFormatter.format(latLon);
        }
    }

    public static class PoiAdditionalCustomFilter
    extends AbstractPoiType {
        private final PoiType poiType;
        public List<PoiType> additionalPoiTypes = new ArrayList<PoiType>();

        public PoiAdditionalCustomFilter(MapPoiTypes registry, PoiType pt) {
            super(pt.getKeyName(), registry);
            this.additionalPoiTypes.add(pt);
            this.poiType = pt;
        }

        @Override
        public boolean isAdditional() {
            return true;
        }

        @Override
        public Map<PoiCategory, LinkedHashSet<String>> putTypes(Map<PoiCategory, LinkedHashSet<String>> acceptedTypes) {
            for (PoiType p : this.additionalPoiTypes) {
                if (p.getParentType() == this.registry.getOtherMapCategory()) {
                    for (PoiCategory c : this.registry.getCategories(false)) {
                        c.putTypes(acceptedTypes);
                    }
                    continue;
                }
                p.getParentType().putTypes(acceptedTypes);
            }
            return acceptedTypes;
        }

        @Override
        public String getParentTypeName() {
            return this.poiType.getParentTypeName();
        }

        @Override
        public boolean equals(Object other) {
            if (super.equals(other)) {
                if (!(other instanceof PoiAdditionalCustomFilter)) {
                    return false;
                }
                PoiAdditionalCustomFilter that = (PoiAdditionalCustomFilter)other;
                return this.additionalPoiTypes.equals(that.additionalPoiTypes);
            }
            return false;
        }
    }

    public static class SearchBuildingAndIntersectionsByStreetAPI
    extends SearchBaseAPI {
        Street cacheBuilding;

        public SearchBuildingAndIntersectionsByStreetAPI() {
            super(ObjectType.HOUSE, ObjectType.STREET_INTERSECTION);
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return false;
        }

        @Override
        public boolean search(SearchPhrase phrase, final SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            Street s = null;
            int priority = 100;
            if (phrase.isLastWord(ObjectType.STREET)) {
                s = (Street)phrase.getLastSelectedWord().getResult().object;
            }
            if (SearchCoreFactory.isLastWordCityGroup(phrase)) {
                priority = 300;
                Object o = phrase.getLastSelectedWord().getResult().object;
                if (o instanceof City) {
                    List<Street> streets = ((City)o).getStreets();
                    if (streets.size() == 1) {
                        s = streets.get(0);
                    } else {
                        for (Street st : streets) {
                            if (!st.getName().equals(((City)o).getName()) && !st.getName().equals("<" + ((City)o).getName() + ">")) continue;
                            s = st;
                            break;
                        }
                    }
                }
            }
            if (s != null) {
                String streetIntersection;
                BinaryMapIndexReader file = phrase.getLastSelectedWord().getResult().file;
                if (this.cacheBuilding != s) {
                    this.cacheBuilding = s;
                    BinaryMapIndexReader.SearchRequest<Building> sr = BinaryMapIndexReader.buildAddressRequest(new ResultMatcher<Building>(){

                        @Override
                        public boolean publish(Building object) {
                            return true;
                        }

                        @Override
                        public boolean isCancelled() {
                            return resultMatcher.isCancelled();
                        }
                    });
                    file.preloadBuildings(s, sr, phrase.getSettings().getStat());
                    Collections.sort(s.getBuildings(), new Comparator<Building>(){

                        @Override
                        public int compare(Building o1, Building o2) {
                            int i2;
                            int i1 = Algorithms.extractFirstIntegerNumber(o1.getName());
                            if (i1 == (i2 = Algorithms.extractFirstIntegerNumber(o2.getName()))) {
                                return 0;
                            }
                            return Algorithms.compare(i1, i2);
                        }
                    });
                }
                String lw = phrase.getUnknownWordToSearchBuilding();
                SearchPhrase.NameStringMatcher buildingMatch = phrase.getUnknownWordToSearchBuildingNameMatcher();
                SearchPhrase.NameStringMatcher startMatch = new SearchPhrase.NameStringMatcher(lw, CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH);
                int number = Algorithms.extractFirstIntegerNumber(lw);
                if (phrase.isSearchTypeAllowed(ObjectType.HOUSE)) {
                    for (Building b : s.getBuildings()) {
                        SearchResult res = new SearchResult(phrase);
                        boolean interpolation = false;
                        if (b.belongsToInterpolation(lw)) {
                            interpolation = true;
                        } else if ((number <= 0 || number != Algorithms.extractFirstIntegerNumber(b.getName()) || !lw.startsWith(b.getName().toLowerCase())) && !buildingMatch.matches(b.getName())) continue;
                        if (interpolation) {
                            res.localeName = lw;
                            res.location = b.getLocation(b.interpolation(lw));
                        } else {
                            res.localeName = b.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                            res.location = b.getLocation();
                        }
                        res.otherNames = b.getOtherNames(true);
                        res.object = b;
                        res.file = file;
                        res.priority = priority;
                        res.priorityDistance = 0.0;
                        res.firstUnknownWordMatches = startMatch.matches(res.localeName);
                        res.relatedObject = s;
                        res.localeRelatedObjectName = s.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                        res.objectType = ObjectType.HOUSE;
                        res.preferredZoom = 16;
                        resultMatcher.publish(res);
                    }
                }
                if (Algorithms.isEmpty(streetIntersection = phrase.getUnknownWordToSearch()) || !Character.isDigit(streetIntersection.charAt(0)) && CommonWords.getCommonSearch(streetIntersection) == -1 && phrase.isSearchTypeAllowed(ObjectType.STREET_INTERSECTION)) {
                    for (Street street : s.getIntersectedStreets()) {
                        SearchResult res = new SearchResult(phrase);
                        res.otherNames = street.getOtherNames(true);
                        res.localeName = street.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                        res.object = street;
                        if (!this.matchAddressName(phrase, null, res, false)) continue;
                        res.file = file;
                        res.relatedObject = s;
                        res.priority = priority + 1;
                        res.localeRelatedObjectName = s.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                        res.priorityDistance = 0.0;
                        res.objectType = ObjectType.STREET_INTERSECTION;
                        res.location = street.getLocation();
                        res.preferredZoom = 16;
                        phrase.countUnknownWordsMatchMainResult(res);
                        resultMatcher.publish(res);
                    }
                }
            }
            return true;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            if (SearchCoreFactory.isLastWordCityGroup(p)) {
                return 300;
            }
            if (!p.isLastWord(ObjectType.STREET)) {
                return -1;
            }
            return 100;
        }
    }

    public static class SearchStreetByCityAPI
    extends SearchBaseAPI {
        private static final int DEFAULT_ADDRESS_BBOX_RADIUS = 100000;
        private SearchBuildingAndIntersectionsByStreetAPI streetsAPI;
        private static int LIMIT = 10000;

        public SearchStreetByCityAPI(SearchBuildingAndIntersectionsByStreetAPI streetsAPI) {
            super(ObjectType.HOUSE, ObjectType.STREET, ObjectType.STREET_INTERSECTION);
            this.streetsAPI = streetsAPI;
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return phrase.getRadiusLevel() == 1 && this.getSearchPriority(phrase) != -1;
        }

        @Override
        public int getMinimalSearchRadius(SearchPhrase phrase) {
            return phrase.getRadiusSearch(100000);
        }

        @Override
        public int getNextSearchRadius(SearchPhrase phrase) {
            return phrase.getNextRadiusSearch(100000);
        }

        @Override
        public boolean search(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            SearchWord sw = phrase.getLastSelectedWord();
            if (SearchCoreFactory.isLastWordCityGroup(phrase) && sw.getResult() != null && sw.getResult().file != null) {
                City c = (City)sw.getResult().object;
                if (c.getStreets().isEmpty()) {
                    sw.getResult().file.preloadStreets(c, null, phrase.getSettings().getStat());
                }
                int limit = 0;
                for (Street object : c.getStreets()) {
                    SearchResult res = new SearchResult(phrase);
                    res.localeName = object.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                    res.otherNames = object.getOtherNames(true);
                    res.object = object;
                    boolean pub = true;
                    if (object.getName().startsWith("<")) {
                        pub = false;
                    } else if (phrase.isUnknownSearchWordPresent() && !this.matchAddressName(phrase, null, res, false)) continue;
                    res.localeRelatedObjectName = c.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                    res.preferredZoom = 17;
                    res.file = sw.getResult().file;
                    res.location = object.getLocation();
                    res.priority = 200.0;
                    res.objectType = ObjectType.STREET;
                    this.subSearchApiOrPublish(phrase, resultMatcher, res, this.streetsAPI, null, pub);
                    if (limit++ <= LIMIT) continue;
                    break;
                }
                return true;
            }
            return true;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            if (SearchCoreFactory.isLastWordCityGroup(p)) {
                return 200;
            }
            return -1;
        }
    }

    public static class SearchAmenityByTypeAPI
    extends SearchBaseAPI {
        private static final int BBOX_RADIUS = 10000;
        private static final int BBOX_RADIUS_NEAREST = 1000;
        private SearchAmenityTypesAPI searchAmenityTypesAPI;
        private MapPoiTypes types;
        private AbstractPoiType unselectedPoiType;
        private String nameFilter;

        public SearchAmenityByTypeAPI(MapPoiTypes types, SearchAmenityTypesAPI searchAmenityTypesAPI) {
            super(ObjectType.POI);
            this.types = types;
            this.searchAmenityTypesAPI = searchAmenityTypesAPI;
        }

        public AbstractPoiType getUnselectedPoiType() {
            return this.unselectedPoiType;
        }

        public String getNameFilter() {
            return this.nameFilter;
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return this.getSearchPriority(phrase) != -1 && super.isSearchMoreAvailable(phrase);
        }

        @Override
        public int getMinimalSearchRadius(SearchPhrase phrase) {
            return phrase.getRadiusSearch(10000);
        }

        @Override
        public int getNextSearchRadius(SearchPhrase phrase) {
            return phrase.getNextRadiusSearch(10000);
        }

        @Override
        public boolean search(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            this.unselectedPoiType = null;
            BinaryMapIndexReader.SearchPoiTypeFilter poiTypeFilter = null;
            BinaryMapIndexReader.SearchPoiAdditionalFilter poiAdditionalFilter = null;
            Object nameFilter = null;
            int countExtraWords = 0;
            LinkedHashSet<String> poiAdditionals = new LinkedHashSet<String>();
            if (phrase.isLastWord(ObjectType.POI_TYPE)) {
                Object obj = phrase.getLastSelectedWord().getResult().object;
                if (obj instanceof AbstractPoiType) {
                    poiTypeFilter = this.getPoiTypeFilter((AbstractPoiType)obj, poiAdditionals);
                } else if (obj instanceof BinaryMapIndexReader.SearchPoiTypeFilter) {
                    poiTypeFilter = (BinaryMapIndexReader.SearchPoiTypeFilter)obj;
                } else if (obj instanceof BinaryMapIndexReader.SearchPoiAdditionalFilter) {
                    poiTypeFilter = null;
                    poiAdditionalFilter = (BinaryMapIndexReader.SearchPoiAdditionalFilter)obj;
                } else {
                    throw new UnsupportedOperationException();
                }
                nameFilter = phrase.getUnknownSearchPhrase();
            } else if (this.searchAmenityTypesAPI != null && phrase.isNoSelectedType() && phrase.getFirstUnknownSearchWord().length() > 1) {
                SearchPhrase.NameStringMatcher nm = phrase.getFirstUnknownNameStringMatcher();
                SearchPhrase.NameStringMatcher nmAdditional = new SearchPhrase.NameStringMatcher(phrase.getFirstUnknownSearchWord(), CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS_FROM_SPACE);
                this.searchAmenityTypesAPI.initPoiTypes();
                Map<String, PoiTypeResult> poiTypeResults = this.searchAmenityTypesAPI.getPoiTypeResults(nm, nmAdditional);
                for (PoiTypeResult poiTypeResult : poiTypeResults.values()) {
                    for (String foundName : poiTypeResult.foundWords) {
                        int wordsInUnknownPart;
                        CollatorStringMatcher csm = new CollatorStringMatcher(foundName, CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH);
                        int mwords = SearchPhrase.countWords(foundName);
                        if (!csm.matches(phrase.getUnknownSearchPhrase()) || countExtraWords >= mwords) continue;
                        countExtraWords = SearchPhrase.countWords(foundName);
                        List<String> otherSearchWords = phrase.getUnknownSearchWords();
                        nameFilter = null;
                        if (countExtraWords - 1 < otherSearchWords.size()) {
                            nameFilter = "";
                            for (int k = countExtraWords - 1; k < otherSearchWords.size(); ++k) {
                                if (((String)nameFilter).length() > 0) {
                                    nameFilter = (String)nameFilter + " ";
                                }
                                nameFilter = (String)nameFilter + otherSearchWords.get(k);
                            }
                        }
                        poiTypeFilter = this.getPoiTypeFilter(poiTypeResult.pt, poiAdditionals);
                        this.unselectedPoiType = poiTypeResult.pt;
                        int wordsInPoiType = SearchPhrase.countWords(foundName);
                        if (wordsInPoiType != (wordsInUnknownPart = SearchPhrase.countWords(phrase.getUnknownSearchPhrase()))) continue;
                        phrase.setUnselectedPoiType(this.unselectedPoiType);
                    }
                }
            }
            this.nameFilter = nameFilter;
            if (poiTypeFilter != null || poiAdditionalFilter != null) {
                String name;
                int radius = 10000;
                if (poiTypeFilter != null && phrase.getRadiusLevel() == 1 && poiTypeFilter instanceof CustomSearchPoiFilter && "std_null".equals(name = ((CustomSearchPoiFilter)poiTypeFilter).getFilterId())) {
                    radius = 1000;
                }
                QuadRect bbox = phrase.getRadiusBBoxToSearch(radius);
                List<BinaryMapIndexReader> offlineIndexes = phrase.getOfflineIndexes();
                TreeSet<String> searchedPois = new TreeSet<String>();
                for (BinaryMapIndexReader r : offlineIndexes) {
                    ResultMatcher<Amenity> rm = this.getResultMatcher(phrase, poiTypeFilter, resultMatcher, (String)nameFilter, r, searchedPois, poiAdditionals, countExtraWords);
                    if (poiTypeFilter instanceof CustomSearchPoiFilter) {
                        rm = ((CustomSearchPoiFilter)poiTypeFilter).wrapResultMatcher(rm);
                    }
                    BinaryMapIndexReader.SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest((int)bbox.left, (int)bbox.right, (int)bbox.top, (int)bbox.bottom, -1, poiTypeFilter, poiAdditionalFilter, rm);
                    req.setSearchStat(phrase.getSettings().getStat());
                    r.searchPoi(req);
                    resultMatcher.apiSearchRegionFinished(this, r, phrase);
                }
            }
            return true;
        }

        private ResultMatcher<Amenity> getResultMatcher(final SearchPhrase phrase, BinaryMapIndexReader.SearchPoiTypeFilter poiTypeFilter, final SearchUICore.SearchResultMatcher resultMatcher, String nameFilter, final BinaryMapIndexReader selected, final Set<String> searchedPois, final Collection<String> poiAdditionals, final int countExtraWords) {
            final SearchPhrase.NameStringMatcher ns = nameFilter == null ? null : new SearchPhrase.NameStringMatcher(nameFilter, CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE);
            return new ResultMatcher<Amenity>(){

                @Override
                public boolean publish(Amenity object) {
                    if (phrase.getSettings().isExportObjects()) {
                        resultMatcher.exportObject(phrase, object);
                    }
                    SearchResult res = new SearchResult(phrase);
                    String poiID = object.getType().getKeyName() + "_" + object.getId();
                    if (!searchedPois.add(poiID)) {
                        return false;
                    }
                    if (object.isClosed()) {
                        return false;
                    }
                    if (!phrase.isAcceptPrivate() && object.isPrivateAccess()) {
                        return false;
                    }
                    if (!poiAdditionals.isEmpty()) {
                        boolean found = false;
                        for (String add : poiAdditionals) {
                            if (!object.getAdditionalInfoKeys().contains(add)) continue;
                            found = true;
                            break;
                        }
                        if (!found) {
                            return false;
                        }
                    }
                    res.localeName = object.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                    res.otherNames = object.getOtherNames(true);
                    if (Algorithms.isEmpty(res.localeName)) {
                        if (object.isRouteTrack()) {
                            res.localeName = object.getAdditionalInfo("route_id");
                        } else if (object.isRouteArticle()) {
                            res.localeName = SearchCoreFactory.getMapObjectName(object, phrase.getSettings());
                        }
                    }
                    if (Algorithms.isEmpty(res.localeName)) {
                        AbstractPoiType st = types.getAnyPoiTypeByKey(object.getSubType());
                        res.localeName = st != null ? st.getTranslation() : object.getSubType();
                    }
                    if (ns != null) {
                        if (ns.matches(res.localeName) || ns.matches(res.otherNames)) {
                            phrase.countUnknownWordsMatchMainResult(res, countExtraWords);
                        } else {
                            String ref = object.getTagContent("ref", null);
                            if (ref == null || !ns.matches(ref)) {
                                return false;
                            }
                            phrase.countUnknownWordsMatchMainResult(res, ref, countExtraWords);
                            res.localeName = res.localeName + " " + ref;
                        }
                    } else {
                        phrase.countUnknownWordsMatchMainResult(res, countExtraWords);
                    }
                    res.object = object;
                    res.cityName = object.getCityFromTagGroups(phrase.getSettings().getLang());
                    res.preferredZoom = 16;
                    res.file = selected;
                    res.location = object.getLocation();
                    res.priority = 300.0;
                    res.priorityDistance = 1.0;
                    res.objectType = ObjectType.POI;
                    resultMatcher.publish(res);
                    return false;
                }

                @Override
                public boolean isCancelled() {
                    return resultMatcher.isCancelled();
                }
            };
        }

        private BinaryMapIndexReader.SearchPoiTypeFilter getPoiTypeFilter(AbstractPoiType pt, Set<String> poiAdditionals) {
            final LinkedHashMap<PoiCategory, LinkedHashSet<String>> acceptedTypes = new LinkedHashMap<PoiCategory, LinkedHashSet<String>>();
            pt.putTypes(acceptedTypes);
            poiAdditionals.clear();
            if (pt.isAdditional()) {
                poiAdditionals.add(pt.getKeyName());
            }
            return new BinaryMapIndexReader.SearchPoiTypeFilter(){

                @Override
                public boolean isEmpty() {
                    return false;
                }

                @Override
                public boolean accept(PoiCategory type, String subtype) {
                    if (type == null) {
                        return true;
                    }
                    if (!types.isRegisteredType(type)) {
                        type = types.getOtherPoiCategory();
                    }
                    if (!acceptedTypes.containsKey(type)) {
                        return false;
                    }
                    LinkedHashSet set = (LinkedHashSet)acceptedTypes.get(type);
                    if (set == null) {
                        return true;
                    }
                    return set.contains(subtype);
                }
            };
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            if (p.isLastWord(ObjectType.POI_TYPE) && p.getLastTokenLocation() != null || p.isNoSelectedType()) {
                return 300;
            }
            return -1;
        }
    }

    public static class SearchAmenityTypesAPI
    extends SearchBaseAPI {
        public static final String STD_POI_FILTER_PREFIX = "std_";
        private static final int BBOX_RADIUS = 10000;
        private Map<String, PoiType> translatedNames = new LinkedHashMap<String, PoiType>();
        private List<AbstractPoiType> topVisibleFilters;
        private List<PoiCategory> categories;
        private List<CustomSearchPoiFilter> customPoiFilters = new ArrayList<CustomSearchPoiFilter>();
        private Map<String, Integer> activePoiFilters = new HashMap<String, Integer>();
        private MapPoiTypes types;
        private Map<BinaryMapIndexReader, Set<String>> poiAdditionalTopIndexCache = new HashMap<BinaryMapIndexReader, Set<String>>();

        public SearchAmenityTypesAPI(MapPoiTypes types) {
            super(ObjectType.POI_TYPE);
            this.types = types;
        }

        public void clearCustomFilters() {
            this.customPoiFilters.clear();
            this.activePoiFilters.clear();
        }

        public void addCustomFilter(CustomSearchPoiFilter poiFilter, int priority) {
            this.customPoiFilters.add(poiFilter);
            if (priority > 0) {
                this.activePoiFilters.put(poiFilter.getFilterId(), priority);
            }
        }

        public void setActivePoiFiltersByOrder(List<String> filterOrder) {
            for (int i = 0; i < filterOrder.size(); ++i) {
                this.activePoiFilters.put(filterOrder.get(i), i);
            }
        }

        public Map<String, PoiTypeResult> getPoiTypeResults(SearchPhrase.NameStringMatcher nm, SearchPhrase.NameStringMatcher nmAdditional) {
            PoiTypeResult res;
            LinkedHashMap<String, PoiTypeResult> results = new LinkedHashMap<String, PoiTypeResult>();
            for (AbstractPoiType pf : this.topVisibleFilters) {
                res = this.checkPoiType(nm, pf);
                if (res == null) continue;
                results.put(res.pt.getKeyName(), res);
            }
            for (PoiCategory c : this.categories) {
                res = this.checkPoiType(nm, c);
                if (res != null) {
                    results.put(res.pt.getKeyName(), res);
                }
                if (nmAdditional != null) {
                    this.addAditonals(nmAdditional, results, c);
                }
                for (PoiFilter pf : c.getPoiFilters()) {
                    PoiTypeResult filtRes = this.checkPoiType(nm, pf);
                    if (filtRes == null) continue;
                    results.put(filtRes.pt.getKeyName(), filtRes);
                }
            }
            LinkedHashMap<String, PoiTypeResult> additionals = new LinkedHashMap<String, PoiTypeResult>();
            for (Map.Entry<String, PoiType> e : this.translatedNames.entrySet()) {
                PoiType pt = e.getValue();
                if (pt.getCategory() == this.types.getOtherMapCategory() || pt.isReference()) continue;
                PoiTypeResult res2 = this.checkPoiType(nm, pt);
                if (res2 != null) {
                    results.put(res2.pt.getKeyName(), res2);
                }
                if (nmAdditional == null) continue;
                this.addAditonals(nmAdditional, additionals, pt);
            }
            results.putAll(additionals);
            return results;
        }

        private void addAditonals(SearchPhrase.NameStringMatcher nm, Map<String, PoiTypeResult> results, AbstractPoiType pt) {
            List<PoiType> additionals = pt.getPoiAdditionals();
            if (additionals != null) {
                for (PoiType a : additionals) {
                    PoiTypeResult ptr;
                    if (a.getReferenceType() != null) continue;
                    PoiTypeResult existingResult = results.get(a.getKeyName());
                    if (existingResult != null) {
                        PoiAdditionalCustomFilter f = existingResult.pt instanceof PoiAdditionalCustomFilter ? (PoiAdditionalCustomFilter)existingResult.pt : new PoiAdditionalCustomFilter(this.types, (PoiType)existingResult.pt);
                        if (!f.additionalPoiTypes.contains(a)) {
                            f.additionalPoiTypes.add(a);
                        }
                        existingResult.pt = f;
                        continue;
                    }
                    String enTranslation = a.getEnTranslation().toLowerCase();
                    if ("no".equals(enTranslation) || (ptr = this.checkPoiType(nm, a)) == null || ptr.pt == null || !ptr.pt.isTopVisible()) continue;
                    results.put(a.getKeyName(), ptr);
                }
            }
        }

        private PoiTypeResult checkPoiType(SearchPhrase.NameStringMatcher nm, AbstractPoiType pf) {
            PoiTypeResult res = null;
            if (nm.matches(pf.getTranslation())) {
                res = this.addIfMatch(nm, pf.getTranslation(), pf, res);
            }
            if (nm.matches(pf.getEnTranslation())) {
                res = this.addIfMatch(nm, pf.getEnTranslation(), pf, res);
            }
            if (nm.matches(pf.getKeyName())) {
                res = this.addIfMatch(nm, pf.getKeyName().replace('_', ' '), pf, res);
            }
            if (nm.matches(pf.getSynonyms())) {
                String[] synonyms;
                for (String synonym : synonyms = pf.getSynonyms().split(";")) {
                    res = this.addIfMatch(nm, synonym, pf, res);
                }
            }
            return res;
        }

        private PoiTypeResult addIfMatch(SearchPhrase.NameStringMatcher nm, String s, AbstractPoiType pf, PoiTypeResult res) {
            if (nm.matches(s)) {
                if (res == null) {
                    res = new PoiTypeResult();
                    res.pt = pf;
                }
                res.foundWords.add(s);
            }
            return res;
        }

        private void initPoiTypes() {
            if (this.translatedNames.isEmpty()) {
                this.translatedNames = this.types.getAllTranslatedNames(false);
                this.topVisibleFilters = this.types.getTopVisibleFilters();
                this.topVisibleFilters.remove(this.types.getOsmwiki());
                this.categories = this.types.getCategories(false);
                if (DISPLAY_DEFAULT_POI_TYPES) {
                    ArrayList<String> order = new ArrayList<String>();
                    for (AbstractPoiType p : this.topVisibleFilters) {
                        order.add(this.getStandardFilterId(p));
                    }
                    CustomSearchPoiFilter nearestPois = new CustomSearchPoiFilter(){

                        @Override
                        public boolean isEmpty() {
                            return false;
                        }

                        @Override
                        public boolean accept(PoiCategory type, String subcategory) {
                            return true;
                        }

                        @Override
                        public ResultMatcher<Amenity> wrapResultMatcher(ResultMatcher<Amenity> matcher) {
                            return matcher;
                        }

                        @Override
                        public String getName() {
                            return "Neareset POIs";
                        }

                        @Override
                        public Object getIconResource() {
                            return null;
                        }

                        @Override
                        public String getFilterId() {
                            return "nearest_pois";
                        }
                    };
                    this.setActivePoiFiltersByOrder(order);
                    this.addCustomFilter(nearestPois, 100);
                }
            }
        }

        @Override
        public boolean search(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            SearchResult res;
            boolean showTopFiltersOnly = !phrase.isUnknownSearchWordPresent();
            SearchPhrase.NameStringMatcher nm = phrase.getFirstUnknownNameStringMatcher();
            this.initPoiTypes();
            if (showTopFiltersOnly) {
                for (AbstractPoiType pt : this.topVisibleFilters) {
                    res = new SearchResult(phrase);
                    res.localeName = pt.getTranslation();
                    res.object = pt;
                    this.addPoiTypeResult(phrase, resultMatcher, showTopFiltersOnly, this.getStandardFilterId(pt), res);
                }
            } else {
                boolean includeAdditional = !phrase.hasMoreThanOneUnknownSearchWord();
                SearchPhrase.NameStringMatcher nmAdditional = includeAdditional ? new SearchPhrase.NameStringMatcher(phrase.getFirstUnknownSearchWord(), CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS_FROM_SPACE) : null;
                Map<String, PoiTypeResult> poiTypes = this.getPoiTypeResults(nm, nmAdditional);
                poiTypes = this.filterTypes(poiTypes);
                PoiTypeResult wikiCategory = poiTypes.get("osmwiki");
                PoiTypeResult wikiType = poiTypes.get("wiki_place");
                if (wikiCategory != null && wikiType != null) {
                    poiTypes.remove("wiki_place");
                }
                for (PoiTypeResult ptr : poiTypes.values()) {
                    boolean match;
                    boolean bl = match = !phrase.isFirstUnknownSearchWordComplete();
                    if (!match) {
                        String foundName;
                        CollatorStringMatcher csm;
                        Iterator<String> iterator = ptr.foundWords.iterator();
                        while (iterator.hasNext() && !(match = (csm = new CollatorStringMatcher(foundName = iterator.next(), CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH)).matches(phrase.getUnknownSearchPhrase()))) {
                        }
                    }
                    if (!match) continue;
                    SearchResult res2 = new SearchResult(phrase);
                    res2.localeName = "osmwiki".equals(ptr.pt.getKeyName()) ? ptr.pt.getTranslation() + " (" + this.types.getAllLanguagesTranslationSuffix() + ")" : ptr.pt.getTranslation();
                    res2.object = ptr.pt;
                    this.addPoiTypeResult(phrase, resultMatcher, showTopFiltersOnly, this.getStandardFilterId(ptr.pt), res2);
                }
            }
            for (int i = 0; i < this.customPoiFilters.size(); ++i) {
                CustomSearchPoiFilter csf = this.customPoiFilters.get(i);
                if (!showTopFiltersOnly && !nm.matches(csf.getName())) continue;
                res = new SearchResult(phrase);
                res.localeName = csf.getName();
                res.object = csf;
                this.addPoiTypeResult(phrase, resultMatcher, showTopFiltersOnly, csf.getFilterId(), res);
            }
            this.searchTopIndexPoiAdditional(phrase, resultMatcher);
            return true;
        }

        private Map<String, PoiTypeResult> filterTypes(Map<String, PoiTypeResult> poiTypes) {
            LinkedHashMap<String, PoiTypeResult> filtered = new LinkedHashMap<String, PoiTypeResult>();
            for (PoiTypeResult ptr : poiTypes.values()) {
                AbstractPoiType abstractPoiType = ptr.pt;
                if (abstractPoiType instanceof PoiAdditionalCustomFilter) {
                    PoiAdditionalCustomFilter pt = (PoiAdditionalCustomFilter)abstractPoiType;
                    if (pt.getPoiAdditionalCategory() != null) {
                        filtered.put(ptr.pt.getKeyName(), ptr);
                        continue;
                    }
                    pt.additionalPoiTypes.forEach(t -> {
                        if (t.getPoiAdditionalCategory() != null) {
                            filtered.put(ptr.pt.getKeyName(), ptr);
                        }
                    });
                    continue;
                }
                filtered.put(ptr.pt.getKeyName(), ptr);
            }
            return filtered;
        }

        private void addPoiTypeResult(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher, boolean showTopFiltersOnly, String stdFilterId, SearchResult res) {
            res.priorityDistance = 0.0;
            res.objectType = ObjectType.POI_TYPE;
            res.firstUnknownWordMatches = true;
            if (showTopFiltersOnly) {
                if (this.activePoiFilters.containsKey(stdFilterId)) {
                    res.priority = this.getPoiTypePriority(stdFilterId);
                    resultMatcher.publish(res);
                }
            } else {
                phrase.countUnknownWordsMatchMainResult(res);
                res.priority = 100.0;
                resultMatcher.publish(res);
            }
        }

        private int getPoiTypePriority(String stdFilterId) {
            Integer i = this.activePoiFilters.get(stdFilterId);
            if (i == null) {
                return 100;
            }
            return 100 + i;
        }

        public String getStandardFilterId(AbstractPoiType poi) {
            return STD_POI_FILTER_PREFIX + poi.getKeyName();
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return false;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            if (p.hasObjectType(ObjectType.POI) || p.hasObjectType(ObjectType.POI_TYPE)) {
                return -1;
            }
            if (!p.isNoSelectedType() && !p.isUnknownSearchWordPresent()) {
                return -1;
            }
            SearchWord lastSelectedWord = p.getLastSelectedWord();
            if (lastSelectedWord != null && ObjectType.isAddress(lastSelectedWord.getType())) {
                return -1;
            }
            return 100;
        }

        private void initPoiAdditionalTopIndex(BinaryMapIndexReader r) throws IOException {
            if (this.poiAdditionalTopIndexCache.containsKey(r)) {
                return;
            }
            List<BinaryMapPoiReaderAdapter.PoiSubType> poiSubTypes = r.getTopIndexSubTypes();
            if (poiSubTypes.size() == 0) {
                return;
            }
            HashSet<String> names = new HashSet<String>();
            for (BinaryMapPoiReaderAdapter.PoiSubType subType : poiSubTypes) {
                if (subType.possibleValues == null) continue;
                names.addAll(subType.possibleValues);
            }
            ArrayList<String> translation = new ArrayList<String>();
            for (String v : names) {
                String translate = this.getTopIndexTranslation(v);
                translation.add(translate);
            }
            names.addAll(translation);
            if (names.size() > 0) {
                this.poiAdditionalTopIndexCache.put(r, names);
            }
        }

        public void searchTopIndexPoiAdditional(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            if (phrase.isEmpty()) {
                return;
            }
            Iterator<BinaryMapIndexReader> offlineIndexes = phrase.getRadiusOfflineIndexes(10000, SearchPhrase.SearchPhraseDataType.POI);
            SearchPhrase.NameStringMatcher nm = phrase.getMainUnknownNameStringMatcher();
            HashMap<String, HashSet> matchedValues = new HashMap<String, HashSet>();
            while (offlineIndexes.hasNext()) {
                TopIndexMatch match;
                BinaryMapIndexReader r = offlineIndexes.next();
                this.initPoiAdditionalTopIndex(r);
                if (!this.poiAdditionalTopIndexCache.containsKey(r) || !nm.matches((Collection<String>)this.poiAdditionalTopIndexCache.get(r)) || (match = this.matchTopIndex(r, phrase)) == null || matchedValues.containsKey(match.subType.name) && ((HashSet)matchedValues.get(match.subType.name)).contains(match.value)) continue;
                SearchResult res = new SearchResult(phrase);
                res.localeName = match.translatedValue;
                res.object = new TopIndexFilter(match.subType, this.types, match.value);
                this.addPoiTypeResult(phrase, resultMatcher, false, null, res);
                HashSet values = matchedValues.computeIfAbsent(match.subType.name, s -> new HashSet());
                values.add(match.value);
            }
        }

        private TopIndexMatch matchTopIndex(BinaryMapIndexReader r, SearchPhrase phrase) throws IOException {
            String search = phrase.getUnknownSearchPhrase();
            boolean complete = phrase.isFirstUnknownSearchWordComplete();
            List<BinaryMapPoiReaderAdapter.PoiSubType> poiSubTypes = r.getTopIndexSubTypes();
            String lang = phrase.getSettings().getLang();
            ArrayList<TopIndexMatch> matches = new ArrayList<TopIndexMatch>();
            Collator collator = OsmAndCollator.primaryCollator();
            SearchPhrase.NameStringMatcher nm = new SearchPhrase.NameStringMatcher(search, CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH);
            for (BinaryMapPoiReaderAdapter.PoiSubType subType : poiSubTypes) {
                String topIndexValue = null;
                String translate = null;
                ArrayList<String> possibleValues = new ArrayList<String>(subType.possibleValues);
                Collections.sort(possibleValues);
                for (String s : possibleValues) {
                    translate = this.getTopIndexTranslation(s);
                    String normalizeBrand = s.toLowerCase(Locale.ROOT);
                    if (complete) {
                        if (CollatorStringMatcher.cmatches(collator, search, normalizeBrand, CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH)) {
                            topIndexValue = s;
                            break;
                        }
                        if (!CollatorStringMatcher.cmatches(collator, search, translate, CollatorStringMatcher.StringMatcherMode.CHECK_ONLY_STARTS_WITH)) continue;
                        topIndexValue = s;
                        break;
                    }
                    if (!nm.matches(s) && !nm.matches(translate)) continue;
                    topIndexValue = s;
                    break;
                }
                if (topIndexValue == null) continue;
                TopIndexMatch topIndexMatch = new TopIndexMatch(subType, topIndexValue, translate);
                if (!Algorithms.isEmpty(lang) && subType.name.contains(":" + lang)) {
                    return topIndexMatch;
                }
                matches.add(topIndexMatch);
            }
            for (TopIndexMatch m : matches) {
                if (m.subType.name.contains(":")) continue;
                return m;
            }
            if (matches.size() > 0) {
                return (TopIndexMatch)matches.get(0);
            }
            return null;
        }

        private String getTopIndexTranslation(String value) {
            String key = TopIndexFilter.getValueKey(value);
            String translate = this.types.getPoiTranslation(key);
            if (translate.toLowerCase(Locale.ROOT).equals(key)) {
                translate = value;
            }
            return translate;
        }
    }

    protected static class PoiTypeResult {
        public AbstractPoiType pt;
        public Set<String> foundWords = new LinkedHashSet<String>();

        protected PoiTypeResult() {
        }
    }

    public static class SearchAmenityByNameAPI
    extends SearchBaseAPI {
        private static final int LIMIT = 10000;
        private static final int BBOX_RADIUS = 500000;
        private static final int BBOX_RADIUS_INSIDE = 5600000;
        private static final int BBOX_RADIUS_POI_IN_CITY = 25000;
        private static final int FIRST_WORD_MIN_LENGTH = 3;

        public SearchAmenityByNameAPI() {
            super(ObjectType.POI);
        }

        @Override
        public boolean search(final SearchPhrase phrase, final SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            if (!phrase.isUnknownSearchWordPresent()) {
                return false;
            }
            if (!phrase.isNoSelectedType()) {
                return false;
            }
            final BinaryMapIndexReader[] currentFile = new BinaryMapIndexReader[1];
            Iterator<BinaryMapIndexReader> offlineIterator = phrase.getRadiusOfflineIndexes(500000, SearchPhrase.SearchPhraseDataType.POI);
            String searchWord = phrase.getUnknownWordToSearch();
            final SearchPhrase.NameStringMatcher nm = phrase.getMainUnknownNameStringMatcher();
            QuadRect bbox = phrase.getFileRequest() != null ? phrase.getRadiusBBoxToSearch(25000) : phrase.getRadiusBBoxToSearch(5600000);
            final HashSet ids = new HashSet();
            ResultMatcher<Amenity> rawDataCollector = null;
            if (phrase.getSettings().isExportObjects()) {
                rawDataCollector = new ResultMatcher<Amenity>(){

                    @Override
                    public boolean publish(Amenity object) {
                        resultMatcher.exportObject(phrase, object);
                        return true;
                    }

                    @Override
                    public boolean isCancelled() {
                        return false;
                    }
                };
            }
            ResultMatcher<Amenity> matcher = new ResultMatcher<Amenity>(){
                int limit = 0;

                @Override
                public boolean publish(Amenity object) {
                    if (phrase.getSettings().isExportObjects()) {
                        resultMatcher.exportObject(phrase, object);
                    }
                    if (this.limit++ > 10000) {
                        return false;
                    }
                    String poiID = object.getType().getKeyName() + "_" + object.getId();
                    if (ids.contains(poiID)) {
                        return false;
                    }
                    SearchResult sr = new SearchResult(phrase);
                    sr.otherNames = object.getOtherNames(true);
                    sr.localeName = object.getName(phrase.getSettings().getLang());
                    if (!nm.matches(sr.localeName)) {
                        sr.localeName = object.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                    }
                    if (!nm.matches(sr.localeName) && !nm.matches(sr.otherNames)) {
                        for (String k : object.getAdditionalInfoKeys()) {
                            if (!ObfConstants.isTagIndexedForSearchAsName(k) && !ObfConstants.isTagIndexedForSearchAsId(k) || !nm.matches(object.getAdditionalInfo(k))) continue;
                            sr.alternateName = object.getAdditionalInfo(k);
                            break;
                        }
                        if (Algorithms.isEmpty(sr.alternateName)) {
                            return false;
                        }
                    }
                    sr.object = object;
                    sr.preferredZoom = 16;
                    sr.file = currentFile[0];
                    sr.location = object.getLocation();
                    if (object.getSubType().equals("city") || object.getSubType().equals("country")) {
                        sr.priorityDistance = 0.001;
                        sr.preferredZoom = object.getSubType().equals("country") ? 7 : 13;
                    } else {
                        sr.priorityDistance = object.getSubType().equals("town") ? 0.005 : 1.0;
                    }
                    sr.priority = 500.0;
                    phrase.countUnknownWordsMatchMainResult(sr);
                    sr.cityName = object.getCityFromTagGroups(phrase.getSettings().getLang());
                    sr.objectType = ObjectType.POI;
                    resultMatcher.publish(sr);
                    ids.add(poiID);
                    return phrase.getSettings().getStat() != null;
                }

                @Override
                public boolean isCancelled() {
                    return resultMatcher.isCancelled() && this.limit < 10000;
                }
            };
            BinaryMapIndexReader.SearchRequest<Amenity> req = BinaryMapIndexReader.buildSearchPoiRequest((int)bbox.centerX(), (int)bbox.centerY(), searchWord, (int)bbox.left, (int)bbox.right, (int)bbox.top, (int)bbox.bottom, matcher, rawDataCollector);
            req.setSearchStat(phrase.getSettings().getStat());
            BinaryMapIndexReader.SearchRequest<Amenity> reqUnlimited = BinaryMapIndexReader.buildSearchPoiRequest((int)bbox.centerX(), (int)bbox.centerY(), searchWord, 0, Integer.MAX_VALUE, 0, Integer.MAX_VALUE, matcher, rawDataCollector);
            reqUnlimited.setSearchStat(phrase.getSettings().getStat());
            BinaryMapIndexReader fileRequest = phrase.getFileRequest();
            if (fileRequest != null) {
                fileRequest.searchPoiByName(req);
                resultMatcher.apiSearchRegionFinished(this, fileRequest, phrase);
            } else {
                while (offlineIterator.hasNext()) {
                    BinaryMapIndexReader r;
                    currentFile[0] = r = offlineIterator.next();
                    r.searchPoiByName(r.isBasemap() ? reqUnlimited : req);
                    resultMatcher.apiSearchRegionFinished(this, r, phrase);
                }
            }
            return true;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            if (p.hasObjectType(ObjectType.POI) || !p.isUnknownSearchWordPresent()) {
                return -1;
            }
            if (p.hasObjectType(ObjectType.POI_TYPE)) {
                return -1;
            }
            if (p.getUnknownWordToSearch().length() >= 3 || p.isFirstUnknownSearchWordComplete()) {
                return 500;
            }
            return -1;
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return super.isSearchMoreAvailable(phrase) && this.getSearchPriority(phrase) != -1;
        }

        @Override
        public int getMinimalSearchRadius(SearchPhrase phrase) {
            return phrase.getRadiusSearch(500000);
        }

        @Override
        public int getNextSearchRadius(SearchPhrase phrase) {
            return phrase.getNextRadiusSearch(500000);
        }
    }

    public static class SearchAddressByNameAPI
    extends SearchBaseAPI {
        private static final int DEFAULT_ADDRESS_BBOX_RADIUS = 100000;
        private static final int LIMIT = 10000;
        private Set<String> townCitiesInit = new LinkedHashSet<String>();
        private QuadTree<City> townCitiesQR = new QuadTree(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 12, 0.55f);
        private QuadTree<City> boundariesQR = new QuadTree(new QuadRect(0.0, 0.0, 2.147483647E9, 2.147483647E9), 12, 0.55f);
        private List<City> resArray = new ArrayList<City>();
        private SearchStreetByCityAPI cityApi;
        private SearchBuildingAndIntersectionsByStreetAPI streetsApi;

        public SearchAddressByNameAPI(SearchBuildingAndIntersectionsByStreetAPI streetsApi, SearchStreetByCityAPI cityApi) {
            super(ObjectType.CITY, ObjectType.VILLAGE, ObjectType.BOUNDARY, ObjectType.POSTCODE, ObjectType.STREET, ObjectType.HOUSE, ObjectType.STREET_INTERSECTION);
            this.streetsApi = streetsApi;
            this.cityApi = cityApi;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            if (!p.isNoSelectedType() && p.getRadiusLevel() == 1) {
                return -1;
            }
            if (p.isLastWord(ObjectType.POI) || p.isLastWord(ObjectType.POI_TYPE)) {
                return -1;
            }
            if (p.isNoSelectedType()) {
                return 500;
            }
            return 500;
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return this.getSearchPriority(phrase) != -1 && super.isSearchMoreAvailable(phrase);
        }

        @Override
        public int getMinimalSearchRadius(SearchPhrase phrase) {
            return phrase.getRadiusSearch(100000);
        }

        @Override
        public int getNextSearchRadius(SearchPhrase phrase) {
            return phrase.getNextRadiusSearch(100000);
        }

        @Override
        public boolean search(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            if (!phrase.isUnknownSearchWordPresent() && !phrase.isEmptyQueryAllowed()) {
                return false;
            }
            if (phrase.isNoSelectedType() || phrase.isLastWord(ObjectType.BOUNDARY, ObjectType.REGION) || phrase.isLastWord(ObjectType.CITY, ObjectType.VILLAGE, ObjectType.POSTCODE) || phrase.getRadiusLevel() >= 2) {
                this.initAndSearchCities(phrase, resultMatcher);
                this.searchByName(phrase, resultMatcher);
            }
            return true;
        }

        private void initAndSearchCities(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            QuadRect bbox = phrase.getRadiusBBoxToSearch(500000);
            Iterator<BinaryMapIndexReader> offlineIndexes = phrase.getOfflineIndexes(bbox, SearchPhrase.SearchPhraseDataType.ADDRESS);
            while (offlineIndexes.hasNext()) {
                int[] bbox31;
                QuadRect qr;
                int x;
                int y;
                LatLon cl;
                BinaryMapIndexReader r = offlineIndexes.next();
                if (this.townCitiesInit.contains(r.getRegionName())) continue;
                List<City> l = r.getCities(null, BinaryMapAddressReaderAdapter.CityBlocks.CITY_TOWN_TYPE, null, phrase.getSettings().getStat());
                this.townCitiesInit.add(r.getRegionName());
                for (City c : l) {
                    if (phrase.getSettings().isExportObjects()) {
                        resultMatcher.exportCity(phrase, c);
                    }
                    c.setReferenceFile(r);
                    cl = c.getLocation();
                    y = MapUtils.get31TileNumberY(cl.getLatitude());
                    x = MapUtils.get31TileNumberX(cl.getLongitude());
                    qr = new QuadRect(x, y, x, y);
                    bbox31 = c.getBbox31();
                    if (bbox31 != null) {
                        qr = new QuadRect(bbox31[0], bbox31[1], bbox31[2], bbox31[3]);
                    }
                    this.townCitiesQR.insert(c, qr);
                }
                l = r.getCities(null, BinaryMapAddressReaderAdapter.CityBlocks.BOUNDARY_TYPE, null, phrase.getSettings().getStat());
                for (City c : l) {
                    if (phrase.getSettings().isExportObjects()) {
                        resultMatcher.exportCity(phrase, c);
                    }
                    c.setReferenceFile(r);
                    cl = c.getLocation();
                    y = MapUtils.get31TileNumberY(cl.getLatitude());
                    x = MapUtils.get31TileNumberX(cl.getLongitude());
                    qr = new QuadRect(x, y, x, y);
                    bbox31 = c.getBbox31();
                    if (bbox31 != null) {
                        qr = new QuadRect(bbox31[0], bbox31[1], bbox31[2], bbox31[3]);
                    }
                    this.boundariesQR.insert(c, qr);
                }
            }
            if (phrase.isNoSelectedType() && bbox != null && (phrase.isUnknownSearchWordPresent() || phrase.isEmptyQueryAllowed()) && phrase.isSearchTypeAllowed(ObjectType.CITY)) {
                SearchPhrase.NameStringMatcher nm = phrase.getMainUnknownNameStringMatcher();
                this.resArray.clear();
                this.resArray = this.townCitiesQR.queryInBox(bbox, this.resArray);
                int limit = 0;
                for (City c : this.resArray) {
                    SearchResult res = new SearchResult(phrase);
                    res.object = c;
                    res.file = (BinaryMapIndexReader)c.getReferenceFile();
                    res.localeName = c.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                    res.otherNames = c.getOtherNames(true);
                    res.localeRelatedObjectName = res.file.getRegionName();
                    res.relatedObject = res.file;
                    res.location = c.getLocation();
                    res.priority = 500.0;
                    res.priorityDistance = 0.1;
                    res.objectType = ObjectType.CITY;
                    if (phrase.isEmptyQueryAllowed() && phrase.isEmpty()) {
                        resultMatcher.publish(res);
                    } else if (nm.matches(res.localeName) || nm.matches(res.otherNames)) {
                        this.subSearchApiOrPublish(phrase, resultMatcher, res, this.cityApi);
                    }
                    if (limit++ <= 10000 * phrase.getRadiusLevel()) continue;
                    break;
                }
            }
        }

        private void searchByName(final SearchPhrase phrase, final SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            if (phrase.getRadiusLevel() > 1 || phrase.getUnknownWordToSearch().length() > 3 || phrase.hasMoreThanOneUnknownSearchWord() || phrase.isSearchTypeAllowed(ObjectType.POSTCODE, true)) {
                final boolean locSpecified = phrase.getLastTokenLocation() != null;
                LatLon loc = phrase.getLastTokenLocation();
                final ArrayList immediateResults = new ArrayList();
                final QuadRect postcodeBbox = phrase.getRadiusBBoxToSearch(500000);
                final QuadRect villagesBbox = phrase.getRadiusBBoxToSearch(300000);
                final QuadRect cityBbox = phrase.getRadiusBBoxToSearch(500000);
                final int priority = phrase.isNoSelectedType() ? 500 : 500;
                final BinaryMapIndexReader[] currentFile = new BinaryMapIndexReader[1];
                ResultMatcher<MapObject> rm = new ResultMatcher<MapObject>(){
                    int limit = 0;

                    @Override
                    public boolean publish(MapObject object) {
                        if (this.isCancelled()) {
                            return false;
                        }
                        SearchResult sr = new SearchResult(phrase);
                        sr.object = object;
                        sr.file = currentFile[0];
                        sr.localeName = object.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                        sr.otherNames = object.getOtherNames(true);
                        sr.localeRelatedObjectName = sr.file.getRegionName();
                        sr.relatedObject = sr.file;
                        sr.location = object.getLocation();
                        sr.priorityDistance = 1.0;
                        sr.priority = priority;
                        int y = MapUtils.get31TileNumberY(object.getLocation().getLatitude());
                        int x = MapUtils.get31TileNumberX(object.getLocation().getLongitude());
                        List<City> closestCities = null;
                        if (object instanceof Street) {
                            if (!phrase.isSearchTypeAllowed(ObjectType.STREET)) {
                                return false;
                            }
                            if (object.getName().startsWith("<")) {
                                return false;
                            }
                            sr.objectType = ObjectType.STREET;
                            sr.localeRelatedObjectName = ((Street)object).getCity().getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                            sr.relatedObject = ((Street)object).getCity();
                        } else if (object instanceof City && !SearchCoreFactory.isLastWordCityGroup(phrase)) {
                            City.CityType type = ((City)object).getType();
                            if (type == City.CityType.CITY || type == City.CityType.TOWN) {
                                if (phrase.isNoSelectedType()) {
                                    return false;
                                }
                                if (locSpecified && !cityBbox.contains(x, y, x, y) || !phrase.isSearchTypeAllowed(ObjectType.CITY)) {
                                    return false;
                                }
                                sr.objectType = ObjectType.CITY;
                                sr.priorityDistance = 0.1;
                            } else if (type == City.CityType.POSTCODE) {
                                if (locSpecified && !postcodeBbox.contains(x, y, x, y) || !phrase.isSearchTypeAllowed(ObjectType.POSTCODE)) {
                                    return false;
                                }
                                sr.objectType = ObjectType.POSTCODE;
                                sr.priorityDistance = 0.0;
                            } else if (type == City.CityType.BOUNDARY) {
                                if (locSpecified && !villagesBbox.contains(x, y, x, y) || !phrase.isSearchTypeAllowed(ObjectType.BOUNDARY)) {
                                    return false;
                                }
                                sr.objectType = ObjectType.BOUNDARY;
                                sr.priorityDistance = 0.0;
                                phrase.countUnknownWordsMatchMainResult(sr);
                            } else if (type == City.CityType.HAMLET || type == City.CityType.SUBURB || type == City.CityType.VILLAGE) {
                                if (locSpecified && !villagesBbox.contains(x, y, x, y) || !phrase.isSearchTypeAllowed(ObjectType.VILLAGE)) {
                                    return false;
                                }
                                MapObject closestCity = null;
                                if (closestCities == null) {
                                    closestCities = townCitiesQR.queryInBox(villagesBbox, new ArrayList());
                                }
                                double minDist = -1.0;
                                double pDist = -1.0;
                                for (City city : closestCities) {
                                    double pd;
                                    double ll = MapUtils.getDistance(city.getLocation(), object.getLocation());
                                    double d = pd = city.getType() == City.CityType.CITY ? ll : ll * 10.0;
                                    if (minDist != -1.0 && !(pd < pDist)) continue;
                                    closestCity = city;
                                    minDist = ll;
                                    pDist = pd;
                                }
                                if (closestCity != null) {
                                    sr.localeRelatedObjectName = closestCity.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                                    sr.relatedObject = closestCity;
                                    sr.distRelatedObjectName = minDist;
                                }
                                sr.objectType = ObjectType.VILLAGE;
                            }
                        } else {
                            return false;
                        }
                        ++this.limit;
                        immediateResults.add(sr);
                        return phrase.getSettings().getStat() != null;
                    }

                    @Override
                    public boolean isCancelled() {
                        return this.limit > 10000 * phrase.getRadiusLevel() || resultMatcher.isCancelled();
                    }
                };
                ResultMatcher<MapObject> rawDataCollector = null;
                if (phrase.getSettings().isExportObjects()) {
                    rawDataCollector = new ResultMatcher<MapObject>(){

                        @Override
                        public boolean publish(MapObject object) {
                            resultMatcher.exportObject(phrase, object);
                            return true;
                        }

                        @Override
                        public boolean isCancelled() {
                            return false;
                        }
                    };
                }
                SearchWord lastWord = phrase.getLastSelectedWord();
                Iterator<BinaryMapIndexReader> offlineIterator = phrase.getRadiusOfflineIndexes(500000, SearchPhrase.SearchPhraseDataType.ADDRESS);
                String wordToSearch = phrase.getUnknownWordToSearch();
                Set<String> wordToSearchSplit = this.splitAddressSearchNames(wordToSearch);
                if (wordToSearchSplit.size() > 1) {
                    wordToSearch = phrase.selectMainUnknownWordToSearch(new ArrayList<String>(wordToSearchSplit));
                }
                BinaryMapIndexReader.SearchRequest<MapObject> req = BinaryMapIndexReader.buildAddressByNameRequest(rm, rawDataCollector, wordToSearch.toLowerCase(), phrase.isMainUnknownSearchWordComplete() ? CollatorStringMatcher.StringMatcherMode.CHECK_EQUALS_FROM_SPACE : CollatorStringMatcher.StringMatcherMode.CHECK_STARTS_FROM_SPACE);
                if (locSpecified) {
                    QuadRect rect;
                    Object object;
                    if (lastWord != null && lastWord.getResult() != null && (object = lastWord.getResult().object) instanceof City) {
                        City c = (City)object;
                        int x31 = MapUtils.get31TileNumberX(c.getLocation().getLongitude());
                        int y31 = MapUtils.get31TileNumberY(c.getLocation().getLatitude());
                        int[] bb = c.getBbox31();
                        if (bb != null && bb.length >= 4) {
                            int w = (bb[2] - bb[0]) / 3;
                            int h = (bb[3] - bb[1]) / 3;
                            int left = bb[0] - w;
                            int top = bb[1] - h;
                            int right = bb[2] + w;
                            int bottom = bb[3] + h;
                            rect = new QuadRect(left, top, right, bottom);
                            req.setBBox(x31, y31, left, top, right, bottom);
                        } else {
                            int radius = (int)c.getType().getRadius() * 3;
                            rect = SearchPhrase.calculateBbox(radius, c.getLocation());
                            req.setBBoxRadius(c.getLocation().getLatitude(), c.getLocation().getLongitude(), radius);
                        }
                    } else {
                        int radius = phrase.getRadiusSearch(500000);
                        rect = SearchPhrase.calculateBbox(radius, loc);
                        req.setBBoxRadius(loc.getLatitude(), loc.getLongitude(), radius);
                    }
                    offlineIterator = phrase.getOfflineIndexes(rect, SearchPhrase.SearchPhraseDataType.ADDRESS);
                }
                while (offlineIterator.hasNext() && wordToSearch.length() > 0) {
                    BinaryMapIndexReader r;
                    currentFile[0] = r = offlineIterator.next();
                    immediateResults.clear();
                    req.setSearchStat(phrase.getSettings().getStat());
                    r.searchAddressDataByName(req);
                    for (SearchResult res : immediateResults) {
                        if (res.objectType == ObjectType.STREET) {
                            SearchResult newParentSearchResult = null;
                            if (res.parentSearchResult == null && resultMatcher.getParentSearchResult() == null && res.object instanceof Street && ((Street)res.object).getCity() != null) {
                                City ct = ((Street)res.object).getCity();
                                SearchResult cityResult = new SearchResult(phrase);
                                cityResult.object = ct;
                                cityResult.objectType = ObjectType.CITY;
                                cityResult.localeName = ct.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                                cityResult.otherNames = ct.getOtherNames(true);
                                cityResult.location = ct.getLocation();
                                cityResult.localeRelatedObjectName = res.file.getRegionName();
                                cityResult.file = res.file;
                                boolean match = this.matchAddressName(phrase, res, cityResult, true);
                                if (match) {
                                    newParentSearchResult = cityResult;
                                } else {
                                    this.resArray.clear();
                                    QuadRect bbox = SearchPhrase.calculateBbox(1000, res.location);
                                    this.resArray = this.boundariesQR.queryInBox(bbox, this.resArray);
                                    for (City boundary : this.resArray) {
                                        QuadRect boundBox;
                                        int[] bb = boundary.getBbox31();
                                        if (bb == null || !QuadRect.intersects(boundBox = new QuadRect(bb[0], bb[1], bb[2], bb[3]), bbox)) continue;
                                        cityResult.localeName = boundary.getName(phrase.getSettings().getLang(), phrase.getSettings().isTransliterate());
                                        cityResult.otherNames = boundary.getOtherNames(true);
                                        if (!this.matchAddressName(phrase, res, cityResult, true)) continue;
                                        cityResult.object = boundary;
                                        cityResult.location = boundary.getLocation();
                                        newParentSearchResult = cityResult;
                                        break;
                                    }
                                }
                            }
                            this.subSearchApiOrPublish(phrase, resultMatcher, res, this.streetsApi, newParentSearchResult, true);
                            continue;
                        }
                        if (res.objectType == ObjectType.BOUNDARY) {
                            if (!this.matchAddressName(phrase, null, res, true)) continue;
                            this.subSearchApiOrPublish(phrase, resultMatcher, res, this);
                            continue;
                        }
                        this.subSearchApiOrPublish(phrase, resultMatcher, res, this.cityApi);
                        if (!this.matchAddressName(phrase, null, res, true)) continue;
                        this.subSearchApiOrPublish(phrase, resultMatcher, res, this);
                    }
                    resultMatcher.apiSearchRegionFinished(this, r, phrase);
                }
            }
        }
    }

    public static class SearchRegionByNameAPI
    extends SearchBaseAPI {
        public SearchRegionByNameAPI() {
            super(ObjectType.REGION);
        }

        @Override
        public boolean search(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            for (BinaryMapIndexReader bmir : phrase.getOfflineIndexes()) {
                if (bmir.getRegionCenter() == null) continue;
                SearchResult sr = new SearchResult(phrase);
                sr.localeName = bmir.getRegionName();
                sr.object = bmir;
                sr.file = bmir;
                sr.priority = 1000.0;
                sr.objectType = ObjectType.REGION;
                sr.location = bmir.getRegionCenter();
                sr.preferredZoom = 6;
                if (phrase.getFullSearchPhrase().length() <= 1 && phrase.isNoSelectedType()) {
                    resultMatcher.publish(sr);
                    continue;
                }
                if (!phrase.getFirstUnknownNameStringMatcher().matches(sr.localeName)) continue;
                resultMatcher.publish(sr);
            }
            return true;
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return false;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            if (!p.isNoSelectedType()) {
                return -1;
            }
            return 300;
        }
    }

    public static abstract class SearchBaseAPI
    implements SearchCoreAPI {
        private ObjectType[] searchTypes;

        protected SearchBaseAPI(ObjectType ... searchTypes) {
            if (searchTypes == null) {
                throw new IllegalArgumentException("Search types are not defined for search core API");
            }
            this.searchTypes = searchTypes;
        }

        @Override
        public boolean isSearchAvailable(SearchPhrase p) {
            ObjectType[] typesToSearch = p.getSearchTypes();
            ObjectType exclusiveSearchType = p.getExclusiveSearchType();
            if (exclusiveSearchType != null) {
                return this.searchTypes != null && this.searchTypes.length == 1 && this.searchTypes[0] == exclusiveSearchType;
            }
            if (typesToSearch == null) {
                return true;
            }
            for (ObjectType type : this.searchTypes) {
                for (ObjectType ts : typesToSearch) {
                    if (type != ts) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean search(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher) throws IOException {
            return true;
        }

        @Override
        public int getSearchPriority(SearchPhrase p) {
            return 1;
        }

        @Override
        public boolean isSearchMoreAvailable(SearchPhrase phrase) {
            return phrase.getRadiusLevel() < 7;
        }

        @Override
        public int getMinimalSearchRadius(SearchPhrase phrase) {
            return 0;
        }

        @Override
        public int getNextSearchRadius(SearchPhrase phrase) {
            return 0;
        }

        protected SearchPhrase subSearchApiOrPublish(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher, SearchResult res, SearchBaseAPI api) throws IOException {
            return this.subSearchApiOrPublish(phrase, resultMatcher, res, api, null, true);
        }

        protected SearchPhrase subSearchApiOrPublish(SearchPhrase phrase, SearchUICore.SearchResultMatcher resultMatcher, SearchResult res, SearchBaseAPI api, SearchResult setParentSearchResult, boolean publish) throws IOException {
            phrase.countUnknownWordsMatchMainResult(res);
            List<String> leftUnknownSearchWords = res.filterUnknownSearchWord(null);
            if (setParentSearchResult != null) {
                phrase.countUnknownWordsMatchMainResult(setParentSearchResult);
                leftUnknownSearchWords = setParentSearchResult.filterUnknownSearchWord(leftUnknownSearchWords);
            }
            if (publish) {
                if (setParentSearchResult != null) {
                    SearchResult prev = resultMatcher.setParentSearchResult(setParentSearchResult);
                    resultMatcher.publish(res);
                    resultMatcher.setParentSearchResult(prev);
                } else {
                    resultMatcher.publish(res);
                }
            }
            if (!leftUnknownSearchWords.isEmpty() && api != null && api.isSearchAvailable(phrase)) {
                SearchPhrase nphrase = phrase.selectWord(res, leftUnknownSearchWords, phrase.isLastUnknownSearchWordComplete() || !leftUnknownSearchWords.contains(phrase.getLastUnknownSearchWord()));
                SearchResult prev = resultMatcher.setParentSearchResult(publish ? res : resultMatcher.getParentSearchResult());
                api.search(nphrase, resultMatcher);
                resultMatcher.setParentSearchResult(prev);
                return nphrase;
            }
            return null;
        }

        boolean matchAddressName(SearchPhrase phrase, SearchResult prevRes, SearchResult res, boolean fullMatch) {
            boolean match = false;
            if (prevRes != null) {
                String[] backup = prevRes.stripBracesNames();
                phrase.countUnknownWordsMatchMainResult(prevRes);
                prevRes.restoreBraceNames(backup);
                List<String> leftUnknownSearchWords = prevRes.filterUnknownSearchWord(null);
                SearchPhrase nphrase = phrase.selectWord(prevRes, leftUnknownSearchWords, phrase.isLastUnknownSearchWordComplete() || !leftUnknownSearchWords.contains(phrase.getLastUnknownSearchWord()));
                for (String otherName : res.otherNames) {
                    if (!phrase.getCollator().equals(nphrase.getUnknownWordToSearch(), otherName)) continue;
                    return true;
                }
            }
            if (!phrase.isUnknownSearchWordPresent()) {
                return false;
            }
            SearchPhrase.NameStringMatcher nm = phrase.getMainUnknownNameStringMatcher();
            String localeName = SearchPhrase.stripBraces(res.localeName);
            Collection<String> otherNames = res.otherNames;
            if (!fullMatch && (nm.matches(localeName) || nm.matches(otherNames))) {
                return true;
            }
            List<String> localeNames = SearchPhrase.splitWords(localeName, new ArrayList<String>(), "\\s|,");
            if (prevRes == null || !prevRes.firstUnknownWordMatches) {
                Iterator<String> it = localeNames.iterator();
                while (it.hasNext()) {
                    String lName = it.next();
                    if (!phrase.getFirstUnknownNameStringMatcher().matches(lName)) continue;
                    it.remove();
                }
            }
            List<String> leftUnknownSearchWords = prevRes == null ? phrase.getUnknownSearchWords() : prevRes.filterUnknownSearchWord(null);
            List<String> unknownSearchWords = phrase.getUnknownSearchWords();
            for (int i = 0; i < unknownSearchWords.size() && !match; ++i) {
                String leftUnknownSearchWord = unknownSearchWords.get(i);
                if (!leftUnknownSearchWords.contains(leftUnknownSearchWord)) continue;
                Iterator<String> it = localeNames.iterator();
                while (it.hasNext()) {
                    String lName = it.next();
                    if (!phrase.getUnknownNameStringMatcher(i).matches(lName)) continue;
                    it.remove();
                }
            }
            return localeNames.size() == 0;
        }

        Set<String> splitAddressSearchNames(String name) {
            int prev = -1;
            HashSet<String> namesToAdd = new HashSet<String>();
            for (int i = 0; i <= name.length(); ++i) {
                boolean isHyphenNearNumber;
                boolean bl = isHyphenNearNumber = i != name.length() && name.charAt(i) == '-' && (i + 1 < name.length() && Character.isDigit(name.charAt(i + 1)) || i - 1 >= 0 && Character.isDigit(name.charAt(i - 1)));
                if (i == name.length() || !Character.isLetter(name.charAt(i)) && !Character.isDigit(name.charAt(i)) && name.charAt(i) != '\'' && !isHyphenNearNumber) {
                    if (prev == -1) continue;
                    String substr = name.substring(prev, i);
                    namesToAdd.add(substr.toLowerCase());
                    prev = -1;
                    continue;
                }
                if (prev != -1) continue;
                prev = i;
            }
            return namesToAdd;
        }

        public String toString() {
            return this.getClass().getSimpleName();
        }
    }
}

