/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.shared.gpx.primitives;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import net.osmand.shared.gpx.ElevationApproximator;
import net.osmand.shared.gpx.ElevationDiffsCalculator;
import net.osmand.shared.gpx.GpxTrackAnalysis;
import net.osmand.shared.gpx.GpxUtilities;
import net.osmand.shared.gpx.SplitMetric;
import net.osmand.shared.gpx.SplitSegment;
import net.osmand.shared.gpx.primitives.GpxExtensions;
import net.osmand.shared.gpx.primitives.WptPt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0013\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001:\u0001LB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010%\u001a\u00020\u000bJ\u0006\u0010&\u001a\u00020\u000bJ\u0012\u0010'\u001a\b\u0012\u0004\u0012\u00020)0(*\u00020\u0000H\u0002J\u0018\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020\u0012H\u0002J\u000e\u0010.\u001a\b\u0012\u0004\u0012\u00020/0(H\u0002J\b\u00100\u001a\u000201H\u0002J\u001e\u00102\u001a\u00020\u000b2\u0006\u00103\u001a\u0002042\f\u00105\u001a\b\u0012\u0004\u0012\u00020/0(H\u0002J\b\u00106\u001a\u000207H\u0002J \u00108\u001a\u0002092\u0006\u0010:\u001a\u0002012\u0006\u0010;\u001a\u0002012\u0006\u0010<\u001a\u00020=H\u0002J\f\u0010>\u001a\b\u0012\u0004\u0012\u00020?0(J\u0016\u0010>\u001a\b\u0012\u0004\u0012\u00020?0(2\b\u0010@\u001a\u0004\u0018\u00010AJ\u001c\u0010B\u001a\b\u0012\u0004\u0012\u00020?0(2\u0006\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020\u000bJ&\u0010B\u001a\b\u0012\u0004\u0012\u00020?0(2\u0006\u0010C\u001a\u00020+2\u0006\u0010D\u001a\u00020\u000b2\b\u0010@\u001a\u0004\u0018\u00010AJ\u001c\u0010E\u001a\b\u0012\u0004\u0012\u00020?0(2\u0006\u0010F\u001a\u0002042\u0006\u0010D\u001a\u00020\u000bJ&\u0010E\u001a\b\u0012\u0004\u0012\u00020?0(2\u0006\u0010F\u001a\u0002042\u0006\u0010D\u001a\u00020\u000b2\b\u0010@\u001a\u0004\u0018\u00010AJ8\u0010G\u001a\b\u0012\u0004\u0012\u00020?0(2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010K\u001a\u00020+2\u0006\u0010D\u001a\u00020\u000b2\b\u0010@\u001a\u0004\u0018\u00010AH\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\u00020\u000bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR \u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR \u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u001e0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u0014\"\u0004\b \u0010\u0016R \u0010!\u001a\b\u0012\u0004\u0012\u00020\"0\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010\u0014\"\u0004\b$\u0010\u0016\u00a8\u0006M"}, d2={"Lnet/osmand/shared/gpx/primitives/TrkSegment;", "Lnet/osmand/shared/gpx/primitives/GpxExtensions;", "<init>", "()V", "name", "", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "generalSegment", "", "getGeneralSegment", "()Z", "setGeneralSegment", "(Z)V", "points", "", "Lnet/osmand/shared/gpx/primitives/WptPt;", "getPoints", "()Ljava/util/List;", "setPoints", "(Ljava/util/List;)V", "renderer", "", "getRenderer", "()Ljava/lang/Object;", "setRenderer", "(Ljava/lang/Object;)V", "routeSegments", "Lnet/osmand/shared/gpx/GpxUtilities$RouteSegment;", "getRouteSegments", "setRouteSegments", "routeTypes", "Lnet/osmand/shared/gpx/GpxUtilities$RouteType;", "getRouteTypes", "setRouteTypes", "isGeneralSegment", "hasRoute", "splitBySlopeTypeUsingExtremums", "", "Lnet/osmand/shared/gpx/SplitSegment;", "getSlopeValue", "", "sp", "point", "getExtremums", "Lnet/osmand/shared/gpx/ElevationDiffsCalculator$Extremum;", "accumulatePointsDistance", "", "isPointExtremum", "index", "", "extremums", "getElevationApproximator", "Lnet/osmand/shared/gpx/ElevationApproximator;", "getElevationDiffsCalculator", "Lnet/osmand/shared/gpx/ElevationDiffsCalculator;", "distances", "elevations", "indexes", "", "splitByUpDownHills", "Lnet/osmand/shared/gpx/GpxTrackAnalysis;", "pointsAnalyser", "Lnet/osmand/shared/gpx/GpxTrackAnalysis$TrackPointsAnalyser;", "splitByDistance", "meters", "joinSegments", "splitByTime", "seconds", "split", "metric", "Lnet/osmand/shared/gpx/SplitMetric;", "secondaryMetric", "metricLimit", "SegmentSlopeType", "OsmAnd-shared"})
public final class TrkSegment
extends GpxExtensions {
    @Nullable
    private String name;
    private boolean generalSegment;
    @NotNull
    private List<WptPt> points = new ArrayList();
    @Nullable
    private Object renderer;
    @NotNull
    private List<GpxUtilities.RouteSegment> routeSegments = new ArrayList();
    @NotNull
    private List<GpxUtilities.RouteType> routeTypes = new ArrayList();

    @Nullable
    public final String getName() {
        return this.name;
    }

    public final void setName(@Nullable String string) {
        this.name = string;
    }

    public final boolean getGeneralSegment() {
        return this.generalSegment;
    }

    public final void setGeneralSegment(boolean bl) {
        this.generalSegment = bl;
    }

    @NotNull
    public final List<WptPt> getPoints() {
        return this.points;
    }

    public final void setPoints(@NotNull List<WptPt> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.points = list;
    }

    @Nullable
    public final Object getRenderer() {
        return this.renderer;
    }

    public final void setRenderer(@Nullable Object object) {
        this.renderer = object;
    }

    @NotNull
    public final List<GpxUtilities.RouteSegment> getRouteSegments() {
        return this.routeSegments;
    }

    public final void setRouteSegments(@NotNull List<GpxUtilities.RouteSegment> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.routeSegments = list;
    }

    @NotNull
    public final List<GpxUtilities.RouteType> getRouteTypes() {
        return this.routeTypes;
    }

    public final void setRouteTypes(@NotNull List<GpxUtilities.RouteType> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.routeTypes = list;
    }

    public final boolean isGeneralSegment() {
        return this.generalSegment;
    }

    public final boolean hasRoute() {
        return !((Collection)this.routeSegments).isEmpty() && !((Collection)this.routeTypes).isEmpty();
    }

    private final List<SplitSegment> splitBySlopeTypeUsingExtremums(TrkSegment $this$splitBySlopeTypeUsingExtremums) {
        List splitSegments = new ArrayList();
        if ($this$splitBySlopeTypeUsingExtremums.points.size() < 3) {
            return CollectionsKt.emptyList();
        }
        List<ElevationDiffsCalculator.Extremum> extremums = $this$splitBySlopeTypeUsingExtremums.getExtremums();
        if (extremums.size() < 2) {
            return CollectionsKt.emptyList();
        }
        double[] accumulatedDistances = $this$splitBySlopeTypeUsingExtremums.accumulatePointsDistance();
        Integer prevExtremumIndex = null;
        SplitSegment sp = null;
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)((Object)SegmentSlopeType.UPHILL), (Object)0), TuplesKt.to((Object)((Object)SegmentSlopeType.DOWNHILL), (Object)0), TuplesKt.to((Object)((Object)SegmentSlopeType.FLAT), (Object)0)};
        Map slopeCounters = MapsKt.mutableMapOf((Pair[])pairArray);
        int n = ((Collection)$this$splitBySlopeTypeUsingExtremums.points).size();
        for (int i = 0; i < n; ++i) {
            WptPt point = $this$splitBySlopeTypeUsingExtremums.points.get(i);
            boolean isExtremum = $this$splitBySlopeTypeUsingExtremums.isPointExtremum(i, extremums);
            if (i > 0) {
                if (prevExtremumIndex != null && isExtremum) {
                    SegmentSlopeType slopeType;
                    WptPt prevExtremumPoint = $this$splitBySlopeTypeUsingExtremums.points.get(prevExtremumIndex);
                    double extremumElevDiff = prevExtremumPoint.getEle() - point.getEle();
                    SegmentSlopeType segmentSlopeType = Math.abs(extremumElevDiff) < 1.0 ? SegmentSlopeType.FLAT : (slopeType = extremumElevDiff < 0.0 ? SegmentSlopeType.UPHILL : SegmentSlopeType.DOWNHILL);
                    if (sp != null && sp.getSegmentSlopeType() == slopeType) {
                        sp.setMetricEnd(accumulatedDistances[i]);
                        sp.setEndPointInd(i - 1);
                        sp.setSlopeValue($this$splitBySlopeTypeUsingExtremums.getSlopeValue(sp, point));
                    } else {
                        Integer n2 = (Integer)slopeCounters.get((Object)slopeType);
                        int count = (n2 != null ? n2 : 0) + 1;
                        Integer n3 = count;
                        slopeCounters.put(slopeType, n3);
                        sp = new SplitSegment($this$splitBySlopeTypeUsingExtremums);
                        sp.setStartPointInd(prevExtremumIndex);
                        sp.setEndPointInd(i - 1);
                        sp.setMetricEnd(accumulatedDistances[i]);
                        sp.setSegmentSlopeType(slopeType);
                        sp.setSlopeCount(count);
                        sp.setSlopeValue($this$splitBySlopeTypeUsingExtremums.getSlopeValue(sp, point));
                        splitSegments.add(sp);
                    }
                }
                if (isExtremum) {
                    prevExtremumIndex = i;
                }
            }
            if (!isExtremum) continue;
            prevExtremumIndex = i;
        }
        return splitSegments;
    }

    private final double getSlopeValue(SplitSegment sp, WptPt point) {
        WptPt startPoint = this.points.get(sp.getStartPointInd());
        if (Double.isNaN(startPoint.getEle()) || Double.isNaN(point.getEle())) {
            return 0.0;
        }
        double distance = point.getDistance() - startPoint.getDistance();
        if (distance == 0.0) {
            return 0.0;
        }
        double elevationDiff = point.getEle() - startPoint.getEle();
        return elevationDiff / distance * (double)100;
    }

    private final List<ElevationDiffsCalculator.Extremum> getExtremums() {
        ElevationApproximator approximator2 = this.getElevationApproximator();
        if (!approximator2.approximate()) {
            return CollectionsKt.emptyList();
        }
        double[] dArray = approximator2.getDistances();
        if (dArray == null) {
            return CollectionsKt.emptyList();
        }
        double[] distances = dArray;
        double[] dArray2 = approximator2.getElevations();
        if (dArray2 == null) {
            return CollectionsKt.emptyList();
        }
        double[] elevations = dArray2;
        int[] nArray = approximator2.getSurvivedIndexes();
        if (nArray == null) {
            return CollectionsKt.emptyList();
        }
        int[] survivedIndexes = nArray;
        if (distances.length < 2) {
            return CollectionsKt.emptyList();
        }
        ElevationDiffsCalculator elevationDiffsCalc2 = this.getElevationDiffsCalculator(distances, elevations, survivedIndexes);
        elevationDiffsCalc2.calculateElevationDiffs();
        List<ElevationDiffsCalculator.Extremum> extremums = elevationDiffsCalc2.getExtremums();
        return extremums;
    }

    private final double[] accumulatePointsDistance() {
        SplitMetric metric = new SplitMetric.DistanceSplitMetric();
        double[] accumulatedDistances = new double[this.points.size()];
        WptPt prev = null;
        double totalDist = 0.0;
        int n = ((Collection)this.points).size();
        for (int i = 0; i < n; ++i) {
            WptPt point = this.points.get(i);
            if (i > 0) {
                if (prev != null) {
                    WptPt it;
                    boolean bl = false;
                    double calcDist = metric.metric(it, point);
                    accumulatedDistances[i] = totalDist += calcDist;
                }
            }
            prev = point;
        }
        return accumulatedDistances;
    }

    private final boolean isPointExtremum(int index, List<ElevationDiffsCalculator.Extremum> extremums) {
        for (ElevationDiffsCalculator.Extremum extremum : extremums) {
            if (index != extremum.getIndex()) continue;
            return true;
        }
        return false;
    }

    private final ElevationApproximator getElevationApproximator() {
        return new ElevationApproximator(this){
            final /* synthetic */ TrkSegment this$0;
            {
                this.this$0 = $receiver;
            }

            public double getPointLatitude(int index) {
                return this.this$0.getPoints().get(index).getLat();
            }

            public double getPointLongitude(int index) {
                return this.this$0.getPoints().get(index).getLon();
            }

            public double getPointElevation(int index) {
                return this.this$0.getPoints().get(index).getEle();
            }

            public int getPointsCount() {
                return this.this$0.getPoints().size();
            }
        };
    }

    private final ElevationDiffsCalculator getElevationDiffsCalculator(double[] distances, double[] elevations, int[] indexes) {
        return new ElevationDiffsCalculator(distances, indexes, elevations){
            final /* synthetic */ double[] $distances;
            final /* synthetic */ int[] $indexes;
            final /* synthetic */ double[] $elevations;
            {
                this.$distances = $distances;
                this.$indexes = $indexes;
                this.$elevations = $elevations;
            }

            public double getPointDistance(int index) {
                return this.$distances[index];
            }

            public int getPointIndex(int index) {
                return this.$indexes[index];
            }

            public double getPointElevation(int index) {
                return this.$elevations[index];
            }

            public int getPointsCount() {
                return this.$distances.length;
            }
        };
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByUpDownHills() {
        return this.splitByUpDownHills(null);
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByUpDownHills(@Nullable GpxTrackAnalysis.TrackPointsAnalyser pointsAnalyser) {
        return GpxUtilities.INSTANCE.convert(this.splitBySlopeTypeUsingExtremums(this), pointsAnalyser);
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByDistance(double meters, boolean joinSegments) {
        return this.splitByDistance(meters, joinSegments, null);
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByDistance(double meters, boolean joinSegments, @Nullable GpxTrackAnalysis.TrackPointsAnalyser pointsAnalyser) {
        return this.split(new SplitMetric.DistanceSplitMetric(), new SplitMetric.TimeSplitMetric(), meters, joinSegments, pointsAnalyser);
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByTime(int seconds, boolean joinSegments) {
        return this.splitByTime(seconds, joinSegments, null);
    }

    @NotNull
    public final List<GpxTrackAnalysis> splitByTime(int seconds, boolean joinSegments, @Nullable GpxTrackAnalysis.TrackPointsAnalyser pointsAnalyser) {
        return this.split(new SplitMetric.TimeSplitMetric(), new SplitMetric.DistanceSplitMetric(), seconds, joinSegments, pointsAnalyser);
    }

    private final List<GpxTrackAnalysis> split(SplitMetric metric, SplitMetric secondaryMetric, double metricLimit, boolean joinSegments, GpxTrackAnalysis.TrackPointsAnalyser pointsAnalyser) {
        List splitSegments = new ArrayList();
        SplitMetric.Companion.splitSegment(metric, secondaryMetric, metricLimit, splitSegments, this, joinSegments);
        return GpxUtilities.INSTANCE.convert(splitSegments, pointsAnalyser);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0011\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lnet/osmand/shared/gpx/primitives/TrkSegment$SegmentSlopeType;", "", "symbol", "", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getSymbol", "()Ljava/lang/String;", "UPHILL", "DOWNHILL", "FLAT", "OsmAnd-shared"})
    public static final class SegmentSlopeType
    extends Enum<SegmentSlopeType> {
        @NotNull
        private final String symbol;
        public static final /* enum */ SegmentSlopeType UPHILL = new SegmentSlopeType("\u2191");
        public static final /* enum */ SegmentSlopeType DOWNHILL = new SegmentSlopeType("\u2193");
        public static final /* enum */ SegmentSlopeType FLAT = new SegmentSlopeType("\u2194");
        private static final /* synthetic */ SegmentSlopeType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private SegmentSlopeType(String symbol) {
            this.symbol = symbol;
        }

        @NotNull
        public final String getSymbol() {
            return this.symbol;
        }

        public static SegmentSlopeType[] values() {
            return (SegmentSlopeType[])$VALUES.clone();
        }

        public static SegmentSlopeType valueOf(String value) {
            return Enum.valueOf(SegmentSlopeType.class, value);
        }

        @NotNull
        public static EnumEntries<SegmentSlopeType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = segmentSlopeTypeArray = new SegmentSlopeType[]{SegmentSlopeType.UPHILL, SegmentSlopeType.DOWNHILL, SegmentSlopeType.FLAT};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

