/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.util;

import com.ibm.icu.util.ULocale;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenderInfo {
    private final ListGenderStyle style;
    private static GenderInfo neutral = new GenderInfo(ListGenderStyle.NEUTRAL);
    private static Map<ULocale, GenderInfo> localeToListGender = new HashMap<ULocale, GenderInfo>();

    public static GenderInfo getInstance(ULocale uLocale) {
        do {
            GenderInfo data;
            if ((data = localeToListGender.get(uLocale)) == null) continue;
            return data;
        } while ((uLocale = uLocale.getFallback()) != null);
        return neutral;
    }

    public static GenderInfo getInstance(Locale locale) {
        return GenderInfo.getInstance(ULocale.forLocale(locale));
    }

    public static void setLocaleMapping(Map<ULocale, GenderInfo> newULocaleToListGender) {
        localeToListGender.clear();
        localeToListGender.putAll(newULocaleToListGender);
    }

    public Gender getListGender(Gender ... genders) {
        return this.getListGender(Arrays.asList(genders));
    }

    public Gender getListGender(List<Gender> genders) {
        if (genders.size() == 0 || this.style == ListGenderStyle.NEUTRAL) {
            return Gender.OTHER;
        }
        if (genders.size() == 1) {
            return genders.get(0);
        }
        switch (this.style) {
            case MIXED_NEUTRAL: {
                boolean hasFemale = false;
                boolean hasMale = false;
                for (Gender gender : genders) {
                    switch (gender) {
                        case FEMALE: {
                            if (hasMale) {
                                return Gender.OTHER;
                            }
                            hasFemale = true;
                            break;
                        }
                        case MALE: {
                            if (hasFemale) {
                                return Gender.OTHER;
                            }
                            hasMale = true;
                            break;
                        }
                        case OTHER: {
                            return Gender.OTHER;
                        }
                    }
                }
                return hasMale ? Gender.MALE : Gender.FEMALE;
            }
            case MALE_TAINTS: {
                for (Gender gender : genders) {
                    if (gender == Gender.FEMALE) continue;
                    return Gender.MALE;
                }
                return Gender.FEMALE;
            }
        }
        return Gender.OTHER;
    }

    public GenderInfo(ListGenderStyle genderStyle) {
        this.style = genderStyle;
    }

    static {
        GenderInfo taints = new GenderInfo(ListGenderStyle.MALE_TAINTS);
        for (String locale : Arrays.asList("ar", "ca", "cs", "hr", "es", "fr", "he", "hi", "it", "lt", "lv", "mr", "nl", "pl", "pt", "ro", "ru", "sk", "sl", "sr", "uk", "ur", "zh")) {
            localeToListGender.put(new ULocale(locale), taints);
        }
        GenderInfo mixed = new GenderInfo(ListGenderStyle.MIXED_NEUTRAL);
        for (String locale : Arrays.asList("el", "is")) {
            localeToListGender.put(new ULocale(locale), mixed);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ListGenderStyle {
        NEUTRAL,
        MIXED_NEUTRAL,
        MALE_TAINTS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Gender {
        MALE,
        FEMALE,
        OTHER;

    }
}

