/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.binary;

import com.google.protobuf.GeneratedMessageLite;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryHHRouteReaderAdapter;
import net.osmand.binary.BinaryIndexPart;
import net.osmand.binary.BinaryMapAddressReaderAdapter;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.BinaryMapPoiReaderAdapter;
import net.osmand.binary.BinaryMapRouteReaderAdapter;
import net.osmand.binary.BinaryMapTransportReaderAdapter;
import net.osmand.binary.OsmandIndex;
import org.apache.commons.logging.Log;

public class CachedOsmandIndexes {
    private OsmandIndex.OsmAndStoredIndex storedIndex;
    private OsmandIndex.OsmAndStoredIndex.Builder storedIndexBuilder;
    private Log log = PlatformUtil.getLog(CachedOsmandIndexes.class);
    private boolean hasChanged = false;
    public static final String INDEXES_DEFAULT_FILENAME = "indexes.cache";
    public static final int VERSION = 5;

    public OsmandIndex.FileIndex addToCache(BinaryMapIndexReader reader, File f) {
        GeneratedMessageLite.Builder routing;
        this.hasChanged = true;
        if (this.storedIndexBuilder == null) {
            this.storedIndexBuilder = OsmandIndex.OsmAndStoredIndex.newBuilder();
            this.storedIndexBuilder.setVersion(5);
            this.storedIndexBuilder.setDateCreated(System.currentTimeMillis());
            if (this.storedIndex != null) {
                for (OsmandIndex.FileIndex ex : this.storedIndex.getFileIndexList()) {
                    if (ex.getFileName().equals(f.getName())) continue;
                    this.storedIndexBuilder.addFileIndex(ex);
                }
            }
        } else {
            int found = -1;
            List<OsmandIndex.FileIndex> fileIndexList = this.storedIndexBuilder.getFileIndexList();
            for (int i = 0; i < fileIndexList.size(); ++i) {
                if (!fileIndexList.get(i).getFileName().equals(f.getName())) continue;
                found = i;
                break;
            }
            if (found >= 0) {
                this.storedIndexBuilder.removeFileIndex(found);
            }
        }
        OsmandIndex.FileIndex.Builder fileIndex = OsmandIndex.FileIndex.newBuilder();
        long d = reader.getDateCreated();
        fileIndex.setDateModified(d == 0L ? f.lastModified() : d);
        fileIndex.setSize(f.length());
        fileIndex.setVersion(reader.getVersion());
        fileIndex.setFileName(f.getName());
        for (BinaryMapIndexReader.MapIndex mapIndex : reader.getMapIndexes()) {
            OsmandIndex.MapPart.Builder map = OsmandIndex.MapPart.newBuilder();
            map.setSize(mapIndex.getLength());
            map.setOffset(mapIndex.getFilePointer());
            if (mapIndex.getName() != null) {
                map.setName(mapIndex.getName());
            }
            for (BinaryMapIndexReader.MapRoot mapRoot : mapIndex.getRoots()) {
                OsmandIndex.MapLevel.Builder lev = OsmandIndex.MapLevel.newBuilder();
                lev.setSize(mapRoot.length);
                lev.setOffset(mapRoot.filePointer);
                lev.setLeft(mapRoot.left);
                lev.setRight(mapRoot.right);
                lev.setTop(mapRoot.top);
                lev.setBottom(mapRoot.bottom);
                lev.setMinzoom(mapRoot.minZoom);
                lev.setMaxzoom(mapRoot.maxZoom);
                map.addLevels(lev);
            }
            fileIndex.addMapIndex(map);
        }
        for (BinaryMapAddressReaderAdapter.AddressRegion addressRegion : reader.getAddressIndexes()) {
            OsmandIndex.AddressPart.Builder addr = OsmandIndex.AddressPart.newBuilder();
            addr.setSize(addressRegion.getLength());
            addr.setOffset(addressRegion.getFilePointer());
            if (addressRegion.getName() != null) {
                addr.setName(addressRegion.getName());
            }
            if (addressRegion.getEnName() != null) {
                addr.setNameEn(addressRegion.getEnName());
            }
            addr.setIndexNameOffset(addressRegion.getIndexNameOffset());
            for (BinaryMapAddressReaderAdapter.CitiesBlock citiesBlock : addressRegion.getCities()) {
                OsmandIndex.CityBlock.Builder cblock = OsmandIndex.CityBlock.newBuilder();
                cblock.setSize(citiesBlock.length);
                cblock.setOffset(citiesBlock.filePointer);
                cblock.setType(citiesBlock.type);
                addr.addCities(cblock);
            }
            for (String string : addressRegion.getAttributeTagsTable()) {
                addr.addAdditionalTags(string);
            }
            fileIndex.addAddressIndex(addr);
        }
        for (BinaryMapPoiReaderAdapter.PoiRegion poiRegion : reader.getPoiIndexes()) {
            OsmandIndex.PoiPart.Builder poi = OsmandIndex.PoiPart.newBuilder();
            poi.setSize(poiRegion.getLength());
            poi.setOffset(poiRegion.getFilePointer());
            if (poiRegion.getName() != null) {
                poi.setName(poiRegion.getName());
            }
            poi.setLeft(poiRegion.left31);
            poi.setRight(poiRegion.right31);
            poi.setTop(poiRegion.top31);
            poi.setBottom(poiRegion.bottom31);
            fileIndex.addPoiIndex(poi.build());
        }
        for (BinaryMapTransportReaderAdapter.TransportIndex transportIndex : reader.getTransportIndexes()) {
            OsmandIndex.TransportPart.Builder transport = OsmandIndex.TransportPart.newBuilder();
            transport.setSize(transportIndex.getLength());
            transport.setOffset(transportIndex.getFilePointer());
            if (transportIndex.getName() != null) {
                transport.setName(transportIndex.getName());
            }
            transport.setLeft(transportIndex.getLeft());
            transport.setRight(transportIndex.getRight());
            transport.setTop(transportIndex.getTop());
            transport.setBottom(transportIndex.getBottom());
            transport.setStopsTableLength(transportIndex.stopsFileLength);
            transport.setStopsTableOffset(transportIndex.stopsFileOffset);
            transport.setIncompleteRoutesLength(transportIndex.incompleteRoutesLength);
            transport.setIncompleteRoutesOffset(transportIndex.incompleteRoutesOffset);
            transport.setStringTableLength(transportIndex.stringTable.length);
            transport.setStringTableOffset(transportIndex.stringTable.fileOffset);
            fileIndex.addTransportIndex(transport);
        }
        for (BinaryMapRouteReaderAdapter.RouteRegion routeRegion : reader.getRoutingIndexes()) {
            routing = OsmandIndex.RoutingPart.newBuilder();
            ((OsmandIndex.RoutingPart.Builder)routing).setSize(routeRegion.getLength());
            ((OsmandIndex.RoutingPart.Builder)routing).setOffset(routeRegion.getFilePointer());
            if (routeRegion.getName() != null) {
                ((OsmandIndex.RoutingPart.Builder)routing).setName(routeRegion.getName());
            }
            for (BinaryMapRouteReaderAdapter.RouteSubregion routeSubregion : routeRegion.getSubregions()) {
                this.addRouteSubregion((OsmandIndex.RoutingPart.Builder)routing, routeSubregion, false);
            }
            for (BinaryMapRouteReaderAdapter.RouteSubregion routeSubregion : routeRegion.getBaseSubregions()) {
                this.addRouteSubregion((OsmandIndex.RoutingPart.Builder)routing, routeSubregion, true);
            }
            fileIndex.addRoutingIndex((OsmandIndex.RoutingPart.Builder)routing);
        }
        for (BinaryHHRouteReaderAdapter.HHRouteRegion hHRouteRegion : reader.getHHRoutingIndexes()) {
            routing = OsmandIndex.HHRoutingPart.newBuilder();
            ((OsmandIndex.HHRoutingPart.Builder)routing).setSize(hHRouteRegion.getLength());
            ((OsmandIndex.HHRoutingPart.Builder)routing).setOffset(hHRouteRegion.getFilePointer());
            ((OsmandIndex.HHRoutingPart.Builder)routing).setEdition(hHRouteRegion.edition);
            ((OsmandIndex.HHRoutingPart.Builder)routing).addAllProfileParams(hHRouteRegion.profileParams);
            ((OsmandIndex.HHRoutingPart.Builder)routing).setProfile(hHRouteRegion.profile);
            ((OsmandIndex.HHRoutingPart.Builder)routing).setPointsLength(hHRouteRegion.top.length);
            ((OsmandIndex.HHRoutingPart.Builder)routing).setPointsOffset(hHRouteRegion.top.filePointer);
            ((OsmandIndex.HHRoutingPart.Builder)routing).setBottom(hHRouteRegion.top.bottom);
            ((OsmandIndex.HHRoutingPart.Builder)routing).setTop(hHRouteRegion.top.top);
            ((OsmandIndex.HHRoutingPart.Builder)routing).setLeft(hHRouteRegion.top.left);
            ((OsmandIndex.HHRoutingPart.Builder)routing).setRight(hHRouteRegion.top.right);
            fileIndex.addHhRoutingIndex((OsmandIndex.HHRoutingPart.Builder)routing);
        }
        OsmandIndex.FileIndex fi = fileIndex.build();
        this.storedIndexBuilder.addFileIndex(fi);
        return fi;
    }

    private void addRouteSubregion(OsmandIndex.RoutingPart.Builder routing, BinaryMapRouteReaderAdapter.RouteSubregion sub, boolean base) {
        OsmandIndex.RoutingSubregion.Builder rpart = OsmandIndex.RoutingSubregion.newBuilder();
        rpart.setSize(sub.length);
        rpart.setOffset(sub.filePointer);
        rpart.setLeft(sub.left);
        rpart.setRight(sub.right);
        rpart.setTop(sub.top);
        rpart.setBasemap(base);
        rpart.setBottom(sub.bottom);
        rpart.setShifToData(sub.shiftToData);
        routing.addSubregions(rpart);
    }

    public BinaryMapIndexReader getReader(File f, boolean useStoredIndex) throws IOException {
        OsmandIndex.FileIndex found = useStoredIndex ? this.getFileIndex(f, false) : null;
        BinaryMapIndexReader reader = null;
        RandomAccessFile mf = new RandomAccessFile(f.getPath(), "r");
        if (found == null) {
            long val = System.currentTimeMillis();
            reader = new BinaryMapIndexReader(mf, f);
            found = this.addToCache(reader, f);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Initializing db " + f.getAbsolutePath() + " " + (System.currentTimeMillis() - val) + "ms"));
            }
        } else {
            reader = this.initReaderFromFileIndex(found, mf, f);
        }
        return reader;
    }

    public OsmandIndex.FileIndex getFileIndex(File f, boolean init) throws IOException {
        OsmandIndex.FileIndex found = null;
        if (this.storedIndex != null) {
            for (int i = 0; i < this.storedIndex.getFileIndexCount(); ++i) {
                OsmandIndex.FileIndex fi = this.storedIndex.getFileIndex(i);
                if (f.length() != fi.getSize() || !f.getName().equals(fi.getFileName())) continue;
                found = fi;
                break;
            }
        }
        if (found == null && init) {
            RandomAccessFile mf = new RandomAccessFile(f.getPath(), "r");
            long val = System.currentTimeMillis();
            BinaryMapIndexReader reader = new BinaryMapIndexReader(mf, f);
            found = this.addToCache(reader, f);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Initializing db " + f.getAbsolutePath() + " " + (System.currentTimeMillis() - val) + "ms"));
            }
            reader.close();
            mf.close();
        }
        return found;
    }

    public BinaryMapIndexReader initReaderFromFileIndex(OsmandIndex.FileIndex found, RandomAccessFile mf, File f) throws IOException {
        BinaryIndexPart mi;
        BinaryMapIndexReader reader = new BinaryMapIndexReader(mf, f, false);
        reader.version = found.getVersion();
        reader.dateCreated = found.getDateModified();
        for (OsmandIndex.MapPart mapPart : found.getMapIndexList()) {
            mi = new BinaryMapIndexReader.MapIndex();
            ((BinaryMapIndexReader.MapIndex)mi).length = mapPart.getSize();
            ((BinaryMapIndexReader.MapIndex)mi).filePointer = mapPart.getOffset();
            ((BinaryMapIndexReader.MapIndex)mi).name = mapPart.getName();
            for (OsmandIndex.MapLevel mapLevel : mapPart.getLevelsList()) {
                BinaryMapIndexReader.MapRoot root = new BinaryMapIndexReader.MapRoot();
                root.length = mapLevel.getSize();
                root.filePointer = mapLevel.getOffset();
                root.left = mapLevel.getLeft();
                root.right = mapLevel.getRight();
                root.top = mapLevel.getTop();
                root.bottom = mapLevel.getBottom();
                root.minZoom = mapLevel.getMinzoom();
                root.maxZoom = mapLevel.getMaxzoom();
                ((BinaryMapIndexReader.MapIndex)mi).roots.add(root);
            }
            reader.mapIndexes.add((BinaryMapIndexReader.MapIndex)mi);
            reader.indexes.add(mi);
            reader.basemap = reader.basemap || ((BinaryMapIndexReader.MapIndex)mi).isBaseMap();
        }
        for (OsmandIndex.AddressPart addressPart : found.getAddressIndexList()) {
            mi = new BinaryMapAddressReaderAdapter.AddressRegion();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).length = addressPart.getSize();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).filePointer = addressPart.getOffset();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).name = addressPart.getName();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).enName = addressPart.getNameEn();
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).indexNameOffset = addressPart.getIndexNameOffset();
            for (OsmandIndex.CityBlock cityBlock : addressPart.getCitiesList()) {
                BinaryMapAddressReaderAdapter.CitiesBlock cblock = new BinaryMapAddressReaderAdapter.CitiesBlock();
                cblock.length = cityBlock.getSize();
                cblock.filePointer = cityBlock.getOffset();
                cblock.type = cityBlock.getType();
                ((BinaryMapAddressReaderAdapter.AddressRegion)mi).cities.add(cblock);
            }
            ((BinaryMapAddressReaderAdapter.AddressRegion)mi).attributeTagsTable.addAll(addressPart.getAdditionalTagsList());
            reader.addressIndexes.add((BinaryMapAddressReaderAdapter.AddressRegion)mi);
            reader.indexes.add(mi);
        }
        for (OsmandIndex.PoiPart poiPart : found.getPoiIndexList()) {
            mi = new BinaryMapPoiReaderAdapter.PoiRegion();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).length = poiPart.getSize();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).filePointer = poiPart.getOffset();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).name = poiPart.getName();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).left31 = poiPart.getLeft();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).right31 = poiPart.getRight();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).top31 = poiPart.getTop();
            ((BinaryMapPoiReaderAdapter.PoiRegion)mi).bottom31 = poiPart.getBottom();
            reader.poiIndexes.add((BinaryMapPoiReaderAdapter.PoiRegion)mi);
            reader.indexes.add(mi);
        }
        for (OsmandIndex.TransportPart transportPart : found.getTransportIndexList()) {
            mi = new BinaryMapTransportReaderAdapter.TransportIndex();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).length = transportPart.getSize();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).filePointer = transportPart.getOffset();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).name = transportPart.getName();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).left = transportPart.getLeft();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).right = transportPart.getRight();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).top = transportPart.getTop();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).bottom = transportPart.getBottom();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stopsFileLength = transportPart.getStopsTableLength();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stopsFileOffset = transportPart.getStopsTableOffset();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).incompleteRoutesLength = transportPart.getIncompleteRoutesLength();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).incompleteRoutesOffset = transportPart.getIncompleteRoutesOffset();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stringTable = new BinaryMapTransportReaderAdapter.IndexStringTable();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stringTable.fileOffset = transportPart.getStringTableOffset();
            ((BinaryMapTransportReaderAdapter.TransportIndex)mi).stringTable.length = transportPart.getStringTableLength();
            reader.transportIndexes.add((BinaryMapTransportReaderAdapter.TransportIndex)mi);
            reader.indexes.add(mi);
        }
        for (OsmandIndex.RoutingPart routingPart : found.getRoutingIndexList()) {
            mi = new BinaryMapRouteReaderAdapter.RouteRegion();
            ((BinaryMapRouteReaderAdapter.RouteRegion)mi).length = routingPart.getSize();
            ((BinaryMapRouteReaderAdapter.RouteRegion)mi).filePointer = routingPart.getOffset();
            ((BinaryMapRouteReaderAdapter.RouteRegion)mi).name = routingPart.getName();
            for (OsmandIndex.RoutingSubregion routingSubregion : routingPart.getSubregionsList()) {
                BinaryMapRouteReaderAdapter.RouteSubregion sub = new BinaryMapRouteReaderAdapter.RouteSubregion((BinaryMapRouteReaderAdapter.RouteRegion)mi);
                sub.length = routingSubregion.getSize();
                sub.filePointer = routingSubregion.getOffset();
                sub.left = routingSubregion.getLeft();
                sub.right = routingSubregion.getRight();
                sub.top = routingSubregion.getTop();
                sub.bottom = routingSubregion.getBottom();
                sub.shiftToData = routingSubregion.getShifToData();
                if (routingSubregion.getBasemap()) {
                    ((BinaryMapRouteReaderAdapter.RouteRegion)mi).basesubregions.add(sub);
                    continue;
                }
                ((BinaryMapRouteReaderAdapter.RouteRegion)mi).subregions.add(sub);
            }
            reader.routingIndexes.add((BinaryMapRouteReaderAdapter.RouteRegion)mi);
            reader.indexes.add(mi);
        }
        for (OsmandIndex.HHRoutingPart hHRoutingPart : found.getHhRoutingIndexList()) {
            mi = new BinaryHHRouteReaderAdapter.HHRouteRegion();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).length = hHRoutingPart.getSize();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).filePointer = hHRoutingPart.getOffset();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).edition = hHRoutingPart.getEdition();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).profile = hHRoutingPart.getProfile();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).profileParams = hHRoutingPart.getProfileParamsList();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).top = new BinaryHHRouteReaderAdapter.HHRoutePointsBox();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).top.bottom = hHRoutingPart.getBottom();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).top.right = hHRoutingPart.getRight();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).top.left = hHRoutingPart.getLeft();
            ((BinaryHHRouteReaderAdapter.HHRouteRegion)mi).top.top = hHRoutingPart.getTop();
            reader.hhIndexes.add((BinaryHHRouteReaderAdapter.HHRouteRegion)mi);
            reader.indexes.add(mi);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFromFile(File f) throws IOException {
        long time = System.currentTimeMillis();
        try (FileInputStream is = new FileInputStream(f);){
            this.storedIndex = ((OsmandIndex.OsmAndStoredIndex.Builder)OsmandIndex.OsmAndStoredIndex.newBuilder().mergeFrom(is)).build();
            this.hasChanged = false;
            if (this.storedIndex.getVersion() != 5) {
                this.storedIndex = null;
            }
        }
        this.log.info((Object)("Initialize cache " + f.getName() + " " + (System.currentTimeMillis() - time) + " ms"));
    }

    public void writeToFile(File f) throws IOException {
        if (this.hasChanged) {
            try (FileOutputStream outputStream = new FileOutputStream(f);){
                this.storedIndexBuilder.build().writeTo(outputStream);
            }
        }
    }
}

