/*
 * Decompiled with CFR 0.152.
 */
package io.github.cosinekitty.astronomy;

import io.github.cosinekitty.astronomy.Aberration;
import io.github.cosinekitty.astronomy.Astronomy;
import io.github.cosinekitty.astronomy.Body;
import io.github.cosinekitty.astronomy.Direction;
import io.github.cosinekitty.astronomy.EquatorEpoch;
import io.github.cosinekitty.astronomy.Equatorial;
import io.github.cosinekitty.astronomy.Observer;
import io.github.cosinekitty.astronomy.Refraction;
import io.github.cosinekitty.astronomy.SearchContext;
import io.github.cosinekitty.astronomy.Time;
import io.github.cosinekitty.astronomy.Topocentric;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lio/github/cosinekitty/astronomy/SearchContext_Altitude;", "Lio/github/cosinekitty/astronomy/SearchContext;", "body", "Lio/github/cosinekitty/astronomy/Body;", "direction", "Lio/github/cosinekitty/astronomy/Direction;", "observer", "Lio/github/cosinekitty/astronomy/Observer;", "bodyRadiusAu", "", "targetAltitude", "<init>", "(Lio/github/cosinekitty/astronomy/Body;Lio/github/cosinekitty/astronomy/Direction;Lio/github/cosinekitty/astronomy/Observer;DD)V", "eval", "time", "Lio/github/cosinekitty/astronomy/Time;", "OsmAnd-shared"})
final class SearchContext_Altitude
implements SearchContext {
    @NotNull
    private final Body body;
    @NotNull
    private final Direction direction;
    @NotNull
    private final Observer observer;
    private final double bodyRadiusAu;
    private final double targetAltitude;

    public SearchContext_Altitude(@NotNull Body body, @NotNull Direction direction, @NotNull Observer observer, double bodyRadiusAu, double targetAltitude) {
        Intrinsics.checkNotNullParameter((Object)((Object)body), (String)"body");
        Intrinsics.checkNotNullParameter((Object)((Object)direction), (String)"direction");
        Intrinsics.checkNotNullParameter((Object)observer, (String)"observer");
        this.body = body;
        this.direction = direction;
        this.observer = observer;
        this.bodyRadiusAu = bodyRadiusAu;
        this.targetAltitude = targetAltitude;
    }

    @Override
    public double eval(@NotNull Time time) {
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        Equatorial ofdate = Astronomy.equator(this.body, time, this.observer, EquatorEpoch.OfDate, Aberration.Corrected);
        Topocentric hor = Astronomy.horizon(time, this.observer, ofdate.getRa(), ofdate.getDec(), Refraction.None);
        double altitude = hor.getAltitude() + Astronomy.radiansToDegrees(Math.asin(this.bodyRadiusAu / ofdate.getDist()));
        return (double)this.direction.getSign() * (altitude - this.targetAltitude);
    }
}

